/****************************************************************************
**
** Copyright (C) 2017 Pier Luigi Fiorini <pierluigi.fiorini@gmail.com>
** Contact: https://www.qt.io/licensing/
**
** This file is part of the plugins of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

/*
 * This lookup table was generated from https://git.fedorahosted.org/cgit/hwdata.git/plain/pnp.ids
 *
 * Do not change directly this file, instead edit the
 * qtbase/util/edid/qedidvendortable.py script and regenerate this file.
 */

#ifndef QEDIDVENDORTABLE_P_H
#define QEDIDVENDORTABLE_P_H

QT_BEGIN_NAMESPACE

typedef struct VendorTable {
    const char id[4];
    const char name[78];
} VendorTable;

static const struct VendorTable q_edidVendorTable[] = {
    { "LLL", "L-3 Communications" },
    { "GMX", "GMX Inc" },
    { "FOS", "Foss Tecator" },
    { "PHI", "DO NOT USE - PHI" },
    { "DNV", "DiCon" },
    { "KZN", "K-Zone International" },
    { "TIC", "Trigem KinfoComm" },
    { "FNC", "Fanuc LTD" },
    { "ESY", "E-Systems Inc" },
    { "TGM", "TriGem Computer,Inc." },
    { "DBN", "DB Networks Inc" },
    { "GCS", "Grey Cell Systems Ltd" },
    { "AVR", "AVer Information Inc." },
    { "OKI", "OKI Electric Industrial Company Ltd" },
    { "GDI", "G. Diehl ISDN GmbH" },
    { "SPC", "SpinCore Technologies, Inc" },
    { "ICV", "Inside Contactless" },
    { "UNY", "Unicate" },
    { "NMP", "Nokia Mobile Phones" },
    { "HMC", "Hualon Microelectric Corporation" },
    { "OPT", "OPTi Inc" },
    { "TSG", "The Software Group Ltd" },
    { "IMN", "Impossible Production" },
    { "DHQ", "Quadram" },
    { "UFG", "UNIGRAF-USA" },
    { "CLA", "Clarion Company Ltd" },
    { "IOM", "Iomega" },
    { "MTS", "Multi-Tech Systems" },
    { "TXN", "Texas Insturments" },
    { "SDH", "Communications Specialies, Inc." },
    { "DCC", "Dale Computer Corporation" },
    { "PAK", "Many CNC System Co., Ltd." },
    { "TDC", "Teradici" },
    { "XAC", "XAC Automation Corp" },
    { "DRI", "Data Race Inc" },
    { "HAN", "Hanchang System Corporation" },
    { "NTR", "N-trig Innovative Technologies, Inc." },
    { "PDR", "Pure Data Inc" },
    { "BNS", "Boulder Nonlinear Systems" },
    { "EGO", "Ergo Electronics" },
    { "ETS", "Electronic Trade Solutions Ltd" },
    { "CNN", "Canon Inc" },
    { "CSB", "Transtex SA" },
    { "NAK", "Nakano Engineering Co.,Ltd." },
    { "IME", "Imagraph" },
    { "CYT", "Cytechinfo Inc" },
    { "ADM", "Ad Lib MultiMedia Inc" },
    { "IBC", "Integrated Business Systems" },
    { "TMT", "T-Metrics Inc." },
    { "ALP", "Alps Electric Company Ltd" },
    { "TWX", "TEKWorx Limited" },
    { "CDP", "CalComp" },
    { "KSX", "King Tester Corporation" },
    { "AMI", "American Megatrends Inc" },
    { "KBI", "Kidboard Inc" },
    { "COO", "coolux GmbH" },
    { "CBR", "Cebra Tech A/S" },
    { "ANA", "Anakron" },
    { "ACT", "Applied Creative Technology" },
    { "PGS", "Princeton Graphic Systems" },
    { "DCL", "Dynamic Controls Ltd" },
    { "TCH", "Interaction Systems, Inc" },
    { "STP", "StreamPlay Ltd" },
    { "PCG", "First Industrial Computer Inc" },
    { "SSE", "Samsung Electronic Co." },
    { "TXT", "Textron Defense System" },
    { "XRO", "XORO ELECTRONICS (CHENGDU) LIMITED" },
    { "MTU", "Mark of the Unicorn Inc" },
    { "ERG", "Ergo System" },
    { "GFN", "Gefen Inc." },
    { "UNE", "Unisys Corporation" },
    { "DDD", "Danka Data Devices" },
    { "ZGT", "Zenith Data Systems" },
    { "NAL", "Network Alchemy" },
    { "FVX", "C-C-C Group Plc" },
    { "AJA", "AJA Video Systems, Inc." },
    { "AZT", "Aztech Systems Ltd" },
    { "CIS", "Cisco Systems Inc" },
    { "DUA", "Dosch & Amand GmbH & Company KG" },
    { "INP", "Interphase Corporation" },
    { "DMS", "DOME imaging systems" },
    { "COW", "Polycow Productions" },
    { "PTC", "PS Technology Corporation" },
    { "PRD", "Praim S.R.L." },
    { "DEC", "Digital Equipment Corporation" },
    { "SMT", "Silcom Manufacturing Tech Inc" },
    { "MII", "Mitec Inc" },
    { "QLC", "Q-Logic" },
    { "PRG", "The Phoenix Research Group Inc" },
    { "LNV", "Lenovo" },
    { "IND", "ILC" },
    { "MXL", "Hitachi Maxell, Ltd." },
    { "DAU", "Daou Tech Inc" },
    { "SNK", "S&K Electronics" },
    { "SYE", "SY Electronics Ltd" },
    { "BCC", "Beaver Computer Corporaton" },
    { "LPI", "Design Technology" },
    { "CLO", "Clone Computers" },
    { "CMI", "C-Media Electronics" },
    { "ESK", "ES&S" },
    { "HCW", "Hauppauge Computer Works Inc" },
    { "KPC", "King Phoenix Company" },
    { "DXS", "Signet" },
    { "OLY", "OLYMPUS CORPORATION" },
    { "OOS", "OSRAM" },
    { "NOE", "NordicEye AB" },
    { "DXP", "Data Expert Corporation" },
    { "ITP", "IT-PRO Consulting und Systemhaus GmbH" },
    { "MMS", "MMS Electronics" },
    { "FDC", "Future Domain" },
    { "ASM", "ASEM S.p.A." },
    { "AIC", "Arnos Insturments & Computer Systems" },
    { "ANC", "Ancot" },
    { "SEE", "SeeColor Corporation" },
    { "JAS", "Janz Automationssysteme AG" },
    { "TGV", "Grass Valley Germany GmbH" },
    { "LTI", "Jongshine Tech Inc" },
    { "JVC", "JVC" },
    { "TLV", "S3 Inc" },
    { "MGC", "Mentor Graphics Corporation" },
    { "NBS", "National Key Lab. on ISN" },
    { "GTI", "Goldtouch" },
    { "SPI", "SPACE-I Co., Ltd." },
    { "ZNX", "Znyx Adv. Systems" },
    { "EMC", "eMicro Corporation" },
    { "WDE", "Westinghouse Digital Electronics" },
    { "CEN", "Centurion Technologies P/L" },
    { "BFE", "B.F. Engineering Corporation" },
    { "DTL", "e-Net Inc" },
    { "FTL", "FUJITSU TEN LIMITED" },
    { "HSC", "Hagiwara Sys-Com Company Ltd" },
    { "ECP", "Elecom Company Ltd" },
    { "LJX", "Datalogic Corporation" },
    { "DRC", "Data Ray Corp." },
    { "STM", "SGS Thomson Microelectronics" },
    { "GDT", "Vortex Computersysteme GmbH" },
    { "JSK", "SANKEN ELECTRIC CO., LTD" },
    { "TMC", "Techmedia Computer Systems Corporation" },
    { "CFG", "Atlantis" },
    { "DCO", "Dialogue Technology Corporation" },
    { "NEC", "NEC Corporation" },
    { "SAE", "Saab Aerotech" },
    { "STA", "ST Electronics Systems Assembly Pte Ltd" },
    { "GEO", "GEO Sense" },
    { "SLH", "Silicon Library Inc." },
    { "SAG", "Sedlbauer" },
    { "VEK", "Vektrex" },
    { "ADA", "Addi-Data GmbH" },
    { "NCT", "NEC CustomTechnica, Ltd." },
    { "STX", "ST-Ericsson" },
    { "PRM", "Prometheus" },
    { "DPA", "DigiTalk Pro AV" },
    { "SLF", "StarLeaf" },
    { "AXY", "AXYZ Automation Services, Inc" },
    { "CPX", "Powermatic Data Systems" },
    { "DLL", "Dell Inc" },
    { "PLF", "Panasonic Avionics Corporation" },
    { "FRI", "Fibernet Research Inc" },
    { "BRM", "Braemar Inc" },
    { "MSK", "Megasoft Inc" },
    { "ECT", "Enciris Technologies" },
    { "TKO", "TouchKo, Inc." },
    { "CYC", "Cylink Corporation" },
    { "SMR", "B.& V. s.r.l." },
    { "SRT", "SeeReal Technologies GmbH" },
    { "GES", "GES Singapore Pte Ltd" },
    { "DHT", "Projectavision Inc" },
    { "ESC", "Eden Sistemas de Computacao S/A" },
    { "BYD", "byd:sign corporation" },
    { "BMI", "Benson Medical Instruments Company" },
    { "XSY", "XSYS" },
    { "MYX", "Micronyx Inc" },
    { "OUK", "OUK Company Ltd" },
    { "MPI", "Mediatrix Peripherals Inc" },
    { "BUS", "BusTek" },
    { "LCN", "LEXICON" },
    { "ADS", "Analog Devices Inc" },
    { "XTL", "Crystal Computer" },
    { "CEF", "Cefar Digital Vision" },
    { "IPP", "IP Power Technologies GmbH" },
    { "CDV", "Convergent Design Inc." },
    { "OLD", "Olidata S.p.A." },
    { "GNN", "GN Nettest Inc" },
    { "ADH", "Aerodata Holdings Ltd" },
    { "IMM", "Immersion Corporation" },
    { "CBT", "Cabletime Ltd" },
    { "RVI", "Realvision Inc" },
    { "HNS", "Hughes Network Systems" },
    { "HAR", "Harris Corporation" },
    { "ACV", "ActivCard S.A" },
    { "RUN", "RUNCO International" },
    { "WDC", "Western Digital" },
    { "SIG", "Sigma Designs Inc" },
    { "PNR", "Planar Systems, Inc." },
    { "PRS", "Leutron Vision" },
    { "KEM", "Kontron Embedded Modules GmbH" },
    { "LAN", "Sodeman Lancom Inc" },
    { "CEM", "MEC Electronics GmbH" },
    { "RHD", "RightHand Technologies" },
    { "CHE", "Acer Inc" },
    { "POL", "PolyComp (PTY) Ltd." },
    { "MST", "MS Telematica" },
    { "ALA", "Alacron Inc" },
    { "EDI", "Edimax Tech. Company Ltd" },
    { "EGN", "Egenera, Inc." },
    { "PIX", "Pixie Tech Inc" },
    { "AVN", "Advance Computer Corporation" },
    { "CTN", "Computone Products" },
    { "SFM", "TORNADO Company" },
    { "ATA", "Allied Telesyn International (Asia) Pte Ltd" },
    { "SIA", "SIEMENS AG" },
    { "NAV", "Navigation Corporation" },
    { "PRF", "Digital Electronics Corporation" },
    { "HRE", "Qingdao Haier Electronics Co., Ltd." },
    { "NAC", "Ncast Corporation" },
    { "ELM", "Elmic Systems Inc" },
    { "HYR", "Hypertec Pty Ltd" },
    { "EMB", "Embedded computing inc ltd" },
    { "MWR", "mware" },
    { "KGL", "KEISOKU GIKEN Co.,Ltd." },
    { "NRL", "U.S. Naval Research Lab" },
    { "TNM", "TECNIMAGEN SA" },
    { "GTT", "General Touch Technology Co., Ltd." },
    { "BTE", "Brilliant Technology" },
    { "KDS", "KDS USA" },
    { "EEP", "E.E.P.D. GmbH" },
    { "NCI", "NewCom Inc" },
    { "CIP", "Ciprico Inc" },
    { "RTL", "Realtek Semiconductor Company Ltd" },
    { "MUK", "mainpine limited" },
    { "SLX", "Specialix" },
    { "HCM", "HCL Peripherals" },
    { "CHA", "Chase Research PLC" },
    { "VOB", "MaxData Computer AG" },
    { "ANK", "Anko Electronic Company Ltd" },
    { "FWR", "Flat Connections Inc" },
    { "DXL", "Dextera Labs Inc" },
    { "QVU", "Quartics" },
    { "MPS", "mps Software GmbH" },
    { "AVM", "AVM GmbH" },
    { "TDY", "Tandy Electronics" },
    { "MJS", "MJS Designs" },
    { "SNC", "Sentronic International Corp." },
    { "IPT", "International Power Technologies" },
    { "API", "A Plus Info Corporation" },
    { "TLT", "Dai Telecom S.p.A." },
    { "PCC", "PowerCom Technology Company Ltd" },
    { "TRM", "Tekram Technology Company Ltd" },
    { "DEL", "Dell Inc." },
    { "CYW", "Cyberware" },
    { "TDS", "Tri-Data Systems Inc" },
    { "FPE", "Fujitsu Peripherals Ltd" },
    { "SPN", "Sapience Corporation" },
    { "COX", "Comrex" },
    { "STE", "SII Ido-Tsushin Inc" },
    { "RVC", "RSI Systems Inc" },
    { "HMK", "hmk Daten-System-Technik BmbH" },
    { "TTA", "Topson Technology Co., Ltd." },
    { "CSM", "Cosmic Engineering Inc." },
    { "PTL", "Pantel Inc" },
    { "EQX", "Equinox Systems Inc" },
    { "HEL", "Hitachi Micro Systems Europe Ltd" },
    { "TIX", "Tixi.Com GmbH" },
    { "CMD", "Colorado MicroDisplay, Inc." },
    { "VIS", "Visioneer" },
    { "MTH", "Micro-Tech Hearing Instruments" },
    { "ISR", "INSIS Co., LTD." },
    { "EME", "EMiNE TECHNOLOGY COMPANY, LTD." },
    { "DMT", "Distributed Management Task Force, Inc. (DMTF)" },
    { "JFX", "Jones Futurex Inc" },
    { "SMB", "Schlumberger" },
    { "GTM", "Garnet System Company Ltd" },
    { "DBK", "Databook Inc" },
    { "IQT", "IMAGEQUEST Co., Ltd" },
    { "DTX", "Data Translation" },
    { "QSI", "Quantum Solutions, Inc." },
    { "BEL", "Beltronic Industrieelektronik GmbH" },
    { "PJT", "Pan Jit International Inc." },
    { "WST", "Wistron Corporation" },
    { "ASN", "Asante Tech Inc" },
    { "ROS", "Rohde & Schwarz" },
    { "NWP", "NovaWeb Technologies Inc" },
    { "CLG", "CoreLogic" },
    { "ECS", "Elitegroup Computer Systems Company Ltd" },
    { "PER", "Perceptive Signal Technologies" },
    { "SPR", "pmns GmbH" },
    { "DLB", "Dolby Laboratories Inc." },
    { "SRF", "Surf Communication Solutions Ltd" },
    { "ATM", "ATM Ltd" },
    { "MED", "Messeltronik Dresden GmbH" },
    { "SGD", "Sigma Designs, Inc." },
    { "RJA", "Roland Corporation" },
    { "EDC", "e.Digital Corporation" },
    { "CON", "Contec Company Ltd" },
    { "CCJ", "CONTEC CO.,LTD." },
    { "GVC", "GVC Corporation" },
    { "TRI", "Tricord Systems" },
    { "SLB", "Shlumberger Ltd" },
    { "PRO", "Proteon" },
    { "DSI", "Digitan Systems Inc" },
    { "SDF", "SODIFF E&T CO., Ltd." },
    { "VDC", "VDC Display Systems" },
    { "PSL", "Perle Systems Limited" },
    { "SCR", "Systran Corporation" },
    { "DEX", "idex displays" },
    { "CDS", "Computer Diagnostic Systems" },
    { "RAY", "Raylar Design, Inc." },
    { "MMF", "Minnesota Mining and Manufacturing" },
    { "MMA", "Micromedia AG" },
    { "FUS", "Fujitsu Siemens Computers GmbH" },
    { "ESS", "ESS Technology Inc" },
    { "SIX", "Zuniq Data Corporation" },
    { "ISS", "ISS Inc" },
    { "PFT", "Telia ProSoft AB" },
    { "SOL", "Solitron Technologies Inc" },
    { "ZTM", "ZT Group Int'l Inc." },
    { "GZE", "GUNZE Limited" },
    { "CHS", "Agentur Chairos" },
    { "CBI", "ComputerBoards Inc" },
    { "DTA", "DELTATEC" },
    { "CSC", "Crystal Semiconductor" },
    { "MPC", "M-Pact Inc" },
    { "HHI", "Fraunhofer Heinrich-Hertz-Institute" },
    { "BIT", "Bit 3 Computer" },
    { "ICP", "ICP Electronics, Inc./iEi Technology Corp." },
    { "FOA", "FOR-A Company Limited" },
    { "NWC", "NW Computer Engineering" },
    { "MRO", "Medikro Oy" },
    { "IDT", "International Display Technology" },
    { "NMV", "NEC-Mitsubishi Electric Visual Systems Corporation" },
    { "COT", "Core Technology Inc" },
    { "PEL", "Primax Electric Ltd" },
    { "ZMZ", "Z Microsystems" },
    { "TYN", "Tyan Computer Corporation" },
    { "DIN", "Daintelecom Co., Ltd" },
    { "QTH", "Questech Ltd" },
    { "CYL", "Cyberlabs" },
    { "DGC", "Data General Corporation" },
    { "PPM", "Clinton Electronics Corp." },
    { "ITD", "Internet Technology Corporation" },
    { "MMM", "Electronic Measurements" },
    { "CMM", "Comtime GmbH" },
    { "NDC", "National DataComm Corporaiton" },
    { "TAS", "Taskit Rechnertechnik GmbH" },
    { "MFR", "MediaFire Corp." },
    { "HIC", "Hitachi Information Technology Co., Ltd." },
    { "CMC", "CMC Ltd" },
    { "TSE", "Tottori Sanyo Electric" },
    { "TMR", "Taicom International Inc" },
    { "SIE", "Siemens" },
    { "IMD", "ImasDe Canarias S.A." },
    { "SCE", "Sun Corporation" },
    { "PJD", "Projectiondesign AS" },
    { "VML", "Vine Micros Limited" },
    { "ETL", "Evertz Microsystems Ltd." },
    { "MAZ", "MAZeT GmbH" },
    { "UNC", "Unisys Corporation" },
    { "MEG", "Abeam Tech Ltd" },
    { "FCS", "Focus Enhancements, Inc." },
    { "MDV", "MET Development Inc" },
    { "GLD", "Goldmund - Digital Audio SA" },
    { "MRC", "Marconi Simulation & Ty-Coch Way Training" },
    { "FEC", "FURUNO ELECTRIC CO., LTD." },
    { "ALR", "Advanced Logic" },
    { "AEJ", "Alpha Electronics Company" },
    { "QCC", "QuakeCom Company Ltd" },
    { "TDK", "TDK USA Corporation" },
    { "TKN", "Teknor Microsystem Inc" },
    { "FMC", "Ford Microelectronics Inc" },
    { "KTI", "Konica Technical Inc" },
    { "AEI", "Actiontec Electric Inc" },
    { "TGI", "TriGem Computer Inc" },
    { "HIL", "Hilevel Technology" },
    { "WNI", "WillNet Inc." },
    { "FTI", "FastPoint Technologies, Inc." },
    { "ASU", "Asuscom Network Inc" },
    { "MEJ", "Mac-Eight Co., LTD." },
    { "SLS", "Schnick-Schnack-Systems GmbH" },
    { "SXG", "SELEX GALILEO" },
    { "EXP", "Data Export Corporation" },
    { "TPR", "Topro Technology Inc" },
    { "RCE", "Parc d'Activite des Bellevues" },
    { "VIK", "Viking Connectors" },
    { "TGS", "Torus Systems Ltd" },
    { "IDO", "IDEO Product Development" },
    { "MCE", "Metz-Werke GmbH & Co KG" },
    { "PHC", "Pijnenburg Beheer N.V." },
    { "BTF", "Bitfield Oy" },
    { "MCD", "McDATA Corporation" },
    { "EXY", "Exterity Ltd" },
    { "ZTI", "Zoom Telephonics Inc" },
    { "MTI", "Motorola Inc." },
    { "ONK", "ONKYO Corporation" },
    { "SEC", "Seiko Epson Corporation" },
    { "TTB", "National Semiconductor Japan Ltd" },
    { "SNO", "SINOSUN TECHNOLOGY CO., LTD" },
    { "SHG", "Soft & Hardware development Goldammer GmbH" },
    { "GEM", "Gem Plus" },
    { "BOS", "BOS" },
    { "SAK", "Saitek Ltd" },
    { "CNE", "Cine-tal" },
    { "BOB", "Rainy Orchard" },
    { "UNF", "Unisys Corporation" },
    { "MCG", "Motorola Computer Group" },
    { "RTC", "Relia Technologies" },
    { "ASD", "USC Information Sciences Institute" },
    { "BMS", "BIOMEDISYS" },
    { "LPE", "El-PUSK Co., Ltd." },
    { "CTA", "CoSystems Inc" },
    { "SVI", "Sun Microsystems" },
    { "PCS", "TOSHIBA PERSONAL COMPUTER SYSTEM CORPRATION" },
    { "GEN", "Genesys ATE Inc" },
    { "CRI", "Crio Inc." },
    { "TOG", "The OPEN Group" },
    { "SYT", "Seyeon Tech Company Ltd" },
    { "CRE", "Creative Labs Inc" },
    { "ALK", "Acrolink Inc" },
    { "TNC", "TNC Industrial Company Ltd" },
    { "PLV", "PLUS Vision Corp." },
    { "CCL", "CCL/ITRI" },
    { "PLY", "Polycom Inc." },
    { "RMC", "Raritan Computer, Inc" },
    { "XRC", "Xircom Inc" },
    { "BRC", "BARC" },
    { "CUK", "Calibre UK Ltd" },
    { "KME", "KIMIN Electronics Co., Ltd." },
    { "TBS", "Turtle Beach System" },
    { "ASY", "Rockwell Collins / Airshow Systems" },
    { "ALV", "AlphaView LCD" },
    { "VSD", "3M" },
    { "MTN", "Mtron Storage Technology Co., Ltd." },
    { "LMG", "Lucent Technologies" },
    { "HWP", "Hewlett Packard" },
    { "UEG", "Elitegroup Computer Systems Company Ltd" },
    { "FIC", "Formosa Industrial Computing Inc" },
    { "CRV", "Cerevo Inc." },
    { "AIL", "Altos India Ltd" },
    { "EMI", "Ex Machina Inc" },
    { "DPC", "Delta Electronics Inc" },
    { "ADN", "Analog & Digital Devices Tel. Inc" },
    { "LGC", "Logic Ltd" },
    { "DMP", "D&M Holdings Inc, Professional Business Company" },
    { "CEC", "Chicony Electronics Company Ltd" },
    { "BTC", "Bit 3 Computer" },
    { "IWX", "Intelliworxx, Inc." },
    { "SML", "Sumitomo Metal Industries, Ltd." },
    { "JWY", "Jetway Information Co., Ltd" },
    { "OMC", "OBJIX Multimedia Corporation" },
    { "CIT", "Citifax Limited" },
    { "AOE", "Advanced Optics Electronics, Inc." },
    { "SYC", "Sysmic" },
    { "ZTT", "Z3 Technology" },
    { "LCS", "Longshine Electronics Company" },
    { "NXQ", "Nexiq Technologies, Inc." },
    { "PSY", "Prodea Systems Inc." },
    { "CUB", "Cubix Corporation" },
    { "JWL", "Jewell Instruments, LLC" },
    { "SUB", "Subspace Comm. Inc" },
    { "PTG", "Cipher Systems Inc" },
    { "TON", "TONNA" },
    { "VBR", "VBrick Systems Inc." },
    { "RTI", "Rancho Tech Inc" },
    { "IMG", "IMAGENICS Co., Ltd." },
    { "AEP", "Aetas Peripheral International" },
    { "PTH", "Pathlight Technology Inc" },
    { "ZYX", "Zyxel" },
    { "NXP", "NXP Semiconductors bv." },
    { "OYO", "Shadow Systems" },
    { "PVM", "Penta Studiotechnik GmbH" },
    { "AVC", "Auravision Corporation" },
    { "SYM", "Symicron Computer Communications Ltd." },
    { "AVI", "Nippon Avionics Co.,Ltd" },
    { "EYE", "eyevis GmbH" },
    { "PLM", "PROLINK Microsystems Corp." },
    { "NFC", "BTC Korea Co., Ltd" },
    { "PIE", "Pacific Image Electronics Company Ltd" },
    { "SRC", "Integrated Tech Express Inc" },
    { "CMX", "Comex Electronics AB" },
    { "OPP", "OPPO Digital, Inc." },
    { "GAL", "Galil Motion Control" },
    { "YHW", "Exacom SA" },
    { "SSD", "FlightSafety International" },
    { "FSC", "Future Systems Consulting KK" },
    { "HRI", "Hall Research" },
    { "PSA", "Advanced Signal Processing Technologies" },
    { "MSI", "Microstep" },
    { "IMI", "International Microsystems Inc" },
    { "IDX", "IDEXX Labs" },
    { "SCO", "SORCUS Computer GmbH" },
    { "DIS", "Diseda S.A." },
    { "SVA", "SGEG" },
    { "SMA", "SMART Modular Technologies" },
    { "SXL", "SolutionInside" },
    { "WRC", "WiNRADiO Communications" },
    { "NIT", "Network Info Technology" },
    { "EKS", "EKSEN YAZILIM" },
    { "GEF", "GE Fanuc Embedded Systems" },
    { "DEI", "Deico Electronics" },
    { "DCD", "Datacast LLC" },
    { "MEE", "Mitsubishi Electric Engineering Co., Ltd." },
    { "LSC", "LifeSize Communications" },
    { "PDV", "Prodrive B.V." },
    { "HIB", "Hibino Corporation" },
    { "SKT", "Samsung Electro-Mechanics Company Ltd" },
    { "SAN", "Sanyo Electric Co.,Ltd." },
    { "RCO", "Rockwell Collins" },
    { "SNY", "Sony" },
    { "ANR", "ANR Ltd" },
    { "DKY", "Datakey Inc" },
    { "OPC", "Opcode Inc" },
    { "TBC", "Turbo Communication, Inc" },
    { "CNT", "COINT Multimedia Systems" },
    { "HDC", "HardCom Elektronik & Datateknik" },
    { "UNB", "Unisys Corporation" },
    { "IOD", "I-O Data Device Inc" },
    { "APR", "Aprilia s.p.a." },
    { "AXX", "Axxon Computer Corporation" },
    { "AED", "Advanced Electronic Designs, Inc." },
    { "MTX", "Matrox" },
    { "TAX", "Taxan (Europe) Ltd" },
    { "TVS", "TVS Electronics Limited" },
    { "CZE", "Carl Zeiss AG" },
    { "SMI", "SpaceLabs Medical Inc" },
    { "FCB", "Furukawa Electric Company Ltd" },
    { "AXP", "American Express" },
    { "FST", "Modesto PC Inc" },
    { "PSI", "PSI-Perceptive Solutions Inc" },
    { "MCR", "Marina Communicaitons" },
    { "JCE", "Jace Tech Inc" },
    { "GRE", "GOLD RAIN ENTERPRISES CORP." },
    { "SYN", "Synaptics Inc" },
    { "MBC", "MBC" },
    { "SIB", "Sanyo Electric Company Ltd" },
    { "TCT", "Telecom Technology Centre Co. Ltd." },
    { "BIC", "Big Island Communications" },
    { "UNI", "Unisys Corporation" },
    { "ELX", "Elonex PLC" },
    { "ZDS", "Zenith Data Systems" },
    { "XLX", "Xilinx, Inc." },
    { "MIC", "Micom Communications Inc" },
    { "SEB", "system elektronik GmbH" },
    { "WIN", "Wintop Technology Inc" },
    { "CDG", "Christie Digital Systems Inc" },
    { "HUB", "GAI-Tronics, A Hubbell Company" },
    { "CSE", "Concept Solutions & Engineering" },
    { "SUR", "Surenam Computer Corporation" },
    { "VTM", "Miltope Corporation" },
    { "ATK", "Allied Telesyn Int'l" },
    { "MGT", "Megatech R & D Company" },
    { "SLK", "Silitek Corporation" },
    { "DYN", "Askey Computer Corporation" },
    { "KEY", "Key Tech Inc" },
    { "DVD", "Dictaphone Corporation" },
    { "OTT", "OPTO22, Inc." },
    { "TCI", "Tulip Computers Int'l B.V." },
    { "ACB", "Aculab Ltd" },
    { "PAD", "Promotion and Display Technology Ltd." },
    { "CMG", "Chenming Mold Ind. Corp." },
    { "UJR", "Ueda Japan Radio Co., Ltd." },
    { "LHA", "Lars Haagh ApS" },
    { "SIM", "S3 Inc" },
    { "TPC", "Touch Panel Systems Corporation" },
    { "TVD", "Tecnovision" },
    { "FZI", "FZI Forschungszentrum Informatik" },
    { "AIW", "Aiwa Company Ltd" },
    { "LTW", "Lightware, Inc" },
    { "DSP", "Domain Technology Inc" },
    { "ILS", "Innotech Corporation" },
    { "VDM", "Vadem" },
    { "KYK", "Samsung Electronics America Inc" },
    { "NTW", "Networth Inc" },
    { "SID", "Seiko Instruments Information Devices Inc" },
    { "MRT", "Merging Technologies" },
    { "MGL", "M-G Technology Ltd" },
    { "UBL", "Ubinetics Ltd." },
    { "PSM", "Prosum" },
    { "MDR", "Medar Inc" },
    { "STN", "Samsung Electronics America" },
    { "NCR", "NCR Electronics" },
    { "INU", "Inovatec S.p.A." },
    { "WAL", "Wave Access" },
    { "BLN", "BioLink Technologies" },
    { "RXT", "Tectona SoftSolutions (P) Ltd.," },
    { "MRL", "Miratel" },
    { "ZAZ", "Zazzle Technologies" },
    { "NIC", "National Instruments Corporation" },
    { "FMZ", "Formoza-Altair" },
    { "MDG", "Madge Networks" },
    { "VIA", "VIA Tech Inc" },
    { "KOD", "Eastman Kodak Company" },
    { "SAI", "Sage Inc" },
    { "FEL", "Fellowes & Questec" },
    { "SLI", "Symbios Logic Inc" },
    { "ELE", "Elecom Company Ltd" },
    { "FRE", "Forvus Research Inc" },
    { "TTL", "2-Tel B.V." },
    { "PPX", "Perceptive Pixel Inc." },
    { "NAT", "NaturalPoint Inc." },
    { "SLC", "Syslogic Datentechnik AG" },
    { "PAM", "Peter Antesberger Messtechnik" },
    { "JPW", "Wallis Hamilton Industries" },
    { "AVA", "Avaya Communication" },
    { "EEH", "EEH Datalink GmbH" },
    { "WMT", "Winmate Communication Inc" },
    { "LWC", "Labway Corporation" },
    { "HYO", "HYC CO., LTD." },
    { "MCC", "Micro Industries" },
    { "IOA", "CRE Technology Corporation" },
    { "AGI", "Artish Graphics Inc" },
    { "TDT", "TDT" },
    { "UNO", "Unisys Corporation" },
    { "LIN", "Lenovo Beijing Co. Ltd." },
    { "MAG", "MAG InnoVision" },
    { "HCL", "HCL America Inc" },
    { "BWK", "Bitworks Inc." },
    { "BSN", "BRIGHTSIGN, LLC" },
    { "INM", "InnoMedia Inc" },
    { "MIN", "Minicom Digital Signage" },
    { "ARE", "ICET S.p.A." },
    { "TPZ", "Ypoaz Systems Inc" },
    { "BRO", "BROTHER INDUSTRIES,LTD." },
    { "MEX", "MSC Vertriebs GmbH" },
    { "FJC", "Fujitsu Takamisawa Component Limited" },
    { "HRT", "HERCULES" },
    { "MOM", "Momentum Data Systems" },
    { "RSV", "Ross Video Ltd" },
    { "RAN", "Rancho Tech Inc" },
    { "HOL", "Holoeye Photonics AG" },
    { "SOT", "Sotec Company Ltd" },
    { "AAE", "Anatek Electronics Inc." },
    { "ZYT", "Zytex Computers" },
    { "APP", "Apple Computer Inc" },
    { "MCM", "Metricom Inc" },
    { "NXC", "NextCom K.K." },
    { "CBX", "Cybex Computer Products Corporation" },
    { "FJS", "Fujitsu Spain" },
    { "SNI", "Siemens Microdesign GmbH" },
    { "MPL", "Maple Research Inst. Company Ltd" },
    { "PLX", "Parallax Graphics" },
    { "EAS", "Evans and Sutherland Computer" },
    { "ZBR", "Zebra Technologies International, LLC" },
    { "MSL", "MicroSlate Inc." },
    { "XOC", "DO NOT USE - XOC" },
    { "EMG", "EMG Consultants Inc" },
    { "SMC", "Standard Microsystems Corporation" },
    { "RAD", "Radisys Corporation" },
    { "NMS", "Natural Micro System" },
    { "APT", "Audio Processing Technology Ltd" },
    { "MLI", "McIntosh Laboratory Inc." },
    { "ISI", "Interface Solutions" },
    { "RAT", "Rent-A-Tech" },
    { "BAN", "Banyan" },
    { "PCL", "pentel.co.,ltd" },
    { "CSI", "Cabletron System Inc" },
    { "IVS", "Intevac Photonics Inc." },
    { "MAT", "Matsushita Electric Ind. Company Ltd" },
    { "LWR", "Lightware Visual Engineering" },
    { "FWA", "Attero Tech, LLC" },
    { "ORI", "OSR Open Systems Resources, Inc." },
    { "ARG", "Argus Electronics Co., LTD" },
    { "CAS", "CASIO COMPUTER CO.,LTD" },
    { "DHP", "DH Print" },
    { "TTS", "TechnoTrend Systemtechnik GmbH" },
    { "HHC", "HIRAKAWA HEWTECH CORP." },
    { "GRM", "Garmin International" },
    { "BUL", "Bull" },
    { "AFA", "Alfa Inc" },
    { "OVR", "Oculus VR, Inc." },
    { "EPI", "Envision Peripherals, Inc" },
    { "GSC", "General Standards Corporation" },
    { "DNG", "Apache Micro Peripherals Inc" },
    { "VIN", "Vine Micros Ltd" },
    { "PTW", "DO NOT USE - PTW" },
    { "MFI", "Micro Firmware" },
    { "SMP", "Simple Computing" },
    { "HCA", "DAT" },
    { "PHL", "Philips Consumer Electronics Company" },
    { "ADC", "Acnhor Datacomm" },
    { "VBT", "Valley Board Ltda" },
    { "MPX", "Micropix Technologies, Ltd." },
    { "VSP", "Vision Systems GmbH" },
    { "PJA", "Projecta" },
    { "AMT", "AMT International Industry" },
    { "VCI", "VistaCom Inc" },
    { "XIR", "Xirocm Inc" },
    { "MBV", "Moreton Bay" },
    { "NSC", "National Semiconductor Corporation" },
    { "TPV", "Top Victory Electronics ( Fujian ) Company Ltd" },
    { "HAE", "Haider electronics" },
    { "PKA", "Acco UK ltd." },
    { "PXC", "Phoenix Contact" },
    { "BXE", "Buxco Electronics" },
    { "OZC", "OZ Corporation" },
    { "TXL", "Trixel Ltd" },
    { "MXD", "MaxData Computer GmbH & Co.KG" },
    { "ASK", "Ask A/S" },
    { "KSC", "Kinetic Systems Corporation" },
    { "XAD", "Alpha Data" },
    { "MVI", "Media Vision Inc" },
    { "BPU", "Best Power" },
    { "LAF", "Microline" },
    { "SPS", "Synopsys Inc" },
    { "WXT", "Woxter Technology Co. Ltd" },
    { "NIX", "Seanix Technology Inc" },
    { "HPA", "Zytor Communications" },
    { "SPK", "SpeakerCraft" },
    { "CHP", "CH Products" },
    { "SNX", "Sonix Comm. Ltd" },
    { "LZX", "Lightwell Company Ltd" },
    { "ART", "Corion Industrial Corporation" },
    { "IFS", "In Focus Systems Inc" },
    { "DAL", "Digital Audio Labs Inc" },
    { "STR", "Starlight Networks Inc" },
    { "PRT", "Parade Technologies, Ltd." },
    { "VRC", "Virtual Resources Corporation" },
    { "IIC", "ISIC Innoscan Industrial Computers A/S" },
    { "AUR", "Aureal Semiconductor" },
    { "ATC", "Ably-Tech Corporation" },
    { "ODR", "Odrac" },
    { "LIP", "Linked IP GmbH" },
    { "FLI", "Faroudja Laboratories" },
    { "AVV", "SBS Technologies (Canada), Inc. (was Avvida Systems, Inc.)" },
    { "ECM", "E-Cmos Tech Corporation" },
    { "LAG", "Laguna Systems" },
    { "FFC", "FUJIFILM Corporation" },
    { "MAX", "Rogen Tech Distribution Inc" },
    { "HUM", "IMP Electronics Ltd." },
    { "VTX", "Vestax Corporation" },
    { "NST", "Network Security Technology Co" },
    { "FLY", "Butterfly Communications" },
    { "ETT", "E-Tech Inc" },
    { "NXS", "Technology Nexus Secure Open Systems AB" },
    { "VES", "Vestel Elektronik Sanayi ve Ticaret A. S." },
    { "EBT", "HUALONG TECHNOLOGY CO., LTD" },
    { "HPK", "HAMAMATSU PHOTONICS K.K." },
    { "RGB", "RGB Spectrum" },
    { "AUI", "Alps Electric Inc" },
    { "ICI", "Infotek Communication Inc" },
    { "NTS", "Nits Technology Inc." },
    { "EVI", "eviateg GmbH" },
    { "CRD", "Cardinal Technical Inc" },
    { "MOD", "Modular Technology" },
    { "CCP", "Capetronic USA Inc" },
    { "DGS", "Diagsoft Inc" },
    { "IFT", "Informtech" },
    { "LWW", "Lanier Worldwide" },
    { "SDK", "SAIT-Devlonics" },
    { "UWC", "Uniwill Computer Corp." },
    { "MXV", "MaxVision Corporation" },
    { "HOE", "Hosiden Corporation" },
    { "SGE", "Kansai Electric Company Ltd" },
    { "URD", "Video Computer S.p.A." },
    { "TSV", "TRANSVIDEO" },
    { "MBM", "Marshall Electronics" },
    { "TLA", "Ferrari Electronic GmbH" },
    { "GLM", "Genesys Logic" },
    { "LEN", "Lenovo Group Limited" },
    { "SAM", "Samsung Electric Company" },
    { "VTL", "Vivid Technology Pte Ltd" },
    { "UTD", "Up to Date Tech" },
    { "ITC", "Intercom Inc" },
    { "ENI", "Efficient Networks" },
    { "GDC", "General Datacom" },
    { "XIT", "Xitel Pty ltd" },
    { "CMN", "Chimei Innolux Corporation" },
    { "AVE", "Add Value Enterpises (Asia) Pte Ltd" },
    { "WEC", "Winbond Electronics Corporation" },
    { "OAK", "Oak Tech Inc" },
    { "DON", "DENON, Ltd." },
    { "ITR", "Infotronic America, Inc." },
    { "CAC", "CA & F Elettronica" },
    { "VIM", "Via Mons Ltd." },
    { "DGP", "Digicorp European sales S.A." },
    { "HPD", "Hewlett Packard" },
    { "USD", "U.S. Digital Corporation" },
    { "TAM", "Tamura Seisakusyo Ltd" },
    { "SGZ", "Systec Computer GmbH" },
    { "NGS", "A D S Exports" },
    { "FSI", "Fore Systems Inc" },
    { "SIL", "Silicon Laboratories, Inc" },
    { "QCP", "Qualcomm Inc" },
    { "SDA", "SAT (Societe Anonyme)" },
    { "SEI", "Seitz & Associates Inc" },
    { "RSI", "Rampage Systems Inc" },
    { "VIZ", "VIZIO, Inc" },
    { "EPN", "EPiCON Inc." },
    { "OIC", "Option Industrial Computers" },
    { "KDE", "KDE" },
    { "CLV", "Clevo Company" },
    { "GRA", "Graphica Computer" },
    { "HIK", "Hikom Co., Ltd." },
    { "LCE", "La Commande Electronique" },
    { "MNP", "Microcom" },
    { "ERI", "Ericsson Mobile Communications AB" },
    { "REX", "RATOC Systems, Inc." },
    { "PPP", "Purup Prepress AS" },
    { "JAT", "Jaton Corporation" },
    { "GLE", "AD electronics" },
    { "VAL", "Valence Computing Corporation" },
    { "CDN", "Codenoll Technical Corporation" },
    { "SDT", "Siemens AG" },
    { "RSC", "PhotoTelesis" },
    { "FFI", "Fairfield Industries" },
    { "VPR", "Best Buy" },
    { "IPM", "IPM Industria Politecnica Meridionale SpA" },
    { "HSM", "AT&T Microelectronics" },
    { "YHQ", "Yokogawa Electric Corporation" },
    { "UEC", "Ultima Electronics Corporation" },
    { "NME", "Navico, Inc." },
    { "GVL", "Global Village Communication" },
    { "TEK", "Tektronix Inc" },
    { "SBD", "Softbed - Consulting & Development Ltd" },
    { "PSD", "Peus-Systems GmbH" },
    { "DCA", "Digital Communications Association" },
    { "HWC", "DBA Hans Wedemeyer" },
    { "DFK", "SharkTec A/S" },
    { "DMB", "Digicom Systems Inc" },
    { "IPW", "IPWireless, Inc" },
    { "ACC", "Accton Technology Corporation" },
    { "CPM", "Capella Microsystems Inc." },
    { "AAT", "Ann Arbor Technologies" },
    { "LAS", "LASAT Comm. A/S" },
    { "TWI", "Easytel oy" },
    { "HJI", "Harris & Jeffries Inc" },
    { "SGX", "Silicon Graphics Inc" },
    { "TSL", "Tottori SANYO Electric Co., Ltd." },
    { "SVD", "SVD Computer" },
    { "CLT", "automated computer control systems" },
    { "WLD", "Wildfire Communications Inc" },
    { "LCI", "Lite-On Communication Inc" },
    { "AEC", "Antex Electronics Corporation" },
    { "ACA", "Ariel Corporation" },
    { "KML", "Kensington Microware Ltd" },
    { "KDT", "KDDI Technology Corporation" },
    { "BSE", "Bose Corporation" },
    { "WSP", "Wireless And Smart Products Inc." },
    { "GNZ", "Gunze Ltd" },
    { "PMM", "Point Multimedia System" },
    { "ASC", "Ascom Strategic Technology Unit" },
    { "EVX", "Everex" },
    { "WBN", "MicroSoftWare" },
    { "FGL", "Fujitsu General Limited." },
    { "JSI", "Jupiter Systems, Inc." },
    { "SII", "Silicon Image, Inc." },
    { "SMM", "Shark Multimedia Inc" },
    { "XYC", "Xycotec Computer GmbH" },
    { "PEC", "POTRANS Electrical Corp." },
    { "TSD", "TechniSat Digital GmbH" },
    { "ZSE", "Zenith Data Systems" },
    { "ENC", "Eizo Nanao Corporation" },
    { "MWY", "Microway Inc" },
    { "OLI", "Olivetti" },
    { "WIL", "WIPRO Information Technology Ltd" },
    { "LKM", "Likom Technology Sdn. Bhd." },
    { "KOU", "KOUZIRO Co.,Ltd." },
    { "VHI", "Macrocad Development Inc." },
    { "FIT", "Feature Integration Technology Inc." },
    { "MXP", "Maxpeed Corporation" },
    { "SCD", "Sanyo Electric Company Ltd" },
    { "NBL", "N*Able Technologies Inc" },
    { "SPT", "Sceptre Tech Inc" },
    { "IPN", "Performance Technologies" },
    { "BMD", "Blackmagic Design" },
    { "MDK", "Mediatek Corporation" },
    { "DCS", "Diamond Computer Systems Inc" },
    { "ICE", "IC Ensemble" },
    { "LSY", "LSI Systems Inc" },
    { "AMC", "Attachmate Corporation" },
    { "TCO", "Thomas-Conrad Corporation" },
    { "NOK", "Nokia Display Products" },
    { "VFI", "VeriFone Inc" },
    { "OPV", "Optivision Inc" },
    { "LCM", "Latitude Comm." },
    { "LSL", "Logical Solutions" },
    { "TVO", "TV One Ltd" },
    { "KVA", "Kvaser AB" },
    { "PMT", "Promate Electronic Co., Ltd." },
    { "ZZZ", "Boca Research Inc" },
    { "ELC", "Electro Scientific Ind" },
    { "SIR", "Sirius Technologies Pty Ltd" },
    { "DCE", "dSPACE GmbH" },
    { "WAN", "DO NOT USE - WAN" },
    { "PCT", "PC-Tel Inc" },
    { "BEO", "Baug & Olufsen" },
    { "LUM", "Lumagen, Inc." },
    { "DNA", "DNA Enterprises, Inc." },
    { "WEY", "WEY Design AG" },
    { "IAF", "Institut f r angewandte Funksystemtechnik GmbH" },
    { "QFF", "Padix Co., Inc." },
    { "JIC", "Jaeik Information & Communication Co., Ltd." },
    { "VIT", "Visitech AS" },
    { "QUA", "Quatographic AG" },
    { "BNK", "Banksia Tech Pty Ltd" },
    { "TME", "AT&T Microelectronics" },
    { "DRB", "Dr. Bott KG" },
    { "NET", "Mettler Toledo" },
    { "CDE", "Colin.de" },
    { "ATI", "Allied Telesis KK" },
    { "PMD", "TDK USA Corporation" },
    { "SKY", "SKYDATA S.P.A." },
    { "FTN", "Fountain Technologies Inc" },
    { "DBD", "Diebold Inc." },
    { "ECA", "Electro Cam Corp." },
    { "TLI", "TOSHIBA TELI CORPORATION" },
    { "CTC", "CTC Communication Development Company Ltd" },
    { "NVT", "Navatek Engineering Corporation" },
    { "CKC", "The Concept Keyboard Company Ltd" },
    { "FIR", "Chaplet Systems Inc" },
    { "HYD", "Hydis Technologies.Co.,LTD" },
    { "TTY", "TRIDELITY Display Solutions GmbH" },
    { "DAE", "Digatron Industrie Elektronik GmbH" },
    { "AUT", "Autotime Corporation" },
    { "GTC", "Graphtec Corporation" },
    { "MYR", "Myriad Solutions Ltd" },
    { "DLT", "Digitelec Informatique Park Cadera" },
    { "SDR", "SDR Systems" },
    { "ACS", "Altos Computer Systems" },
    { "SVC", "Intellix Corp." },
    { "ZTE", "ZTE Corporation" },
    { "ERT", "Escort Insturments Corporation" },
    { "WII", "Innoware Inc" },
    { "DOL", "Dolman Technologies Group Inc" },
    { "RLD", "MEPCO" },
    { "HRL", "Herolab GmbH" },
    { "IRD", "IRdata" },
    { "IVI", "Intervoice Inc" },
    { "ICS", "Integrated Circuit Systems" },
    { "ASE", "AseV Display Labs" },
    { "SYX", "Prime Systems, Inc." },
    { "SOI", "Silicon Optix Corporation" },
    { "OCS", "Open Connect Solutions" },
    { "HON", "Sonitronix" },
    { "TAG", "Teles AG" },
    { "PEP", "Peppercon AG" },
    { "INT", "Interphase Corporation" },
    { "IBR", "IBR GmbH" },
    { "WYS", "Wyse Technology" },
    { "TRE", "Tremetrics" },
    { "RKC", "Reakin Technolohy Corporation" },
    { "SEG", "DO NOT USE - SEG" },
    { "CAV", "Cavium Networks, Inc" },
    { "ELA", "ELAD srl" },
    { "MMD", "Micromed Biotecnologia Ltd" },
    { "SGL", "Super Gate Technology Company Ltd" },
    { "SIS", "Silicon Integrated Systems Corporation" },
    { "XFO", "EXFO Electro Optical Engineering" },
    { "ING", "Integraph Corporation" },
    { "NEU", "NEUROTEC - EMPRESA DE PESQUISA E DESENVOLVIMENTO EM BIOMEDICINA" },
    { "ZIC", "Nationz Technologies Inc." },
    { "CVI", "Colorado Video, Inc." },
    { "VCC", "Virtual Computer Corporation" },
    { "INZ", "Best Buy" },
    { "ELO", "Tyco Electronics" },
    { "EPH", "Epiphan Systems Inc." },
    { "SYL", "Sylvania Computer Products" },
    { "MXI", "Macronix Inc" },
    { "GEH", "GE Intelligent Platforms - Huntsville" },
    { "BBB", "an-najah university" },
    { "ARK", "Ark Logic Inc" },
    { "IVM", "Iiyama North America" },
    { "XTE", "X2E GmbH" },
    { "DMV", "NDS Ltd" },
    { "CPD", "CompuAdd" },
    { "CYD", "Cyclades Corporation" },
    { "ALX", "ALEXON Co.,Ltd." },
    { "COB", "COBY Electronics Co., Ltd" },
    { "HCE", "Hitachi Consumer Electronics Co., Ltd" },
    { "EXX", "Exxact GmbH" },
    { "TAB", "Todos Data System AB" },
    { "MPN", "Mainpine Limited" },
    { "ATH", "Athena Informatica S.R.L." },
    { "AWL", "Aironet Wireless Communications, Inc" },
    { "FNI", "Funai Electric Co., Ltd." },
    { "PLT", "PT Hartono Istana Teknologi" },
    { "DEN", "Densitron Computers Ltd" },
    { "MIM", "Mimio – A Newell Rubbermaid Company" },
    { "GER", "GERMANEERS GmbH" },
    { "CAI", "Canon Inc." },
    { "DNI", "Deterministic Networks Inc." },
    { "DOT", "Dotronic Mikroelektronik GmbH" },
    { "MVX", "COM 1" },
    { "WTC", "ACC Microelectronics" },
    { "HIT", "Hitachi America Ltd" },
    { "ALM", "Acutec Ltd." },
    { "TIP", "TIPTEL AG" },
    { "END", "ENIDAN Technologies Ltd" },
    { "PAR", "Parallan Comp Inc" },
    { "DVL", "Devolo AG" },
    { "ADV", "Advanced Micro Devices Inc" },
    { "TKS", "TimeKeeping Systems, Inc." },
    { "MLD", "Deep Video Imaging Ltd" },
    { "IUC", "ICSL" },
    { "MNL", "Monorail Inc" },
    { "HRC", "Hercules" },
    { "ANS", "Ansel Communication Company" },
    { "UAS", "Ultima Associates Pte Ltd" },
    { "SBS", "SBS-or Industrial Computers GmbH" },
    { "DVT", "Data Video" },
    { "PTS", "Plain Tree Systems Inc" },
    { "CSD", "Cresta Systems Inc" },
    { "LDT", "LogiDataTech Electronic GmbH" },
    { "AGM", "Advan Int'l Corporation" },
    { "TLD", "Telindus" },
    { "SPU", "SIM2 Multimedia S.P.A." },
    { "BCS", "Booria CAD/CAM systems" },
    { "CRQ", "Cirque Corporation" },
    { "MIL", "Marconi Instruments Ltd" },
    { "FTE", "Frontline Test Equipment Inc." },
    { "RWC", "Red Wing Corporation" },
    { "TLS", "Teleste Educational OY" },
    { "DAT", "Datel Inc" },
    { "SIT", "Sitintel" },
    { "QTI", "Quicknet Technologies Inc" },
    { "EBH", "Data Price Informatica" },
    { "PCK", "PCBANK21" },
    { "VSC", "ViewSonic Corporation" },
    { "BBL", "Brain Boxes Limited" },
    { "UFO", "UFO Systems Inc" },
    { "NTI", "New Tech Int'l Company" },
    { "WAV", "Wavephore" },
    { "NOT", "Not Limited Inc" },
    { "GRH", "Granch Ltd" },
    { "VTC", "VTel Corporation" },
    { "UNA", "Unisys DSD" },
    { "LAB", "ACT Labs Ltd" },
    { "UIC", "Uniform Industrial Corporation" },
    { "IDK", "IDK Corporation" },
    { "CHI", "Chrontel Inc" },
    { "QCH", "Metronics Inc" },
    { "CER", "Ceronix" },
    { "PCB", "OCTAL S.A." },
    { "VTV", "VATIV Technologies" },
    { "BTI", "BusTech Inc" },
    { "RVL", "Reveal Computer Prod" },
    { "CHC", "Chic Technology Corp." },
    { "QDS", "Quanta Display Inc." },
    { "DAW", "DA2 Technologies Inc" },
    { "MTR", "Mitron computer Inc" },
    { "PCP", "Procomp USA Inc" },
    { "AZM", "AZ Middelheim - Radiotherapy" },
    { "NHT", "Vinci Labs" },
    { "ROB", "Robust Electronics GmbH" },
    { "RIC", "RICOH COMPANY, LTD." },
    { "PCI", "Pioneer Computer Inc" },
    { "EKA", "MagTek Inc." },
    { "SWL", "Sharedware Ltd" },
    { "GSM", "Goldstar Company Ltd" },
    { "IDP", "Integrated Device Technology, Inc." },
    { "BPD", "Micro Solutions, Inc." },
    { "UNS", "Unisys Corporation" },
    { "PBN", "Packard Bell NEC" },
    { "KRM", "Kroma Telecom" },
    { "ENT", "Enterprise Comm. & Computing Inc" },
    { "ATL", "Arcus Technology Ltd" },
    { "VDT", "Viditec, Inc." },
    { "JUK", "Janich & Klass Computertechnik GmbH" },
    { "PVG", "Proview Global Co., Ltd" },
    { "INX", "Communications Supply Corporation (A division of WESCO)" },
    { "GDS", "GDS" },
    { "UHB", "XOCECO" },
    { "MEI", "Panasonic Industry Company" },
    { "OXU", "Oxus Research S.A." },
    { "SGO", "Logos Design A/S" },
    { "STU", "Sentelic Corporation" },
    { "PUL", "Pulse-Eight Ltd" },
    { "BRA", "Braemac Pty Ltd" },
    { "MBD", "Microbus PLC" },
    { "OAS", "Oasys Technology Company" },
    { "MDS", "Micro Display Systems Inc" },
    { "SCS", "Nanomach Anstalt" },
    { "DAS", "DAVIS AS" },
    { "NLC", "Next Level Communications" },
    { "MSU", "motorola" },
    { "MAD", "Xedia Corporation" },
    { "LOE", "Loewe Opta GmbH" },
    { "EEE", "ET&T Technology Company Ltd" },
    { "ANX", "Acer Netxus Inc" },
    { "IEE", "IEE" },
    { "ALL", "Alliance Semiconductor Corporation" },
    { "DCT", "Dancall Telecom A/S" },
    { "AII", "Amptron International Inc." },
    { "DPT", "DPT" },
    { "TNJ", "DO NOT USE - TNJ" },
    { "FTC", "Futuretouch Corporation" },
    { "ESG", "ELCON Systemtechnik GmbH" },
    { "SYV", "SYVAX Inc" },
    { "RAC", "Racore Computer Products Inc" },
    { "IBM", "IBM France" },
    { "LTV", "Leitch Technology International Inc." },
    { "AKE", "AKAMI Electric Co.,Ltd" },
    { "VDO", "Video & Display Oriented Corporation" },
    { "MEN", "MEN Mikroelectronik Nueruberg GmbH" },
    { "UNT", "Unisys Corporation" },
    { "TTK", "Totoku Electric Company Ltd" },
    { "DII", "Dataq Instruments Inc" },
    { "AMO", "Amino Technologies PLC and Amino Communications Limited" },
    { "IMC", "IMC Networks" },
    { "STG", "StereoGraphics Corp." },
    { "RRI", "Radicom Research Inc" },
    { "HTI", "Hampshire Company, Inc." },
    { "SOR", "Sorcus Computer GmbH" },
    { "AXL", "Axel" },
    { "SNS", "Cirtech (UK) Ltd" },
    { "IPD", "Industrial Products Design, Inc." },
    { "FMI", "Fujitsu Microelect Inc" },
    { "FMA", "Fast Multimedia AG" },
    { "MIT", "MCM Industrial Technology GmbH" },
    { "RII", "Racal Interlan Inc" },
    { "PDN", "AT&T Paradyne" },
    { "TRU", "Aashima Technology B.V." },
    { "BEI", "Beckworth Enterprises Inc" },
    { "RSS", "Rockwell Semiconductor Systems" },
    { "SHR", "Digital Discovery" },
    { "CDT", "IBM Corporation" },
    { "TKC", "Taiko Electric Works.LTD" },
    { "ITM", "ITM inc." },
    { "QUE", "Questra Consulting" },
    { "CMR", "Cambridge Research Systems Ltd" },
    { "LCC", "LCI" },
    { "MDO", "Panasonic" },
    { "IEC", "Interlace Engineering Corporation" },
    { "DPL", "Digital Projection Limited" },
    { "INV", "Inviso, Inc." },
    { "JSD", "JS DigiTech, Inc" },
    { "TOE", "TOEI Electronics Co., Ltd." },
    { "HAY", "Hayes Microcomputer Products Inc" },
    { "SSJ", "Sankyo Seiki Mfg.co., Ltd" },
    { "NNC", "NNC" },
    { "PHE", "Philips Medical Systems Boeblingen GmbH" },
    { "MWI", "Multiwave Innovation Pte Ltd" },
    { "WYT", "Wooyoung Image & Information Co.,Ltd." },
    { "AIM", "AIMS Lab Inc" },
    { "CSS", "CSS Laboratories" },
    { "TRS", "Torus Systems Ltd" },
    { "ROK", "Rockwell International" },
    { "SXD", "Silex technology, Inc." },
    { "PHS", "Philips Communication Systems" },
    { "CLM", "CrystaLake Multimedia" },
    { "ALO", "Algolith Inc." },
    { "SIU", "Seiko Instruments USA Inc" },
    { "TUA", "T+A elektroakustik GmbH" },
    { "CTE", "Chunghwa Telecom Co., Ltd." },
    { "SDD", "Intrada-SDD Ltd" },
    { "RMT", "Roper Mobile" },
    { "SSP", "Spectrum Signal Proecessing Inc" },
    { "VTN", "VIDEOTRON CORP." },
    { "VAD", "Vaddio, LLC" },
    { "SFT", "Mikroforum Ring 3" },
    { "DGK", "DugoTech Co., LTD" },
    { "ACH", "Archtek Telecom Corporation" },
    { "ABT", "Anchor Bay Technologies, Inc." },
    { "STC", "STAC Electronics" },
    { "DRS", "DRS Defense Solutions, LLC" },
    { "OQI", "Oksori Company Ltd" },
    { "IMT", "Inmax Technology Corporation" },
    { "ENE", "ENE Technology Inc." },
    { "WBS", "WB Systemtechnik GmbH" },
    { "PRC", "PerComm" },
    { "PSC", "Philips Semiconductors" },
    { "RJS", "Advanced Engineering" },
    { "STS", "SITECSYSTEM CO., LTD." },
    { "LAV", "Lava Computer MFG Inc" },
    { "RCH", "Reach Technology Inc" },
    { "DWE", "Daewoo Electronics Company Ltd" },
    { "KTC", "Kingston Tech Corporation" },
    { "GLS", "Gadget Labs LLC" },
    { "COS", "CoStar Corporation" },
    { "SBI", "SMART Technologies Inc." },
    { "ATP", "Alpha-Top Corporation" },
    { "DQB", "Datacube Inc" },
    { "INN", "Innovent Systems, Inc." },
    { "DNT", "Dr. Neuhous Telekommunikation GmbH" },
    { "KFX", "Kofax Image Products" },
    { "APE", "Alpine Electronics, Inc." },
    { "DSM", "DSM Digital Services GmbH" },
    { "RES", "ResMed Pty Ltd" },
    { "HMX", "HUMAX Co., Ltd." },
    { "PCW", "Pacific CommWare Inc" },
    { "KYC", "Kyocera Corporation" },
    { "VSN", "Ingram Macrotron" },
    { "SNT", "SuperNet Inc" },
    { "TEL", "Promotion and Display Technology Ltd." },
    { "IFX", "Infineon Technologies AG" },
    { "PVC", "DO NOT USE - PVC" },
    { "JKC", "JVC KENWOOD Corporation" },
    { "MSV", "Mosgi Corporation" },
    { "BUR", "Bernecker & Rainer Ind-Eletronik GmbH" },
    { "PTA", "PAR Tech Inc." },
    { "GGL", "Google Inc." },
    { "COM", "Comtrol Corporation" },
    { "JEN", "N-Vision" },
    { "AMP", "AMP Inc" },
    { "HDI", "HD-INFO d.o.o." },
    { "BOE", "BOE" },
    { "ICM", "Intracom SA" },
    { "ADD", "Advanced Peripheral Devices Inc" },
    { "PRI", "Priva Hortimation BV" },
    { "ANL", "Analogix Semiconductor, Inc" },
    { "AVO", "Avocent Corporation" },
    { "LEG", "Legerity, Inc" },
    { "DTE", "Dimension Technologies, Inc." },
    { "WPA", "Matsushita Communication Industrial Co., Ltd." },
    { "OLV", "Olitec S.A." },
    { "RNB", "Rainbow Technologies" },
    { "LVI", "LVI Low Vision International AB" },
    { "LOC", "Locamation B.V." },
    { "TGC", "Toshiba Global Commerce Solutions, Inc." },
    { "STI", "Smart Tech Inc" },
    { "TLF", "Teleforce.,co,ltd" },
    { "PLC", "Pro-Log Corporation" },
    { "HSD", "HannStar Display Corp" },
    { "ONE", "Oneac Corporation" },
    { "CLE", "Classe Audio" },
    { "MCI", "Micronics Computers" },
    { "VTG", "Voice Technologies Group Inc" },
    { "VTI", "VLSI Tech Inc" },
    { "DAI", "DAIS SET Ltd." },
    { "UNM", "Unisys Corporation" },
    { "MCQ", "Mat's Computers" },
    { "IPC", "IPC Corporation" },
    { "ADE", "Arithmos, Inc." },
    { "PON", "Perpetual Technologies, LLC" },
    { "EXA", "Exabyte" },
    { "CHD", "ChangHong Electric Co.,Ltd" },
    { "FDT", "Fujitsu Display Technologies Corp." },
    { "DBL", "Doble Engineering Company" },
    { "CTP", "Computer Technology Corporation" },
    { "CLD", "COMMAT L.t.d." },
    { "BLI", "Busicom" },
    { "FRS", "South Mountain Technologies, LTD" },
    { "CDD", "Convergent Data Devices" },
    { "SHT", "Shin Ho Tech" },
    { "EPC", "Empac" },
    { "RDS", "Radius Inc" },
    { "NEX", "Nexgen Mediatech Inc.," },
    { "AGC", "Beijing Aerospace Golden Card Electronic Engineering Co.,Ltd." },
    { "MCP", "Magni Systems Inc" },
    { "WMO", "Westermo Teleindustri AB" },
    { "NMX", "Neomagic" },
    { "BDS", "Barco Display Systems" },
    { "RIV", "Rivulet Communications" },
    { "TRA", "TriTech Microelectronics International" },
    { "CYX", "Cyrix Corporation" },
    { "TCM", "3Com Corporation" },
    { "ZYP", "Zypcom Inc" },
    { "VIB", "Tatung UK Ltd" },
    { "IEI", "Interlink Electronics" },
    { "BGB", "Barco Graphics N.V" },
    { "ISP", "IntreSource Systems Pte Ltd" },
    { "BGT", "Budzetron Inc" },
    { "DPS", "Digital Processing Systems" },
    { "SSS", "S3 Inc" },
    { "AXB", "Adrienne Electronics Corporation" },
    { "HKA", "HONKO MFG. CO., LTD." },
    { "TPK", "TOPRE CORPORATION" },
    { "NPI", "Network Peripherals Inc" },
    { "LMP", "Leda Media Products" },
    { "MAI", "Mutoh America Inc" },
    { "ATX", "Athenix Corporation" },
    { "MVM", "SOBO VISION" },
    { "ALI", "Acer Labs" },
    { "HPR", "H.P.R. Electronics GmbH" },
    { "BIL", "Billion Electric Company Ltd" },
    { "CRO", "Extraordinary Technologies PTY Limited" },
    { "KTG", "Kayser-Threde GmbH" },
    { "SCI", "System Craft" },
    { "MVD", "Microvitec PLC" },
    { "IST", "Intersolve Technologies" },
    { "ICD", "ICD Inc" },
    { "PDS", "PD Systems International Ltd" },
    { "CPQ", "Compaq Computer Company" },
    { "QCL", "Quadrant Components Inc" },
    { "PRA", "PRO/AUTOMATION" },
    { "MAC", "MAC System Company Ltd" },
    { "TOP", "Orion Communications Co., Ltd." },
    { "AGT", "Agilent Technologies" },
    { "SWI", "Sierra Wireless Inc." },
    { "ATT", "AT&T" },
    { "MCL", "Motorola Communications Israel" },
    { "NCS", "Northgate Computer Systems" },
    { "RSX", "Rapid Tech Corporation" },
    { "ATV", "Office Depot, Inc." },
    { "MRD", "MicroDisplay Corporation" },
    { "SCH", "Schlumberger Cards" },
    { "ONW", "OPEN Networks Ltd" },
    { "DTC", "DTC Tech Corporation" },
    { "HYV", "Hynix Semiconductor" },
    { "WEL", "W-DEV" },
    { "AND", "Adtran Inc" },
    { "AMN", "Amimon LTD." },
    { "PXL", "The Moving Pixel Company" },
    { "ZCT", "ZeitControl cardsystems GmbH" },
    { "ALH", "AL Systems" },
    { "VCJ", "Victor Company of Japan, Limited" },
    { "COD", "CODAN Pty. Ltd." },
    { "TMM", "Time Management, Inc." },
    { "PPR", "PicPro" },
    { "INL", "InnoLux Display Corporation" },
    { "LTC", "Labtec Inc" },
    { "PNP", "Microsoft" },
    { "FIL", "Forefront Int'l Ltd" },
    { "OSR", "Oksori Company Ltd" },
    { "PEI", "PEI Electronics Inc" },
    { "EZP", "Storm Technology" },
    { "TCE", "Century Corporation" },
    { "KAR", "Karna" },
    { "ALS", "Texas Advanced optoelectronics Solutions, Inc" },
    { "COI", "Codec Inc." },
    { "NRT", "Beijing Northern Radiantelecom Co." },
    { "FTR", "Mediasonic" },
    { "SUN", "Sun Electronics Corporation" },
    { "OZO", "Tribe Computer Works Inc" },
    { "MCO", "Motion Computing Inc." },
    { "UBI", "Ungermann-Bass Inc" },
    { "ZNI", "Zetinet Inc" },
    { "FUN", "sisel muhendislik" },
    { "RMP", "Research Machines" },
    { "DGT", "The Dearborn Group" },
    { "SPX", "Simplex Time Recorder Co." },
    { "COR", "Corollary Inc" },
    { "AMX", "AMX LLC" },
    { "AKY", "Askey Computer Corporation" },
    { "RAR", "Raritan, Inc." },
    { "VDS", "Vidisys GmbH & Company" },
    { "SCL", "Sigmacom Co., Ltd." },
    { "KSL", "Karn Solutions Ltd." },
    { "ACK", "Acksys" },
    { "NWS", "Newisys, Inc." },
    { "TRX", "Trex Enterprises" },
    { "BOI", "NINGBO BOIGLE DIGITAL TECHNOLOGY CO.,LTD" },
    { "NTT", "NTT Advanced Technology Corporation" },
    { "GUZ", "Guzik Technical Enterprises" },
    { "MDY", "Microdyne Inc" },
    { "EDM", "EDMI" },
    { "DTI", "Diversified Technology, Inc." },
    { "MMI", "Multimax" },
    { "SCB", "SeeCubic B.V." },
    { "UPS", "Systems Enhancement" },
    { "AKB", "Akebia Ltd" },
    { "NBT", "NingBo Bestwinning Technology CO., Ltd" },
    { "TCD", "Taicom Data Systems Co., Ltd." },
    { "XMM", "C3PO S.L." },
    { "OIM", "Option International" },
    { "DAV", "Davicom Semiconductor Inc" },
    { "CKJ", "Carina System Co., Ltd." },
    { "ATD", "Alpha Telecom Inc" },
    { "XQU", "SHANGHAI SVA-DAV ELECTRONICS CO., LTD" },
    { "KOL", "Kollmorgen Motion Technologies Group" },
    { "HWA", "Harris Canada Inc" },
    { "INE", "Inventec Electronics (M) Sdn. Bhd." },
    { "ORN", "ORION ELECTRIC CO., LTD." },
    { "KES", "Kesa Corporation" },
    { "CRC", "CONRAC GmbH" },
    { "AXT", "Axtend Technologies Inc" },
    { "NAX", "Naxos Tecnologia" },
    { "DAN", "Danelec Marine A/S" },
    { "ADP", "Adaptec Inc" },
    { "ICA", "ICA Inc" },
    { "AGL", "Argolis" },
    { "ECC", "ESSential Comm. Corporation" },
    { "AWS", "Wave Systems" },
    { "APN", "Appian Tech Inc" },
    { "DGI", "DIGI International" },
    { "MCS", "Micro Computer Systems" },
    { "ITA", "Itausa Export North America" },
    { "CII", "Cromack Industries Inc" },
    { "IPS", "IPS, Inc. (Intellectual Property Solutions, Inc.)" },
    { "KOE", "KOLTER ELECTRONIC" },
    { "MEP", "Meld Technology" },
    { "IMA", "Imagraph" },
    { "DDV", "Delta Information Systems, Inc" },
    { "GML", "General Information Systems" },
    { "SSC", "Sierra Semiconductor Inc" },
    { "WNX", "Wincor Nixdorf International GmbH" },
    { "ABD", "Allen Bradley Company" },
    { "CMS", "CompuMaster Srl" },
    { "INK", "Indtek Co., Ltd." },
    { "DTT", "Design & Test Technology, Inc." },
    { "MGA", "Mega System Technologies, Inc." },
    { "SMO", "STMicroelectronics" },
    { "SSI", "S-S Technology Inc" },
    { "CIR", "Cirrus Logic Inc" },
    { "EKC", "Eastman Kodak Company" },
    { "LNR", "Linear Systems Ltd." },
    { "VCM", "Vector Magnetics, LLC" },
    { "HKG", "Josef Heim KG" },
    { "ORG", "ORGA Kartensysteme GmbH" },
    { "ELG", "Elmeg GmbH Kommunikationstechnik" },
    { "NSI", "NISSEI ELECTRIC CO.,LTD" },
    { "RDM", "Tremon Enterprises Company Ltd" },
    { "HAI", "Haivision Systems Inc." },
    { "CIC", "Comm. Intelligence Corporation" },
    { "LTS", "LTS Scale LLC" },
    { "SAS", "Stores Automated Systems Inc" },
    { "OEC", "ORION ELECTRIC CO.,LTD" },
    { "BRG", "Bridge Information Co., Ltd" },
    { "SQT", "Sequent Computer Systems Inc" },
    { "CCI", "Cache" },
    { "PRX", "Proxima Corporation" },
    { "ADR", "Nasa Ames Research Center" },
    { "SNW", "Snell & Wilcox" },
    { "CDI", "Concept Development Inc" },
    { "SEA", "Seanix Technology Inc." },
    { "STY", "SDS Technologies" },
    { "PCA", "Philips BU Add On Card" },
    { "NYC", "nakayo telecommunications,inc." },
    { "JMT", "Micro Technical Company Ltd" },
    { "MTD", "MindTech Display Co. Ltd" },
    { "NSP", "Nspire System Inc." },
    { "DSD", "DS Multimedia Pte Ltd" },
    { "PBI", "Pitney Bowes" },
    { "ARO", "Poso International B.V." },
    { "TTE", "TTE, Inc." },
    { "DDA", "DA2 Technologies Corporation" },
    { "MAS", "Mass Inc." },
    { "LAC", "LaCie" },
    { "CRX", "Cyrix Corporation" },
    { "EMO", "ELMO COMPANY, LIMITED" },
    { "OSP", "OPTI-UPS Corporation" },
    { "GED", "General Dynamics C4 Systems" },
    { "PPI", "Practical Peripherals" },
    { "VPI", "Video Products Inc" },
    { "TOS", "Toshiba Corporation" },
    { "ASL", "AccuScene Corporation Ltd" },
    { "ANT", "Ace CAD Enterprise Company Ltd" },
    { "GRV", "Advanced Gravis" },
    { "ANO", "Anorad Corporation" },
    { "LNK", "Link Tech Inc" },
    { "DIG", "Digicom S.p.A." },
    { "ALC", "Altec Corporation" },
    { "IAI", "Integration Associates, Inc." },
    { "APG", "Horner Electric Inc" },
    { "TWK", "TOWITOKO electronics GmbH" },
    { "BRI", "Boca Research Inc" },
    { "SVS", "SVSI" },
    { "QCI", "Quanta Computer Inc" },
    { "MDD", "MODIS" },
    { "PDT", "PDTS - Prozessdatentechnik und Systeme" },
    { "IMP", "Impression Products Incorporated" },
    { "EXI", "Exide Electronics" },
    { "WNV", "Winnov L.P." },
    { "ALG", "Realtek Semiconductor Corp." },
    { "ESA", "Elbit Systems of America" },
    { "OLC", "Olicom A/S" },
    { "DPX", "DpiX, Inc." },
    { "GSB", "NIPPONDENCHI CO,.LTD" },
    { "MCA", "American Nuclear Systems Inc" },
    { "EST", "Embedded Solution Technology" },
    { "ADX", "Adax Inc" },
    { "MSA", "Micro Systemation AB" },
    { "HDV", "Holografika kft." },
    { "GIP", "GI Provision Ltd" },
    { "XTN", "X-10 (USA) Inc" },
    { "VEC", "Vector Informatik GmbH" },
    { "DTN", "Datang Telephone Co" },
    { "CST", "CSTI Inc" },
    { "ECO", "Echo Speech Corporation" },
    { "TDD", "Tandberg Data Display AS" },
    { "NVL", "Novell Inc" },
    { "CHT", "Chunghwa Picture Tubes,LTD." },
    { "SCP", "Scriptel Corporation" },
    { "TMS", "Trident Microsystems Ltd" },
    { "ABO", "D-Link Systems Inc" },
    { "JTY", "jetway security micro,inc" },
    { "LSD", "Intersil Corporation" },
    { "SEP", "SEP Eletronica Ltda." },
    { "SHI", "Jiangsu Shinco Electronic Group Co., Ltd" },
    { "FTG", "FTG Data Systems" },
    { "ESN", "eSATURNUS" },
    { "DJE", "Capstone Visual Product Development" },
    { "BEC", "Elektro Beckhoff GmbH" },
    { "FVC", "First Virtual Corporation" },
    { "JUP", "Jupiter Systems" },
    { "XNT", "XN Technologies, Inc." },
    { "RTK", "DO NOT USE - RTK" },
    { "ACL", "Apricot Computers" },
    { "TAA", "Tandberg" },
    { "WIP", "Wipro Infotech" },
    { "KRL", "Krell Industries Inc." },
    { "INO", "Innolab Pte Ltd" },
    { "ELT", "Element Labs, Inc." },
    { "KTE", "K-Tech" },
    { "CVA", "Covia Inc." },
    { "SIC", "Sysmate Corporation" },
    { "STH", "Semtech Corporation" },
    { "ACD", "AWETA BV" },
    { "EHN", "Enhansoft" },
    { "VMI", "Vermont Microsystems" },
    { "TTC", "Telecommunications Techniques Corporation" },
    { "KYE", "KYE Syst Corporation" },
    { "QDI", "Quantum Data Incorporated" },
    { "ELL", "Electrosonic Ltd" },
    { "FLE", "ADTI Media, Inc" },
    { "KTD", "Takahata Electronics Co.,Ltd." },
    { "MAL", "Meridian Audio Ltd" },
    { "TRV", "Trivisio Prototyping GmbH" },
    { "TWH", "Twinhead International Corporation" },
    { "SYP", "SYPRO Co Ltd" },
    { "GCC", "GCC Technologies Inc" },
    { "POR", "Portalis LC" },
    { "PIM", "Prism, LLC" },
    { "MLX", "Mylex Corporation" },
    { "ONL", "OnLive, Inc" },
    { "NIS", "Nissei Electric Company" },
    { "ISM", "Image Stream Medical" },
    { "EPS", "KEPS" },
    { "PAC", "Pacific Avionics Corporation" },
    { "AXC", "AXIOMTEK CO., LTD." },
    { "DYX", "Dynax Electronics (HK) Ltd" },
    { "WEB", "WebGear Inc" },
    { "RIT", "Ritech Inc" },
    { "INI", "Initio Corporation" },
    { "LBO", "Lubosoft" },
    { "PGM", "Paradigm Advanced Research Centre" },
    { "OSA", "OSAKA Micro Computer, Inc." },
    { "SIN", "Singular Technology Co., Ltd." },
    { "CIN", "Citron GmbH" },
    { "OTB", "outsidetheboxstuff.com" },
    { "ARL", "Arlotto Comnet Inc" },
    { "HOB", "HOB Electronic GmbH" },
    { "QQQ", "Chuomusen Co., Ltd." },
    { "AXE", "D-Link Systems Inc" },
    { "CCC", "C-Cube Microsystems" },
    { "CPT", "cPATH" },
    { "SEM", "Samsung Electronics Company Ltd" },
    { "PVI", "Prime view international Co., Ltd" },
    { "TAT", "Teleliaison Inc" },
    { "SON", "Sony" },
    { "ITT", "I&T Telecom." },
    { "SLM", "Solomon Technology Corporation" },
    { "MAN", "LGIC" },
    { "AIX", "ALTINEX, INC." },
    { "ASP", "ASP Microelectronics Ltd" },
    { "VUT", "Vutrix (UK) Ltd" },
    { "MTE", "MediaTec GmbH" },
    { "UPP", "UPPI" },
    { "DCM", "DCM Data Products" },
    { "DYC", "Dycam Inc" },
    { "DAK", "Daktronics" },
    { "JAZ", "Carrera Computer Inc" },
    { "FOX", "HON HAI PRECISON IND.CO.,LTD." },
    { "UEI", "Universal Electronics Inc" },
    { "OPI", "D.N.S. Corporation" },
    { "CXT", "Conexant Systems" },
    { "VTK", "Viewteck Co., Ltd." },
    { "AVL", "Avalue Technology Inc." },
    { "TSI", "TeleVideo Systems" },
    { "PAN", "The Panda Project" },
    { "CED", "Cambridge Electronic Design Ltd" },
    { "RUP", "Ups Manufactoring s.r.l." },
    { "MIP", "micronpc.com" },
    { "REM", "SCI Systems Inc." },
    { "NSS", "Newport Systems Solutions" },
    { "FBI", "Interface Corporation" },
    { "FER", "Ferranti Int'L" },
    { "DLG", "Digital-Logic GmbH" },
    { "TSY", "TouchSystems" },
    { "PIO", "Pioneer Electronic Corporation" },
    { "PNG", "P.I. Engineering Inc" },
    { "OIN", "Option International" },
    { "RED", "Research Electronics Development Inc" },
    { "NOI", "North Invent A/S" },
    { "MAY", "Maynard Electronics" },
    { "BTO", "BioTao Ltd" },
    { "ZYD", "Zydacron Inc" },
    { "KCD", "Chunichi Denshi Co.,LTD." },
    { "TTI", "Trenton Terminals Inc" },
    { "TRD", "Trident Microsystem Inc" },
    { "TDP", "3D Perception" },
    { "TER", "TerraTec Electronic GmbH" },
    { "AEM", "ASEM S.p.A." },
    { "IBI", "INBINE.CO.LTD" },
    { "ECK", "Eugene Chukhlomin Sole Proprietorship, d.b.a." },
    { "AVT", "Avtek (Electronics) Pty Ltd" },
    { "PST", "Global Data SA" },
    { "FPS", "Deltec Corporation" },
    { "SHP", "Sharp Corporation" },
    { "RDN", "RADIODATA GmbH" },
    { "TRC", "Trioc AB" },
    { "ABE", "Alcatel Bell" },
    { "VCX", "VCONEX" },
    { "PBL", "Packard Bell Electronics" },
    { "TLK", "Telelink AG" },
    { "DMM", "Dimond Multimedia Systems Inc" },
    { "IGM", "IGM Communi" },
    { "KFC", "SCD Tech" },
    { "GUD", "Guntermann & Drunck GmbH" },
    { "MDA", "Media4 Inc" },
    { "VWB", "Vweb Corp." },
    { "ISG", "Insignia Solutions Inc" },
    { "AMS", "ARMSTEL, Inc." },
    { "NTL", "National Transcomm. Ltd" },
    { "LSJ", "LSI Japan Company Ltd" },
    { "NDL", "Network Designers" },
    { "DIA", "Diadem" },
    { "SDX", "SDX Business Systems Ltd" },
    { "LPL", "LG Philips" },
    { "CAG", "CalComp" },
    { "FZC", "Founder Group Shenzhen Co." },
    { "PCX", "PC Xperten" },
    { "TSF", "Racal-Airtech Software Forge Ltd" },
    { "RGL", "Robertson Geologging Ltd" },
    { "MSD", "Datenerfassungs- und Informationssysteme" },
    { "NVC", "NetVision Corporation" },
    { "SKD", "Schneider & Koch" },
    { "CRS", "Crescendo Communication Inc" },
    { "AXI", "American Magnetics" },
    { "HRS", "Harris Semiconductor" },
    { "AEN", "Avencall" },
    { "TCL", "Technical Concepts Ltd" },
    { "SST", "SystemSoft Corporation" },
    { "OMN", "Omnitel" },
    { "GCI", "Gateway Comm. Inc" },
    { "SEN", "Sencore" },
    { "MDT", "Magus Data Tech" },
    { "ALN", "Alana Technologies" },
    { "AVD", "Avid Electronics Corporation" },
    { "DOM", "Dome Imaging Systems" },
    { "KBL", "Kobil Systems GmbH" },
    { "ITS", "IDTECH" },
    { "CGS", "Chyron Corp" },
    { "CYV", "Cyviz AS" },
    { "CSO", "California Institute of Technology" },
    { "ADT", "Aved Display Technologies" },
    { "ACP", "Aspen Tech Inc" },
    { "AKI", "AKIA Corporation" },
    { "LCT", "Labcal Technologies" },
    { "NDS", "Nokia Data" },
    { "WCS", "Woodwind Communications Systems Inc" },
    { "XFG", "Jan Strapko - FOTO" },
    { "CPI", "Computer Peripherals Inc" },
    { "FCG", "First International Computer Ltd" },
    { "EVE", "Advanced Micro Peripherals Ltd" },
    { "ATO", "ASTRO DESIGN, INC." },
    { "SGW", "Shanghai Guowei Science and Technology Co., Ltd." },
    { "CNB", "American Power Conversion" },
    { "TCX", "FREEMARS Heavy Industries" },
    { "ITN", "The NTI Group" },
    { "HWD", "Highwater Designs Ltd" },
    { "NUG", "NU Technology, Inc." },
    { "ISL", "Isolation Systems" },
    { "CIL", "Citicom Infotech Private Limited" },
    { "IOT", "I/OTech Inc" },
    { "GET", "Getac Technology Corporation" },
    { "ULT", "Ultra Network Tech" },
    { "TVV", "TV1 GmbH" },
    { "OWL", "Mediacom Technologies Pte Ltd" },
    { "TMX", "Thermotrex Corporation" },
    { "ARC", "Alta Research Corporation" },
    { "SEL", "Way2Call Communications" },
    { "ELS", "ELSA GmbH" },
    { "STD", "STD Computer Inc" },
    { "GST", "Graphic SystemTechnology" },
    { "SME", "Sysmate Company" },
    { "ARS", "Arescom Inc" },
    { "SCN", "Scanport, Inc." },
    { "CTX", "Creatix Polymedia GmbH" },
    { "DIM", "dPict Imaging, Inc." },
    { "MDI", "Micro Design Inc" },
    { "SCM", "SCM Microsystems Inc" },
    { "CEA", "Consumer Electronics Association" },
    { "OTI", "Orchid Technology" },
    { "ADK", "Adtek System Science Company Ltd" },
    { "ETC", "Everton Technology Company Ltd" },
    { "PCO", "Performance Concepts Inc.," },
    { "DMC", "Dune Microsystems Corporation" },
    { "SGM", "SAGEM" },
    { "OBS", "Optibase Technologies" },
    { "PMX", "Photomatrix" },
    { "SDI", "Samtron Displays Inc" },
    { "GMM", "GMM Research Inc" },
    { "DUN", "NCR Corporation" },
    { "CAL", "Acon" },
    { "MIR", "Miro Computer Prod." },
    { "PEN", "Interactive Computer Products Inc" },
    { "CRL", "Creative Logic" },
    { "SBT", "Senseboard Technologies AB" },
    { "AST", "AST Research Inc" },
    { "INS", "Ines GmbH" },
    { "SGC", "Spectragraphics Corporation" },
    { "DBI", "DigiBoard Inc" },
    { "LEO", "First International Computer Inc" },
    { "TSP", "U.S. Navy" },
    { "MTK", "Microtek International Inc." },
    { "TCN", "Tecnetics (PTY) Ltd" },
    { "DPM", "ADPM Synthesis sas" },
    { "LGS", "LG Semicom Company Ltd" },
    { "LGI", "Logitech Inc" },
    { "PBV", "Pitney Bowes" },
    { "ELI", "Edsun Laboratories" },
    { "HPQ", "HP" },
    { "RPT", "R.P.T.Intergroups" },
    { "BDO", "Brahler ICS" },
    { "ARM", "Arima" },
    { "JTS", "JS Motorsports" },
    { "TNY", "Tennyson Tech Pty Ltd" },
    { "UDN", "Uniden Corporation" },
    { "KNC", "Konica corporation" },
    { "GND", "Gennum Corporation" },
    { "MSG", "MSI GmbH" },
    { "REH", "Rehan Electronics Ltd." },
    { "COL", "Rockwell Collins, Inc." },
    { "MDC", "Midori Electronics" },
    { "TRN", "Datacommunicatie Tron B.V." },
    { "VDA", "Victor Data Systems" },
    { "TOU", "Touchstone Technology" },
    { "ETD", "ELAN MICROELECTRONICS CORPORATION" },
    { "CYB", "CyberVision" },
    { "SWC", "Software Café" },
    { "EXN", "RGB Systems, Inc. dba Extron Electronics" },
    { "HSP", "HannStar Display Corp" },
    { "WTK", "Wearnes Thakral Pte" },
    { "GFM", "GFMesstechnik GmbH" },
    { "INC", "Home Row Inc" },
    { "LEC", "Lectron Company Ltd" },
    { "WTS", "Restek Electric Company Ltd" },
    { "ACE", "Actek Engineering Pty Ltd" },
    { "MSH", "Microsoft" },
    { "CHL", "Chloride-R&D" },
    { "ALT", "Altra" },
    { "EES", "EE Solutions, Inc." },
    { "ASX", "AudioScience" },
    { "DAC", "Digital Acoustics Corporation" },
    { "HAL", "Halberthal" },
    { "HPC", "Hewlett Packard Co." },
    { "GRY", "Robert Gray Company" },
    { "AXO", "Axonic Labs LLC" },
    { "ALJ", "Altec Lansing" },
    { "SMS", "Silicom Multimedia Systems Inc" },
    { "HPI", "Headplay, Inc." },
    { "FRO", "FARO Technologies" },
    { "GAU", "Gaudi Co., Ltd." },
    { "SRS", "SR-Systems e.K." },
    { "APL", "Aplicom Oy" },
    { "JGD", "University College" },
    { "NVD", "Nvidia" },
    { "CEP", "C-DAC" },
    { "BDR", "Blonder Tongue Labs, Inc." },
    { "AUO", "AU Optronics" },
    { "DCR", "Decros Ltd" },
    { "DLK", "D-Link Systems Inc" },
    { "SWS", "Static" },
    { "WSC", "CIS Technology Inc" },
    { "ESL", "Esterline Technologies" },
    { "ISC", "Id3 Semiconductors" },
    { "XSN", "Xscreen AS" },
    { "FML", "Fujitsu Microelect Ltd" },
    { "WPI", "Wearnes Peripherals International (Pte) Ltd" },
    { "EGL", "Eagle Technology" },
    { "EGA", "Elgato Systems LLC" },
    { "GAG", "Gage Applied Sciences Inc" },
    { "HCP", "Hitachi Computer Products Inc" },
    { "UET", "Universal Empowering Technologies" },
    { "ITL", "Inter-Tel" },
    { "SDE", "Sherwood Digital Electronics Corporation" },
    { "CAA", "Castles Automation Co., Ltd" },
    { "ZRN", "Zoran Corporation" },
    { "VLT", "VideoLan Technologies" },
    { "EUT", "Ericsson Mobile Networks B.V." },
    { "REA", "Real D" },
    { "BUT", "21ST CENTURY ENTERTAINMENT" },
    { "THN", "Thundercom Holdings Sdn. Bhd." },
    { "CHO", "Sichuang Changhong Corporation" },
    { "SCC", "SORD Computer Corporation" },
    { "MSY", "MicroTouch Systems Inc" },
    { "ERP", "Euraplan GmbH" },
    { "CPL", "Compal Electronics Inc" },
    { "ACM", "Acroloop Motion Control Systems Inc" },
    { "VTS", "VTech Computers Ltd" },
    { "ETH", "Etherboot Project" },
    { "CGT", "congatec AG" },
    { "FEN", "Fen Systems Ltd." },
    { "MLN", "Mark Levinson" },
    { "UMC", "United Microelectr Corporation" },
    { "CAR", "Cardinal Company Ltd" },
    { "LIT", "Lithics Silicon Technology" },
    { "AWC", "Access Works Comm Inc" },
    { "PPC", "Phoenixtec Power Company Ltd" },
    { "SVT", "SEVIT Co., Ltd." },
    { "MDX", "MicroDatec GmbH" },
    { "XIN", "Xinex Networks Inc" },
    { "KTN", "Katron Tech Inc" },
    { "MJI", "MARANTZ JAPAN, INC." },
    { "CTM", "Computerm Corporation" },
    { "PDM", "Psion Dacom Plc." },
    { "AKM", "Asahi Kasei Microsystems Company Ltd" },
    { "GSY", "Grossenbacher Systeme AG" },
    { "OMR", "Omron Corporation" },
    { "RSH", "ADC-Centre" },
    { "MTM", "Motium" },
    { "XDM", "XDM Ltd." },
    { "MSX", "Micomsoft Co., Ltd." },
    { "VNC", "Vinca Corporation" },
    { "STK", "SANTAK CORP." },
    { "JET", "JET POWER TECHNOLOGY CO., LTD." },
    { "SLR", "Schlumberger Technology Corporate" },
    { "GWI", "GW Instruments" },
    { "TMI", "Texas Microsystem" },
    { "EXT", "Exatech Computadores & Servicos Ltda" },
    { "SXB", "Syntax-Brillian" },
    { "HYT", "Heng Yu Technology (HK) Limited" },
    { "TST", "Transtream Inc" },
    { "FIS", "FLY-IT Simulators" },
    { "VMW", "VMware Inc.," },
    { "PET", "Practical Electronic Tools" },
    { "BLP", "Bloomberg L.P." },
    { "MVS", "Microvision" },
    { "ZMT", "Zalman Tech Co., Ltd." },
    { "QTD", "Quantum 3D Inc" },
    { "ITE", "Integrated Tech Express Inc" },
    { "MIS", "Modular Industrial Solutions Inc" },
    { "KOB", "Kobil Systems GmbH" },
    { "KOW", "KOWA Company,LTD." },
    { "SHC", "ShibaSoku Co., Ltd." },
    { "IKS", "Ikos Systems Inc" },
    { "PGP", "propagamma kommunikation" },
    { "AYD", "Aydin Displays" },
    { "MFG", "MicroField Graphics Inc" },
    { "APS", "Autologic Inc" },
    { "APM", "Applied Memory Tech" },
    { "ACO", "Allion Computer Inc." },
    { "IWR", "Icuiti Corporation" },
    { "RCI", "RC International" },
    { "YMH", "Yamaha Corporation" },
    { "SPE", "SPEA Software AG" },
    { "ADL", "ASTRA Security Products Ltd" },
    { "QFI", "Quickflex, Inc" },
    { "FRD", "Freedom Scientific BLV" },
    { "PCM", "PCM Systems Corporation" },
    { "RHM", "Rohm Company Ltd" },
    { "EQP", "Equipe Electronics Ltd." },
    { "UND", "Unisys Corporation" },
    { "ITX", "integrated Technology Express Inc" },
    { "WML", "Wolfson Microelectronics Ltd" },
    { "IPR", "Ithaca Peripherals" },
    { "NCE", "Norcent Technology, Inc." },
    { "GWY", "Gateway 2000" },
    { "DAX", "Data Apex Ltd" },
    { "MKT", "MICROTEK Inc." },
    { "AOL", "America OnLine" },
    { "BIO", "BioLink Technologies International, Inc." },
    { "DCI", "Concepts Inc" },
    { "LOL", "Litelogic Operations Ltd" },
    { "ADI", "ADI Systems Inc" },
    { "TPJ", "Junnila" },
    { "JDL", "Japan Digital Laboratory Co.,Ltd." },
    { "MMN", "MiniMan Inc" },
    { "MNC", "Mini Micro Methods Ltd" },
    { "SUM", "Summagraphics Corporation" },
    { "SXT", "SHARP TAKAYA ELECTRONIC INDUSTRY CO.,LTD." },
    { "CAT", "Consultancy in Advanced Technology" },
    { "MSM", "Advanced Digital Systems" },
    { "CHY", "Cherry GmbH" },
    { "VLB", "ValleyBoard Ltda." },
    { "DDS", "Barco, n.v." },
    { "STL", "SigmaTel Inc" },
    { "AIE", "Altmann Industrieelektronik" },
    { "CHM", "CHIC TECHNOLOGY CORP." },
    { "KTK", "Key Tronic Corporation" },
    { "LTN", "Litronic Inc" },
    { "IDC", "International Datacasting Corporation" },
    { "TWA", "Tidewater Association" },
    { "ARI", "Argosy Research Inc" },
    { "STT", "Star Paging Telecom Tech (Shenzhen) Co. Ltd." },
    { "MYA", "Monydata" },
    { "JAE", "Japan Aviation Electronics Industry, Limited" },
    { "BBH", "B&Bh" },
    { "GIC", "General Inst. Corporation" },
    { "TIV", "OOO Technoinvest" },
    { "ION", "Inside Out Networks" },
    { "KZI", "K-Zone International co. Ltd." },
    { "IDE", "IDE Associates" },
    { "IQI", "IneoQuest Technologies, Inc" },
    { "NDI", "National Display Systems" },
    { "REL", "Reliance Electric Ind Corporation" },
    { "SPH", "G&W Instruments GmbH" },
    { "RPI", "RoomPro Technologies" },
    { "LUC", "Lucent Technologies" },
    { "CTL", "Creative Technology Ltd" },
    { "SDS", "SunRiver Data System" },
    { "USR", "U.S. Robotics Inc" },
    { "GJN", "Grand Junction Networks" },
    { "YED", "Y-E Data Inc" },
    { "RHT", "Red Hat, Inc." },
    { "AOT", "Alcatel" },
    { "TCR", "Thomson Consumer Electronics" },
    { "ILC", "Image Logic Corporation" },
    { "IGC", "Intergate Pty Ltd" },
    { "HYC", "Hypercope Gmbh Aachen" },
    { "SPL", "Smart Silicon Systems Pty Ltd" },
    { "DLC", "Diamond Lane Comm. Corporation" },
    { "TBB", "Triple S Engineering Inc" },
    { "MLS", "Milestone EPE" },
    { "QDM", "Quadram" },
    { "AIR", "Advanced Integ. Research Inc" },
    { "SLA", "Systeme Lauer GmbH&Co KG" },
    { "IBP", "IBP Instruments GmbH" },
    { "DDI", "Data Display AG" },
    { "LED", "Long Engineering Design Inc" },
    { "MSC", "Mouse Systems Corporation" },
    { "LXS", "ELEA CardWare" },
    { "ATE", "Innovate Ltd" },
    { "APV", "A+V Link" },
    { "FRC", "Force Computers" },
    { "ZTC", "ZyDAS Technology Corporation" },
    { "ANP", "Andrew Network Production" },
    { "LOG", "Logicode Technology Inc" },
    { "RAI", "Rockwell Automation/Intecolor" },
    { "MPJ", "Microlab" },
    { "CMO", "Chi Mei Optoelectronics corp." },
    { "ROH", "Rohm Co., Ltd." },
    { "HYP", "Hyphen Ltd" },
    { "ICO", "Intel Corp" },
    { "ACI", "Ancor Communications Inc" },
    { "SLT", "Salt Internatioinal Corp." },
    { "TSC", "Sanyo Electric Company Ltd" },
    { "APC", "American Power Conversion" },
    { "PSE", "Practical Solutions Pte., Ltd." },
    { "MET", "Metheus Corporation" },
    { "SAT", "Shuttle Tech" },
    { "SYK", "Stryker Communications" },
    { "BCQ", "Deutsche Telekom Berkom GmbH" },
    { "DPI", "DocuPoint" },
    { "FAR", "Farallon Computing" },
    { "ROP", "Roper International Ltd" },
    { "STB", "STB Systems Inc" },
    { "CNC", "Alvedon Computers Ltd" },
    { "DGA", "Digiital Arts Inc" },
    { "EDT", "Emerging Display Technologies Corp" },
    { "IPI", "Intelligent Platform Management Interface (IPMI) forum (Intel, HP, NEC, Dell)" },
    { "VQ@", "Vision Quest" },
    { "EMK", "Emcore Corporation" },
    { "XTD", "Icuiti Corporation" },
    { "KNX", "Nutech Marketing PTL" },
    { "WHI", "Whistle Communications" },
    { "KDM", "Korea Data Systems Co., Ltd." },
    { "QCK", "Quick Corporation" },
    { "QTR", "Qtronix Corporation" },
    { "NFS", "Number Five Software" },
    { "HTK", "Holtek Microelectronics Inc" },
    { "TRL", "Royal Information" },
    { "LXN", "Luxeon" },
    { "VLK", "Vislink International Ltd" },
    { "TWE", "Kontron Electronik" },
    { "DFI", "DFI" },
    { "JWS", "JWSpencer & Co." },
    { "FTW", "MindTribe Product Engineering, Inc." },
    { "TDM", "Tandem Computer Europe Inc" },
    { "RAS", "RAScom Inc" },
    { "KVX", "KeyView" },
    { "MOS", "Moses Corporation" },
    { "ONX", "SOMELEC Z.I. Du Vert Galanta" },
    { "STF", "Starflight Electronics" },
    { "HER", "Ascom Business Systems" },
    { "GTS", "Geotest Marvin Test Systems Inc" },
    { "KEC", "Kyushu Electronics Systems Inc" },
    { "MQP", "MultiQ Products AB" },
    { "LUX", "Luxxell Research Inc" },
    { "HEC", "Hitachi Engineering Company Ltd" },
    { "NXG", "Nexgen" },
    { "CNI", "Connect Int'l A/S" },
    { "FUJ", "Fujitsu Ltd" },
    { "APD", "AppliAdata" },
    { "LHE", "Lung Hwa Electronics Company Ltd" },
    { "SCT", "Smart Card Technology" },
    { "SOY", "SOYO Group, Inc" },
    { "ICN", "Sanyo Icon" },
    { "TDV", "TDVision Systems, Inc." },
    { "AHC", "Advantech Co., Ltd." },
    { "GTK", "G-Tech Corporation" },
    { "BII", "Boeckeler Instruments Inc" },
    { "TCC", "Tandon Corporation" },
    { "BUJ", "ATI Tech Inc" },
    { "SAA", "Sanritz Automation Co.,Ltd." },
    { "DTK", "Dynax Electronics (HK) Ltd" },
    { "HXM", "Hexium Ltd." },
    { "EGD", "EIZO GmbH Display Technologies" },
    { "NDK", "Naitoh Densei CO., LTD." },
    { "TVR", "TV Interactive Corporation" },
    { "PNL", "Panelview, Inc." },
    { "AET", "Aethra Telecomunicazioni S.r.l." },
    { "REC", "ReCom" },
    { "HET", "HETEC Datensysteme GmbH" },
    { "ZOW", "Zowie Intertainment, Inc" },
    { "MEQ", "Matelect Ltd." },
    { "DRD", "DIGITAL REFLECTION INC." },
    { "MRA", "Miranda Technologies Inc" },
    { "QTM", "Quantum" },
    { "REN", "Renesas Technology Corp." },
    { "XIO", "Xiotech Corporation" },
    { "GIS", "AT&T Global Info Solutions" },
    { "TEA", "TEAC System Corporation" },
    { "EMU", "Emulex Corporation" },
    { "VIC", "Victron B.V." },
    { "ATN", "Athena Smartcard Solutions Ltd." },
    { "SYS", "Sysgration Ltd" },
    { "CVS", "Clarity Visual Systems" },
    { "CWR", "Connectware Inc" },
    { "TVI", "Truevision" },
    { "AMB", "Ambient Technologies, Inc." },
    { "USA", "Utimaco Safeware AG" },
    { "LNT", "LANETCO International" },
    { "EDG", "Electronic-Design GmbH" },
    { "MKV", "Trtheim Technology" },
    { "SGT", "Stargate Technology" },
    { "RTS", "Raintree Systems" },
    { "PXM", "Proxim Inc" },
    { "ACG", "A&R Cambridge Ltd" },
    { "FJT", "F.J. Tieman BV" },
    { "LCD", "Toshiba Matsushita Display Technology Co., Ltd" },
    { "IDS", "Interdigital Sistemas de Informacao" },
    { "AOA", "AOpen Inc." },
    { "ACR", "Acer Technologies" },
    { "AKL", "AMiT Ltd" },
    { "IOS", "i-O Display System" },
    { "NOR", "Norand Corporation" },
    { "XST", "XS Technologies Inc" },
    { "BUG", "B.U.G., Inc." },
    { "RCN", "Radio Consult SRL" },
    { "ESI", "Extended Systems, Inc." },
    { "TUT", "Tut Systems" },
    { "VAR", "Varian Australia Pty Ltd" },
    { "DIT", "Dragon Information Technology" },
    { "CET", "TEC CORPORATION" },
    { "WKH", "Uni-Take Int'l Inc." },
    { "BHZ", "BitHeadz, Inc." },
    { "PTI", "Promise Technology Inc" },
    { "HIQ", "Kaohsiung Opto Electronics Americas, Inc." },
    { "SET", "SendTek Corporation" },
    { "KCL", "Keycorp Ltd" },
    { "EIC", "Eicon Technology Corporation" },
    { "TRT", "Tritec Electronic AG" },
    { "ZAN", "Zandar Technologies plc" },
    { "NTN", "Nuvoton Technology Corporation" },
    { "MTC", "Mars-Tech Corporation" },
    { "JQE", "CNet Technical Inc" },
    { "SRG", "Intuitive Surgical, Inc." },
    { "VIR", "Visual Interface, Inc" },
    { "HTX", "Hitex Systementwicklung GmbH" },
    { "TLX", "Telxon Corporation" },
    { "NGC", "Network General" },
    { "TSB", "Toshiba America Info Systems Inc" },
    { "SGI", "Scan Group Ltd" },
    { "AIS", "Alien Internet Services" },
    { "MUD", "Multi-Dimension Institute" },
    { "PNS", "PanaScope" },
    { "NEO", "NEO TELECOM CO.,LTD." },
    { "IMB", "ART s.r.l." },
    { "SRD", "Setred" },
    { "LEX", "Lexical Ltd" },
    { "LMI", "Lexmark Int'l Inc" },
    { "ECL", "Excel Company Ltd" },
    { "EXC", "Excession Audio" },
    { "ABA", "ABBAHOME INC." },
    { "CLI", "Cirrus Logic Inc" },
    { "DYM", "Dymo-CoStar Corporation" },
    { "MEL", "Mitsubishi Electric Corporation" },
    { "ZAX", "Zefiro Acoustics" },
    { "TEC", "Tecmar Inc" },
    { "WTI", "WorkStation Tech" },
    { "APX", "AP Designs Ltd" },
    { "MLM", "Millennium Engineering Inc" },
    { "BAC", "Biometric Access Corporation" },
    { "DDE", "Datasat Digital Entertainment" },
    { "GIM", "Guillemont International" },
    { "TVM", "Taiwan Video & Monitor Corporation" },
    { "KWD", "Kenwood Corporation" },
    { "STW", "Starwin Inc." },
    { "NRV", "Taugagreining hf" },
    { "SUP", "Supra Corporation" },
    { "MTB", "Media Technologies Ltd." },
    { "INF", "Inframetrics Inc" },
    { "OTM", "Optoma Corporation" },
    { "NTX", "Netaccess Inc" },
    { "LXC", "LXCO Technologies AG" },
    { "CRN", "Cornerstone Imaging" },
    { "PVP", "Klos Technologies, Inc." },
    { "TCJ", "TEAC America Inc" },
    { "WVM", "Wave Systems Corporation" },
    { "ERN", "Ericsson, Inc." },
    { "PVN", "Pixel Vision" },
    { "LMT", "Laser Master" },
    { "MID", "miro Displays" },
    { "VID", "Ingram Macrotron Germany" },
    { "IFZ", "Infinite Z" },
    { "ODM", "ODME Inc." },
    { "ASI", "Ahead Systems" },
    { "ISY", "International Integrated Systems,Inc.(IISI)" },
    { "NCL", "NetComm Ltd" },
    { "ITK", "ITK Telekommunikation AG" },
    { "EZE", "EzE Technologies" },
    { "VSR", "V-Star Electronics Inc." },
    { "CPC", "Ciprico Inc" },
    { "JWD", "Video International Inc." },
    { "MEC", "Mega System Technologies Inc" },
    { "NVI", "NuVision US, Inc." },
    { "MRK", "Maruko & Company Ltd" },
    { "AAA", "Avolites Ltd" },
    { "CHG", "Sichuan Changhong Electric CO, LTD." },
    { "WWV", "World Wide Video, Inc." },
    { "SEO", "SEOS Ltd" },
    { "XER", "DO NOT USE - XER" },
    { "MCN", "Micron Electronics Inc" },
    { "DXC", "Digipronix Control Systems" },
    { "RSN", "Radiospire Networks, Inc." },
    { "FGD", "Lisa Draexlmaier GmbH" },
    { "SES", "Session Control LLC" },
    { "IIN", "IINFRA Co., Ltd" },
    { "ETI", "Eclipse Tech Inc" },
    { "DXD", "DECIMATOR DESIGN PTY LTD" },
    { "BST", "BodySound Technologies, Inc." },
    { "MTL", "Mitel Corporation" },
    { "LGX", "Lasergraphics, Inc." },
    { "MSP", "Mistral Solutions [P] Ltd." },
    { "SER", "Sony Ericsson Mobile Communications Inc." },
    { "IHE", "InHand Electronics" },
    { "STO", "Stollmann E+V GmbH" },
    { "RET", "Resonance Technology, Inc." },
    { "PXE", "PIXELA CORPORATION" },
    { "USI", "Universal Scientific Industrial Co., Ltd." },
    { "JAC", "Astec Inc" },
    { "WAC", "Wacom Tech" },
    { "BUF", "Yasuhiko Shirai Melco Inc" },
    { "LSI", "Loughborough Sound Images" },
    { "AMA", "Asia Microelectronic Development Inc" },
    { "DJP", "Maygay Machines, Ltd" },
    { "CAN", "CORNEA" },
    { "UMM", "Universal Multimedia" },
    { "ECI", "Enciris Technologies" },
    { "DDT", "Datadesk Technologies Inc" },
    { "MLG", "Micrologica AG" },
    { "NCA", "Nixdorf Company" },
    { "ENS", "Ensoniq Corporation" },
    { "MOT", "Motorola UDS" },
    { "WCI", "Wisecom Inc" },
    { "MXT", "Maxtech Corporation" },
    { "EHJ", "Epson Research" },
    { "KUR", "Kurta Corporation" },
    { "DFT", "DEI Holdings dba Definitive Technology" },
    { "NAD", "NAD Electronics" },
    { "GMK", "GMK Electronic Design GmbH" },
    { "TAI", "Toshiba America Info Systems Inc" },
    { "SNP", "Siemens Nixdorf Info Systems" },
    { "KFE", "Komatsu Forest" },
    { "PPD", "MEPhI" },
    { "UMG", "Umezawa Giken Co.,Ltd" },
    { "PMC", "PMC Consumer Electronics Ltd" },
    { "KIS", "KiSS Technology A/S" },
    { "ABV", "Advanced Research Technology" },
    { "ISA", "Symbol Technologies" },
    { "GMN", "GEMINI 2000 Ltd" },
    { "VSI", "VideoServer" },
    { "DTO", "Deutsche Thomson OHG" },
    { "OCN", "Olfan" },
    { "LTK", "Lucidity Technology Company Ltd" },
    { "CLX", "CardLogix" },
    { "TPT", "Thruput Ltd" },
    { "IXD", "Intertex Data AB" },
    { "ICX", "ICCC A/S" },
    { "REF", "Reflectivity, Inc." },
    { "CDK", "Cray Communications" },
    { "PNX", "Phoenix Technologies, Ltd." },
    { "MCT", "Microtec" },
    { "ESD", "Ensemble Designs, Inc" },
    { "CTS", "Comtec Systems Co., Ltd." },
    { "ADB", "Aldebbaron" },
    { "AML", "Anderson Multimedia Communications (HK) Limited" },
    { "FIN", "Finecom Co., Ltd." },
    { "NCC", "NCR Corporation" },
    { "ONS", "On Systems Inc" },
    { "CGA", "Chunghwa Picture Tubes, LTD" },
    { "NTC", "NeoTech S.R.L" },
    { "AMD", "Amdek Corporation" },
    { "WVV", "WolfVision GmbH" },
    { "PHO", "Photonics Systems Inc." },
    { "AVX", "AVerMedia Technologies, Inc." },
    { "SJE", "Sejin Electron Inc" },
    { "BCM", "Broadcom" },
    { "RLN", "RadioLAN Inc" },
    { "CAM", "Cambridge Audio" },
    { "TCS", "Tatung Company of America Inc" },
    { "RIO", "Rios Systems Company Ltd" },
    { "SWT", "Software Technologies Group,Inc." },
    { "BSL", "Biomedical Systems Laboratory" },
    { "DCV", "Datatronics Technology Inc" },
    { "JPC", "JPC Technology Limited" },
    { "ICC", "BICC Data Networks Ltd" },
    { "CEI", "Crestron Electronics, Inc." },
    { "NUI", "NU Inc." },
    { "MAE", "Maestro Pty Ltd" },
    { "AYR", "Airlib, Inc" },
    { "TPS", "Teleprocessing Systeme GmbH" },
    { "SMK", "SMK CORPORATION" },
    { "IAT", "IAT Germany GmbH" },
    { "BNO", "Bang & Olufsen" },
    { "KRY", "Kroy LLC" },
    { "OLT", "Olitec S.A." },
    { "ABC", "AboCom System Inc" },
    { "FXX", "Fuji Xerox" },
    { "ANI", "Anigma Inc" },
    { "OEI", "Optum Engineering Inc." },
    { "TPE", "Technology Power Enterprises Inc" },
    { "RDI", "Rainbow Displays, Inc." },
    { "KDK", "Kodiak Tech" },
    { "LHT", "Lighthouse Technologies Limited" },
    { "BEK", "Beko Elektronik A.S." },
    { "LND", "Land Computer Company Ltd" },
    { "CDC", "Core Dynamics Corporation" },
    { "FHL", "FHLP" },
    { "UNP", "Unitop" },
    { "MSR", "MASPRO DENKOH Corp." },
    { "MKC", "Media Tek Inc." },
    { "BCD", "Barco GmbH" },
    { "PQI", "Pixel Qi" },
    { "ALD", "In4S Inc" },
    { "HTC", "Hitachi Ltd" },
    { "OCD", "Macraigor Systems Inc" },
    { "PHY", "Phylon Communications" },
    { "MSF", "M-Systems Flash Disk Pioneers" },
    { "ETK", "eTEK Labs Inc." },
    { "DVS", "Digital Video System" },
    { "ACU", "Acculogic" },
    { "YOW", "American Biometric Company" },
    { "MGE", "Schneider Electric S.A." },
    { "AKP", "Atom Komplex Prylad" },
    { "PGI", "PACSGEAR, Inc." },
    { "III", "Intelligent Instrumentation" },
    { "BML", "BIOMED Lab" },
    { "KMC", "Mitsumi Company Ltd" },
    { "RSQ", "R Squared" },
    { "SBC", "Shanghai Bell Telephone Equip Mfg Co" },
    { "FPX", "Cirel Systemes" },
    { "IDN", "Idneo Technologies" },
    { "BNE", "Bull AB" },
};

QT_END_NAMESPACE

#endif // QEDIDVENDORTABLE_P_H
