/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.CompositeVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonInternal;

public class RejectedModuleMessageBuilder {
    public String buildFailureMessage(ModuleResolveState module) {
        boolean hasRejectAll = false;
        for (SelectorState candidate : module.getSelectors()) {
            hasRejectAll |= RejectedModuleMessageBuilder.isRejectAll(candidate.getVersionConstraint());
        }
        StringBuilder sb = new StringBuilder();
        if (hasRejectAll) {
            sb.append("Module ");
        } else {
            sb.append("Cannot find a version of ");
        }
        boolean first = true;
        for (EdgeState incomingEdge : this.getIncomingEdges(module)) {
            SelectorState selector = incomingEdge.getSelector();
            if (first) {
                sb.append("'").append(module.getId()).append("'");
                if (hasRejectAll) {
                    sb.append(" has been rejected:\n");
                } else {
                    sb.append(" that satisfies the version constraints: \n");
                }
            }
            for (String path : RejectedModuleMessageBuilder.pathTo(incomingEdge)) {
                sb.append("   ").append(path);
                sb.append(" ").append(RejectedModuleMessageBuilder.renderVersionConstraint(selector.getVersionConstraint()));
                RejectedModuleMessageBuilder.renderReason(sb, selector);
                sb.append("\n");
            }
            first = false;
        }
        return sb.toString();
    }

    private Collection<EdgeState> getIncomingEdges(ModuleResolveState module) {
        LinkedHashSet incoming = Sets.newLinkedHashSet();
        for (NodeState nodeState : module.getSelected().getNodes()) {
            incoming.addAll(nodeState.getIncomingEdges());
        }
        return incoming;
    }

    private static Collection<String> pathTo(EdgeState edge) {
        ArrayList acc = Lists.newArrayListWithExpectedSize((int)1);
        RejectedModuleMessageBuilder.pathTo(edge, Lists.newArrayList(), acc, Sets.newHashSet());
        ArrayList result = Lists.newArrayListWithCapacity((int)acc.size());
        for (List path : acc) {
            EdgeState target = (EdgeState)Iterators.getLast(path.iterator());
            StringBuilder sb = new StringBuilder();
            if (target.getSelector().getDependencyMetadata().isPending()) {
                sb.append("Constraint path ");
            } else {
                sb.append("Dependency path ");
            }
            for (EdgeState e : path) {
                ModuleVersionIdentifier id = e.getFrom().getResolvedConfigurationId().getId();
                sb.append('\'').append(id).append('\'');
                sb.append(" --> ");
            }
            ModuleIdentifier moduleId = edge.getTargetComponent().getModule().getId();
            sb.append('\'').append(moduleId.getGroup()).append(':').append(moduleId.getName()).append('\'');
            result.add(sb.toString());
        }
        return result;
    }

    private static void renderReason(StringBuilder sb, SelectorState selector) {
        ComponentSelectionReasonInternal selectionReason = selector.getReasonForSelector();
        if (selectionReason.hasCustomDescriptions()) {
            sb.append(" because of the following reason");
            ArrayList reasons = Lists.newArrayListWithExpectedSize((int)1);
            for (ComponentSelectionDescriptor componentSelectionDescriptor : selectionReason.getDescriptions()) {
                ComponentSelectionDescriptorInternal next = (ComponentSelectionDescriptorInternal)componentSelectionDescriptor;
                if (!next.hasCustomDescription()) continue;
                reasons.add(next.getDescription());
            }
            if (reasons.size() == 1) {
                sb.append(": ").append((String)reasons.get(0));
            } else {
                sb.append("s: ");
                Joiner.on((String)", ").appendTo(sb, (Iterable)reasons);
            }
        }
    }

    private static void pathTo(EdgeState component, List<EdgeState> currentPath, List<List<EdgeState>> accumulator, Set<NodeState> alreadySeen) {
        if (alreadySeen.add(component.getFrom())) {
            currentPath.add(0, component);
            for (EdgeState dependent : component.getFrom().getIncomingEdges()) {
                ArrayList otherPath = Lists.newArrayList(currentPath);
                RejectedModuleMessageBuilder.pathTo(dependent, otherPath, accumulator, alreadySeen);
            }
            if (component.getFrom().isRoot()) {
                accumulator.add(currentPath);
            }
        }
    }

    private static String renderVersionConstraint(ResolvedVersionConstraint constraint) {
        if (RejectedModuleMessageBuilder.isRejectAll(constraint)) {
            return "rejects all versions";
        }
        VersionSelector preferredSelector = constraint.getPreferredSelector();
        VersionSelector rejectedSelector = constraint.getRejectedSelector();
        StringBuilder sb = new StringBuilder("prefers ");
        sb.append('\'');
        sb.append(preferredSelector.getSelector());
        sb.append('\'');
        if (rejectedSelector != null) {
            sb.append(", rejects ");
            if (rejectedSelector instanceof CompositeVersionSelector) {
                sb.append("any of \"");
                int i = 0;
                for (VersionSelector selector : ((CompositeVersionSelector)rejectedSelector).getSelectors()) {
                    if (i++ > 0) {
                        sb.append(", ");
                    }
                    sb.append('\'');
                    sb.append(selector.getSelector());
                    sb.append('\'');
                }
                sb.append("\"");
            } else {
                sb.append('\'');
                sb.append(rejectedSelector.getSelector());
                sb.append('\'');
            }
        }
        return sb.toString();
    }

    private static boolean isRejectAll(ResolvedVersionConstraint constraint) {
        return "".equals(constraint.getPreferredVersion()) && RejectedModuleMessageBuilder.hasMatchAllSelector(constraint.getRejectedVersions());
    }

    private static boolean hasMatchAllSelector(List<String> rejectedVersions) {
        for (String version : rejectedVersions) {
            if (!"+".equals(version)) continue;
            return true;
        }
        return false;
    }
}

