/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.trace;

import com.google.common.base.Charsets;
import com.google.common.base.StandardSystemProperty;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import groovy.json.JsonOutput;
import groovy.json.JsonSlurper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.StartParameter;
import org.gradle.api.invocation.Gradle;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.internal.operations.trace.BuildOperationRecord;
import org.gradle.internal.operations.trace.BuildOperationTree;
import org.gradle.internal.operations.trace.SerializedOperation;
import org.gradle.internal.operations.trace.SerializedOperationFinish;
import org.gradle.internal.operations.trace.SerializedOperationProgress;
import org.gradle.internal.operations.trace.SerializedOperationStart;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildOperationTrace
implements Stoppable {
    public static final String SYSPROP = "org.gradle.internal.operations.trace";
    private static final byte[] NEWLINE = "\n".getBytes();
    private static final byte[] INDENT = "    ".getBytes();
    private final String basePath;
    private final OutputStream logOutputStream;
    private final BuildOperationListenerManager buildOperationListenerManager;
    private final ListenerManager listenerManager;
    private final BuildOperationListener listener = new LoggingListener();

    public BuildOperationTrace(StartParameter startParameter, BuildOperationListenerManager buildOperationListenerManager, ListenerManager listenerManager) {
        this.buildOperationListenerManager = buildOperationListenerManager;
        this.listenerManager = listenerManager;
        Map sysProps = startParameter.getSystemPropertiesArgs();
        String basePath = (String)sysProps.get(SYSPROP);
        if (basePath == null) {
            basePath = System.getProperty(SYSPROP);
        }
        this.basePath = basePath;
        if (this.basePath == null || basePath.equals(Boolean.FALSE.toString())) {
            this.logOutputStream = null;
            return;
        }
        try {
            File logFile = BuildOperationTrace.logFile(basePath);
            GFileUtils.mkdirs((File)logFile.getParentFile());
            if (logFile.isFile()) {
                GFileUtils.forceDelete((File)logFile);
            }
            logFile.createNewFile();
            this.logOutputStream = new BufferedOutputStream(new FileOutputStream(logFile));
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        buildOperationListenerManager.addListener(this.listener);
        listenerManager.addListener((Object)this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.buildOperationListenerManager.removeListener(this.listener);
        this.listenerManager.removeListener((Object)this.listener);
        if (this.logOutputStream != null) {
            try {
                OutputStream outputStream = this.logOutputStream;
                synchronized (outputStream) {
                    this.logOutputStream.close();
                }
                List<BuildOperationRecord> roots = BuildOperationTrace.readLogToTreeRoots(BuildOperationTrace.logFile(this.basePath));
                this.writeDetailTree(roots);
                this.writeSummaryTree(roots);
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
    }

    private void writeDetailTree(List<BuildOperationRecord> roots) throws IOException {
        try {
            String rawJson = JsonOutput.toJson(BuildOperationTree.serialize(roots));
            String prettyJson = JsonOutput.prettyPrint((String)rawJson);
            Files.asCharSink((File)BuildOperationTrace.file(this.basePath, "-tree.json"), (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)prettyJson);
        }
        catch (OutOfMemoryError e) {
            System.err.println("Failed to write build operation trace JSON due to out of memory.");
        }
    }

    private void writeSummaryTree(final List<BuildOperationRecord> roots) throws IOException {
        Files.asCharSink((File)BuildOperationTrace.file(this.basePath, "-tree.txt"), (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).writeLines((Iterable)new Iterable<String>(){

            @Override
            @Nonnull
            public Iterator<String> iterator() {
                final ArrayDeque stack = new ArrayDeque(Collections.singleton(new ArrayDeque(roots)));
                final StringBuilder stringBuilder = new StringBuilder();
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        if (stack.isEmpty()) {
                            return false;
                        }
                        if (((Queue)stack.peek()).isEmpty()) {
                            stack.pop();
                            return this.hasNext();
                        }
                        return true;
                    }

                    @Override
                    public String next() {
                        Queue children = (Queue)stack.peek();
                        BuildOperationRecord record = (BuildOperationRecord)children.poll();
                        stringBuilder.setLength(0);
                        int indents = stack.size() - 1;
                        for (int i = 0; i < indents; ++i) {
                            stringBuilder.append("  ");
                        }
                        if (!record.children.isEmpty()) {
                            stack.addFirst(new ArrayDeque<BuildOperationRecord>(record.children));
                        }
                        stringBuilder.append(record.displayName);
                        if (record.details != null) {
                            stringBuilder.append(" ");
                            stringBuilder.append(JsonOutput.toJson(record.details));
                        }
                        if (record.result != null) {
                            stringBuilder.append(" ");
                            stringBuilder.append(JsonOutput.toJson(record.result));
                        }
                        stringBuilder.append(" [");
                        stringBuilder.append(record.endTime - record.startTime);
                        stringBuilder.append("ms]");
                        stringBuilder.append(" (");
                        stringBuilder.append(record.id);
                        stringBuilder.append(")");
                        if (!record.progress.isEmpty()) {
                            for (BuildOperationRecord.Progress progress : record.progress) {
                                stringBuilder.append(StandardSystemProperty.LINE_SEPARATOR.value());
                                for (int i = 0; i < indents; ++i) {
                                    stringBuilder.append("  ");
                                }
                                stringBuilder.append("- ").append(progress.details).append(" [").append(progress.time - record.startTime).append("]");
                            }
                        }
                        return stringBuilder.toString();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }

    public static BuildOperationTree read(String basePath) {
        List<BuildOperationRecord> roots = BuildOperationTrace.readLogToTreeRoots(BuildOperationTrace.logFile(basePath));
        return new BuildOperationTree(roots);
    }

    private static List<BuildOperationRecord> readLogToTreeRoots(final File logFile) {
        try {
            final JsonSlurper slurper = new JsonSlurper();
            final ArrayList<BuildOperationRecord> roots = new ArrayList<BuildOperationRecord>();
            final HashMap pendings = new HashMap();
            final HashMap childrens = new HashMap();
            Files.asCharSource((File)logFile, (Charset)Charsets.UTF_8).readLines((LineProcessor)new LineProcessor<Void>(){

                public boolean processLine(String line) {
                    Map map = (Map)Cast.uncheckedCast((Object)slurper.parseText(line));
                    if (map.containsKey("startTime")) {
                        SerializedOperationStart serialized = new SerializedOperationStart(map);
                        pendings.put(serialized.id, new PendingOperation(serialized));
                        childrens.put(serialized.id, new LinkedList());
                    } else if (map.containsKey("time")) {
                        SerializedOperationProgress serialized = new SerializedOperationProgress(map);
                        PendingOperation pending = (PendingOperation)pendings.get(serialized.id);
                        assert (pending != null) : "did not find owner of progress event with ID " + serialized.id;
                        pending.progress.add(serialized);
                    } else {
                        SerializedOperationFinish finish = new SerializedOperationFinish(map);
                        PendingOperation pending = (PendingOperation)pendings.remove(finish.id);
                        assert (pending != null);
                        List children = (List)childrens.remove(finish.id);
                        assert (children != null);
                        SerializedOperationStart start = pending.start;
                        Map detailsMap = (Map)Cast.uncheckedCast((Object)start.details);
                        Map resultMap = (Map)Cast.uncheckedCast((Object)finish.result);
                        ArrayList<BuildOperationRecord.Progress> progresses = new ArrayList<BuildOperationRecord.Progress>();
                        for (SerializedOperationProgress progress : pending.progress) {
                            Map progressDetailsMap = (Map)Cast.uncheckedCast((Object)progress.details);
                            progresses.add(new BuildOperationRecord.Progress(progress.time, progressDetailsMap, progress.detailsClassName));
                        }
                        BuildOperationRecord record = new BuildOperationRecord(start.id, start.parentId, start.displayName, start.startTime, finish.endTime, detailsMap == null ? null : Collections.unmodifiableMap(detailsMap), start.detailsClassName, resultMap == null ? null : Collections.unmodifiableMap(resultMap), finish.resultClassName, finish.failureMsg, progresses, (List<BuildOperationRecord>)BuildOperationRecord.ORDERING.immutableSortedCopy((Iterable)children));
                        if (start.parentId == null) {
                            roots.add(record);
                        } else {
                            List parentChildren = (List)childrens.get(start.parentId);
                            assert (parentChildren != null) : "parentChildren != null '" + line + "' from " + logFile;
                            parentChildren.add(record);
                        }
                    }
                    return true;
                }

                public Void getResult() {
                    return null;
                }
            });
            assert (pendings.isEmpty());
            return roots;
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private static File logFile(String basePath) {
        return BuildOperationTrace.file(basePath, "-log.txt");
    }

    private static File file(String base, String suffix) {
        return new File((base == null || base.trim().isEmpty() ? "operations" : base) + suffix).getAbsoluteFile();
    }

    private class LoggingListener
    extends BuildAdapter
    implements BuildOperationListener {
        private boolean buffering = true;
        private final Lock bufferLock = new ReentrantLock();
        private final Queue<Entry> buffer = new ConcurrentLinkedQueue<Entry>();

        private LoggingListener() {
        }

        public void projectsLoaded(Gradle gradle) {
            if (gradle.getParent() == null) {
                this.stopBuffering();
            }
        }

        public void buildFinished(BuildResult result) {
            this.stopBuffering();
        }

        public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
            if (buildOperation.getId().getId() == 11L) {
                boolean bl = true;
            }
            new Entry(new SerializedOperationStart(buildOperation, startEvent), false).add();
        }

        public void progress(OperationIdentifier buildOperationId, OperationProgressEvent progressEvent) {
            new Entry(new SerializedOperationProgress(buildOperationId, progressEvent), false).add();
        }

        public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
            new Entry(new SerializedOperationFinish(buildOperation, finishEvent), false).add();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopBuffering() {
            if (this.buffering) {
                this.bufferLock.lock();
                try {
                    if (this.buffering) {
                        for (Entry entry : this.buffer) {
                            entry.write();
                        }
                        this.buffer.clear();
                        this.buffering = false;
                    }
                }
                finally {
                    this.bufferLock.unlock();
                }
            }
        }

        private final class Entry {
            final SerializedOperation operation;
            final boolean indent;

            Entry(SerializedOperation operation, boolean indent) {
                this.operation = operation;
                this.indent = indent;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void add() {
                if (LoggingListener.this.buffering) {
                    LoggingListener.this.bufferLock.lock();
                    try {
                        if (LoggingListener.this.buffering) {
                            if (this.operation instanceof SerializedOperationStart && ((SerializedOperationStart)this.operation).id == 11L) {
                                boolean bl = true;
                            }
                            LoggingListener.this.buffer.add(this);
                        }
                        this.write();
                    }
                    finally {
                        LoggingListener.this.bufferLock.unlock();
                    }
                } else {
                    this.write();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void write() {
                String json = JsonOutput.toJson(this.operation.toMap());
                try {
                    OutputStream outputStream = BuildOperationTrace.this.logOutputStream;
                    synchronized (outputStream) {
                        if (this.indent) {
                            BuildOperationTrace.this.logOutputStream.write(INDENT);
                        }
                        BuildOperationTrace.this.logOutputStream.write(json.getBytes("UTF-8"));
                        BuildOperationTrace.this.logOutputStream.write(NEWLINE);
                        BuildOperationTrace.this.logOutputStream.flush();
                    }
                }
                catch (IOException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
        }
    }

    static class PendingOperation {
        final SerializedOperationStart start;
        final List<SerializedOperationProgress> progress = new ArrayList<SerializedOperationProgress>();

        PendingOperation(SerializedOperationStart start) {
            this.start = start;
        }
    }
}

