/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.rendersurface;

import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.T3i;
import javajs.util.V3;
import org.jmol.render.MeshRenderer;
import org.jmol.shapesurface.Isosurface;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.C;
import org.jmol.util.Normix;

public class IsosurfaceRenderer
extends MeshRenderer {
    protected boolean iHideBackground;
    protected boolean isBicolorMap;
    protected short backgroundColix;
    protected int nError = 0;
    protected float[] vertexValues;
    protected IsosurfaceMesh imesh;
    private Isosurface isosurface;
    private boolean isNavigationMode;
    private boolean iShowNormals;
    private boolean showNumbers;
    private Boolean showKey;
    private boolean hasColorRange;
    private int meshScale = -1;
    private int mySlabValue;
    private int globalSlabValue;

    protected boolean render() {
        return this.renderIso();
    }

    protected boolean renderIso() {
        this.setGlobals();
        int i = this.isosurface.meshCount;
        while (--i >= 0) {
            this.imesh = (IsosurfaceMesh)this.isosurface.meshes[i];
            this.mesh = this.imesh;
            if (this.imesh.connectedAtoms != null && !this.vwr.ms.at[this.imesh.connectedAtoms[0]].checkVisible()) continue;
            this.hasColorRange = false;
            if (!this.renderMeshSlab()) continue;
            this.renderInfo();
            if (!this.isExport || !this.isGhostPass) continue;
            this.exportPass = 1;
            this.renderMeshSlab();
            this.exportPass = 2;
        }
        return this.needTranslucent;
    }

    private void setGlobals() {
        this.needTranslucent = false;
        this.antialias = this.g3d.isAntialiased();
        this.iShowNormals = this.vwr.getBoolean(603979965);
        this.showNumbers = this.vwr.getBoolean(603979964);
        this.isosurface = (Isosurface)this.shape;
        this.exportPass = this.isExport ? 2 : 0;
        this.isNavigationMode = this.vwr.getBoolean(603979889);
        this.showKey = this.vwr.getBoolean(603979867) ? Boolean.TRUE : null;
        this.isosurface.keyXy = null;
        this.meshScale = -1;
        this.globalSlabValue = this.vwr.gdata.slab;
        this.mySlabValue = this.isNavigationMode ? (int)this.tm.getNavigationOffset().z : Integer.MAX_VALUE;
    }

    protected void renderInfo() {
        if (this.isExport || !this.hasColorRange || this.imesh.colorEncoder == null || Boolean.TRUE != this.showKey) {
            return;
        }
        this.showKey = Boolean.FALSE;
        int[] colors = null;
        short[] colixes = null;
        Lst<Object>[] vContours = null;
        int n = 0;
        int type = 0;
        if (this.imesh.showContourLines) {
            vContours = this.imesh.getContours();
            if (vContours == null) {
                colixes = this.imesh.jvxlData.contourColixes;
                if (colixes == null) {
                    return;
                }
                n = colixes.length;
            } else {
                n = vContours.length;
                type = 1;
            }
        } else {
            colors = this.imesh.colorEncoder.getColorSchemeArray(this.imesh.colorEncoder.currentPalette);
            n = colors == null ? 0 : colors.length;
            type = 2;
        }
        if (n < 2) {
            return;
        }
        int factor = this.antialias ? 2 : 1;
        int height = this.vwr.getScreenHeight() * factor;
        int dy = height / 2 / (n - 1);
        int y = height / 4 * 3 - dy;
        int x = 10 * factor;
        int dx = 20 * factor;
        this.isosurface.keyXy = new int[]{x / factor, 0, (x + dx) / factor, (y + dy) / factor, dy / factor};
        int i = 0;
        while (i < n) {
            switch (type) {
                case 0: {
                    if (this.g3d.setC(colixes[i])) break;
                    return;
                }
                case 1: {
                    if (this.g3d.setC(((short[])vContours[i].get(3))[0])) break;
                    return;
                }
                case 2: {
                    this.vwr.gdata.setColor(colors[i]);
                }
            }
            this.g3d.fillTextRect(x, y, 5, Integer.MIN_VALUE, dx, dy);
            ++i;
            y -= dy;
        }
        this.isosurface.keyXy[1] = (y + dy) / factor;
    }

    private boolean renderMeshSlab() {
        boolean isOK;
        this.volumeRender = this.imesh.jvxlData.colorDensity && this.imesh.jvxlData.allowVolumeRender;
        int thisSlabValue = this.mySlabValue;
        this.frontOnly = this.mesh.frontOnly || this.shapeID == 26;
        boolean bl = this.isShell = this.mesh.isShell && this.shapeID != 26;
        if (!this.isNavigationMode) {
            this.meshSlabValue = this.imesh.jvxlData.slabValue;
            if (this.meshSlabValue != Integer.MIN_VALUE && this.imesh.jvxlData.isSlabbable) {
                P3[] points = this.imesh.jvxlData.boundingBox;
                float z0 = Float.MAX_VALUE;
                float z1 = Float.MIN_VALUE;
                int i = points.length;
                while (--i >= 0) {
                    this.pt2f.setT((T3)points[i]);
                    this.tm.transformPt3f((T3)this.pt2f, this.pt2f);
                    if (this.pt2f.z < z0) {
                        z0 = this.pt2f.z;
                    }
                    if (!(this.pt2f.z > z1)) continue;
                    z1 = this.pt2f.z;
                }
                thisSlabValue = Math.round(z0 + (z1 - z0) * (100.0f - (float)this.meshSlabValue) / 100.0f);
                this.frontOnly &= this.meshSlabValue >= 100;
                this.isShell &= this.meshSlabValue >= 100;
            }
        }
        boolean tCover = this.vwr.gdata.translucentCoverOnly;
        this.vwr.gdata.translucentCoverOnly = this.frontOnly || !this.vwr.getBoolean(603979967);
        this.thePlane = this.imesh.jvxlData.jvxlPlane;
        this.vertexValues = this.mesh.vvs;
        if (thisSlabValue != Integer.MAX_VALUE && this.imesh.jvxlData.isSlabbable) {
            this.g3d.setSlab(thisSlabValue);
            isOK = this.renderMesh2(this.mesh);
            this.g3d.setSlab(this.globalSlabValue);
        } else {
            isOK = this.renderMesh2(this.mesh);
        }
        this.vwr.gdata.translucentCoverOnly = tCover;
        return isOK;
    }

    protected void render2(boolean isExport) {
        if (this.volumeRender) {
            this.renderPoints();
            return;
        }
        switch (this.imesh.dataType) {
            case 70: {
                this.renderLonePair(false);
                return;
            }
            case 71: {
                this.renderLonePair(true);
                return;
            }
        }
        this.isBicolorMap = this.imesh.jvxlData.isBicolorMap;
        this.render2b(isExport);
        if (!this.g3d.setC((short)4)) {
            return;
        }
        if (this.imesh.showContourLines) {
            this.renderContourLines();
        }
    }

    private void renderLonePair(boolean isRadical) {
        this.pt2f.setT(this.vertices[1]);
        this.tm.transformPt3f((T3)this.pt2f, this.pt2f);
        int r = (int)this.vwr.tm.scaleToScreen((int)this.pt2f.z, 100);
        if (r < 1) {
            r = 1;
        }
        if (!isRadical) {
            V3 v1 = new V3();
            V3 v2 = new V3();
            this.pt1f.setT(this.vertices[0]);
            this.tm.transformPt3f((T3)this.pt1f, this.pt1f);
            v1.sub2((T3)this.pt2f, (T3)this.pt1f);
            v2.set(v1.x, v1.y, v1.z + 1.0f);
            v2.cross((T3)v2, (T3)v1);
            v2.normalize();
            float f = this.vwr.tm.scaleToScreen((int)this.pt1f.z, 100);
            v2.scale(f);
            this.pt1f.add2((T3)this.pt2f, (T3)v2);
            this.pt2f.sub((T3)v2);
            this.screens[0].set(Math.round(this.pt1f.x), Math.round(this.pt1f.y), Math.round(this.pt1f.z));
            this.g3d.fillSphereI(r, this.screens[0]);
        }
        this.screens[1].set(Math.round(this.pt2f.x), Math.round(this.pt2f.y), Math.round(this.pt2f.z));
        this.g3d.fillSphereI(r, this.screens[1]);
    }

    private void renderContourLines() {
        Lst<Object>[] vContours = this.imesh.getContours();
        if (vContours == null) {
            if (this.imesh.jvxlData.contourValues != null) {
                this.hasColorRange = true;
            }
            return;
        }
        this.hasColorRange = this.mesh.meshColix == 0;
        int i = vContours.length;
        block0: while (--i >= 0) {
            Lst<Object> v = vContours[i];
            if (v.size() < 6) continue;
            short s = this.colix = this.mesh.meshColix == 0 ? ((short[])v.get(3))[0] : this.mesh.meshColix;
            if (!this.g3d.setC(this.colix)) {
                return;
            }
            int n = v.size() - 1;
            int diam = this.getDiameter();
            for (int j = 6; j < n; ++j) {
                T3 pt1 = (T3)v.get(j);
                T3 pt2 = (T3)v.get(++j);
                if (Float.isNaN(pt1.x) || Float.isNaN(pt2.x)) continue block0;
                this.tm.transformPtScrT3(pt1, (T3)this.pt1f);
                this.tm.transformPtScrT3(pt2, (T3)this.pt2f);
                this.pt1f.z -= 2.0f;
                this.pt2f.z -= 2.0f;
                if (!this.antialias && diam == 1) {
                    this.g3d.drawLineAB(this.pt1f, this.pt2f);
                    continue;
                }
                this.g3d.fillCylinderBits((byte)1, diam, this.pt1f, this.pt2f);
            }
        }
    }

    protected void renderPoints() {
        try {
            int i;
            int cY;
            int diam;
            if (this.volumeRender) {
                this.g3d.volumeRender(true);
            }
            boolean slabPoints = (this.volumeRender || this.mesh.pc == 0) && this.selectedPolyOnly;
            int incr = this.imesh.vertexIncrement;
            if (this.mesh.diameter <= 0) {
                diam = this.vwr.getInt(553648143);
                this.isShell = false;
                this.frontOnly = false;
            } else {
                diam = this.vwr.getScreenDim() / (this.volumeRender ? 50 : 100);
            }
            int ptSize = Math.round(Float.isNaN(this.mesh.volumeRenderPointSize) ? 150.0f : this.mesh.volumeRenderPointSize * 1000.0f);
            if (diam < 1) {
                diam = 1;
            }
            int cX = this.showNumbers ? this.vwr.getScreenWidth() / 2 : 0;
            int n = cY = this.showNumbers ? this.vwr.getScreenHeight() / 2 : 0;
            if (this.showNumbers) {
                this.vwr.gdata.setFontFid(this.vwr.gdata.getFontFidFS("Monospaced", 24.0f));
            }
            int n2 = i = !this.imesh.hasGridPoints || this.imesh.firstRealVertex < 0 ? 0 : this.imesh.firstRealVertex;
            while (i < this.vertexCount) {
                if (!(this.vertexValues != null && Float.isNaN(this.vertexValues[i]) || this.frontOnly && !this.isVisibleNormix(this.normixes[i]) || this.imesh.jvxlData.thisSet >= 0 && this.mesh.vertexSets[i] != this.imesh.jvxlData.thisSet || !this.mesh.isColorSolid && this.mesh.vcs != null && !this.setColix(this.mesh.vcs[i]) || this.haveBsDisplay && !this.mesh.bsDisplay.get(i) || slabPoints && !this.bsPolygons.get(i))) {
                    this.hasColorRange = true;
                    if (this.showNumbers && this.screens[i].z > 10 && Math.abs(this.screens[i].x - cX) < 150 && Math.abs(this.screens[i].y - cY) < 150) {
                        String s = i + (this.mesh.isColorSolid ? "" : " " + this.mesh.vvs[i]);
                        this.g3d.setC((short)4);
                        this.g3d.drawStringNoSlab(s, null, this.screens[i].x, this.screens[i].y, this.screens[i].z - 30, (short)0);
                    }
                    if (this.volumeRender) {
                        diam = (int)this.vwr.tm.scaleToScreen(this.screens[i].z, ptSize);
                        if (diam < 1) {
                            diam = 1;
                        }
                        this.g3d.volumeRender4(diam, this.screens[i].x, this.screens[i].y, this.screens[i].z);
                    } else {
                        this.g3d.fillSphereI(diam, this.screens[i]);
                    }
                }
                i += incr;
            }
            if (incr == 3) {
                this.g3d.setC(this.isTranslucent ? C.getColixTranslucent3((short)12, (boolean)true, (float)0.5f) : (short)12);
                for (i = 1; i < this.vertexCount; i += 3) {
                    this.g3d.fillCylinder((byte)3, diam / 4, this.screens[i], this.screens[i + 1]);
                }
                this.g3d.setC(this.isTranslucent ? C.getColixTranslucent3((short)21, (boolean)true, (float)0.5f) : (short)21);
                for (i = 1; i < this.vertexCount; i += 3) {
                    this.g3d.fillSphereI(diam, this.screens[i]);
                }
                this.g3d.setC(this.isTranslucent ? C.getColixTranslucent3((short)7, (boolean)true, (float)0.5f) : (short)7);
                for (i = 2; i < this.vertexCount; i += 3) {
                    this.g3d.fillSphereI(diam, this.screens[i]);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.volumeRender) {
            this.g3d.volumeRender(false);
        }
    }

    protected void renderTriangles(boolean fill, boolean iShowTriangles, boolean isExport) {
        boolean colorArrayed;
        short[] vertexColixes;
        this.g3d.addRenderer(1073742182);
        int[][] polygonIndexes = this.mesh.pis;
        this.colix = this.isGhostPass ? this.mesh.slabColix : (!fill && this.mesh.meshColix != 0 ? this.mesh.meshColix : this.mesh.colix);
        Object object = vertexColixes = (Object)(!fill && this.mesh.meshColix != 0 ? null : this.mesh.vcs);
        if (this.isTranslucentInherit) {
            this.colix = C.copyColixTranslucency((short)this.mesh.slabColix, (short)this.mesh.colix);
        }
        this.g3d.setC(this.colix);
        boolean generateSet = isExport;
        if (generateSet) {
            if (this.frontOnly && fill) {
                this.frontOnly = false;
            }
            this.bsPolygonsToExport.clearAll();
        }
        if (this.exportType == 1) {
            this.frontOnly = false;
        }
        boolean colorSolid = this.isGhostPass && !this.isBicolorMap || vertexColixes == null || this.mesh.isColorSolid;
        boolean noColor = this.isGhostPass && !this.isBicolorMap || vertexColixes == null || !fill && this.mesh.meshColix != 0;
        boolean isPlane = this.imesh.jvxlData.jvxlPlane != null;
        short colix = this.colix;
        if (isPlane && !colorSolid && !fill && this.mesh.fillTriangles) {
            colorSolid = true;
            colix = 4;
        }
        boolean bl = colorArrayed = colorSolid && this.mesh.pcs != null;
        if (colorArrayed && !fill && this.mesh.fillTriangles) {
            colorArrayed = false;
        }
        short[] contourColixes = this.imesh.jvxlData.contourColixes;
        this.hasColorRange = !colorSolid && !this.isBicolorMap;
        int diam = this.getDiameter();
        int i0 = 0;
        int i = this.mesh.pc;
        while (--i >= i0) {
            short colixA;
            short colixB;
            short colixC;
            int check;
            int[] polygon = polygonIndexes[i];
            if (polygon == null || this.selectedPolyOnly && !this.bsPolygons.get(i)) continue;
            int iA = polygon[0];
            int iB = polygon[1];
            int iC = polygon[2];
            if (this.imesh.jvxlData.thisSet >= 0 && this.mesh.vertexSets != null && this.mesh.vertexSets[iA] != this.imesh.jvxlData.thisSet || this.haveBsDisplay && (!this.mesh.bsDisplay.get(iA) || !this.mesh.bsDisplay.get(iB) || !this.mesh.bsDisplay.get(iC))) continue;
            short nA = this.normixes[iA];
            short nB = this.normixes[iB];
            short nC = this.normixes[iC];
            int n = check = this.frontOnly || this.isShell ? this.checkFront(nA, nB, nC) : 7;
            if (fill && check == 0) continue;
            if (colorSolid) {
                if (colorArrayed && i < this.mesh.pcs.length) {
                    short c = this.mesh.pcs[i];
                    if (c == 0) continue;
                    colix = c;
                }
                if (iShowTriangles) {
                    colix = (short)(Math.round(Math.random() * 10.0) + 5L);
                }
                colixB = colixC = colix;
                colixA = colixC;
            } else {
                colixA = vertexColixes[iA];
                colixB = vertexColixes[iB];
                colixC = vertexColixes[iC];
                if (this.isBicolorMap) {
                    if (colixA != colixB || colixB != colixC) continue;
                    if (this.isGhostPass) {
                        colixB = colixC = C.copyColixTranslucency((short)this.mesh.slabColix, (short)colixA);
                        colixA = colixC;
                    }
                }
            }
            if (fill) {
                if (generateSet) {
                    this.bsPolygonsToExport.set(i);
                    continue;
                }
                if (iB == iC) {
                    this.setColix(colixA);
                    if (iA == iB) {
                        this.g3d.fillSphereI(diam, this.screens[iA]);
                    } else {
                        this.g3d.fillCylinder((byte)3, diam, this.screens[iA], this.screens[iB]);
                    }
                } else if (this.mesh.colorsExplicit) {
                    this.vwr.gdata.setColor(polygon[4]);
                    colixA = C.copyColixTranslucency((short)this.mesh.colix, (short)2047);
                    this.g3d.setC(colixA);
                    this.g3d.fillTriangle3CN(this.screens[iA], colixA, nA, this.screens[iB], colixA, nB, this.screens[iC], colixA, nC);
                } else {
                    if (this.isTranslucentInherit && vertexColixes != null) {
                        colixA = C.copyColixTranslucency((short)this.mesh.slabColix, (short)vertexColixes[iA]);
                        colixB = C.copyColixTranslucency((short)this.mesh.slabColix, (short)vertexColixes[iB]);
                        colixC = C.copyColixTranslucency((short)this.mesh.slabColix, (short)vertexColixes[iC]);
                    }
                    this.g3d.fillTriangle3CN(this.screens[iA], colixA, nA, this.screens[iB], colixB, nB, this.screens[iC], colixC, nC);
                }
                if (!this.iShowNormals) continue;
                this.renderNormals();
                continue;
            }
            if ((check &= polygon[3]) == 0) continue;
            if (iShowTriangles) {
                check = 7;
            }
            this.pt1i.setT((T3i)this.screens[iA]);
            this.pt2i.setT((T3i)this.screens[iB]);
            this.pt3i.setT((T3i)this.screens[iC]);
            this.pt1i.z -= 2;
            this.pt2i.z -= 2;
            this.pt3i.z -= 2;
            if (!noColor) {
                if (colorArrayed) {
                    this.g3d.setC(this.mesh.fillTriangles ? (short)4 : contourColixes[polygon[4] % contourColixes.length]);
                } else {
                    this.drawTriangle(this.pt1i, colixA, this.pt2i, colixB, this.pt3i, colixC, check, diam);
                    continue;
                }
            }
            this.drawTriangle(this.pt1i, colix, this.pt2i, colix, this.pt3i, colix, check, diam);
        }
        if (generateSet) {
            this.exportSurface(colorSolid ? colix : (short)0);
        }
    }

    private int getDiameter() {
        int diam;
        if (this.mesh.diameter <= 0) {
            int n = diam = this.meshScale < 0 ? (this.meshScale = this.vwr.getInt(553648151)) : this.meshScale;
            if (this.antialias) {
                diam *= 2;
            }
        } else {
            diam = this.vwr.getScreenDim() / 100;
        }
        if (diam < 1) {
            diam = 1;
        }
        return diam;
    }

    private void renderNormals() {
        if (!this.g3d.setC(C.copyColixTranslucency((short)this.mesh.colix, (short)8))) {
            return;
        }
        this.vwr.gdata.setFontFid(this.vwr.gdata.getFontFidFS("Monospaced", 24.0f));
        V3[] vertexVectors = Normix.getVertexVectors();
        int i = this.vertexCount;
        while (--i >= 0) {
            if (this.vertexValues != null && Float.isNaN(this.vertexValues[i])) continue;
            this.pt1f.setT(this.vertices[i]);
            short n = this.mesh.normixes[i];
            if (n < 0) continue;
            this.pt2f.scaleAdd2(0.3f, (T3)vertexVectors[n], (T3)this.pt1f);
            this.tm.transformPtScrT3((T3)this.pt2f, (T3)this.pt2f);
            this.pt1f.set((float)this.screens[i].x, (float)this.screens[i].y, (float)this.screens[i].z);
            this.g3d.drawLineAB(this.pt1f, this.pt2f);
        }
    }
}

