/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.util.Objects;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.styleelement.MapImage;
import org.openstreetmap.josm.gui.mappaint.styleelement.NodeElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class RepeatImageElement
extends StyleElement {
    public MapImage pattern;
    public float offset;
    public float spacing;
    public float phase;
    public LineImageAlignment align;
    private static final String[] REPEAT_IMAGE_KEYS = new String[]{"repeat-image", "repeat-image-width", "repeat-image-height", "repeat-image-opacity", null, null};

    public RepeatImageElement(Cascade c, MapImage pattern, float offset, float spacing, float phase, LineImageAlignment align) {
        super(c, 2.9f);
        CheckParameterUtil.ensureParameterNotNull(pattern);
        CheckParameterUtil.ensureParameterNotNull((Object)align);
        this.pattern = pattern;
        this.offset = offset;
        this.spacing = spacing;
        this.phase = phase;
        this.align = align;
    }

    public static RepeatImageElement create(Environment env) {
        MapImage pattern = NodeElement.createIcon(env, REPEAT_IMAGE_KEYS);
        if (pattern == null) {
            return null;
        }
        Cascade c = env.mc.getCascade(env.layer);
        float offset = c.get("repeat-image-offset", Float.valueOf(0.0f), Float.class).floatValue();
        float spacing = c.get("repeat-image-spacing", Float.valueOf(0.0f), Float.class).floatValue();
        float phase = -c.get("repeat-image-phase", Float.valueOf(0.0f), Float.class).floatValue();
        LineImageAlignment align = LineImageAlignment.CENTER;
        Keyword alignKW = c.get("repeat-image-align", Keyword.CENTER, Keyword.class);
        if ("top".equals(alignKW.val)) {
            align = LineImageAlignment.TOP;
        } else if ("bottom".equals(alignKW.val)) {
            align = LineImageAlignment.BOTTOM;
        }
        return new RepeatImageElement(c, pattern, offset, spacing, phase, align);
    }

    @Override
    public void paintPrimitive(IPrimitive primitive, MapPaintSettings paintSettings, StyledMapRenderer painter, boolean selected, boolean outermember, boolean member) {
        if (primitive instanceof Way) {
            Way w = (Way)primitive;
            painter.drawRepeatImage(w, this.pattern, painter.isInactiveMode() || w.isDisabled(), this.offset, this.spacing, this.phase, this.align);
        }
    }

    @Override
    public boolean isProperLineStyle() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        RepeatImageElement that = (RepeatImageElement)obj;
        return this.align == that.align && Float.compare(that.offset, this.offset) == 0 && Float.compare(that.spacing, this.spacing) == 0 && Float.compare(that.phase, this.phase) == 0 && Objects.equals(this.pattern, that.pattern);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.pattern, Float.valueOf(this.offset), Float.valueOf(this.spacing), Float.valueOf(this.phase), this.align});
    }

    @Override
    public String toString() {
        return "RepeatImageStyle{" + super.toString() + "pattern=[" + this.pattern + "], offset=" + this.offset + ", spacing=" + this.spacing + ", phase=" + -this.phase + ", align=" + (Object)((Object)this.align) + '}';
    }

    public static enum LineImageAlignment {
        TOP(0.5),
        CENTER(0.0),
        BOTTOM(-0.5);

        private final double alignmentOffset;

        private LineImageAlignment(double alignmentOffset) {
            this.alignmentOffset = alignmentOffset;
        }

        public double getAlignmentOffset() {
            return this.alignmentOffset;
        }
    }
}

