/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.HomeObject;
import com.eteks.sweethome3d.model.Selectable;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.WeakReference;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class Compass
extends HomeObject
implements Selectable {
    private static final long serialVersionUID = 1L;
    private float x;
    private float y;
    private float diameter;
    private boolean visible;
    private float northDirection;
    private float latitude;
    private float longitude;
    private TimeZone timeZone;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private transient float[][] pointsCache;
    private transient Calendar dateCache;
    private transient float sunElevationCache;
    private transient float sunAzimuthCache;
    private static WeakReference<Map<String, GeographicPoint>> timeZoneGeographicPointsReference;

    public Compass(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.diameter = f3;
        this.visible = true;
        this.timeZone = TimeZone.getDefault();
        this.initGeographicPoint();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        objectInputStream.defaultReadObject();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public float getX() {
        return this.x;
    }

    public void setX(float f) {
        if (f != this.x) {
            float f2 = this.x;
            this.x = f;
            this.pointsCache = null;
            this.propertyChangeSupport.firePropertyChange(Property.X.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f) {
        if (f != this.y) {
            float f2 = this.y;
            this.y = f;
            this.pointsCache = null;
            this.propertyChangeSupport.firePropertyChange(Property.Y.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getDiameter() {
        return this.diameter;
    }

    public void setDiameter(float f) {
        if (f != this.diameter) {
            float f2 = this.diameter;
            this.diameter = f;
            this.pointsCache = null;
            this.propertyChangeSupport.firePropertyChange(Property.DIAMETER.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (bl != this.visible) {
            this.visible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.VISIBLE.name(), !bl, bl);
        }
    }

    public float getNorthDirection() {
        return this.northDirection;
    }

    public void setNorthDirection(float f) {
        if (f != this.northDirection) {
            float f2 = this.northDirection;
            this.northDirection = f;
            this.pointsCache = null;
            this.propertyChangeSupport.firePropertyChange(Property.NORTH_DIRECTION.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public final float getLatitude() {
        return this.latitude;
    }

    public void setLatitude(float f) {
        if (f != this.latitude) {
            float f2 = this.latitude;
            this.latitude = f;
            this.dateCache = null;
            this.propertyChangeSupport.firePropertyChange(Property.LATITUDE.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public final float getLongitude() {
        return this.longitude;
    }

    public void setLongitude(float f) {
        if (f != this.longitude) {
            float f2 = this.longitude;
            this.longitude = f;
            this.dateCache = null;
            this.propertyChangeSupport.firePropertyChange(Property.LONGITUDE.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public String getTimeZone() {
        return this.timeZone.getID();
    }

    public void setTimeZone(String string) {
        if (!this.timeZone.getID().equals(string)) {
            if (string == null) {
                throw new IllegalArgumentException("Time zone ID can't be null");
            }
            String string2 = this.timeZone.getID();
            this.timeZone = TimeZone.getTimeZone(string);
            this.dateCache = null;
            this.propertyChangeSupport.firePropertyChange(Property.TIME_ZONE.name(), string2, string);
        }
    }

    public float[][] getPoints() {
        if (this.pointsCache == null) {
            Rectangle2D.Float float_ = new Rectangle2D.Float(this.getX() - this.getDiameter() / 2.0f, this.getY() - this.getDiameter() / 2.0f, this.getDiameter(), this.getDiameter());
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.getNorthDirection(), this.getX(), this.getY());
            this.pointsCache = new float[4][2];
            PathIterator pathIterator = float_.getPathIterator(affineTransform);
            for (int i = 0; i < this.pointsCache.length; ++i) {
                pathIterator.currentSegment(this.pointsCache[i]);
                pathIterator.next();
            }
        }
        return new float[][]{(float[])this.pointsCache[0].clone(), (float[])this.pointsCache[1].clone(), (float[])this.pointsCache[2].clone(), (float[])this.pointsCache[3].clone()};
    }

    public boolean intersectsRectangle(float f, float f2, float f3, float f4) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, 0.0f, 0.0f);
        float_.add(f3, f4);
        return new Ellipse2D.Float(this.getX() - this.getDiameter() / 2.0f, this.getY() - this.getDiameter() / 2.0f, this.getDiameter(), this.getDiameter()).intersects(float_);
    }

    public boolean containsPoint(float f, float f2, float f3) {
        Ellipse2D.Float float_ = new Ellipse2D.Float(this.getX() - this.getDiameter() / 2.0f, this.getY() - this.getDiameter() / 2.0f, this.getDiameter(), this.getDiameter());
        if (f3 == 0.0f) {
            return float_.contains(f, f2);
        }
        return float_.intersects(f - f3, f2 - f3, 2.0f * f3, 2.0f * f3);
    }

    public void move(float f, float f2) {
        this.setX(this.getX() + f);
        this.setY(this.getY() + f2);
    }

    public Compass clone() {
        Compass compass = (Compass)super.clone();
        compass.propertyChangeSupport = new PropertyChangeSupport(compass);
        return compass;
    }

    public float getSunElevation(long l) {
        this.updateSunLocation(l);
        return this.sunElevationCache;
    }

    public float getSunAzimuth(long l) {
        this.updateSunLocation(l);
        return this.sunAzimuthCache;
    }

    private void updateSunLocation(long l) {
        if (this.dateCache == null || this.dateCache.getTimeInMillis() != l) {
            this.dateCache = new GregorianCalendar(this.timeZone);
            this.dateCache.setTimeInMillis(l);
            int n = this.dateCache.get(1);
            int n2 = this.dateCache.get(2) + 1;
            int n3 = this.dateCache.get(5);
            int n4 = this.dateCache.get(11);
            int n5 = this.dateCache.get(12);
            int n6 = this.dateCache.get(13);
            int n7 = this.dateCache.getTimeZone().getRawOffset() / 3600000;
            int n8 = this.dateCache.get(16) / 3600000;
            double d = this.computeJulianDay(n, n2, n3, n4, n5, n6, n7, n8);
            double d2 = this.toSiderealTime(d);
            double d3 = 360.0 * d2 / 23.9344;
            double d4 = ((double)(n4 - (n7 + n8)) - 12.0 + (double)n5 / 60.0 + (double)n6 / 3600.0) * 360.0 / 23.9344;
            double d5 = d3 + d4;
            double d6 = 357.529 + 0.98560028 * d;
            double d7 = 280.459 + 0.98564736 * d;
            double d8 = d7 + 1.915 * Math.sin(Math.toRadians(d6)) + 0.02 * Math.sin(Math.toRadians(2.0 * d6));
            double d9 = 23.439 - 3.6E-7 * d;
            double d10 = Math.toDegrees(Math.atan(Math.cos(Math.toRadians(d9)) * Math.sin(Math.toRadians(d8)) / Math.cos(Math.toRadians(d8)))) / 15.0;
            if (Math.cos(Math.toRadians(d8)) < 0.0) {
                d10 += 12.0;
            }
            if (Math.cos(Math.toRadians(d8)) > 0.0 && Math.sin(Math.toRadians(d8)) < 0.0) {
                d10 += 24.0;
            }
            double d11 = Math.asin(Math.sin(Math.toRadians(d9)) * Math.sin(Math.toRadians(d8)));
            double d12 = Math.toRadians(d5 - d10 * 15.0 + Math.toDegrees(this.longitude));
            double d13 = Math.asin(Math.sin(d11) * Math.sin(this.latitude) - Math.cos(d11) * Math.cos(this.latitude) * Math.cos(d12));
            double d14 = Math.acos((Math.sin(d11) - Math.sin(this.latitude) * Math.sin(d13)) / (Math.cos(this.latitude) * Math.cos(d13)));
            double d15 = Math.cos(d11) * Math.sin(d12) / Math.cos(d13);
            if (d15 < 0.0) {
                d14 = Math.PI * 2 - d14;
            }
            this.sunElevationCache = (float)d13;
            this.sunAzimuthCache = (float)d14;
        }
    }

    private double computeJulianDay(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        double d = (double)n3 + (double)n4 / 24.0 + (double)n5 / 1440.0 + (double)n6 / 86400.0;
        if (n2 == 1 || n2 == 2) {
            --n;
            n2 += 12;
        }
        int n9 = n / 100;
        int n10 = 2 - n9 + n9 / 4;
        double d2 = (double)((int)(365.25 * ((double)n + 4716.0)) + (int)(30.6001 * (double)(n2 + 1))) + d + (double)n10 - 1524.5;
        d2 -= (double)(n7 + n8) / 24.0;
        return d2 -= 2451545.0;
    }

    private double toSiderealTime(double d) {
        double d2 = d / 36525.0;
        double d3 = (24110.54841 + 8640184.812866 * d2 + 0.093104 * Math.pow(d2, 2.0) - 6.2E-6 * Math.pow(d2, 3.0)) / 3600.0;
        return (d3 / 24.0 - (double)((int)(d3 / 24.0))) * 24.0;
    }

    private void initGeographicPoint() {
        GeographicPoint geographicPoint;
        Map<String, GeographicPoint> map;
        if (timeZoneGeographicPointsReference == null || timeZoneGeographicPointsReference.get() == null) {
            map = new HashMap();
            geographicPoint = new GeographicPoint(-13.833333f, -171.73334f);
            map.put("Etc/GMT+11", geographicPoint);
            map.put("Pacific/Apia", geographicPoint);
            map.put("Pacific/Midway", new GeographicPoint(28.2f, -177.35f));
            map.put("Pacific/Niue", new GeographicPoint(-19.055f, -169.92f));
            map.put("Pacific/Pago_Pago", new GeographicPoint(-14.278055f, -170.7025f));
            map.put("Pacific/Samoa", geographicPoint);
            map.put("US/Samoa", geographicPoint);
            map.put("America/Adak", new GeographicPoint(51.88f, -176.65805f));
            map.put("America/Atka", new GeographicPoint(52.19611f, -174.20056f));
            GeographicPoint geographicPoint2 = new GeographicPoint(21.306944f, -157.85834f);
            map.put("Etc/GMT+10", geographicPoint2);
            map.put("Pacific/Fakaofo", new GeographicPoint(-9.3653f, -171.215f));
            map.put("Pacific/Honolulu", geographicPoint2);
            map.put("Pacific/Johnston", new GeographicPoint(16.75f, -169.517f));
            map.put("Pacific/Rarotonga", new GeographicPoint(-21.233f, -159.783f));
            map.put("Pacific/Tahiti", new GeographicPoint(-17.533333f, -149.56667f));
            map.put("SystemV/HST10", geographicPoint2);
            map.put("US/Aleutian", new GeographicPoint(54.817f, 164.033f));
            map.put("US/Hawaii", geographicPoint2);
            map.put("Pacific/Marquesas", new GeographicPoint(-9.45f, -139.38f));
            GeographicPoint geographicPoint3 = new GeographicPoint(61.218056f, -149.90028f);
            map.put("America/Anchorage", geographicPoint3);
            map.put("America/Juneau", new GeographicPoint(58.301945f, -134.41972f));
            map.put("America/Nome", new GeographicPoint(64.501114f, -165.40639f));
            map.put("America/Yakutat", new GeographicPoint(59.546944f, -139.72722f));
            map.put("Etc/GMT+9", geographicPoint3);
            map.put("Pacific/Gambier", new GeographicPoint(-23.1178f, -134.97f));
            map.put("SystemV/YST9", geographicPoint3);
            map.put("SystemV/YST9YDT", geographicPoint3);
            map.put("US/Alaska", geographicPoint3);
            map.put("America/Dawson", new GeographicPoint(64.066666f, -139.41667f));
            map.put("America/Ensenada", new GeographicPoint(31.866667f, -116.61667f));
            GeographicPoint geographicPoint4 = new GeographicPoint(34.052223f, -118.242775f);
            map.put("America/Los_Angeles", geographicPoint4);
            map.put("America/Santa_Isabel", new GeographicPoint(28.383333f, -113.35f));
            map.put("America/Tijuana", new GeographicPoint(32.533333f, -117.01667f));
            map.put("America/Vancouver", new GeographicPoint(49.25f, -123.13333f));
            map.put("America/Whitehorse", new GeographicPoint(60.716667f, -135.05f));
            map.put("Canada/Pacific", new GeographicPoint(49.25f, -123.13333f));
            map.put("Canada/Yukon", new GeographicPoint(60.716667f, -135.05f));
            map.put("Etc/GMT+8", geographicPoint4);
            map.put("Mexico/BajaNorte", new GeographicPoint(32.533333f, -117.01667f));
            map.put("Pacific/Pitcairn", new GeographicPoint(-25.0667f, -130.1f));
            map.put("SystemV/PST8", geographicPoint4);
            map.put("SystemV/PST8PDT", geographicPoint4);
            map.put("US/Pacific", geographicPoint4);
            map.put("US/Pacific-New", geographicPoint4);
            map.put("America/Boise", new GeographicPoint(43.61361f, -116.2025f));
            map.put("America/Cambridge_Bay", new GeographicPoint(69.11667f, -105.03333f));
            map.put("America/Chihuahua", new GeographicPoint(28.633333f, -106.083336f));
            map.put("America/Dawson_Creek", new GeographicPoint(55.766666f, -120.23333f));
            GeographicPoint geographicPoint5 = new GeographicPoint(39.739166f, -104.98417f);
            map.put("America/Denver", geographicPoint5);
            map.put("America/Edmonton", new GeographicPoint(53.55f, -113.5f));
            map.put("America/Hermosillo", new GeographicPoint(29.066668f, -110.96667f));
            map.put("America/Inuvik", new GeographicPoint(68.35f, -133.7f));
            map.put("America/Mazatlan", new GeographicPoint(23.216667f, -106.416664f));
            map.put("America/Ojinaga", new GeographicPoint(29.566668f, -104.416664f));
            map.put("America/Phoenix", new GeographicPoint(33.448334f, -112.07333f));
            map.put("America/Shiprock", new GeographicPoint(36.785557f, -108.686386f));
            map.put("America/Yellowknife", new GeographicPoint(62.45f, -114.35f));
            map.put("Canada/Mountain", new GeographicPoint(53.55f, -113.5f));
            map.put("Etc/GMT+7", geographicPoint5);
            map.put("Mexico/BajaSur", new GeographicPoint(32.567f, -116.633f));
            map.put("SystemV/MST7", geographicPoint5);
            map.put("SystemV/MST7MDT", geographicPoint5);
            map.put("US/Arizona", new GeographicPoint(33.448334f, -112.07333f));
            map.put("US/Mountain", geographicPoint5);
            map.put("America/Belize", new GeographicPoint(17.483334f, -88.183334f));
            map.put("America/Cancun", new GeographicPoint(21.166668f, -86.833336f));
            GeographicPoint geographicPoint6 = new GeographicPoint(41.85f, -87.65f);
            map.put("America/Chicago", geographicPoint6);
            map.put("America/Costa_Rica", new GeographicPoint(9.933333f, -84.083336f));
            map.put("America/El_Salvador", new GeographicPoint(13.7086115f, -89.20306f));
            map.put("America/Guatemala", new GeographicPoint(14.621111f, -90.52695f));
            map.put("America/Knox_IN", new GeographicPoint(41.295834f, -86.625f));
            map.put("America/Managua", new GeographicPoint(12.150833f, -86.26833f));
            map.put("America/Matamoros", new GeographicPoint(25.883333f, -97.5f));
            map.put("America/Menominee", new GeographicPoint(45.107777f, -87.61417f));
            map.put("America/Merida", new GeographicPoint(20.966667f, -89.61667f));
            map.put("America/Mexico_City", new GeographicPoint(19.434168f, -99.13861f));
            map.put("America/Monterrey", new GeographicPoint(25.666668f, -100.316666f));
            map.put("America/Rainy_River", new GeographicPoint(48.716667f, -94.566666f));
            map.put("America/Rankin_Inlet", new GeographicPoint(62.816666f, -92.083336f));
            map.put("America/Regina", new GeographicPoint(50.45f, -104.61667f));
            map.put("America/Swift_Current", new GeographicPoint(50.283333f, -107.76667f));
            map.put("America/Tegucigalpa", new GeographicPoint(14.1f, -87.21667f));
            map.put("America/Winnipeg", new GeographicPoint(49.88333f, -97.166664f));
            map.put("Canada/Central", new GeographicPoint(50.45f, -104.61667f));
            map.put("Canada/East-Saskatchewan", new GeographicPoint(51.216667f, -102.46667f));
            map.put("Canada/Saskatchewan", new GeographicPoint(50.45f, -104.61667f));
            map.put("Chile/EasterIsland", new GeographicPoint(-27.15f, -109.425f));
            map.put("Etc/GMT+6", geographicPoint6);
            map.put("Mexico/General", new GeographicPoint(19.434168f, -99.13861f));
            map.put("Pacific/Easter", new GeographicPoint(-27.15f, -109.425f));
            map.put("Pacific/Galapagos", new GeographicPoint(-0.667f, -90.55f));
            map.put("SystemV/CST6", geographicPoint6);
            map.put("SystemV/CST6CDT", geographicPoint6);
            map.put("US/Central", geographicPoint6);
            map.put("US/Indiana-Starke", new GeographicPoint(41.295834f, -86.625f));
            map.put("America/Atikokan", new GeographicPoint(48.75f, -91.61667f));
            map.put("America/Bogota", new GeographicPoint(4.6f, -74.083336f));
            map.put("America/Cayman", new GeographicPoint(19.3f, -81.38333f));
            map.put("America/Coral_Harbour", new GeographicPoint(64.13333f, -83.166664f));
            map.put("America/Detroit", new GeographicPoint(42.33139f, -83.04583f));
            map.put("America/Fort_Wayne", new GeographicPoint(41.130554f, -85.12889f));
            map.put("America/Grand_Turk", new GeographicPoint(21.466667f, -71.13333f));
            map.put("America/Guayaquil", new GeographicPoint(-2.1666667f, -79.9f));
            map.put("America/Havana", new GeographicPoint(23.131945f, -82.36417f));
            map.put("America/Indianapolis", new GeographicPoint(39.768333f, -86.15806f));
            map.put("America/Iqaluit", new GeographicPoint(63.733334f, -68.5f));
            map.put("America/Jamaica", new GeographicPoint(18.0f, -76.8f));
            map.put("America/Lima", new GeographicPoint(-12.05f, -77.05f));
            map.put("America/Louisville", new GeographicPoint(38.254166f, -85.759445f));
            map.put("America/Montreal", new GeographicPoint(45.5f, -73.583336f));
            map.put("America/Nassau", new GeographicPoint(25.083334f, -77.35f));
            GeographicPoint geographicPoint7 = new GeographicPoint(40.71417f, -74.006386f);
            map.put("America/New_York", geographicPoint7);
            map.put("America/Nipigon", new GeographicPoint(49.016666f, -88.25f));
            map.put("America/Panama", new GeographicPoint(8.966667f, -79.53333f));
            map.put("America/Pangnirtung", new GeographicPoint(66.13333f, -65.75f));
            map.put("America/Port-au-Prince", new GeographicPoint(18.539167f, -72.335f));
            map.put("America/Resolute", new GeographicPoint(74.683334f, -94.9f));
            map.put("America/Thunder_Bay", new GeographicPoint(48.4f, -89.23333f));
            map.put("America/Toronto", new GeographicPoint(43.666668f, -79.416664f));
            map.put("Canada/Eastern", new GeographicPoint(43.666668f, -79.416664f));
            map.put("Etc/GMT+5", geographicPoint7);
            map.put("SystemV/EST5", geographicPoint7);
            map.put("SystemV/EST5EDT", geographicPoint7);
            map.put("US/East-Indiana", new GeographicPoint(36.8381f, -84.85f));
            map.put("US/Eastern", geographicPoint7);
            map.put("US/Michigan", new GeographicPoint(42.33139f, -83.04583f));
            map.put("America/Caracas", new GeographicPoint(10.5f, -66.916664f));
            map.put("America/Anguilla", new GeographicPoint(18.216667f, -63.05f));
            map.put("America/Antigua", new GeographicPoint(17.116667f, -61.85f));
            map.put("America/Aruba", new GeographicPoint(10.541111f, -72.9175f));
            map.put("America/Asuncion", new GeographicPoint(-25.266666f, -57.666668f));
            map.put("America/Barbados", new GeographicPoint(13.1f, -59.616665f));
            map.put("America/Blanc-Sablon", new GeographicPoint(51.433334f, -57.11667f));
            map.put("America/Boa_Vista", new GeographicPoint(2.8166666f, -60.666668f));
            map.put("America/Campo_Grande", new GeographicPoint(-20.45f, -54.616665f));
            map.put("America/Cuiaba", new GeographicPoint(-15.583333f, -56.083332f));
            map.put("America/Curacao", new GeographicPoint(12.1167f, -68.933f));
            map.put("America/Dominica", new GeographicPoint(15.3f, -61.4f));
            map.put("America/Eirunepe", new GeographicPoint(-6.6666665f, -69.86667f));
            map.put("America/Glace_Bay", new GeographicPoint(46.2f, -59.966667f));
            map.put("America/Goose_Bay", new GeographicPoint(53.333332f, -60.416668f));
            map.put("America/Grenada", new GeographicPoint(12.05f, -61.75f));
            map.put("America/Guadeloupe", new GeographicPoint(16.233334f, -61.516666f));
            map.put("America/Guyana", new GeographicPoint(6.8f, -58.166668f));
            map.put("America/Halifax", new GeographicPoint(44.65f, -63.6f));
            map.put("America/La_Paz", new GeographicPoint(-16.5f, -68.15f));
            map.put("America/Manaus", new GeographicPoint(-3.1133332f, -60.025276f));
            map.put("America/Marigot", new GeographicPoint(18.073f, 63.0844f));
            map.put("America/Martinique", new GeographicPoint(14.6f, -61.083332f));
            map.put("America/Moncton", new GeographicPoint(46.083332f, -64.76667f));
            map.put("America/Montserrat", new GeographicPoint(16.7f, -62.216667f));
            map.put("America/Port_of_Spain", new GeographicPoint(10.65f, -61.516666f));
            map.put("America/Porto_Acre", new GeographicPoint(-9.587778f, -67.53555f));
            map.put("America/Porto_Velho", new GeographicPoint(-8.766666f, -63.9f));
            map.put("America/Puerto_Rico", new GeographicPoint(18.467f, 66.117f));
            map.put("America/Rio_Branco", new GeographicPoint(-9.966667f, -67.8f));
            GeographicPoint geographicPoint8 = new GeographicPoint(-33.45f, -70.666664f);
            map.put("America/Santiago", geographicPoint8);
            map.put("America/Santo_Domingo", new GeographicPoint(18.466667f, -69.9f));
            map.put("America/St_Barthelemy", new GeographicPoint(17.8978f, -62.851f));
            map.put("America/St_Kitts", new GeographicPoint(17.3f, -62.733f));
            map.put("America/St_Lucia", new GeographicPoint(14.0167f, -60.9833f));
            map.put("America/St_Thomas", new GeographicPoint(18.3333f, -64.9167f));
            map.put("America/St_Vincent", new GeographicPoint(13.1667f, -61.2333f));
            map.put("America/Thule", new GeographicPoint(-54.27667f, -36.511665f));
            map.put("America/Tortola", new GeographicPoint(18.416666f, -64.61667f));
            map.put("America/Virgin", new GeographicPoint(18.34389f, -64.931114f));
            map.put("Antarctica/Palmer", new GeographicPoint(-64.25f, -62.833f));
            map.put("Atlantic/Bermuda", new GeographicPoint(32.294167f, -64.78389f));
            map.put("Atlantic/Stanley", new GeographicPoint(-51.7f, -57.85f));
            map.put("Brazil/Acre", new GeographicPoint(-10.883333f, -45.083332f));
            map.put("Brazil/West", new GeographicPoint(-10.883333f, -45.083332f));
            map.put("Canada/Atlantic", new GeographicPoint(44.65f, -63.6f));
            map.put("Chile/Continental", geographicPoint8);
            map.put("Etc/GMT+4", geographicPoint8);
            map.put("SystemV/AST4", new GeographicPoint(44.65f, -63.6f));
            map.put("SystemV/AST4ADT", new GeographicPoint(44.65f, -63.6f));
            map.put("America/St_Johns", new GeographicPoint(47.5675f, -52.7072f));
            map.put("Canada/Newfoundland", new GeographicPoint(47.5675f, -52.7072f));
            map.put("America/Araguaina", new GeographicPoint(-7.16f, -48.0575f));
            map.put("America/Bahia", new GeographicPoint(-12.983334f, -38.516666f));
            map.put("America/Belem", new GeographicPoint(-1.45f, -48.483334f));
            map.put("America/Buenos_Aires", new GeographicPoint(-34.5875f, -58.6725f));
            map.put("America/Catamarca", new GeographicPoint(-28.466667f, -65.78333f));
            map.put("America/Cayenne", new GeographicPoint(4.9333334f, -52.333332f));
            map.put("America/Cordoba", new GeographicPoint(-31.4f, -64.183334f));
            map.put("America/Fortaleza", new GeographicPoint(-3.7166667f, -38.5f));
            map.put("America/Godthab", new GeographicPoint(64.183334f, -51.75f));
            map.put("America/Jujuy", new GeographicPoint(-24.183332f, -65.3f));
            map.put("America/Maceio", new GeographicPoint(-9.666667f, -35.716667f));
            map.put("America/Mendoza", new GeographicPoint(-32.883335f, -68.816666f));
            map.put("America/Miquelon", new GeographicPoint(47.0975f, -56.38139f));
            map.put("America/Montevideo", new GeographicPoint(-34.858055f, -56.170834f));
            map.put("America/Paramaribo", new GeographicPoint(5.8333335f, -55.166668f));
            map.put("America/Recife", new GeographicPoint(-8.05f, -34.9f));
            map.put("America/Rosario", new GeographicPoint(-32.95111f, -60.66639f));
            map.put("America/Santarem", new GeographicPoint(-2.4333334f, -54.7f));
            GeographicPoint geographicPoint9 = new GeographicPoint(-23.533333f, -46.616665f);
            map.put("America/Sao_Paulo", geographicPoint9);
            map.put("Antarctica/Rothera", new GeographicPoint(67.567f, 68.133f));
            map.put("Brazil/East", geographicPoint9);
            map.put("Etc/GMT+3", geographicPoint9);
            map.put("America/Noronha", new GeographicPoint(3.85f, 25.417f));
            GeographicPoint geographicPoint10 = new GeographicPoint(54.25f, 36.75f);
            map.put("Atlantic/South_Georgia", geographicPoint10);
            map.put("Brazil/DeNoronha", new GeographicPoint(3.85f, 25.417f));
            map.put("Etc/GMT+2", geographicPoint10);
            map.put("America/Scoresbysund", new GeographicPoint(70.48333f, -21.966667f));
            GeographicPoint geographicPoint11 = new GeographicPoint(37.483334f, -2.5666666f);
            map.put("Atlantic/Azores", geographicPoint11);
            map.put("Atlantic/Cape_Verde", new GeographicPoint(14.916667f, -23.516666f));
            map.put("Etc/GMT+1", geographicPoint11);
            map.put("Africa/Abidjan", new GeographicPoint(5.341111f, -4.028056f));
            map.put("Africa/Accra", new GeographicPoint(5.55f, -0.2166667f));
            map.put("Africa/Bamako", new GeographicPoint(12.65f, -8.0f));
            map.put("Africa/Banjul", new GeographicPoint(13.453055f, -16.5775f));
            map.put("Africa/Bissau", new GeographicPoint(11.85f, -15.583333f));
            map.put("Africa/Casablanca", new GeographicPoint(33.593056f, -7.616389f));
            map.put("Africa/Conakry", new GeographicPoint(9.509167f, -13.712222f));
            map.put("Africa/Dakar", new GeographicPoint(14.670834f, -17.438055f));
            map.put("Africa/El_Aaiun", new GeographicPoint(27.15361f, -13.203333f));
            map.put("Africa/Freetown", new GeographicPoint(8.49f, -13.234167f));
            map.put("Africa/Lome", new GeographicPoint(6.131944f, 1.2227778f));
            map.put("Africa/Monrovia", new GeographicPoint(6.3105555f, -10.804722f));
            map.put("Africa/Nouakchott", new GeographicPoint(18.08639f, -15.975278f));
            map.put("Africa/Ouagadougou", new GeographicPoint(12.370277f, -1.5247222f));
            map.put("Africa/Sao_Tome", new GeographicPoint(0.3333333f, 6.733333f));
            map.put("Africa/Timbuktu", new GeographicPoint(16.766666f, -3.0166667f));
            map.put("America/Danmarkshavn", new GeographicPoint(76.767f, 18.667f));
            map.put("Atlantic/Canary", new GeographicPoint(28.45f, -16.233334f));
            map.put("Atlantic/Faeroe", new GeographicPoint(62.016666f, -6.766667f));
            map.put("Atlantic/Faroe", new GeographicPoint(62.016666f, -6.766667f));
            map.put("Atlantic/Madeira", new GeographicPoint(32.633335f, -16.9f));
            map.put("Atlantic/Reykjavik", new GeographicPoint(64.15f, -21.95f));
            map.put("Atlantic/St_Helena", new GeographicPoint(-15.933333f, -5.7166667f));
            GeographicPoint geographicPoint12 = new GeographicPoint(51.466667f, 0.0f);
            map.put("Etc/GMT", geographicPoint12);
            map.put("Etc/GMT+0", geographicPoint12);
            map.put("Etc/GMT-0", geographicPoint12);
            map.put("Etc/GMT0", geographicPoint12);
            map.put("Etc/Greenwich", geographicPoint12);
            map.put("Etc/UCT", geographicPoint12);
            map.put("Etc/UTC", geographicPoint12);
            map.put("Etc/Universal", geographicPoint12);
            map.put("Etc/Zulu", geographicPoint12);
            map.put("Europe/Belfast", new GeographicPoint(54.583332f, -5.933333f));
            map.put("Europe/Dublin", new GeographicPoint(53.333057f, -6.248889f));
            map.put("Europe/Guernsey", new GeographicPoint(49.45f, -2.533f));
            map.put("Europe/Isle_of_Man", new GeographicPoint(54.14521f, -4.48172f));
            map.put("Europe/Jersey", new GeographicPoint(49.2f, -2.117f));
            map.put("Europe/Lisbon", new GeographicPoint(38.716667f, -9.133333f));
            map.put("Europe/London", new GeographicPoint(51.5f, -0.116667f));
            map.put("Africa/Algiers", new GeographicPoint(36.763054f, 3.0505557f));
            map.put("Africa/Bangui", new GeographicPoint(4.366667f, 18.583334f));
            map.put("Africa/Brazzaville", new GeographicPoint(-4.2591667f, 15.284722f));
            map.put("Africa/Ceuta", new GeographicPoint(35.890278f, -5.3075f));
            map.put("Africa/Douala", new GeographicPoint(4.0502777f, 9.7f));
            map.put("Africa/Kinshasa", new GeographicPoint(-4.3f, 15.3f));
            map.put("Africa/Lagos", new GeographicPoint(6.4530554f, 3.3958333f));
            map.put("Africa/Libreville", new GeographicPoint(0.3833333f, 9.45f));
            map.put("Africa/Luanda", new GeographicPoint(-8.838333f, 13.234445f));
            map.put("Africa/Malabo", new GeographicPoint(3.75f, 8.783333f));
            map.put("Africa/Ndjamena", new GeographicPoint(12.113055f, 15.049167f));
            map.put("Africa/Niamey", new GeographicPoint(13.516666f, 2.1166668f));
            map.put("Africa/Porto-Novo", new GeographicPoint(6.483333f, 2.6166668f));
            map.put("Africa/Tunis", new GeographicPoint(36.802776f, 10.179722f));
            map.put("Africa/Windhoek", new GeographicPoint(-22.57f, 17.08361f));
            map.put("Arctic/Longyearbyen", new GeographicPoint(78.21667f, 15.633333f));
            map.put("Atlantic/Jan_Mayen", new GeographicPoint(71.0f, -8.333f));
            GeographicPoint geographicPoint13 = new GeographicPoint(48.86667f, 2.333333f);
            map.put("Etc/GMT-1", geographicPoint13);
            map.put("Europe/Amsterdam", new GeographicPoint(52.35f, 4.9166665f));
            map.put("Europe/Andorra", new GeographicPoint(42.5f, 1.5166667f));
            map.put("Europe/Belgrade", new GeographicPoint(44.81861f, 20.468056f));
            map.put("Europe/Berlin", new GeographicPoint(52.516666f, 13.4f));
            map.put("Europe/Bratislava", new GeographicPoint(48.15f, 17.116667f));
            map.put("Europe/Brussels", new GeographicPoint(50.833332f, 4.333333f));
            map.put("Europe/Budapest", new GeographicPoint(47.5f, 19.083334f));
            map.put("Europe/Copenhagen", new GeographicPoint(55.666668f, 12.583333f));
            map.put("Europe/Gibraltar", new GeographicPoint(36.133335f, -5.35f));
            map.put("Europe/Ljubljana", new GeographicPoint(46.05528f, 14.514444f));
            map.put("Europe/Luxembourg", new GeographicPoint(49.611668f, 6.13f));
            map.put("Europe/Madrid", new GeographicPoint(40.4f, -3.6833334f));
            map.put("Europe/Malta", new GeographicPoint(35.899723f, 14.514722f));
            map.put("Europe/Monaco", new GeographicPoint(43.733334f, 7.4166665f));
            map.put("Europe/Oslo", new GeographicPoint(59.916668f, 10.75f));
            map.put("Europe/Paris", geographicPoint13);
            map.put("Europe/Podgorica", new GeographicPoint(42.441113f, 19.26361f));
            map.put("Europe/Prague", new GeographicPoint(50.083332f, 14.466667f));
            map.put("Europe/Rome", new GeographicPoint(41.9f, 12.483334f));
            map.put("Europe/San_Marino", new GeographicPoint(43.933334f, 12.45f));
            map.put("Europe/Sarajevo", new GeographicPoint(43.85f, 18.383333f));
            map.put("Europe/Skopje", new GeographicPoint(42.0f, 21.433332f));
            map.put("Europe/Stockholm", new GeographicPoint(59.333332f, 18.05f));
            map.put("Europe/Tirane", new GeographicPoint(41.3275f, 19.81889f));
            map.put("Europe/Vaduz", new GeographicPoint(47.133335f, 9.516666f));
            map.put("Europe/Vatican", new GeographicPoint(41.9f, 12.45f));
            map.put("Europe/Vienna", new GeographicPoint(48.2f, 16.366667f));
            map.put("Europe/Warsaw", new GeographicPoint(52.25f, 21.0f));
            map.put("Europe/Zagreb", new GeographicPoint(45.8f, 16.0f));
            map.put("Europe/Zurich", new GeographicPoint(47.366665f, 8.55f));
            map.put("Africa/Blantyre", new GeographicPoint(-15.783333f, 35.0f));
            map.put("Africa/Bujumbura", new GeographicPoint(-3.376111f, 29.36f));
            map.put("Africa/Cairo", new GeographicPoint(30.05f, 31.25f));
            map.put("Africa/Gaborone", new GeographicPoint(-24.646389f, 25.911945f));
            map.put("Africa/Harare", new GeographicPoint(-17.817778f, 31.044722f));
            map.put("Africa/Johannesburg", new GeographicPoint(-26.2f, 28.083334f));
            map.put("Africa/Kigali", new GeographicPoint(-1.9536111f, 30.060556f));
            map.put("Africa/Lubumbashi", new GeographicPoint(-11.666667f, 27.466667f));
            map.put("Africa/Lusaka", new GeographicPoint(-15.416667f, 28.283333f));
            map.put("Africa/Maputo", new GeographicPoint(-25.965279f, 32.58917f));
            map.put("Africa/Maseru", new GeographicPoint(-29.316668f, 27.483334f));
            map.put("Africa/Mbabane", new GeographicPoint(-26.316668f, 31.133333f));
            map.put("Africa/Tripoli", new GeographicPoint(32.8925f, 13.18f));
            map.put("Asia/Amman", new GeographicPoint(31.95f, 35.933334f));
            map.put("Asia/Beirut", new GeographicPoint(33.871944f, 35.509724f));
            map.put("Asia/Damascus", new GeographicPoint(33.5f, 36.3f));
            map.put("Asia/Gaza", new GeographicPoint(31.5f, 34.466667f));
            map.put("Asia/Istanbul", new GeographicPoint(41.018612f, 28.964722f));
            map.put("Asia/Jerusalem", new GeographicPoint(31.78f, 35.23f));
            map.put("Asia/Nicosia", new GeographicPoint(35.166668f, 33.366665f));
            map.put("Asia/Tel_Aviv", new GeographicPoint(32.066666f, 34.766666f));
            GeographicPoint geographicPoint14 = new GeographicPoint(37.983334f, 23.733334f);
            map.put("Etc/GMT-2", geographicPoint14);
            map.put("Europe/Athens", new GeographicPoint(37.983334f, 23.733334f));
            map.put("Europe/Bucharest", new GeographicPoint(44.433334f, 26.1f));
            map.put("Europe/Chisinau", new GeographicPoint(47.005554f, 28.8575f));
            map.put("Europe/Helsinki", new GeographicPoint(60.175556f, 24.934166f));
            map.put("Europe/Istanbul", new GeographicPoint(41.018612f, 28.964722f));
            map.put("Europe/Kaliningrad", new GeographicPoint(54.71f, 20.5f));
            map.put("Europe/Kiev", new GeographicPoint(50.433334f, 30.516666f));
            map.put("Europe/Mariehamn", new GeographicPoint(60.1f, 19.95f));
            map.put("Europe/Minsk", new GeographicPoint(53.9f, 27.566668f));
            map.put("Europe/Nicosia", new GeographicPoint(35.166668f, 33.366665f));
            map.put("Europe/Riga", new GeographicPoint(56.95f, 24.1f));
            map.put("Europe/Simferopol", new GeographicPoint(44.95f, 34.1f));
            map.put("Europe/Sofia", new GeographicPoint(42.683334f, 23.316668f));
            map.put("Europe/Tallinn", new GeographicPoint(59.433887f, 24.728056f));
            map.put("Europe/Tiraspol", new GeographicPoint(46.84028f, 29.643333f));
            map.put("Europe/Uzhgorod", new GeographicPoint(48.616665f, 22.3f));
            map.put("Europe/Vilnius", new GeographicPoint(54.683334f, 25.316668f));
            map.put("Europe/Zaporozhye", new GeographicPoint(47.833f, 35.1667f));
            map.put("Africa/Addis_Ababa", new GeographicPoint(9.033333f, 38.7f));
            map.put("Africa/Asmara", new GeographicPoint(15.333333f, 38.933334f));
            map.put("Africa/Asmera", new GeographicPoint(15.333333f, 38.933334f));
            map.put("Africa/Dar_es_Salaam", new GeographicPoint(-6.8f, 39.283333f));
            map.put("Africa/Djibouti", new GeographicPoint(11.595f, 43.148056f));
            map.put("Africa/Kampala", new GeographicPoint(0.3155556f, 32.565556f));
            map.put("Africa/Khartoum", new GeographicPoint(15.588056f, 32.53417f));
            map.put("Africa/Mogadishu", new GeographicPoint(2.0666666f, 45.366665f));
            map.put("Africa/Nairobi", new GeographicPoint(-1.2833333f, 36.816666f));
            map.put("Antarctica/Syowa", new GeographicPoint(-69.0f, 39.5833f));
            map.put("Asia/Aden", new GeographicPoint(12.779445f, 45.036667f));
            map.put("Asia/Baghdad", new GeographicPoint(33.33861f, 44.39389f));
            map.put("Asia/Bahrain", new GeographicPoint(26.23611f, 50.583057f));
            map.put("Asia/Kuwait", new GeographicPoint(29.369722f, 47.978333f));
            map.put("Asia/Qatar", new GeographicPoint(25.286667f, 51.533333f));
            map.put("Asia/Riyadh", new GeographicPoint(24.640833f, 46.772778f));
            GeographicPoint geographicPoint15 = new GeographicPoint(55.752224f, 37.615555f);
            map.put("Etc/GMT-3", geographicPoint15);
            map.put("Europe/Moscow", geographicPoint15);
            map.put("Europe/Volgograd", new GeographicPoint(48.80472f, 44.585835f));
            map.put("Indian/Antananarivo", new GeographicPoint(-18.916666f, 47.516666f));
            map.put("Indian/Comoro", new GeographicPoint(-11.704166f, 43.240276f));
            map.put("Indian/Mayotte", new GeographicPoint(-12.779445f, 45.227222f));
            map.put("Asia/Riyadh87", new GeographicPoint(24.640833f, 46.772778f));
            map.put("Asia/Riyadh88", new GeographicPoint(24.640833f, 46.772778f));
            map.put("Asia/Riyadh89", new GeographicPoint(24.640833f, 46.772778f));
            map.put("Mideast/Riyadh87", new GeographicPoint(24.640833f, 46.772778f));
            map.put("Mideast/Riyadh88", new GeographicPoint(24.640833f, 46.772778f));
            map.put("Mideast/Riyadh89", new GeographicPoint(24.640833f, 46.772778f));
            map.put("Asia/Tehran", new GeographicPoint(35.671944f, 51.424446f));
            map.put("Asia/Baku", new GeographicPoint(40.39528f, 49.88222f));
            GeographicPoint geographicPoint16 = new GeographicPoint(25.252222f, 55.28f);
            map.put("Asia/Dubai", geographicPoint16);
            map.put("Asia/Muscat", new GeographicPoint(23.613333f, 58.593334f));
            map.put("Asia/Tbilisi", new GeographicPoint(41.725f, 44.790833f));
            map.put("Asia/Yerevan", new GeographicPoint(40.18111f, 44.51361f));
            map.put("Etc/GMT-4", geographicPoint16);
            map.put("Europe/Samara", new GeographicPoint(53.2f, 50.15f));
            map.put("Indian/Mahe", new GeographicPoint(-4.616667f, 55.45f));
            map.put("Indian/Mauritius", new GeographicPoint(-20.161945f, 57.49889f));
            map.put("Indian/Reunion", new GeographicPoint(-20.866667f, 55.466667f));
            map.put("Asia/Kabul", new GeographicPoint(34.516666f, 69.183334f));
            map.put("Antarctica/Davis", new GeographicPoint(-68.5764f, 77.9689f));
            map.put("Antarctica/Mawson", new GeographicPoint(-53.104f, 73.514f));
            map.put("Asia/Aqtau", new GeographicPoint(43.65f, 51.2f));
            map.put("Asia/Aqtobe", new GeographicPoint(50.298054f, 57.18139f));
            map.put("Asia/Ashgabat", new GeographicPoint(37.95f, 58.383335f));
            map.put("Asia/Ashkhabad", new GeographicPoint(37.95f, 58.383335f));
            map.put("Asia/Dushanbe", new GeographicPoint(38.56f, 68.77389f));
            map.put("Asia/Karachi", new GeographicPoint(24.866667f, 67.05f));
            map.put("Asia/Oral", new GeographicPoint(51.233334f, 51.366665f));
            map.put("Asia/Samarkand", new GeographicPoint(39.654167f, 66.959724f));
            map.put("Asia/Tashkent", new GeographicPoint(41.316666f, 69.25f));
            map.put("Asia/Yekaterinburg", new GeographicPoint(56.85f, 60.6f));
            GeographicPoint geographicPoint17 = new GeographicPoint(22.569721f, 88.36972f);
            map.put("Etc/GMT-5", geographicPoint17);
            map.put("Indian/Kerguelen", new GeographicPoint(-49.25f, 69.583f));
            map.put("Indian/Maldives", new GeographicPoint(4.1666665f, 73.5f));
            map.put("Asia/Calcutta", geographicPoint17);
            map.put("Asia/Colombo", new GeographicPoint(6.9319444f, 79.84778f));
            map.put("Asia/Kolkata", geographicPoint17);
            map.put("Asia/Kathmandu", new GeographicPoint(27.716667f, 85.316666f));
            map.put("Asia/Katmandu", new GeographicPoint(27.716667f, 85.316666f));
            map.put("Antarctica/Vostok", new GeographicPoint(-78.4644f, 106.8372f));
            map.put("Asia/Almaty", new GeographicPoint(43.25f, 76.95f));
            map.put("Asia/Bishkek", new GeographicPoint(42.873055f, 74.60028f));
            GeographicPoint geographicPoint18 = new GeographicPoint(23.723055f, 90.40861f);
            map.put("Asia/Dacca", geographicPoint18);
            map.put("Asia/Dhaka", geographicPoint18);
            map.put("Asia/Novokuznetsk", new GeographicPoint(53.75f, 87.1f));
            map.put("Asia/Novosibirsk", new GeographicPoint(55.04111f, 82.93444f));
            map.put("Asia/Omsk", new GeographicPoint(55.0f, 73.4f));
            map.put("Asia/Qyzylorda", new GeographicPoint(44.85278f, 65.50916f));
            map.put("Asia/Thimbu", new GeographicPoint(27.483334f, 89.6f));
            map.put("Asia/Thimphu", new GeographicPoint(27.483334f, 89.6f));
            map.put("Etc/GMT-6", geographicPoint18);
            map.put("Indian/Chagos", new GeographicPoint(-6.0f, 71.5f));
            map.put("Asia/Rangoon", new GeographicPoint(16.783333f, 96.166664f));
            map.put("Indian/Cocos", new GeographicPoint(-12.1167f, 96.9f));
            GeographicPoint geographicPoint19 = new GeographicPoint(13.75f, 100.51667f);
            map.put("Asia/Bangkok", geographicPoint19);
            map.put("Asia/Ho_Chi_Minh", new GeographicPoint(10.75f, 106.666664f));
            map.put("Asia/Hovd", new GeographicPoint(48.016666f, 91.63333f));
            map.put("Asia/Jakarta", new GeographicPoint(-6.174444f, 106.829445f));
            map.put("Asia/Krasnoyarsk", new GeographicPoint(56.009724f, 92.791664f));
            map.put("Asia/Phnom_Penh", new GeographicPoint(11.55f, 104.916664f));
            map.put("Asia/Pontianak", new GeographicPoint(-0.0333333f, 109.333336f));
            map.put("Asia/Saigon", new GeographicPoint(10.75f, 106.666664f));
            map.put("Asia/Vientiane", new GeographicPoint(17.966667f, 102.6f));
            map.put("Etc/GMT-7", geographicPoint19);
            map.put("Indian/Christmas", new GeographicPoint(-10.416667f, 105.71667f));
            map.put("Asia/Brunei", new GeographicPoint(4.883333f, 114.933334f));
            map.put("Asia/Choibalsan", new GeographicPoint(48.066666f, 114.5f));
            map.put("Asia/Chongqing", new GeographicPoint(29.562778f, 106.55278f));
            map.put("Asia/Chungking", new GeographicPoint(29.562778f, 106.55278f));
            map.put("Asia/Harbin", new GeographicPoint(45.75f, 126.65f));
            map.put("Asia/Hong_Kong", new GeographicPoint(22.283333f, 114.15f));
            map.put("Asia/Irkutsk", new GeographicPoint(52.266666f, 104.333336f));
            map.put("Asia/Kashgar", new GeographicPoint(39.391388f, 76.04f));
            map.put("Asia/Kuala_Lumpur", new GeographicPoint(3.1666667f, 101.7f));
            map.put("Asia/Kuching", new GeographicPoint(1.55f, 110.333336f));
            map.put("Asia/Macao", new GeographicPoint(22.2f, 113.55f));
            map.put("Asia/Macau", new GeographicPoint(22.2f, 113.55f));
            map.put("Asia/Makassar", new GeographicPoint(2.45f, 99.78333f));
            map.put("Asia/Manila", new GeographicPoint(14.604167f, 120.98222f));
            GeographicPoint geographicPoint20 = new GeographicPoint(31.005f, 121.40861f);
            map.put("Asia/Shanghai", geographicPoint20);
            map.put("Asia/Singapore", new GeographicPoint(1.2930557f, 103.855835f));
            map.put("Asia/Taipei", new GeographicPoint(25.039167f, 121.525f));
            map.put("Asia/Ujung_Pandang", new GeographicPoint(-5.1305556f, 119.406944f));
            map.put("Asia/Ulaanbaatar", new GeographicPoint(47.916668f, 106.916664f));
            map.put("Asia/Ulan_Bator", new GeographicPoint(47.916668f, 106.916664f));
            map.put("Asia/Urumqi", new GeographicPoint(43.8f, 87.583336f));
            map.put("Australia/Perth", new GeographicPoint(-31.933332f, 115.833336f));
            map.put("Australia/West", new GeographicPoint(-31.933332f, 115.833336f));
            map.put("Etc/GMT-8", geographicPoint20);
            map.put("Australia/Eucla", new GeographicPoint(-31.716667f, 128.86667f));
            map.put("Asia/Dili", new GeographicPoint(-8.55f, 125.5833f));
            map.put("Asia/Jayapura", new GeographicPoint(-2.5333333f, 140.7f));
            map.put("Asia/Pyongyang", new GeographicPoint(39.019444f, 125.75472f));
            map.put("Asia/Seoul", new GeographicPoint(37.566387f, 126.999725f));
            GeographicPoint geographicPoint21 = new GeographicPoint(35.685f, 139.75139f);
            map.put("Asia/Tokyo", geographicPoint21);
            map.put("Asia/Yakutsk", new GeographicPoint(62.03389f, 129.73306f));
            map.put("Etc/GMT-9", geographicPoint21);
            map.put("Pacific/Palau", new GeographicPoint(7.5f, 134.6241f));
            map.put("Australia/Adelaide", new GeographicPoint(-34.933334f, 138.6f));
            map.put("Australia/Broken_Hill", new GeographicPoint(-31.95f, 141.43333f));
            map.put("Australia/Darwin", new GeographicPoint(-12.466667f, 130.83333f));
            map.put("Australia/North", new GeographicPoint(-12.466667f, 130.83333f));
            map.put("Australia/South", new GeographicPoint(-34.933334f, 138.6f));
            map.put("Australia/Yancowinna", new GeographicPoint(-31.7581f, 141.7178f));
            map.put("Antarctica/DumontDUrville", new GeographicPoint(-66.66277f, 140.0014f));
            map.put("Asia/Sakhalin", new GeographicPoint(51.0f, 143.0f));
            map.put("Asia/Vladivostok", new GeographicPoint(43.133335f, 131.9f));
            map.put("Australia/ACT", new GeographicPoint(-35.283333f, 149.21666f));
            map.put("Australia/Brisbane", new GeographicPoint(-27.5f, 153.01666f));
            map.put("Australia/Canberra", new GeographicPoint(-35.283333f, 149.21666f));
            map.put("Australia/Currie", new GeographicPoint(-39.933334f, 143.86667f));
            map.put("Australia/Hobart", new GeographicPoint(-42.916668f, 147.33333f));
            map.put("Australia/Lindeman", new GeographicPoint(-20.45f, 149.0333f));
            map.put("Australia/Melbourne", new GeographicPoint(-37.816666f, 144.96666f));
            GeographicPoint geographicPoint22 = new GeographicPoint(-33.88333f, 151.21666f);
            map.put("Australia/NSW", geographicPoint22);
            map.put("Australia/Queensland", new GeographicPoint(-27.5f, 153.01666f));
            map.put("Australia/Sydney", geographicPoint22);
            map.put("Australia/Tasmania", new GeographicPoint(-42.916668f, 147.33333f));
            map.put("Australia/Victoria", new GeographicPoint(-37.816666f, 144.96666f));
            map.put("Etc/GMT-10", geographicPoint22);
            map.put("Pacific/Guam", new GeographicPoint(13.467f, 144.75f));
            map.put("Pacific/Port_Moresby", new GeographicPoint(-9.464723f, 147.1925f));
            map.put("Pacific/Saipan", new GeographicPoint(15.1833f, 145.75f));
            map.put("Pacific/Truk", new GeographicPoint(7.4167f, 151.7833f));
            map.put("Pacific/Yap", new GeographicPoint(9.514444f, 138.12917f));
            map.put("Australia/LHI", new GeographicPoint(-31.55f, 159.083f));
            map.put("Australia/Lord_Howe", new GeographicPoint(-31.55f, 159.083f));
            map.put("Antarctica/Casey", new GeographicPoint(-66.2833f, 110.5333f));
            map.put("Asia/Magadan", new GeographicPoint(59.566666f, 150.8f));
            GeographicPoint geographicPoint23 = new GeographicPoint(-22.266666f, 166.45f);
            map.put("Etc/GMT-11", geographicPoint23);
            map.put("Pacific/Efate", new GeographicPoint(-17.667f, 168.417f));
            map.put("Pacific/Guadalcanal", new GeographicPoint(-9.617f, 160.183f));
            map.put("Pacific/Kosrae", new GeographicPoint(5.317f, 162.983f));
            map.put("Pacific/Noumea", geographicPoint23);
            map.put("Pacific/Ponape", new GeographicPoint(6.963889f, 158.20833f));
            map.put("Pacific/Norfolk", new GeographicPoint(-29.05f, 167.95f));
            map.put("Antarctica/McMurdo", new GeographicPoint(-77.85f, 166.667f));
            map.put("Antarctica/South_Pole", new GeographicPoint(-90.0f, 0.0f));
            map.put("Asia/Anadyr", new GeographicPoint(64.75f, 177.48334f));
            map.put("Asia/Kamchatka", new GeographicPoint(57.0f, 160.0f));
            GeographicPoint geographicPoint24 = new GeographicPoint(-36.86667f, 174.76666f);
            map.put("Etc/GMT-12", geographicPoint24);
            map.put("Pacific/Auckland", geographicPoint24);
            map.put("Pacific/Fiji", new GeographicPoint(-18.133333f, 178.41667f));
            map.put("Pacific/Funafuti", new GeographicPoint(-8.516666f, 179.21666f));
            map.put("Pacific/Kwajalein", new GeographicPoint(9.1939f, 167.4597f));
            map.put("Pacific/Majuro", new GeographicPoint(7.1f, 171.38333f));
            map.put("Pacific/Nauru", new GeographicPoint(-0.5322f, 166.9328f));
            map.put("Pacific/Tarawa", new GeographicPoint(1.4167f, 173.0333f));
            map.put("Pacific/Wake", new GeographicPoint(19.2833f, 166.6f));
            map.put("Pacific/Wallis", new GeographicPoint(-13.273f, -176.205f));
            map.put("Pacific/Chatham", new GeographicPoint(-43.883f, -176.517f));
            GeographicPoint geographicPoint25 = new GeographicPoint(-3.133f, -171.0833f);
            map.put("Etc/GMT-13", geographicPoint25);
            map.put("Pacific/Enderbury", geographicPoint25);
            map.put("Pacific/Tongatapu", new GeographicPoint(-21.2114f, -175.153f));
            GeographicPoint geographicPoint26 = new GeographicPoint(1.883f, -157.4f);
            map.put("Etc/GMT-14", geographicPoint26);
            map.put("Pacific/Kiritimati", geographicPoint26);
            map.put("MIT", geographicPoint);
            map.put("HST", geographicPoint2);
            map.put("PST", geographicPoint4);
            map.put("PST8PDT", geographicPoint4);
            map.put("MST", geographicPoint5);
            map.put("MST7MDT", geographicPoint5);
            map.put("Navajo", new GeographicPoint(35.6728f, -109.0622f));
            map.put("PNT", new GeographicPoint(33.448334f, -112.07333f));
            map.put("America/Indiana/Knox", new GeographicPoint(41.295834f, -86.625f));
            map.put("America/Indiana/Tell_City", new GeographicPoint(37.953f, -86.7614f));
            map.put("America/North_Dakota/Center", new GeographicPoint(47.115f, -101.3003f));
            map.put("America/North_Dakota/New_Salem", new GeographicPoint(46.843f, 101.4119f));
            map.put("CST", geographicPoint6);
            map.put("CST6CDT", geographicPoint6);
            map.put("America/Indiana/Indianapolis", new GeographicPoint(39.768333f, -86.15806f));
            map.put("America/Indiana/Marengo", new GeographicPoint(36.3706f, -86.3433f));
            map.put("America/Indiana/Petersburg", new GeographicPoint(38.4917f, -87.2803f));
            map.put("America/Indiana/Vevay", new GeographicPoint(38.7458f, -85.0711f));
            map.put("America/Indiana/Vincennes", new GeographicPoint(38.6783f, -87.5164f));
            map.put("America/Indiana/Winamac", new GeographicPoint(41.0525f, -86.6044f));
            map.put("America/Kentucky/Louisville", new GeographicPoint(38.2542f, -85.7603f));
            map.put("America/Kentucky/Monticello", new GeographicPoint(36.8381f, -84.85f));
            map.put("Cuba", new GeographicPoint(23.131945f, -82.36417f));
            map.put("EST", geographicPoint7);
            map.put("EST5EDT", geographicPoint7);
            map.put("IET", geographicPoint7);
            map.put("AST", new GeographicPoint(44.65f, -63.6f));
            map.put("Jamaica", new GeographicPoint(18.0f, -76.8f));
            map.put("America/Argentina/San_Luis", new GeographicPoint(-33.3f, -66.333f));
            map.put("PRT", new GeographicPoint(18.467f, 66.117f));
            map.put("CNT", new GeographicPoint(47.5675f, -52.7072f));
            map.put("AGT", new GeographicPoint(-34.5875f, -58.6725f));
            map.put("America/Argentina/Buenos_Aires", new GeographicPoint(-34.5875f, -58.6725f));
            map.put("America/Argentina/Catamarca", new GeographicPoint(-28.466667f, -65.78333f));
            map.put("America/Argentina/ComodRivadavia", new GeographicPoint(-42.7578f, -65.0297f));
            map.put("America/Argentina/Cordoba", new GeographicPoint(-31.4f, -64.183334f));
            map.put("America/Argentina/Jujuy", new GeographicPoint(-24.183332f, -65.3f));
            map.put("America/Argentina/La_Rioja", new GeographicPoint(-29.4144f, -66.8552f));
            map.put("America/Argentina/Mendoza", new GeographicPoint(-32.883335f, -68.816666f));
            map.put("America/Argentina/Rio_Gallegos", new GeographicPoint(-51.625f, -69.2286f));
            map.put("America/Argentina/Salta", new GeographicPoint(-24.783333f, -65.416664f));
            map.put("America/Argentina/San_Juan", new GeographicPoint(-31.5333f, -68.5167f));
            map.put("America/Argentina/Tucuman", new GeographicPoint(-26.8167f, 65.2167f));
            map.put("America/Argentina/Ushuaia", new GeographicPoint(-54.6f, -68.3f));
            map.put("BET", geographicPoint9);
            map.put("Eire", new GeographicPoint(53.333057f, -6.248889f));
            map.put("GB", geographicPoint12);
            map.put("GB-Eire", new GeographicPoint(53.333057f, -6.248889f));
            map.put("GMT", geographicPoint12);
            map.put("GMT0", geographicPoint12);
            map.put("Greenwich", geographicPoint12);
            map.put("Iceland", new GeographicPoint(64.1333f, -21.9333f));
            map.put("Portugal", new GeographicPoint(38.716667f, -9.133333f));
            map.put("UCT", geographicPoint12);
            map.put("UTC", geographicPoint12);
            map.put("Universal", geographicPoint12);
            map.put("WET", geographicPoint12);
            map.put("Zulu", geographicPoint12);
            map.put("CET", geographicPoint13);
            map.put("ECT", geographicPoint13);
            map.put("MET", new GeographicPoint(35.671944f, 51.424446f));
            map.put("Poland", new GeographicPoint(52.25f, 21.0f));
            map.put("ART", new GeographicPoint(-34.5875f, -58.6725f));
            map.put("CAT", new GeographicPoint(-1.9536111f, 30.060556f));
            map.put("EET", new GeographicPoint(37.983334f, 23.733334f));
            map.put("Egypt", new GeographicPoint(30.05f, 31.25f));
            map.put("Israel", new GeographicPoint(32.066666f, 34.766666f));
            map.put("Libya", new GeographicPoint(32.8925f, 13.18f));
            map.put("Turkey", new GeographicPoint(41.018612f, 28.964722f));
            map.put("EAT", new GeographicPoint(-1.2833333f, 36.816666f));
            map.put("W-SU", geographicPoint15);
            map.put("Iran", new GeographicPoint(35.671944f, 51.424446f));
            map.put("NET", new GeographicPoint(40.18111f, 44.51361f));
            map.put("PLT", new GeographicPoint(24.866667f, 67.05f));
            map.put("IST", geographicPoint17);
            map.put("BST", geographicPoint18);
            map.put("VST", geographicPoint19);
            map.put("CTT", geographicPoint20);
            map.put("Hongkong", new GeographicPoint(22.283333f, 114.15f));
            map.put("PRC", geographicPoint20);
            map.put("Singapore", new GeographicPoint(1.2930557f, 103.855835f));
            map.put("JST", geographicPoint21);
            map.put("Japan", geographicPoint21);
            map.put("ROK", new GeographicPoint(37.566387f, 126.999725f));
            map.put("ACT", new GeographicPoint(-35.283333f, 149.21666f));
            map.put("AET", geographicPoint22);
            map.put("SST", new GeographicPoint(-28.4667f, 159.8167f));
            map.put("Kwajalein", new GeographicPoint(9.1939f, 167.4597f));
            map.put("NST", geographicPoint24);
            map.put("NZ", geographicPoint24);
            map.put("NZ-CHAT", new GeographicPoint(-43.883f, -176.517f));
            timeZoneGeographicPointsReference = new WeakReference(map);
        } else {
            map = (Map)timeZoneGeographicPointsReference.get();
        }
        geographicPoint = (GeographicPoint)map.get(TimeZone.getDefault().getID());
        if (geographicPoint == null) {
            geographicPoint = (GeographicPoint)map.get("Etc/GMT");
        }
        this.latitude = (float)Math.toRadians(geographicPoint.getLatitudeInDegrees());
        this.longitude = (float)Math.toRadians(geographicPoint.getLongitudeInDegrees());
    }

    private static class GeographicPoint {
        private final float latitudeInDegrees;
        private final float longitudeInDegrees;

        public GeographicPoint(float f, float f2) {
            this.latitudeInDegrees = f;
            this.longitudeInDegrees = f2;
        }

        public float getLatitudeInDegrees() {
            return this.latitudeInDegrees;
        }

        public float getLongitudeInDegrees() {
            return this.longitudeInDegrees;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        X,
        Y,
        DIAMETER,
        VISIBLE,
        NORTH_DIRECTION,
        LATITUDE,
        LONGITUDE,
        TIME_ZONE;

    }
}

