/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.main;

import java.awt.GraphicsDevice;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import net.sourceforge.glsof.common.about.AboutDialog;
import net.sourceforge.glsof.common.i18n.Messages;

public abstract class AbstractMainWindow
extends JFrame {
    public static final String ABOUT_LOGO = "/icons/glsof-banner-fm.png";
    protected static final String MENU_VIEW_REFRESH = "/icons/view-refresh.png";
    private static final String MENU_EXIT = "/icons/gtk-close.png";
    protected JMenuBar _menuBar;
    private Rectangle _bounds;
    private GraphicsDevice _device;
    private boolean _fullscreen = false;

    protected abstract void initRepositories();

    protected abstract void createContents(JPanel var1);

    protected abstract void close();

    protected abstract String version();

    protected abstract void createMenuItems();

    protected AbstractMainWindow(GraphicsDevice device, String caption) {
        super(device.getDefaultConfiguration());
        this.initRepositories();
        ToolTipManager.sharedInstance().setDismissDelay(10000000);
        this._device = device;
        this.setTitle(caption);
        JPanel panel = new JPanel();
        this.getContentPane().add(panel);
        panel.setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractMainWindow.this.close();
            }
        });
        this._menuBar = new JMenuBar();
        this._menuBar.setOpaque(false);
        this.createMenuItems();
        this.createContents(panel);
        this.setLocation(this._bounds.x, this._bounds.y);
        this.setSize(this._bounds.width, this._bounds.height);
        this.setVisible(true);
    }

    protected JMenu createMenu(ImageIcon icon, String text) {
        JMenu menu = new JMenu();
        menu.setIcon(icon);
        menu.setToolTipText(text);
        this._menuBar.add(menu);
        return menu;
    }

    protected JMenuItem createMenuItem(JMenu menu, String name, String text, KeyStroke acc, String imagePath) {
        JMenuItem item = new JMenuItem();
        item.setName(name);
        menu.add(item);
        item.setText(text);
        if (acc != null) {
            item.setAccelerator(acc);
        }
        if (imagePath != null && !imagePath.equals("")) {
            ImageIcon image = new ImageIcon(imagePath);
            item.setIcon(image);
        }
        return item;
    }

    protected void destroyWindow() {
        this.close();
        this.dispose();
    }

    protected File createSettingsDir(String path) {
        String userHome = System.getProperty("user.home");
        File dir = new File(userHome, path);
        if (!dir.exists() || dir.isFile()) {
            dir.mkdir();
        }
        return dir;
    }

    protected void createExitItem(JMenu menu) {
        this.createMenuItem(menu, "exit", Messages.NLS("Exit_CtrlQ"), KeyStroke.getKeyStroke(81, 2), MENU_EXIT).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AbstractMainWindow.this.destroyWindow();
            }
        });
    }

    protected void createAboutItem(JMenu menu, final String logoPath, final String caption, final String version, final String websiteUrl, final String documentationUrl) {
        this.createMenuItem(menu, "about", Messages.NLS("About"), null, MENU_VIEW_REFRESH).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AboutDialog dialog = new AboutDialog(logoPath, caption, version, websiteUrl, documentationUrl);
                dialog.create();
                dialog.setVisible(true);
            }
        });
    }

    protected void createFullscreenItem(JMenu menu) {
        this.createMenuItem(menu, "fullscreen", Messages.NLS("Fullscreen_F11"), KeyStroke.getKeyStroke("F11"), "").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AbstractMainWindow.this._fullscreen = !AbstractMainWindow.this._fullscreen;
                AbstractMainWindow.this.switchFullscreenMode();
            }
        });
    }

    private void switchFullscreenMode() {
        boolean isFullScreen = this._device.isFullScreenSupported() && this._fullscreen;
        this.dispose();
        this.setUndecorated(isFullScreen);
        this.setResizable(!isFullScreen);
        if (isFullScreen) {
            this._bounds = this.getBounds();
            this._device.setFullScreenWindow(this);
            this.validate();
        } else {
            this.pack();
            this.setLocation(this._bounds.x, this._bounds.y);
            this.setSize(this._bounds.width, this._bounds.height);
            this.setVisible(true);
        }
    }

    protected void setWindowBounds(Rectangle bounds) {
        this._bounds = bounds;
    }
}

