/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import java.security.ProtectionDomain;

class NoCallStackClassLoader
extends ClassLoader {
    private final String[] classNames;
    private final byte[][] byteCodes;
    private final String[] referencedClassNames;
    private final ClassLoader referencedClassLoader;
    private final ProtectionDomain protectionDomain;

    public NoCallStackClassLoader(String className, byte[] byteCode, String[] referencedClassNames, ClassLoader referencedClassLoader, ProtectionDomain protectionDomain) {
        this(new String[]{className}, new byte[][]{byteCode}, referencedClassNames, referencedClassLoader, protectionDomain);
    }

    public NoCallStackClassLoader(String[] classNames, byte[][] byteCodes, String[] referencedClassNames, ClassLoader referencedClassLoader, ProtectionDomain protectionDomain) {
        super(null);
        int i;
        if (classNames == null || classNames.length == 0 || byteCodes == null || classNames.length != byteCodes.length || referencedClassNames == null || protectionDomain == null) {
            throw new IllegalArgumentException();
        }
        for (i = 0; i < classNames.length; ++i) {
            if (classNames[i] != null && byteCodes[i] != null) continue;
            throw new IllegalArgumentException();
        }
        for (i = 0; i < referencedClassNames.length; ++i) {
            if (referencedClassNames[i] != null) continue;
            throw new IllegalArgumentException();
        }
        this.classNames = classNames;
        this.byteCodes = byteCodes;
        this.referencedClassNames = referencedClassNames;
        this.referencedClassLoader = referencedClassLoader;
        this.protectionDomain = protectionDomain;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        int i;
        for (i = 0; i < this.classNames.length; ++i) {
            if (!name.equals(this.classNames[i])) continue;
            return this.defineClass(this.classNames[i], this.byteCodes[i], 0, this.byteCodes[i].length, this.protectionDomain);
        }
        if (this.referencedClassLoader != null) {
            for (i = 0; i < this.referencedClassNames.length; ++i) {
                if (!name.equals(this.referencedClassNames[i])) continue;
                return this.referencedClassLoader.loadClass(name);
            }
        }
        throw new ClassNotFoundException(name);
    }

    public static byte[] stringToBytes(String s) {
        int slen = s.length();
        byte[] bytes = new byte[slen];
        for (int i = 0; i < slen; ++i) {
            bytes[i] = (byte)s.charAt(i);
        }
        return bytes;
    }
}

