/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.export;

import java.io.IOException;
import java.io.Writer;
import javax.swing.table.TableModel;
import org.netbeans.modules.profiler.snaptracer.TracerProgressObject;
import org.netbeans.modules.profiler.snaptracer.impl.export.Exporter;

final class CSVExporter
extends Exporter {
    private static final String DELIMITER = ",";
    private float step = 1.0f;
    private int lastStep = 0;

    CSVExporter() {
    }

    @Override
    protected int getSteps(TableModel tableModel) {
        int n = tableModel.getRowCount();
        if (n > 300) {
            this.step = 300.0f / (float)n;
            n = 300;
        }
        return n;
    }

    @Override
    protected void writeData(TableModel tableModel, String string, Writer writer, TracerProgressObject tracerProgressObject) throws IOException {
        int n;
        int n2 = tableModel.getColumnCount();
        int n3 = tableModel.getRowCount();
        for (n = 0; n < n2; ++n) {
            CSVExporter.write(writer, "\"" + tableModel.getColumnName(n) + "\"");
            if (n >= n2 - 1) continue;
            CSVExporter.write(writer, DELIMITER);
        }
        CSVExporter.writeLine(writer);
        for (n = 0; n < n3; ++n) {
            int n4;
            for (n4 = 0; n4 < n2; ++n4) {
                CSVExporter.write(writer, "\"" + tableModel.getValueAt(n, n4) + "\"");
                if (n4 >= n2 - 1) continue;
                CSVExporter.write(writer, DELIMITER);
            }
            CSVExporter.writeLine(writer);
            if (tracerProgressObject.isFinished()) break;
            if (this.step == 1.0f) {
                tracerProgressObject.addStep();
                continue;
            }
            n4 = (int)((float)n * this.step);
            if (n4 <= this.lastStep) continue;
            tracerProgressObject.addStep();
            this.lastStep = n4;
        }
    }
}

