/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Collection;
import javax.swing.Action;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.util.Lookup;
import org.openide.windows.IOContainer;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public abstract class IOProvider {
    public static IOProvider getDefault() {
        IOProvider iOProvider = (IOProvider)Lookup.getDefault().lookup(IOProvider.class);
        if (iOProvider == null) {
            iOProvider = new Trivial();
        }
        return iOProvider;
    }

    public static IOProvider get(String string) {
        Collection collection = Lookup.getDefault().lookupAll(IOProvider.class);
        for (IOProvider iOProvider : collection) {
            if (!iOProvider.getName().equals(string)) continue;
            return iOProvider;
        }
        return IOProvider.getDefault();
    }

    protected IOProvider() {
    }

    public abstract InputOutput getIO(String var1, boolean var2);

    public InputOutput getIO(String string, Action[] actionArray) {
        return this.getIO(string, true);
    }

    public InputOutput getIO(String string, Action[] actionArray, IOContainer iOContainer) {
        return this.getIO(string, actionArray);
    }

    @NonNull
    public InputOutput getIO(@NonNull String string, boolean bl, @NonNull Action[] actionArray, @NullAllowed IOContainer iOContainer) {
        return this.getIO(string, actionArray);
    }

    public String getName() {
        return "";
    }

    public abstract OutputWriter getStdOut();

    private static final class Trivial
    extends IOProvider {
        private static final Reader in = new BufferedReader(new InputStreamReader(System.in));
        private static final PrintStream out = System.out;
        private static final PrintStream err = System.err;

        @Override
        public InputOutput getIO(String string, boolean bl) {
            return new TrivialIO(string);
        }

        @Override
        public OutputWriter getStdOut() {
            return new TrivialOW(out, "stdout");
        }

        private static final class TrivialOW
        extends OutputWriter {
            private static int count = 0;
            private final String name;
            private final PrintStream stream;

            public TrivialOW(PrintStream printStream, String string) {
                super(new StringWriter());
                this.stream = printStream;
                this.name = string != null ? string : "anon-" + ++count;
            }

            private void prefix(boolean bl) {
                if (bl) {
                    this.stream.print("[" + this.name + "]* ");
                } else {
                    this.stream.print("[" + this.name + "]  ");
                }
            }

            @Override
            public void println(String string, OutputListener outputListener) throws IOException {
                this.prefix(outputListener != null);
                this.stream.println(string);
            }

            @Override
            public void reset() throws IOException {
            }

            @Override
            public void println(float f) {
                this.prefix(false);
                this.stream.println(f);
            }

            @Override
            public void println(double d) {
                this.prefix(false);
                this.stream.println(d);
            }

            @Override
            public void println() {
                this.prefix(false);
                this.stream.println();
            }

            @Override
            public void println(Object object) {
                this.prefix(false);
                this.stream.println(object);
            }

            @Override
            public void println(int n) {
                this.prefix(false);
                this.stream.println(n);
            }

            @Override
            public void println(char c) {
                this.prefix(false);
                this.stream.println(c);
            }

            @Override
            public void println(long l) {
                this.prefix(false);
                this.stream.println(l);
            }

            @Override
            public void println(char[] cArray) {
                this.prefix(false);
                this.stream.println(cArray);
            }

            @Override
            public void println(boolean bl) {
                this.prefix(false);
                this.stream.println(bl);
            }

            @Override
            public void println(String string) {
                this.prefix(false);
                this.stream.println(string);
            }

            @Override
            public void write(int n) {
                this.stream.write(n);
            }

            @Override
            public void write(char[] cArray, int n, int n2) {
                String string = new String(cArray, n, n2);
                if (string.endsWith("\n")) {
                    this.println(string.substring(0, string.length() - 1));
                } else {
                    try {
                        this.stream.write(string.getBytes());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }

            @Override
            public void write(String string, int n, int n2) {
                if ((string = string.substring(n, n + n2)).endsWith("\n")) {
                    this.println(string.substring(0, string.length() - 1));
                } else {
                    try {
                        this.stream.write(string.getBytes());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        private final class TrivialIO
        implements InputOutput {
            private final String name;

            public TrivialIO(String string) {
                this.name = string;
            }

            @Override
            public Reader getIn() {
                return in;
            }

            @Override
            public OutputWriter getOut() {
                return new TrivialOW(out, this.name);
            }

            @Override
            public OutputWriter getErr() {
                return new TrivialOW(err, this.name);
            }

            @Override
            public Reader flushReader() {
                return this.getIn();
            }

            @Override
            public boolean isClosed() {
                return false;
            }

            @Override
            public boolean isErrSeparated() {
                return false;
            }

            @Override
            public boolean isFocusTaken() {
                return false;
            }

            @Override
            public void closeInputOutput() {
            }

            @Override
            public void select() {
            }

            @Override
            public void setErrSeparated(boolean bl) {
            }

            @Override
            public void setErrVisible(boolean bl) {
            }

            @Override
            public void setFocusTaken(boolean bl) {
            }

            @Override
            public void setInputVisible(boolean bl) {
            }

            @Override
            public void setOutputVisible(boolean bl) {
            }
        }
    }
}

