/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.structure;

import java.util.Objects;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.model.ESExpressionVisitor;
import org.jetbrains.kotlin.contracts.model.ESValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J!\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0011J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "Lorg/jetbrains/kotlin/contracts/model/ESValue;", "constantReference", "Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;Lorg/jetbrains/kotlin/types/KotlinType;)V", "getConstantReference", "()Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "accept", "T", "visitor", "Lorg/jetbrains/kotlin/contracts/model/ESExpressionVisitor;", "(Lorg/jetbrains/kotlin/contracts/model/ESExpressionVisitor;)Ljava/lang/Object;", "equals", "", "other", "", "hashCode", "", "isNullConstant", "toString", "", "Companion", "resolution"})
public class ESConstant
extends ESValue {
    @NotNull
    private final ConstantReference constantReference;
    @NotNull
    private final KotlinType type;
    @NotNull
    private static final ESConstant TRUE;
    @NotNull
    private static final ESConstant FALSE;
    @NotNull
    private static final ESConstant NULL;
    @NotNull
    private static final ESConstant NOT_NULL;
    @NotNull
    private static final ESConstant WILDCARD;
    public static final Companion Companion;

    @Override
    public <T> T accept(@NotNull ESExpressionVisitor<? extends T> visitor2) {
        Intrinsics.checkParameterIsNotNull(visitor2, (String)"visitor");
        return visitor2.visitConstant(this);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(object != null ? object.getClass() : null, this.getClass()) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.contracts.model.structure.ESConstant");
        }
        ESConstant cfr_ignored_0 = (ESConstant)object2;
        return !(Intrinsics.areEqual((Object)this.getConstantReference(), (Object)((ESConstant)other).getConstantReference()) ^ true);
    }

    public int hashCode() {
        return Objects.hashCode(this.getConstantReference());
    }

    @NotNull
    public String toString() {
        return this.getConstantReference().getName();
    }

    public final boolean isNullConstant() {
        return Intrinsics.areEqual((Object)this, (Object)Companion.getNULL()) || Intrinsics.areEqual((Object)this, (Object)Companion.getNOT_NULL());
    }

    @NotNull
    public ConstantReference getConstantReference() {
        return this.constantReference;
    }

    @Override
    @NotNull
    public KotlinType getType() {
        return this.type;
    }

    private ESConstant(ConstantReference constantReference, KotlinType type2) {
        super(type2);
        this.constantReference = constantReference;
        this.type = type2;
    }

    static {
        Companion = new Companion(null);
        ConstantReference constantReference = BooleanConstantReference.Companion.getTRUE();
        SimpleType simpleType2 = DefaultBuiltIns.Companion.getInstance().getBooleanType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"DefaultBuiltIns.Instance.booleanType");
        TRUE = new ESConstant(constantReference, simpleType2);
        ConstantReference constantReference2 = BooleanConstantReference.Companion.getFALSE();
        SimpleType simpleType3 = DefaultBuiltIns.Companion.getInstance().getBooleanType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"DefaultBuiltIns.Instance.booleanType");
        FALSE = new ESConstant(constantReference2, simpleType3);
        ConstantReference constantReference3 = ConstantReference.Companion.getNULL();
        SimpleType simpleType4 = DefaultBuiltIns.Companion.getInstance().getNothingType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType4, (String)"DefaultBuiltIns.Instance.nothingType");
        NULL = new ESConstant(constantReference3, TypeUtilsKt.makeNullable(simpleType4));
        ConstantReference constantReference4 = ConstantReference.Companion.getNOT_NULL();
        SimpleType simpleType5 = DefaultBuiltIns.Companion.getInstance().getAnyType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType5, (String)"DefaultBuiltIns.Instance.anyType");
        NOT_NULL = new ESConstant(constantReference4, simpleType5);
        ConstantReference constantReference5 = ConstantReference.Companion.getWILDCARD();
        SimpleType simpleType6 = DefaultBuiltIns.Companion.getInstance().getAnyType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType6, (String)"DefaultBuiltIns.Instance.anyType");
        WILDCARD = new ESConstant(constantReference5, TypeUtilsKt.makeNullable(simpleType6));
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant$Companion;", "", "()V", "FALSE", "Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "getFALSE", "()Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "NOT_NULL", "getNOT_NULL", "NULL", "getNULL", "TRUE", "getTRUE", "WILDCARD", "getWILDCARD", "resolution"})
    public static final class Companion {
        @NotNull
        public final ESConstant getTRUE() {
            return TRUE;
        }

        @NotNull
        public final ESConstant getFALSE() {
            return FALSE;
        }

        @NotNull
        public final ESConstant getNULL() {
            return NULL;
        }

        @NotNull
        public final ESConstant getNOT_NULL() {
            return NOT_NULL;
        }

        @NotNull
        public final ESConstant getWILDCARD() {
            return WILDCARD;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

