/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import com.google.common.collect.ImmutableSortedSet;
import java.util.SortedSet;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.CacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.OriginTaskExecutionMetadata;
import org.gradle.api.internal.tasks.ResolvedTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.TaskOutputChangesListener;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.tasks.TaskOutputCacheCommandFactory;
import org.gradle.caching.internal.tasks.UnrecoverableTaskOutputUnpackingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkipCachedTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipCachedTaskExecuter.class);
    private final BuildCacheController buildCache;
    private final TaskExecuter delegate;
    private final TaskOutputChangesListener taskOutputChangesListener;
    private final TaskOutputCacheCommandFactory buildCacheCommandFactory;

    public SkipCachedTaskExecuter(BuildCacheController buildCache, TaskOutputChangesListener taskOutputChangesListener, TaskOutputCacheCommandFactory buildCacheCommandFactory, TaskExecuter delegate) {
        this.taskOutputChangesListener = taskOutputChangesListener;
        this.buildCacheCommandFactory = buildCacheCommandFactory;
        this.buildCache = buildCache;
        this.delegate = delegate;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        SkipCachedTaskExecuter.LOGGER.debug("Determining if {} is cached already", (Object)task);
        taskProperties = context.getTaskProperties();
        cacheKey = context.getBuildCacheKey();
        taskOutputCachingEnabled = state.getTaskOutputCaching().isEnabled();
        outputProperties = null;
        if (taskOutputCachingEnabled) {
            if (task.isHasCustomActions()) {
                SkipCachedTaskExecuter.LOGGER.info("Custom actions are attached to {}.", (Object)task);
            }
            if (cacheKey.isValid()) {
                taskState = context.getTaskArtifactState();
                outputProperties = SkipCachedTaskExecuter.resolveProperties(taskProperties.getOutputFileProperties());
                if (taskState.isAllowedToUseCachedResults()) {
                    try {
                        originMetadata = (OriginTaskExecutionMetadata)this.buildCache.load(this.buildCacheCommandFactory.createLoad(cacheKey, outputProperties, task, taskProperties, this.taskOutputChangesListener, taskState));
                        if (originMetadata == null) ** GOTO lbl27
                        state.setOutcome(TaskExecutionOutcome.FROM_CACHE);
                        context.setOriginExecutionMetadata(originMetadata);
                        return;
                    }
                    catch (UnrecoverableTaskOutputUnpackingException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        SkipCachedTaskExecuter.LOGGER.warn("Failed to load cache entry for {}, falling back to executing task", (Object)task, (Object)e);
                    }
                } else {
                    SkipCachedTaskExecuter.LOGGER.info("Not loading {} from cache because pulling from cache is disabled for this task", (Object)task);
                }
            } else {
                SkipCachedTaskExecuter.LOGGER.info("Not caching {} because no valid cache key was generated", (Object)task);
            }
        }
lbl27:
        // 6 sources

        this.delegate.execute(task, state, context);
        if (taskOutputCachingEnabled) {
            if (cacheKey.isValid()) {
                if (state.getFailure() == null) {
                    try {
                        taskState = context.getTaskArtifactState();
                        outputSnapshots = taskState.getOutputContentSnapshots();
                        this.buildCache.store(this.buildCacheCommandFactory.createStore(cacheKey, outputProperties, outputSnapshots, task, context.getExecutionTime()));
                    }
                    catch (Exception e) {
                        SkipCachedTaskExecuter.LOGGER.warn("Failed to store cache entry {}", new Object[]{cacheKey.getDisplayName(), task, e});
                    }
                } else {
                    SkipCachedTaskExecuter.LOGGER.debug("Not pushing result from {} to cache because the task failed", (Object)task);
                }
            } else {
                SkipCachedTaskExecuter.LOGGER.info("Not pushing results from {} to cache because no valid cache key was generated", (Object)task);
            }
        }
    }

    private static SortedSet<ResolvedTaskOutputFilePropertySpec> resolveProperties(ImmutableSortedSet<? extends TaskOutputFilePropertySpec> properties) {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (TaskOutputFilePropertySpec property : properties) {
            CacheableTaskOutputFilePropertySpec cacheableProperty = (CacheableTaskOutputFilePropertySpec)property;
            builder.add((Object)new ResolvedTaskOutputFilePropertySpec(cacheableProperty.getPropertyName(), cacheableProperty.getOutputType(), cacheableProperty.getOutputFile()));
        }
        return builder.build();
    }
}

