/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.sun.net.httpserver.HttpExchange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.RuleMatch;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.RequestCounter;
import org.languagetool.server.ServerTools;
import org.languagetool.server.TextChecker;
import org.languagetool.tools.RuleMatchesAsJsonSerializer;
import org.languagetool.tools.StringTools;

class V2TextChecker
extends TextChecker {
    private static final String JSON_CONTENT_TYPE = "application/json";

    V2TextChecker(HTTPServerConfig config, boolean internalServer, Queue<Runnable> workQueue, RequestCounter reqCounter) {
        super(config, internalServer, workQueue, reqCounter);
    }

    @Override
    protected void setHeaders(HttpExchange httpExchange) {
        ServerTools.setCommonHeaders(httpExchange, JSON_CONTENT_TYPE, this.config.allowOriginUrl);
    }

    @Override
    protected String getResponse(String text, Language lang, Language motherTongue, List<RuleMatch> matches, List<RuleMatch> hiddenMatches, String incompleteResultsReason) {
        RuleMatchesAsJsonSerializer serializer = new RuleMatchesAsJsonSerializer();
        return serializer.ruleMatchesToJson(matches, hiddenMatches, text, 40, lang, incompleteResultsReason);
    }

    @Override
    @NotNull
    protected List<String> getEnabledRuleIds(Map<String, String> parameters) {
        String enabledParam = parameters.get("enabledRules");
        ArrayList<String> enabledRules = new ArrayList<String>();
        if (enabledParam != null) {
            enabledRules.addAll(Arrays.asList(enabledParam.split(",")));
        }
        return enabledRules;
    }

    @Override
    @NotNull
    protected List<String> getDisabledRuleIds(Map<String, String> parameters) {
        return this.getCommaSeparatedStrings("disabledRules", parameters);
    }

    @Override
    protected boolean getLanguageAutoDetect(Map<String, String> parameters) {
        return "auto".equals(parameters.get("language"));
    }

    @Override
    protected void checkParams(Map<String, String> parameters) {
        super.checkParams(parameters);
        if (StringTools.isEmpty(parameters.get("language"))) {
            throw new IllegalArgumentException("Missing 'language' parameter, e.g. 'language=en-US' for American English or 'language=fr' for French");
        }
        if (parameters.get("enabled") != null) {
            throw new IllegalArgumentException("You specified 'enabled' but the parameter is now called 'enabledRules' in v2 of the API");
        }
        if (parameters.get("disabled") != null) {
            throw new IllegalArgumentException("You specified 'disabled' but the parameter is now called 'disabledRules' in v2 of the API");
        }
        if (parameters.get("preferredvariants") != null) {
            throw new IllegalArgumentException("You specified 'preferredvariants' but the parameter is now called 'preferredVariants' (uppercase 'V') in v2 of the API");
        }
        if (parameters.get("autodetect") != null) {
            throw new IllegalArgumentException("You specified 'autodetect' but automatic language detection is now activated with 'language=auto' in v2 of the API");
        }
    }

    @Override
    @NotNull
    protected Language getLanguage(String text, Map<String, String> parameters, List<String> preferredVariants) {
        String langParam = parameters.get("language");
        Language lang = this.getLanguageAutoDetect(parameters) ? this.detectLanguageOfString(text, null, preferredVariants) : Languages.getLanguageForShortCode(langParam);
        return lang;
    }

    @Override
    @NotNull
    protected List<String> getPreferredVariants(Map<String, String> parameters) {
        List<String> preferredVariants;
        if (parameters.get("preferredVariants") != null) {
            preferredVariants = Arrays.asList(parameters.get("preferredVariants").split(",\\s*"));
            if (!"auto".equals(parameters.get("language"))) {
                throw new IllegalArgumentException("You specified 'preferredVariants' but you didn't specify 'language=auto'");
            }
        } else {
            preferredVariants = Collections.emptyList();
        }
        return preferredVariants;
    }
}

