/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.graph;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.DefaultMaven;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.ProjectCycleException;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.graph.DefaultProjectDependencyGraph;
import org.apache.maven.graph.FilteredProjectDependencyGraph;
import org.apache.maven.graph.GraphBuilder;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.building.DefaultModelProblem;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemUtils;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.Result;
import org.apache.maven.model.building.UrlModelSource;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.dag.CycleDetectedException;

@Component(role=GraphBuilder.class, hint="graphBuilder")
public class DefaultGraphBuilder
implements GraphBuilder {
    @Requirement
    private Logger logger;
    @Requirement
    protected ProjectBuilder projectBuilder;

    public Result<ProjectDependencyGraph> build(MavenSession session) {
        try {
            Result<ProjectDependencyGraph> result = this.sessionDependencyGraph(session);
            if (result == null) {
                List<MavenProject> projects = this.getProjectsForMavenReactor(session);
                this.validateProjects(projects);
                result = this.reactorDependencyGraph(session, projects);
            }
            return result;
        }
        catch (ProjectBuildingException e) {
            return Result.error((Iterable)Lists.newArrayList((Object[])new DefaultModelProblem[]{new DefaultModelProblem(null, null, null, null, 0, 0, (Exception)e)}));
        }
        catch (CycleDetectedException e) {
            String message = "The projects in the reactor contain a cyclic reference: " + e.getMessage();
            ProjectCycleException error = new ProjectCycleException(message, e);
            return Result.error((Iterable)Lists.newArrayList((Object[])new DefaultModelProblem[]{new DefaultModelProblem(null, null, null, null, 0, 0, (Exception)error)}));
        }
        catch (DuplicateProjectException e) {
            return Result.error((Iterable)Lists.newArrayList((Object[])new DefaultModelProblem[]{new DefaultModelProblem(null, null, null, null, 0, 0, (Exception)e)}));
        }
        catch (MavenExecutionException e) {
            return Result.error((Iterable)Lists.newArrayList((Object[])new DefaultModelProblem[]{new DefaultModelProblem(null, null, null, null, 0, 0, (Exception)e)}));
        }
    }

    private Result<ProjectDependencyGraph> sessionDependencyGraph(MavenSession session) throws CycleDetectedException, DuplicateProjectException {
        Result result = null;
        if (session.getProjectDependencyGraph() != null || session.getProjects() != null) {
            DefaultProjectDependencyGraph graph = new DefaultProjectDependencyGraph(session.getAllProjects(), session.getProjects());
            result = Result.success((Object)graph);
        }
        return result;
    }

    private Result<ProjectDependencyGraph> reactorDependencyGraph(MavenSession session, List<MavenProject> projects) throws CycleDetectedException, DuplicateProjectException, MavenExecutionException {
        ProjectDependencyGraph projectDependencyGraph = new DefaultProjectDependencyGraph(projects);
        List<MavenProject> activeProjects = projectDependencyGraph.getSortedProjects();
        activeProjects = this.trimSelectedProjects(activeProjects, projectDependencyGraph, session.getRequest());
        activeProjects = this.trimExcludedProjects(activeProjects, session.getRequest());
        if ((activeProjects = this.trimResumedProjects(activeProjects, session.getRequest())).size() != projectDependencyGraph.getSortedProjects().size()) {
            projectDependencyGraph = new FilteredProjectDependencyGraph(projectDependencyGraph, activeProjects);
        }
        return Result.success((Object)projectDependencyGraph);
    }

    private List<MavenProject> trimSelectedProjects(List<MavenProject> projects, ProjectDependencyGraph graph, MavenExecutionRequest request) throws MavenExecutionException {
        List<MavenProject> result = projects;
        if (!request.getSelectedProjects().isEmpty()) {
            File reactorDirectory = null;
            if (request.getBaseDirectory() != null) {
                reactorDirectory = new File(request.getBaseDirectory());
            }
            LinkedHashSet<MavenProject> selectedProjects = new LinkedHashSet<MavenProject>(projects.size());
            for (String selector : request.getSelectedProjects()) {
                MavenProject selectedProject = null;
                for (MavenProject project : projects) {
                    if (!this.isMatchingProject(project, selector, reactorDirectory)) continue;
                    selectedProject = project;
                    break;
                }
                if (selectedProject != null) {
                    selectedProjects.add(selectedProject);
                    continue;
                }
                throw new MavenExecutionException("Could not find the selected project in the reactor: " + selector, request.getPom());
            }
            boolean makeUpstream = false;
            boolean makeDownstream = false;
            if ("make-upstream".equals(request.getMakeBehavior())) {
                makeUpstream = true;
            } else if ("make-downstream".equals(request.getMakeBehavior())) {
                makeDownstream = true;
            } else if ("make-both".equals(request.getMakeBehavior())) {
                makeUpstream = true;
                makeDownstream = true;
            } else if (StringUtils.isNotEmpty((String)request.getMakeBehavior())) {
                throw new MavenExecutionException("Invalid reactor make behavior: " + request.getMakeBehavior(), request.getPom());
            }
            if (makeUpstream || makeDownstream) {
                for (MavenProject selectedProject : new ArrayList(selectedProjects)) {
                    if (makeUpstream) {
                        selectedProjects.addAll(graph.getUpstreamProjects(selectedProject, true));
                    }
                    if (!makeDownstream) continue;
                    selectedProjects.addAll(graph.getDownstreamProjects(selectedProject, true));
                }
            }
            result = new ArrayList<MavenProject>(selectedProjects.size());
            for (MavenProject project : projects) {
                if (!selectedProjects.contains(project)) continue;
                result.add(project);
            }
        }
        return result;
    }

    private List<MavenProject> trimExcludedProjects(List<MavenProject> projects, MavenExecutionRequest request) throws MavenExecutionException {
        List<MavenProject> result = projects;
        if (!request.getExcludedProjects().isEmpty()) {
            File reactorDirectory = null;
            if (request.getBaseDirectory() != null) {
                reactorDirectory = new File(request.getBaseDirectory());
            }
            LinkedHashSet<MavenProject> excludedProjects = new LinkedHashSet<MavenProject>(projects.size());
            for (String selector : request.getExcludedProjects()) {
                MavenProject excludedProject = null;
                for (MavenProject project : projects) {
                    if (!this.isMatchingProject(project, selector, reactorDirectory)) continue;
                    excludedProject = project;
                    break;
                }
                if (excludedProject != null) {
                    excludedProjects.add(excludedProject);
                    continue;
                }
                throw new MavenExecutionException("Could not find the selected project in the reactor: " + selector, request.getPom());
            }
            result = new ArrayList<MavenProject>(projects.size());
            for (MavenProject project : projects) {
                if (excludedProjects.contains(project)) continue;
                result.add(project);
            }
        }
        return result;
    }

    private List<MavenProject> trimResumedProjects(List<MavenProject> projects, MavenExecutionRequest request) throws MavenExecutionException {
        List<MavenProject> result = projects;
        if (StringUtils.isNotEmpty((String)request.getResumeFrom())) {
            File reactorDirectory = null;
            if (request.getBaseDirectory() != null) {
                reactorDirectory = new File(request.getBaseDirectory());
            }
            String selector = request.getResumeFrom();
            result = new ArrayList<MavenProject>(projects.size());
            boolean resumed = false;
            for (MavenProject project : projects) {
                if (!resumed && this.isMatchingProject(project, selector, reactorDirectory)) {
                    resumed = true;
                }
                if (!resumed) continue;
                result.add(project);
            }
            if (!resumed) {
                throw new MavenExecutionException("Could not find project to resume reactor build from: " + selector + " vs " + projects, request.getPom());
            }
        }
        return result;
    }

    private boolean isMatchingProject(MavenProject project, String selector, File reactorDirectory) {
        if (selector.indexOf(58) >= 0) {
            String id = ':' + project.getArtifactId();
            if (id.equals(selector)) {
                return true;
            }
            id = project.getGroupId() + id;
            if (id.equals(selector)) {
                return true;
            }
        } else if (reactorDirectory != null) {
            File selectedProject = new File(new File(reactorDirectory, selector).toURI().normalize());
            if (selectedProject.isFile()) {
                return selectedProject.equals(project.getFile());
            }
            if (selectedProject.isDirectory()) {
                return selectedProject.equals(project.getBasedir());
            }
        }
        return false;
    }

    private List<MavenProject> getProjectsForMavenReactor(MavenSession session) throws ProjectBuildingException {
        MavenExecutionRequest request = session.getRequest();
        request.getProjectBuildingRequest().setRepositorySession(session.getRepositorySession());
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
        if (request.getPom() == null) {
            UrlModelSource modelSource = new UrlModelSource(DefaultMaven.class.getResource("project/standalone.xml"));
            MavenProject project = this.projectBuilder.build((ModelSource)modelSource, request.getProjectBuildingRequest()).getProject();
            project.setExecutionRoot(true);
            projects.add(project);
            request.setProjectPresent(false);
            return projects;
        }
        List<File> files = Arrays.asList(request.getPom().getAbsoluteFile());
        this.collectProjects(projects, files, request);
        return projects;
    }

    private void collectProjects(List<MavenProject> projects, List<File> files, MavenExecutionRequest request) throws ProjectBuildingException {
        ProjectBuildingRequest projectBuildingRequest = request.getProjectBuildingRequest();
        List<ProjectBuildingResult> results = this.projectBuilder.build(files, request.isRecursive(), projectBuildingRequest);
        boolean problems = false;
        for (ProjectBuildingResult result : results) {
            projects.add(result.getProject());
            if (result.getProblems().isEmpty() || !this.logger.isWarnEnabled()) continue;
            this.logger.warn("");
            this.logger.warn("Some problems were encountered while building the effective model for " + result.getProject().getId());
            for (ModelProblem problem : result.getProblems()) {
                String loc = ModelProblemUtils.formatLocation((ModelProblem)problem, (String)result.getProjectId());
                this.logger.warn(problem.getMessage() + (StringUtils.isNotEmpty((String)loc) ? " @ " + loc : ""));
            }
            problems = true;
        }
        if (problems) {
            this.logger.warn("");
            this.logger.warn("It is highly recommended to fix these problems because they threaten the stability of your build.");
            this.logger.warn("");
            this.logger.warn("For this reason, future Maven versions might no longer support building such malformed projects.");
            this.logger.warn("");
        }
    }

    private void validateProjects(List<MavenProject> projects) {
        HashMap<String, MavenProject> projectsMap = new HashMap<String, MavenProject>();
        for (MavenProject p : projects) {
            String projectKey = ArtifactUtils.key((String)p.getGroupId(), (String)p.getArtifactId(), (String)p.getVersion());
            projectsMap.put(projectKey, p);
        }
        for (MavenProject project : projects) {
            for (Plugin plugin : project.getBuildPlugins()) {
                String pluginKey;
                if (!plugin.isExtensions() || !projectsMap.containsKey(pluginKey = ArtifactUtils.key((String)plugin.getGroupId(), (String)plugin.getArtifactId(), (String)plugin.getVersion()))) continue;
                this.logger.warn(project.getName() + " uses " + plugin.getKey() + " as extensions, which is not possible within the same reactor build. " + "This plugin was pulled from the local repository!");
            }
        }
    }
}

