#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: dbus
version: 1.0.1
id: dbus-1.0.1-BKHfJflAxPd7Sk7vGgLM7j
key: dbus-1.0.1-BKHfJflAxPd7Sk7vGgLM7j
license: Apache-2.0
maintainer: Andrey Sverdlichenko <blaze@ruddy.ru>
stability: experimental
homepage: https://github.com/rblaze/haskell-dbus#readme
synopsis: A client library for the D-Bus IPC system.
description:
    D-Bus is a simple, message-based protocol for inter-process
    communication, which allows applications to interact with other parts of
    the machine and the user'\''s session using remote procedure calls.
    .
    D-Bus is a essential part of the modern Linux desktop, where it replaces
    earlier protocols such as CORBA and DCOP.
    .
    This library is an implementation of the D-Bus protocol in Haskell. It
    can be used to add D-Bus support to Haskell applications, without the
    awkward interfaces common to foreign bindings.
    .
    Example: connect to the session bus, and get a list of active names.
    .
    @
    &#x7b;-\# LANGUAGE OverloadedStrings \#-&#x7d;
    .
    import Data.List (sort)
    import DBus
    import DBus.Client
    .
    main = do
    &#x20;   client <- connectSession
    &#x20;   //
    &#x20;   \-- Request a list of connected clients from the bus
    &#x20;   reply <- call_ client (methodCall \"\/org\/freedesktop\/DBus\" \"org.freedesktop.DBus\" \"ListNames\")
    &#x20;       &#x7b; methodCallDestination = Just \"org.freedesktop.DBus\"
    &#x20;       &#x7d;
    &#x20;   //
    &#x20;   \-- org.freedesktop.DBus.ListNames() returns a single value, which is
    &#x20;   \-- a list of names (here represented as [String])
    &#x20;   let Just names = fromVariant (methodReturnBody reply !! 0)
    &#x20;   //
    &#x20;   \-- Print each name on a line, sorted so reserved names are below
    &#x20;   \-- temporary names.
    &#x20;   mapM_ putStrLn (sort names)
    @
    .
    >$ ghc --make list-names.hs
    >$ ./list-names
    >:1.0
    >:1.1
    >:1.10
    >:1.106
    >:1.109
    >:1.110
    >ca.desrt.dconf
    >org.freedesktop.DBus
    >org.freedesktop.Notifications
    >org.freedesktop.secrets
    >org.gnome.ScreenSaver
category: Network, Desktop
author: John Millikin <john@john-millikin.com>
exposed: True
indefinite: False
exposed-modules:
    DBus DBus.Client DBus.Generation DBus.Internal.Address
    DBus.Internal.Message DBus.Internal.Types DBus.Internal.Wire
    DBus.Introspection DBus.Socket DBus.TH DBus.Transport
abi: d871f53ffb28a63d5e0092b7d8c951c1
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/dbus-1.0.1
library-dirs: /usr/lib/ghc-8.2.2/site-local/dbus-1.0.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/dbus-1.0.1
hs-libraries: HSdbus-1.0.1-BKHfJflAxPd7Sk7vGgLM7j
depends:
    base-4.10.1.0 bytestring-0.10.8.2
    cereal-0.5.5.0-DWUgAsuwqXgLl3Helfg18I containers-0.5.10.2
    deepseq-1.4.3.0 filepath-1.4.1.2 lens-4.15.4-6m0DRudBlbcIMz3JMQWt18
    libxml-sax-0.7.5-9uJRjofyhKXDY1KBQQfeQn
    network-2.6.3.5-BVJHDRdh5LJ4pgucNKJkuJ
    parsec-3.1.13.0-F9Bf3y6KXh0ILPjymhJoOp
    random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We
    split-0.2.3.3-BN2ylJ9hXZBIaY8HiUVge7 template-haskell-2.12.0.0
    text-1.2.3.0-912fnkqHcZz4dFvcXKwtDz
    th-lift-0.7.10-G3XiXDUh4133Q225ueZYGi transformers-0.5.2.0
    unix-2.7.2.2 vector-0.12.0.1-JlawpRjIcMJIYPJVsWriIA
    xml-types-0.3.6-GzQgX9Brh0VH8ue9BSAlZr
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             cereal-0.5.5.0-DWUgAsuwqXgLl3Helfg18I=6218d13b02d73798bf7f063f3f4fa054
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             deepseq-1.4.3.0=e843b5d736cc095915bf2399fddf152e
             filepath-1.4.1.2=a40cd48e5480796e558f3c29652ee19a
             lens-4.15.4-6m0DRudBlbcIMz3JMQWt18=711291bbead8ac7054491886b474b5a2
             libxml-sax-0.7.5-9uJRjofyhKXDY1KBQQfeQn=ae476ce38361b2a40eddc0731cf8b464
             network-2.6.3.5-BVJHDRdh5LJ4pgucNKJkuJ=82fe21e10301e2e4d8701392ba21a740
             parsec-3.1.13.0-F9Bf3y6KXh0ILPjymhJoOp=b942a04aec0a266706b2e8e67bd137e3
             random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We=368a9f817c8c1b290191231dd0d81d85
             split-0.2.3.3-BN2ylJ9hXZBIaY8HiUVge7=b6b8499789ca23888d2f286cbdde6707
             template-haskell-2.12.0.0=24d98a36b9e0dbd4d443161d478c05b2
             text-1.2.3.0-912fnkqHcZz4dFvcXKwtDz=29872508833c96394f0471371217bab0
             th-lift-0.7.10-G3XiXDUh4133Q225ueZYGi=84d98936d171a4c6838b2f837c12329a
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
             unix-2.7.2.2=3df01ca0d7640dab598065ff1b1cffeb
             vector-0.12.0.1-JlawpRjIcMJIYPJVsWriIA=137c9db50bf637e10c6e6dd9e685ce59
             xml-types-0.3.6-GzQgX9Brh0VH8ue9BSAlZr=edf071c0face4ef12f6ee1822aae3316
haddock-interfaces: /usr/share/doc/haskell-dbus/html/dbus.haddock
haddock-html: /usr/share/doc/haskell-dbus/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

