#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: psqueues
version: 0.2.7.0
id: psqueues-0.2.7.0-8HyBaSvkKbxHiF3609X8zK
key: psqueues-0.2.7.0-8HyBaSvkKbxHiF3609X8zK
license: BSD3
maintainer: Jasper Van der Jeugt <jaspervdj@gmail.com>
synopsis: Pure priority search queues
description:
    The psqueues package provides
    <http://en.wikipedia.org/wiki/Priority_queue Priority Search Queues> in
    three different flavors.
    .
    * @OrdPSQ k p v@, which uses the @Ord k@ instance to provide fast insertion,
    deletion and lookup. This implementation is based on Ralf Hinze'\''s
    <http://citeseer.ist.psu.edu/hinze01simple.html A Simple Implementation Technique for Priority Search Queues>.
    Hence, it is similar to the
    <http://hackage.haskell.org/package/PSQueue PSQueue> library, although it is
    considerably faster and provides a slightly different API.
    .
    * @IntPSQ p v@ is a far more efficient implementation. It fixes the key type
    to @Int@ and uses a <http://en.wikipedia.org/wiki/Radix_tree radix tree>
    (like @IntMap@) with an additional min-heap property.
    .
    * @HashPSQ k p v@ is a fairly straightforward extension of @IntPSQ@: it
    simply uses the keys'\'' hashes as indices in the @IntPSQ@. If there are any
    hash collisions, it uses an @OrdPSQ@ to resolve those. The performance of
    this implementation is comparable to that of @IntPSQ@, but it is more widely
    applicable since the keys are not restricted to @Int@, but rather to any
    @Hashable@ datatype.
    .
    Each of the three implementations provides the same API, so they can be used
    interchangeably. The benchmarks show how they perform relative to one
    another, and also compared to the other Priority Search Queue
    implementations on Hackage:
    <http://hackage.haskell.org/package/PSQueue PSQueue>
    and
    <http://hackage.haskell.org/package/fingertree-psqueue fingertree-psqueue>.
    .
    <<http://i.imgur.com/KmbDKR6.png>>
    .
    <<http://i.imgur.com/ClT181D.png>>
    .
    Typical applications of Priority Search Queues include:
    .
    * Caches, and more specifically LRU Caches;
    .
    * Schedulers;
    .
    * Pathfinding algorithms, such as Dijkstra'\''s and A*.
category: Data Structures
exposed: True
indefinite: False
exposed-modules:
    Data.HashPSQ Data.IntPSQ Data.OrdPSQ
hidden-modules: Data.BitUtil Data.HashPSQ.Internal
                Data.IntPSQ.Internal Data.OrdPSQ.Internal
abi: 021480abe8cb8a993d691cd1baa027de
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/psqueues-0.2.7.0
library-dirs: /usr/lib/ghc-8.2.2/site-local/psqueues-0.2.7.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/psqueues-0.2.7.0
hs-libraries: HSpsqueues-0.2.7.0-8HyBaSvkKbxHiF3609X8zK
depends:
    base-4.10.1.0 deepseq-1.4.3.0
    hashable-1.2.7.0-D1kf6WO5TlN7xk82E4ZIan ghc-prim-0.5.1.1
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             deepseq-1.4.3.0=e843b5d736cc095915bf2399fddf152e
             hashable-1.2.7.0-D1kf6WO5TlN7xk82E4ZIan=7c14723fffdda860d330f4ccf53597f4
             ghc-prim-0.5.1.1=84323a6edd008b04bf217464a4ccaf16
haddock-interfaces: /usr/share/doc/haskell-psqueues/html/psqueues.haddock
haddock-html: /usr/share/doc/haskell-psqueues/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

