#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: stringsearch
version: 0.3.6.6
id: stringsearch-0.3.6.6-5wkiVsEYY78BZshzFV6bBe
key: stringsearch-0.3.6.6-5wkiVsEYY78BZshzFV6bBe
license: BSD3
copyright: (c) 2007-2011
           Daniel Fischer, Chris Kuklewicz, Justin Bailey
maintainer: daniel.is.fischer@googlemail.com
homepage: https://bitbucket.org/dafis/stringsearch
synopsis: Fast searching, splitting and replacing of ByteStrings
description:
    This package provides several functions to quickly
    search for substrings in strict or lazy ByteStrings.
    It also provides functions for breaking or splitting
    on substrings and replacing all occurrences of a
    substring (the first in case of overlaps) with another.
    GHC before 6.10 are no longer supported, other compilers
    only if they support BangPatterns. If you need it to
    work with other compilers, send a feature request.
category: Text, Search
author: Daniel Fischer, Chris Kuklewicz, Justin Bailey
exposed: True
indefinite: False
exposed-modules:
    Data.ByteString.Lazy.Search Data.ByteString.Lazy.Search.DFA
    Data.ByteString.Lazy.Search.KMP
    Data.ByteString.Lazy.Search.KarpRabin Data.ByteString.Search
    Data.ByteString.Search.BoyerMoore Data.ByteString.Search.DFA
    Data.ByteString.Search.KMP Data.ByteString.Search.KarpRabin
    Data.ByteString.Search.KnuthMorrisPratt
    Data.ByteString.Search.Substitution
hidden-modules: Data.ByteString.Search.Internal.BoyerMoore
                Data.ByteString.Search.Internal.KnuthMorrisPratt
                Data.ByteString.Search.Internal.Utils
                Data.ByteString.Lazy.Search.Internal.BoyerMoore
abi: 292f66bdec412c120260c59a3319bc20
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/stringsearch-0.3.6.6
library-dirs: /usr/lib/ghc-8.2.2/site-local/stringsearch-0.3.6.6
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/stringsearch-0.3.6.6
hs-libraries: HSstringsearch-0.3.6.6-5wkiVsEYY78BZshzFV6bBe
depends:
    array-0.5.2.0 base-4.10.1.0 bytestring-0.10.8.2 containers-0.5.10.2
abi-depends: array-0.5.2.0=567646df31883e5d21d17233cc6e3caf
             base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
haddock-interfaces: /usr/share/doc/haskell-stringsearch/html/stringsearch.haddock
haddock-html: /usr/share/doc/haskell-stringsearch/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

