/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class AbinitReader
extends AtomSetCollectionReader {
    private float[] znucl;
    private boolean inputOnly;
    private int nAtom;
    private int nType;
    private float[] typeArray;
    float[] cellLattice;

    protected void initializeReader() {
        this.setSpaceGroupName("P1");
        this.doApplySymmetry = true;
        this.setFractionalCoordinates(false);
        this.inputOnly = this.checkFilterKey("INPUT");
    }

    protected boolean checkLine() throws Exception {
        if (this.line.contains("natom")) {
            this.readNoatom();
        } else if (this.line.contains("ntypat") || this.line.contains("ntype")) {
            this.readNotypes();
        } else if (this.line.contains("typat") || this.line.contains("type")) {
            this.readTypesequence();
        } else if (this.line.contains("Pseudopotential")) {
            this.readAtomSpecies();
        } else if (this.line.contains("Symmetries :")) {
            this.readSpaceGroup();
        } else if (this.line.contains("Real(R)+Recip(G)")) {
            this.readIntiallattice();
            if (this.inputOnly) {
                this.continuing = false;
            }
        } else if (this.line.contains("xcart")) {
            this.readAtoms();
        }
        return true;
    }

    private void readNoatom() throws Exception {
        String[] tokens = this.getTokens();
        if (tokens.length <= 2) {
            this.nAtom = this.parseIntStr(tokens[1]);
        }
    }

    private void readNotypes() throws Exception {
        String[] tokens = this.getTokens();
        if (tokens.length <= 2) {
            this.nType = this.parseIntStr(tokens[1]);
        }
    }

    private void readTypesequence() throws Exception {
        this.typeArray = new float[this.nAtom];
        this.fillFloatArray(this.line.substring(12), 0, this.typeArray);
    }

    private void readAtomSpecies() throws Exception {
        this.znucl = new float[this.nType];
        for (int i = 0; i < this.nType; ++i) {
            this.discardLinesUntilContains("zion");
            String[] tokens = this.getTokens();
            this.znucl[i] = this.parseFloatStr(tokens[tokens[0] == "-" ? 1 : 0]);
        }
    }

    private void readSpaceGroup() throws Exception {
    }

    private void readIntiallattice() throws Exception {
        float f = 0.0f;
        this.cellLattice = new float[9];
        for (int i = 0; i < 9; ++i) {
            if (i % 3 == 0) {
                this.line = this.rd().substring(6);
                f = this.parseFloatStr(this.line);
            }
            this.cellLattice[i] = f * 0.5291772f;
            f = this.parseFloat();
        }
        this.applySymmetry();
    }

    private void applySymmetry() throws Exception {
        if (this.cellLattice == null) {
            return;
        }
        this.setSpaceGroupName("P1");
        for (int i = 0; i < 3; ++i) {
            this.addExplicitLatticeVector(i, this.cellLattice, i * 3);
        }
        Atom[] atoms = this.asc.atoms;
        int i0 = this.asc.getAtomSetAtomIndex(this.asc.iSet);
        if (!this.iHaveFractionalCoordinates) {
            int i = this.asc.ac;
            while (--i >= i0) {
                this.setAtomCoord(atoms[i]);
            }
        }
        this.applySymmetryAndSetTrajectory();
    }

    private void readAtoms() throws Exception {
        this.asc.newAtomSet();
        this.iHaveFractionalCoordinates = false;
        int i0 = this.asc.ac;
        this.line = this.line.substring(12);
        while (this.line != null && !this.line.contains("x")) {
            Atom atom = this.asc.addNewAtom();
            this.setAtomCoordScaled(atom, this.getTokens(), 0, 0.5291772f);
            this.rd();
        }
        this.discardLinesUntilContains("z");
        if (this.znucl == null) {
            this.znucl = new float[this.nType];
            this.fillFloatArray(this.line.substring(12), 0, this.znucl);
        }
        Atom[] atoms = this.asc.atoms;
        for (int i = 0; i < this.nAtom; ++i) {
            atoms[i + i0].elementNumber = (short)this.znucl[(int)this.typeArray[i] - 1];
        }
        this.applySymmetry();
    }
}

