/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.mapmode.DrawAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.SelectCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class FollowLineAction
extends JosmAction {
    public FollowLineAction() {
        super(I18n.tr("Follow line", new Object[0]), "followline", I18n.tr("Continues drawing a line that shares nodes with another line.", new Object[0]), Shortcut.registerShortcut("tools:followline", I18n.tr("Tool: {0}", I18n.tr("Follow", new Object[0])), 70, 5003), true);
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.updateEnabledStateOnModifiableSelection(selection);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        List<OsmPrimitive> referrers;
        DataSet ds = this.getLayerManager().getEditDataSet();
        if (ds == null) {
            return;
        }
        MapFrame map = MainApplication.getMap();
        if (!(map.mapMode instanceof DrawAction)) {
            return;
        }
        Collection<Node> selectedPoints = ds.getSelectedNodes();
        Collection<Way> selectedLines = ds.getSelectedWays();
        if (selectedPoints.size() > 1 || selectedLines.size() != 1) {
            return;
        }
        Node last = ((DrawAction)map.mapMode).getCurrentBaseNode();
        if (last == null) {
            return;
        }
        Way follower = selectedLines.iterator().next();
        if (follower.isClosed()) {
            return;
        }
        Node prev = follower.getNode(1);
        boolean reversed = true;
        if (follower.lastNode().equals(last)) {
            prev = follower.getNode(follower.getNodesCount() - 2);
            reversed = false;
        }
        if ((referrers = last.getReferrers()).size() < 2) {
            return;
        }
        Node newPoint = null;
        for (Way toFollow : Utils.filteredCollection(referrers, Way.class)) {
            if (toFollow.equals(follower)) continue;
            Set<Node> points = toFollow.getNeighbours(last);
            points.remove(prev);
            if (points.isEmpty()) continue;
            if (points.size() > 1) {
                return;
            }
            Node newPointCandidate = points.iterator().next();
            if (newPoint != null && newPoint != newPointCandidate) {
                return;
            }
            newPoint = newPointCandidate;
        }
        if (newPoint != null) {
            Way newFollower = new Way(follower);
            if (reversed) {
                newFollower.addNode(0, newPoint);
            } else {
                newFollower.addNode(newPoint);
            }
            MainApplication.undoRedo.add(new SequenceCommand(I18n.tr("Follow line", new Object[0]), new ChangeCommand(ds, follower, newFollower), new SelectCommand(ds, newFollower.isClosed() ? Arrays.asList(follower) : Arrays.asList(follower, newPoint))));
            if (DrawAction.VIEWPORT_FOLLOWING.get().booleanValue()) {
                map.mapView.smoothScrollTo(newPoint.getEastNorth());
            }
        }
    }
}

