/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callsite;

import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubySymbol;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.callsite.NormalCachingCallSite;

public class RespondToCallSite
extends NormalCachingCallSite {
    private volatile RespondToTuple respondToTuple = RespondToTuple.NULL_CACHE;
    private final String respondToName;
    private RubySymbol respondToNameSym;

    public RespondToCallSite() {
        super("respond_to?");
        this.respondToName = null;
    }

    public RespondToCallSite(String name2) {
        super("respond_to?");
        this.respondToName = name2;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject name2) {
        String strName;
        RespondToTuple tuple = this.respondToTuple;
        RubyClass klass = self2.getMetaClass();
        if (tuple.cacheOk(klass) && (strName = name2.asJavaString()).equals(tuple.name) && tuple.checkVisibility) {
            return tuple.respondsTo;
        }
        return super.call(context, caller2, self2, name2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject name2, IRubyObject bool2) {
        String strName;
        RespondToTuple tuple = this.respondToTuple;
        RubyClass klass = self2.getMetaClass();
        if (tuple.cacheOk(klass) && (strName = name2.asJavaString()).equals(tuple.name) && !bool2.isTrue() == tuple.checkVisibility) {
            return tuple.respondsTo;
        }
        return super.call(context, caller2, self2, name2, bool2);
    }

    public boolean respondsTo(ThreadContext context, IRubyObject caller2, IRubyObject self2) {
        String strName;
        RespondToTuple tuple = this.respondToTuple;
        RubyClass klass = self2.getMetaClass();
        if (tuple.cacheOk(klass) && (strName = this.respondToName).equals(tuple.name) && tuple.checkVisibility) {
            return tuple.respondsToBoolean;
        }
        return super.call(context, caller2, self2, (IRubyObject)this.getRespondToNameSym(context)).isTrue();
    }

    public boolean respondsTo(ThreadContext context, IRubyObject caller2, IRubyObject self2, boolean includePrivate) {
        String strName;
        RespondToTuple tuple = this.respondToTuple;
        RubyClass klass = self2.getMetaClass();
        if (tuple.cacheOk(klass) && (strName = this.respondToName).equals(tuple.name) && !includePrivate == tuple.checkVisibility) {
            return tuple.respondsToBoolean;
        }
        return super.call(context, caller2, self2, (IRubyObject)this.getRespondToNameSym(context), (IRubyObject)context.runtime.newBoolean(includePrivate)).isTrue();
    }

    private RubySymbol getRespondToNameSym(ThreadContext context) {
        RubySymbol sym = this.respondToNameSym;
        if (sym == null) {
            this.respondToNameSym = sym = context.runtime.newSymbol(this.respondToName);
        }
        return sym;
    }

    @Override
    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, ThreadContext context, IRubyObject self2, IRubyObject arg2) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method = entry.method;
        if (this.methodMissing(method, caller2)) {
            return this.callMethodMissing(context, self2, method, arg2);
        }
        if (entry.method.isBuiltin()) {
            String name2 = arg2.asJavaString();
            RespondToTuple tuple = RespondToCallSite.recacheRespondsTo(entry, name2, selfType, true, context);
            if (tuple.respondsTo.isTrue() || selfType.searchWithCache((String)"respond_to_missing?").method == context.runtime.getRespondToMissingMethod()) {
                this.respondToTuple = tuple;
                return tuple.respondsTo;
            }
        }
        this.cache = entry;
        return method.call(context, self2, (RubyModule)selfType, this.methodName, arg2);
    }

    @Override
    protected IRubyObject cacheAndCall(IRubyObject caller2, RubyClass selfType, ThreadContext context, IRubyObject self2, IRubyObject arg0, IRubyObject arg1) {
        CacheEntry entry = selfType.searchWithCache(this.methodName);
        DynamicMethod method = entry.method;
        if (this.methodMissing(method, caller2)) {
            return this.callMethodMissing(context, self2, method, arg0, arg1);
        }
        if (entry.method.equals(context.runtime.getRespondToMethod())) {
            String name2 = arg0.asJavaString();
            RespondToTuple tuple = RespondToCallSite.recacheRespondsTo(entry, name2, selfType, !arg1.isTrue(), context);
            if (tuple.respondsTo.isTrue() || selfType.searchWithCache((String)"respond_to_missing?").method == context.runtime.getRespondToMissingMethod()) {
                this.respondToTuple = tuple;
                return tuple.respondsTo;
            }
        }
        this.cache = entry;
        return method.call(context, self2, (RubyModule)selfType, this.methodName, arg0, arg1);
    }

    private static RespondToTuple recacheRespondsTo(CacheEntry respondToMethod, String newString, RubyClass klass, boolean checkVisibility, ThreadContext context) {
        CacheEntry respondToLookupResult = klass.searchWithCache(newString);
        boolean respondsTo = Helpers.respondsToMethod(respondToLookupResult.method, checkVisibility);
        return new RespondToTuple(newString, checkVisibility, respondToMethod, respondToLookupResult, context.runtime.newBoolean(respondsTo));
    }

    private static class RespondToTuple {
        static final RespondToTuple NULL_CACHE = new RespondToTuple("", true, CacheEntry.NULL_CACHE, CacheEntry.NULL_CACHE);
        public final String name;
        public final boolean checkVisibility;
        public final CacheEntry respondToMethod;
        public final CacheEntry entry;
        public final IRubyObject respondsTo;
        public final boolean respondsToBoolean;

        public RespondToTuple(String name2, boolean checkVisibility, CacheEntry respondToMethod, CacheEntry entry, IRubyObject respondsTo) {
            this.name = name2;
            this.checkVisibility = checkVisibility;
            this.respondToMethod = respondToMethod;
            this.entry = entry;
            this.respondsTo = respondsTo;
            this.respondsToBoolean = respondsTo.isTrue();
        }

        public RespondToTuple(String name2, boolean checkVisibility, CacheEntry respondToMethod, CacheEntry entry) {
            this.name = name2;
            this.checkVisibility = checkVisibility;
            this.respondToMethod = respondToMethod;
            this.entry = entry;
            this.respondsTo = null;
            this.respondsToBoolean = false;
        }

        public boolean cacheOk(RubyClass klass) {
            return this.respondToMethod.typeOk(klass) && this.entry.typeOk(klass);
        }
    }
}

