/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidApplicationException;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.StringValueExp;

class InstanceOfQueryExp
extends QueryEval
implements QueryExp {
    private static final long serialVersionUID = -1081892073854801359L;
    private StringValueExp classNameValue;

    public InstanceOfQueryExp(StringValueExp classNameValue) {
        if (classNameValue == null) {
            throw new IllegalArgumentException("Null class name.");
        }
        this.classNameValue = classNameValue;
    }

    public StringValueExp getClassNameValue() {
        return this.classNameValue;
    }

    @Override
    public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        StringValueExp val;
        try {
            val = (StringValueExp)this.classNameValue.apply(name);
        }
        catch (ClassCastException x) {
            BadStringOperationException y = new BadStringOperationException(x.toString());
            y.initCause(x);
            throw y;
        }
        try {
            return InstanceOfQueryExp.getMBeanServer().isInstanceOf(name, val.getValue());
        }
        catch (InstanceNotFoundException infe) {
            return false;
        }
    }

    public String toString() {
        return "InstanceOf " + this.classNameValue.toString();
    }
}

