/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.GetPropertyAction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AccessController;
import java.util.logging.Level;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;

public class ModelMBeanInfoSupport
extends MBeanInfo
implements ModelMBeanInfo {
    private static final long oldSerialVersionUID = -3944083498453227709L;
    private static final long newSerialVersionUID = -1935722590756516193L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("modelMBeanDescriptor", Descriptor.class), new ObjectStreamField("mmbAttributes", MBeanAttributeInfo[].class), new ObjectStreamField("mmbConstructors", MBeanConstructorInfo[].class), new ObjectStreamField("mmbNotifications", MBeanNotificationInfo[].class), new ObjectStreamField("mmbOperations", MBeanOperationInfo[].class), new ObjectStreamField("currClass", String.class)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("modelMBeanDescriptor", Descriptor.class), new ObjectStreamField("modelMBeanAttributes", MBeanAttributeInfo[].class), new ObjectStreamField("modelMBeanConstructors", MBeanConstructorInfo[].class), new ObjectStreamField("modelMBeanNotifications", MBeanNotificationInfo[].class), new ObjectStreamField("modelMBeanOperations", MBeanOperationInfo[].class)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    private Descriptor modelMBeanDescriptor;
    private MBeanAttributeInfo[] modelMBeanAttributes;
    private MBeanConstructorInfo[] modelMBeanConstructors;
    private MBeanNotificationInfo[] modelMBeanNotifications;
    private MBeanOperationInfo[] modelMBeanOperations;
    private static final String ATTR = "attribute";
    private static final String OPER = "operation";
    private static final String NOTF = "notification";
    private static final String CONS = "constructor";
    private static final String MMB = "mbean";
    private static final String ALL = "all";
    private static final String currClass = "ModelMBeanInfoSupport";
    private static final ModelMBeanAttributeInfo[] NO_ATTRIBUTES;
    private static final ModelMBeanConstructorInfo[] NO_CONSTRUCTORS;
    private static final ModelMBeanNotificationInfo[] NO_NOTIFICATIONS;
    private static final ModelMBeanOperationInfo[] NO_OPERATIONS;

    public ModelMBeanInfoSupport(ModelMBeanInfo mbi) {
        block3: {
            super(mbi.getClassName(), mbi.getDescription(), mbi.getAttributes(), mbi.getConstructors(), mbi.getOperations(), mbi.getNotifications());
            this.modelMBeanDescriptor = null;
            this.modelMBeanAttributes = mbi.getAttributes();
            this.modelMBeanConstructors = mbi.getConstructors();
            this.modelMBeanOperations = mbi.getOperations();
            this.modelMBeanNotifications = mbi.getNotifications();
            try {
                Descriptor mbeandescriptor = mbi.getMBeanDescriptor();
                this.modelMBeanDescriptor = this.validDescriptor(mbeandescriptor);
            }
            catch (MBeanException mbe) {
                this.modelMBeanDescriptor = this.validDescriptor(null);
                if (!JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) break block3;
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "ModelMBeanInfo(ModelMBeanInfo)", "Could not get a valid modelMBeanDescriptor, setting a default Descriptor");
            }
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "ModelMBeanInfo(ModelMBeanInfo)", "Exit");
        }
    }

    public ModelMBeanInfoSupport(String className, String description, ModelMBeanAttributeInfo[] attributes, ModelMBeanConstructorInfo[] constructors, ModelMBeanOperationInfo[] operations, ModelMBeanNotificationInfo[] notifications) {
        this(className, description, attributes, constructors, operations, notifications, (Descriptor)null);
    }

    public ModelMBeanInfoSupport(String className, String description, ModelMBeanAttributeInfo[] attributes, ModelMBeanConstructorInfo[] constructors, ModelMBeanOperationInfo[] operations, ModelMBeanNotificationInfo[] notifications, Descriptor mbeandescriptor) {
        super(className, description, attributes != null ? attributes : NO_ATTRIBUTES, constructors != null ? constructors : NO_CONSTRUCTORS, operations != null ? operations : NO_OPERATIONS, notifications != null ? notifications : NO_NOTIFICATIONS);
        this.modelMBeanDescriptor = null;
        this.modelMBeanAttributes = attributes;
        this.modelMBeanConstructors = constructors;
        this.modelMBeanOperations = operations;
        this.modelMBeanNotifications = notifications;
        this.modelMBeanDescriptor = this.validDescriptor(mbeandescriptor);
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "ModelMBeanInfoSupport(String,String,ModelMBeanAttributeInfo[],ModelMBeanConstructorInfo[],ModelMBeanOperationInfo[],ModelMBeanNotificationInfo[],Descriptor)", "Exit");
        }
    }

    @Override
    public Object clone() {
        return new ModelMBeanInfoSupport(this);
    }

    @Override
    public Descriptor[] getDescriptors(String inDescriptorType) throws MBeanException, RuntimeOperationsException {
        Descriptor[] retList;
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getDescriptors(String)", "Entry");
        }
        if (inDescriptorType == null || inDescriptorType.equals("")) {
            inDescriptorType = ALL;
        }
        if (inDescriptorType.equalsIgnoreCase(MMB)) {
            retList = new Descriptor[]{this.modelMBeanDescriptor};
        } else if (inDescriptorType.equalsIgnoreCase(ATTR)) {
            MBeanAttributeInfo[] attrList = this.modelMBeanAttributes;
            int numAttrs = 0;
            if (attrList != null) {
                numAttrs = attrList.length;
            }
            retList = new Descriptor[numAttrs];
            for (int i = 0; i < numAttrs; ++i) {
                retList[i] = ((ModelMBeanAttributeInfo)attrList[i]).getDescriptor();
            }
        } else if (inDescriptorType.equalsIgnoreCase(OPER)) {
            MBeanOperationInfo[] operList = this.modelMBeanOperations;
            int numOpers = 0;
            if (operList != null) {
                numOpers = operList.length;
            }
            retList = new Descriptor[numOpers];
            for (int i = 0; i < numOpers; ++i) {
                retList[i] = ((ModelMBeanOperationInfo)operList[i]).getDescriptor();
            }
        } else if (inDescriptorType.equalsIgnoreCase(CONS)) {
            MBeanConstructorInfo[] consList = this.modelMBeanConstructors;
            int numCons = 0;
            if (consList != null) {
                numCons = consList.length;
            }
            retList = new Descriptor[numCons];
            for (int i = 0; i < numCons; ++i) {
                retList[i] = ((ModelMBeanConstructorInfo)consList[i]).getDescriptor();
            }
        } else if (inDescriptorType.equalsIgnoreCase(NOTF)) {
            MBeanNotificationInfo[] notifList = this.modelMBeanNotifications;
            int numNotifs = 0;
            if (notifList != null) {
                numNotifs = notifList.length;
            }
            retList = new Descriptor[numNotifs];
            for (int i = 0; i < numNotifs; ++i) {
                retList[i] = ((ModelMBeanNotificationInfo)notifList[i]).getDescriptor();
            }
        } else if (inDescriptorType.equalsIgnoreCase(ALL)) {
            int i;
            MBeanAttributeInfo[] attrList = this.modelMBeanAttributes;
            int numAttrs = 0;
            if (attrList != null) {
                numAttrs = attrList.length;
            }
            MBeanOperationInfo[] operList = this.modelMBeanOperations;
            int numOpers = 0;
            if (operList != null) {
                numOpers = operList.length;
            }
            MBeanConstructorInfo[] consList = this.modelMBeanConstructors;
            int numCons = 0;
            if (consList != null) {
                numCons = consList.length;
            }
            MBeanNotificationInfo[] notifList = this.modelMBeanNotifications;
            int numNotifs = 0;
            if (notifList != null) {
                numNotifs = notifList.length;
            }
            int count = numAttrs + numCons + numOpers + numNotifs + 1;
            retList = new Descriptor[count];
            retList[count - 1] = this.modelMBeanDescriptor;
            int j = 0;
            for (i = 0; i < numAttrs; ++i) {
                retList[j] = ((ModelMBeanAttributeInfo)attrList[i]).getDescriptor();
                ++j;
            }
            for (i = 0; i < numCons; ++i) {
                retList[j] = ((ModelMBeanConstructorInfo)consList[i]).getDescriptor();
                ++j;
            }
            for (i = 0; i < numOpers; ++i) {
                retList[j] = ((ModelMBeanOperationInfo)operList[i]).getDescriptor();
                ++j;
            }
            for (i = 0; i < numNotifs; ++i) {
                retList[j] = ((ModelMBeanNotificationInfo)notifList[i]).getDescriptor();
                ++j;
            }
        } else {
            IllegalArgumentException iae = new IllegalArgumentException("Descriptor Type is invalid");
            String msg = "Exception occurred trying to find the descriptors of the MBean";
            throw new RuntimeOperationsException(iae, "Exception occurred trying to find the descriptors of the MBean");
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getDescriptors(String)", "Exit");
        }
        return retList;
    }

    @Override
    public void setDescriptors(Descriptor[] inDescriptors) throws MBeanException, RuntimeOperationsException {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "setDescriptors(Descriptor[])", "Entry");
        }
        if (inDescriptors == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Descriptor list is invalid"), "Exception occurred trying to set the descriptors of the MBeanInfo");
        }
        if (inDescriptors.length == 0) {
            return;
        }
        for (int j = 0; j < inDescriptors.length; ++j) {
            this.setDescriptor(inDescriptors[j], null);
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "setDescriptors(Descriptor[])", "Exit");
        }
    }

    public Descriptor getDescriptor(String inDescriptorName) throws MBeanException, RuntimeOperationsException {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getDescriptor(String)", "Entry");
        }
        return this.getDescriptor(inDescriptorName, null);
    }

    @Override
    public Descriptor getDescriptor(String inDescriptorName, String inDescriptorType) throws MBeanException, RuntimeOperationsException {
        MBeanFeatureInfo oper;
        if (inDescriptorName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Descriptor is invalid"), "Exception occurred trying to set the descriptors of the MBeanInfo");
        }
        if (MMB.equalsIgnoreCase(inDescriptorType)) {
            return (Descriptor)this.modelMBeanDescriptor.clone();
        }
        if (ATTR.equalsIgnoreCase(inDescriptorType) || inDescriptorType == null) {
            ModelMBeanAttributeInfo attr = this.getAttribute(inDescriptorName);
            if (attr != null) {
                return attr.getDescriptor();
            }
            if (inDescriptorType != null) {
                return null;
            }
        }
        if (OPER.equalsIgnoreCase(inDescriptorType) || inDescriptorType == null) {
            oper = this.getOperation(inDescriptorName);
            if (oper != null) {
                return ((ModelMBeanOperationInfo)oper).getDescriptor();
            }
            if (inDescriptorType != null) {
                return null;
            }
        }
        if (CONS.equalsIgnoreCase(inDescriptorType) || inDescriptorType == null) {
            oper = this.getConstructor(inDescriptorName);
            if (oper != null) {
                return ((ModelMBeanConstructorInfo)oper).getDescriptor();
            }
            if (inDescriptorType != null) {
                return null;
            }
        }
        if (NOTF.equalsIgnoreCase(inDescriptorType) || inDescriptorType == null) {
            ModelMBeanNotificationInfo notif = this.getNotification(inDescriptorName);
            if (notif != null) {
                return notif.getDescriptor();
            }
            if (inDescriptorType != null) {
                return null;
            }
        }
        if (inDescriptorType == null) {
            return null;
        }
        throw new RuntimeOperationsException(new IllegalArgumentException("Descriptor Type is invalid"), "Exception occurred trying to find the descriptors of the MBean");
    }

    @Override
    public void setDescriptor(Descriptor inDescriptor, String inDescriptorType) throws MBeanException, RuntimeOperationsException {
        String inDescriptorName;
        String excMsg = "Exception occurred trying to set the descriptors of the MBean";
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "setDescriptor(Descriptor,String)", "Entry");
        }
        if (inDescriptor == null) {
            inDescriptor = new DescriptorSupport();
        }
        if ((inDescriptorType == null || inDescriptorType.equals("")) && (inDescriptorType = (String)inDescriptor.getFieldValue("descriptorType")) == null) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "setDescriptor(Descriptor,String)", "descriptorType null in both String parameter and Descriptor, defaulting to mbean");
            inDescriptorType = MMB;
        }
        if ((inDescriptorName = (String)inDescriptor.getFieldValue("name")) == null) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "setDescriptor(Descriptor,String)", "descriptor name null, defaulting to " + this.getClassName());
            inDescriptorName = this.getClassName();
        }
        boolean found = false;
        if (inDescriptorType.equalsIgnoreCase(MMB)) {
            this.setMBeanDescriptor(inDescriptor);
            found = true;
        } else if (inDescriptorType.equalsIgnoreCase(ATTR)) {
            MBeanAttributeInfo[] attrList = this.modelMBeanAttributes;
            int numAttrs = 0;
            if (attrList != null) {
                numAttrs = attrList.length;
            }
            for (int i = 0; i < numAttrs; ++i) {
                if (!inDescriptorName.equals(attrList[i].getName())) continue;
                found = true;
                ModelMBeanAttributeInfo mmbai = (ModelMBeanAttributeInfo)attrList[i];
                mmbai.setDescriptor(inDescriptor);
                if (!JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) continue;
                StringBuilder strb = new StringBuilder().append("Setting descriptor to ").append(inDescriptor).append("\t\n local: AttributeInfo descriptor is ").append(mmbai.getDescriptor()).append("\t\n modelMBeanInfo: AttributeInfo descriptor is ").append(this.getDescriptor(inDescriptorName, ATTR));
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "setDescriptor(Descriptor,String)", strb.toString());
            }
        } else if (inDescriptorType.equalsIgnoreCase(OPER)) {
            MBeanOperationInfo[] operList = this.modelMBeanOperations;
            int numOpers = 0;
            if (operList != null) {
                numOpers = operList.length;
            }
            for (int i = 0; i < numOpers; ++i) {
                if (!inDescriptorName.equals(operList[i].getName())) continue;
                found = true;
                ModelMBeanOperationInfo mmboi = (ModelMBeanOperationInfo)operList[i];
                mmboi.setDescriptor(inDescriptor);
            }
        } else if (inDescriptorType.equalsIgnoreCase(CONS)) {
            MBeanConstructorInfo[] consList = this.modelMBeanConstructors;
            int numCons = 0;
            if (consList != null) {
                numCons = consList.length;
            }
            for (int i = 0; i < numCons; ++i) {
                if (!inDescriptorName.equals(consList[i].getName())) continue;
                found = true;
                ModelMBeanConstructorInfo mmbci = (ModelMBeanConstructorInfo)consList[i];
                mmbci.setDescriptor(inDescriptor);
            }
        } else if (inDescriptorType.equalsIgnoreCase(NOTF)) {
            MBeanNotificationInfo[] notifList = this.modelMBeanNotifications;
            int numNotifs = 0;
            if (notifList != null) {
                numNotifs = notifList.length;
            }
            for (int i = 0; i < numNotifs; ++i) {
                if (!inDescriptorName.equals(notifList[i].getName())) continue;
                found = true;
                ModelMBeanNotificationInfo mmbni = (ModelMBeanNotificationInfo)notifList[i];
                mmbni.setDescriptor(inDescriptor);
            }
        } else {
            IllegalArgumentException iae = new IllegalArgumentException("Invalid descriptor type: " + inDescriptorType);
            throw new RuntimeOperationsException(iae, "Exception occurred trying to set the descriptors of the MBean");
        }
        if (!found) {
            IllegalArgumentException iae = new IllegalArgumentException("Descriptor name is invalid: type=" + inDescriptorType + "; name=" + inDescriptorName);
            throw new RuntimeOperationsException(iae, "Exception occurred trying to set the descriptors of the MBean");
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "setDescriptor(Descriptor,String)", "Exit");
        }
    }

    @Override
    public ModelMBeanAttributeInfo getAttribute(String inName) throws MBeanException, RuntimeOperationsException {
        ModelMBeanAttributeInfo retInfo = null;
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getAttribute(String)", "Entry");
        }
        if (inName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute Name is null"), "Exception occurred trying to get the ModelMBeanAttributeInfo of the MBean");
        }
        MBeanAttributeInfo[] attrList = this.modelMBeanAttributes;
        int numAttrs = 0;
        if (attrList != null) {
            numAttrs = attrList.length;
        }
        for (int i = 0; i < numAttrs && retInfo == null; ++i) {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
                StringBuilder strb = new StringBuilder().append("\t\n this.getAttributes() MBeanAttributeInfo Array ").append(i).append(":").append(((ModelMBeanAttributeInfo)attrList[i]).getDescriptor()).append("\t\n this.modelMBeanAttributes MBeanAttributeInfo Array ").append(i).append(":").append(((ModelMBeanAttributeInfo)this.modelMBeanAttributes[i]).getDescriptor());
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getAttribute(String)", strb.toString());
            }
            if (!inName.equals(attrList[i].getName())) continue;
            retInfo = (ModelMBeanAttributeInfo)attrList[i].clone();
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getAttribute(String)", "Exit");
        }
        return retInfo;
    }

    @Override
    public ModelMBeanOperationInfo getOperation(String inName) throws MBeanException, RuntimeOperationsException {
        ModelMBeanOperationInfo retInfo = null;
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getOperation(String)", "Entry");
        }
        if (inName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("inName is null"), "Exception occurred trying to get the ModelMBeanOperationInfo of the MBean");
        }
        MBeanOperationInfo[] operList = this.modelMBeanOperations;
        int numOpers = 0;
        if (operList != null) {
            numOpers = operList.length;
        }
        for (int i = 0; i < numOpers && retInfo == null; ++i) {
            if (!inName.equals(operList[i].getName())) continue;
            retInfo = (ModelMBeanOperationInfo)operList[i].clone();
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getOperation(String)", "Exit");
        }
        return retInfo;
    }

    public ModelMBeanConstructorInfo getConstructor(String inName) throws MBeanException, RuntimeOperationsException {
        ModelMBeanConstructorInfo retInfo = null;
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getConstructor(String)", "Entry");
        }
        if (inName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Constructor name is null"), "Exception occurred trying to get the ModelMBeanConstructorInfo of the MBean");
        }
        MBeanConstructorInfo[] consList = this.modelMBeanConstructors;
        int numCons = 0;
        if (consList != null) {
            numCons = consList.length;
        }
        for (int i = 0; i < numCons && retInfo == null; ++i) {
            if (!inName.equals(consList[i].getName())) continue;
            retInfo = (ModelMBeanConstructorInfo)consList[i].clone();
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getConstructor(String)", "Exit");
        }
        return retInfo;
    }

    @Override
    public ModelMBeanNotificationInfo getNotification(String inName) throws MBeanException, RuntimeOperationsException {
        ModelMBeanNotificationInfo retInfo = null;
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getNotification(String)", "Entry");
        }
        if (inName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Notification name is null"), "Exception occurred trying to get the ModelMBeanNotificationInfo of the MBean");
        }
        MBeanNotificationInfo[] notifList = this.modelMBeanNotifications;
        int numNotifs = 0;
        if (notifList != null) {
            numNotifs = notifList.length;
        }
        for (int i = 0; i < numNotifs && retInfo == null; ++i) {
            if (!inName.equals(notifList[i].getName())) continue;
            retInfo = (ModelMBeanNotificationInfo)notifList[i].clone();
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getNotification(String)", "Exit");
        }
        return retInfo;
    }

    @Override
    public Descriptor getDescriptor() {
        return this.getMBeanDescriptorNoException();
    }

    @Override
    public Descriptor getMBeanDescriptor() throws MBeanException {
        return this.getMBeanDescriptorNoException();
    }

    private Descriptor getMBeanDescriptorNoException() {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getMBeanDescriptorNoException()", "Entry");
        }
        if (this.modelMBeanDescriptor == null) {
            this.modelMBeanDescriptor = this.validDescriptor(null);
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "getMBeanDescriptorNoException()", "Exit, returning: " + this.modelMBeanDescriptor);
        }
        return (Descriptor)this.modelMBeanDescriptor.clone();
    }

    @Override
    public void setMBeanDescriptor(Descriptor inMBeanDescriptor) throws MBeanException, RuntimeOperationsException {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanInfoSupport.class.getName(), "setMBeanDescriptor(Descriptor)", "Entry");
        }
        this.modelMBeanDescriptor = this.validDescriptor(inMBeanDescriptor);
    }

    private Descriptor validDescriptor(Descriptor in) throws RuntimeOperationsException {
        Descriptor clone;
        boolean defaulted;
        boolean bl = defaulted = in == null;
        if (defaulted) {
            clone = new DescriptorSupport();
            JmxProperties.MODELMBEAN_LOGGER.finer("Null Descriptor, creating new.");
        } else {
            clone = (Descriptor)in.clone();
        }
        if (defaulted && clone.getFieldValue("name") == null) {
            clone.setField("name", this.getClassName());
            JmxProperties.MODELMBEAN_LOGGER.finer("Defaulting Descriptor name to " + this.getClassName());
        }
        if (defaulted && clone.getFieldValue("descriptorType") == null) {
            clone.setField("descriptorType", MMB);
            JmxProperties.MODELMBEAN_LOGGER.finer("Defaulting descriptorType to \"mbean\"");
        }
        if (clone.getFieldValue("displayName") == null) {
            clone.setField("displayName", this.getClassName());
            JmxProperties.MODELMBEAN_LOGGER.finer("Defaulting Descriptor displayName to " + this.getClassName());
        }
        if (clone.getFieldValue("persistPolicy") == null) {
            clone.setField("persistPolicy", "never");
            JmxProperties.MODELMBEAN_LOGGER.finer("Defaulting Descriptor persistPolicy to \"never\"");
        }
        if (clone.getFieldValue("log") == null) {
            clone.setField("log", "F");
            JmxProperties.MODELMBEAN_LOGGER.finer("Defaulting Descriptor \"log\" field to \"F\"");
        }
        if (clone.getFieldValue("visibility") == null) {
            clone.setField("visibility", "1");
            JmxProperties.MODELMBEAN_LOGGER.finer("Defaulting Descriptor visibility to 1");
        }
        if (!clone.isValid()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid Descriptor argument"), "The isValid() method of the Descriptor object itself returned false,one or more required fields are invalid. Descriptor:" + clone.toString());
        }
        if (!((String)clone.getFieldValue("descriptorType")).equalsIgnoreCase(MMB)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid Descriptor argument"), "The Descriptor \"descriptorType\" field does not match the object described.  Expected: mbean , was: " + clone.getFieldValue("descriptorType"));
        }
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (compat) {
            ObjectInputStream.GetField fields = in.readFields();
            this.modelMBeanDescriptor = (Descriptor)fields.get("modelMBeanDescriptor", null);
            if (fields.defaulted("modelMBeanDescriptor")) {
                throw new NullPointerException("modelMBeanDescriptor");
            }
            this.modelMBeanAttributes = (MBeanAttributeInfo[])fields.get("mmbAttributes", null);
            if (fields.defaulted("mmbAttributes")) {
                throw new NullPointerException("mmbAttributes");
            }
            this.modelMBeanConstructors = (MBeanConstructorInfo[])fields.get("mmbConstructors", null);
            if (fields.defaulted("mmbConstructors")) {
                throw new NullPointerException("mmbConstructors");
            }
            this.modelMBeanNotifications = (MBeanNotificationInfo[])fields.get("mmbNotifications", null);
            if (fields.defaulted("mmbNotifications")) {
                throw new NullPointerException("mmbNotifications");
            }
            this.modelMBeanOperations = (MBeanOperationInfo[])fields.get("mmbOperations", null);
            if (fields.defaulted("mmbOperations")) {
                throw new NullPointerException("mmbOperations");
            }
        } else {
            in.defaultReadObject();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField fields = out.putFields();
            fields.put("modelMBeanDescriptor", this.modelMBeanDescriptor);
            fields.put("mmbAttributes", this.modelMBeanAttributes);
            fields.put("mmbConstructors", this.modelMBeanConstructors);
            fields.put("mmbNotifications", this.modelMBeanNotifications);
            fields.put("mmbOperations", this.modelMBeanOperations);
            fields.put("currClass", currClass);
            out.writeFields();
        } else {
            out.defaultWriteObject();
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction act = new GetPropertyAction("jmx.serial.form");
            String form = AccessController.doPrivileged(act);
            compat = form != null && form.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = -3944083498453227709L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = -1935722590756516193L;
        }
        NO_ATTRIBUTES = new ModelMBeanAttributeInfo[0];
        NO_CONSTRUCTORS = new ModelMBeanConstructorInfo[0];
        NO_NOTIFICATIONS = new ModelMBeanNotificationInfo[0];
        NO_OPERATIONS = new ModelMBeanOperationInfo[0];
    }
}

