/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.misc.ExtensionInfo;
import sun.misc.ExtensionInstallationException;
import sun.misc.ExtensionInstallationProvider;
import sun.misc.JarFilter;
import sun.misc.Launcher;
import sun.net.www.ParseUtil;
import sun.security.action.GetPropertyAction;

public class ExtensionDependency {
    private static Vector providers;
    static final boolean DEBUG = false;

    public static synchronized void addExtensionInstallationProvider(ExtensionInstallationProvider eip) {
        if (providers == null) {
            providers = new Vector();
        }
        providers.add(eip);
    }

    public static synchronized void removeExtensionInstallationProvider(ExtensionInstallationProvider eip) {
        providers.remove(eip);
    }

    public static boolean checkExtensionsDependencies(JarFile jar2) {
        if (providers == null) {
            return true;
        }
        try {
            ExtensionDependency extDep = new ExtensionDependency();
            return extDep.checkExtensions(jar2);
        }
        catch (ExtensionInstallationException e) {
            ExtensionDependency.debug(e.getMessage());
            return false;
        }
    }

    protected boolean checkExtensions(JarFile jar2) throws ExtensionInstallationException {
        Manifest man;
        try {
            man = jar2.getManifest();
        }
        catch (IOException e) {
            return false;
        }
        if (man == null) {
            return true;
        }
        boolean result = true;
        Attributes attr = man.getMainAttributes();
        if (attr != null) {
            String value = attr.getValue(Attributes.Name.EXTENSION_LIST);
            if (value != null) {
                StringTokenizer st = new StringTokenizer(value);
                while (st.hasMoreTokens()) {
                    String extensionName = st.nextToken();
                    ExtensionDependency.debug("The file " + jar2.getName() + " appears to depend on " + extensionName);
                    String extName = extensionName + "-" + Attributes.Name.EXTENSION_NAME.toString();
                    if (attr.getValue(extName) == null) {
                        ExtensionDependency.debug("The jar file " + jar2.getName() + " appers to depend on " + extensionName + " but does not define the " + extName + " attribute in its manifest ");
                        continue;
                    }
                    if (this.checkExtension(extensionName, attr)) continue;
                    ExtensionDependency.debug("Failed installing " + extensionName);
                    result = false;
                }
            } else {
                ExtensionDependency.debug("No dependencies for " + jar2.getName());
            }
        }
        return result;
    }

    protected synchronized boolean checkExtension(String extensionName, Attributes attr) throws ExtensionInstallationException {
        ExtensionDependency.debug("Checking extension " + extensionName);
        if (this.checkExtensionAgainstInstalled(extensionName, attr)) {
            return true;
        }
        ExtensionDependency.debug("Extension not currently installed ");
        ExtensionInfo reqInfo = new ExtensionInfo(extensionName, attr);
        return this.installExtension(reqInfo, null);
    }

    boolean checkExtensionAgainstInstalled(String extensionName, Attributes attr) throws ExtensionInstallationException {
        File[] installedExts;
        File fExtension = this.checkExtensionExists(extensionName);
        if (fExtension != null) {
            try {
                if (this.checkExtensionAgainst(extensionName, attr, fExtension)) {
                    return true;
                }
            }
            catch (FileNotFoundException e) {
                this.debugException(e);
            }
            catch (IOException e) {
                this.debugException(e);
            }
            return false;
        }
        try {
            installedExts = this.getInstalledExtensions();
        }
        catch (IOException e) {
            this.debugException(e);
            return false;
        }
        for (int i = 0; i < installedExts.length; ++i) {
            try {
                if (!this.checkExtensionAgainst(extensionName, attr, installedExts[i])) continue;
                return true;
            }
            catch (FileNotFoundException e) {
                this.debugException(e);
                continue;
            }
            catch (IOException e) {
                this.debugException(e);
            }
        }
        return false;
    }

    protected boolean checkExtensionAgainst(String extensionName, Attributes attr, final File file) throws IOException, FileNotFoundException, ExtensionInstallationException {
        Attributes instAttr;
        Manifest man;
        ExtensionDependency.debug("Checking extension " + extensionName + " against " + file.getName());
        try {
            man = AccessController.doPrivileged(new PrivilegedExceptionAction<Manifest>(){

                @Override
                public Manifest run() throws IOException, FileNotFoundException {
                    if (!file.exists()) {
                        throw new FileNotFoundException(file.getName());
                    }
                    JarFile jarFile = new JarFile(file);
                    return jarFile.getManifest();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof FileNotFoundException) {
                throw (FileNotFoundException)e.getException();
            }
            throw (IOException)e.getException();
        }
        ExtensionInfo reqInfo = new ExtensionInfo(extensionName, attr);
        ExtensionDependency.debug("Requested Extension : " + reqInfo);
        int isCompatible = 4;
        ExtensionInfo instInfo = null;
        if (man != null && (instAttr = man.getMainAttributes()) != null) {
            instInfo = new ExtensionInfo(null, instAttr);
            ExtensionDependency.debug("Extension Installed " + instInfo);
            isCompatible = instInfo.isCompatibleWith(reqInfo);
            switch (isCompatible) {
                case 0: {
                    ExtensionDependency.debug("Extensions are compatible");
                    return true;
                }
                case 4: {
                    ExtensionDependency.debug("Extensions are incompatible");
                    return false;
                }
            }
            ExtensionDependency.debug("Extensions require an upgrade or vendor switch");
            return this.installExtension(reqInfo, instInfo);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean installExtension(ExtensionInfo reqInfo, ExtensionInfo instInfo) throws ExtensionInstallationException {
        Vector currentProviders;
        Vector vector = providers;
        synchronized (vector) {
            currentProviders = (Vector)providers.clone();
        }
        Enumeration e = currentProviders.elements();
        while (e.hasMoreElements()) {
            ExtensionInstallationProvider eip = (ExtensionInstallationProvider)e.nextElement();
            if (eip == null || !eip.installExtension(reqInfo, instInfo)) continue;
            ExtensionDependency.debug(reqInfo.name + " installation successful");
            Launcher.ExtClassLoader cl = (Launcher.ExtClassLoader)Launcher.getLauncher().getClassLoader().getParent();
            this.addNewExtensionsToClassLoader(cl);
            return true;
        }
        ExtensionDependency.debug(reqInfo.name + " installation failed");
        return false;
    }

    private File checkExtensionExists(String extensionName) {
        final String extName = extensionName;
        final String[] fileExt = new String[]{".jar", ".zip"};
        return AccessController.doPrivileged(new PrivilegedAction<File>(){

            @Override
            public File run() {
                try {
                    File[] dirs = ExtensionDependency.getExtDirs();
                    for (int i = 0; i < dirs.length; ++i) {
                        for (int j = 0; j < fileExt.length; ++j) {
                            File fExtension = extName.toLowerCase().endsWith(fileExt[j]) ? new File(dirs[i], extName) : new File(dirs[i], extName + fileExt[j]);
                            ExtensionDependency.debug("checkExtensionExists:fileName " + fExtension.getName());
                            if (!fExtension.exists()) continue;
                            return fExtension;
                        }
                    }
                    return null;
                }
                catch (Exception e) {
                    ExtensionDependency.this.debugException(e);
                    return null;
                }
            }
        });
    }

    private static File[] getExtDirs() {
        File[] dirs;
        String s = AccessController.doPrivileged(new GetPropertyAction("java.ext.dirs"));
        if (s != null) {
            StringTokenizer st = new StringTokenizer(s, File.pathSeparator);
            int count = st.countTokens();
            ExtensionDependency.debug("getExtDirs count " + count);
            dirs = new File[count];
            for (int i = 0; i < count; ++i) {
                dirs[i] = new File(st.nextToken());
                ExtensionDependency.debug("getExtDirs dirs[" + i + "] " + dirs[i]);
            }
        } else {
            dirs = new File[]{};
            ExtensionDependency.debug("getExtDirs dirs " + dirs);
        }
        ExtensionDependency.debug("getExtDirs dirs.length " + dirs.length);
        return dirs;
    }

    private static File[] getExtFiles(File[] dirs) throws IOException {
        Vector<File> urls = new Vector<File>();
        for (int i = 0; i < dirs.length; ++i) {
            String[] files = dirs[i].list(new JarFilter());
            if (files == null) continue;
            ExtensionDependency.debug("getExtFiles files.length " + files.length);
            for (int j = 0; j < files.length; ++j) {
                File f = new File(dirs[i], files[j]);
                urls.add(f);
                ExtensionDependency.debug("getExtFiles f[" + j + "] " + f);
            }
        }
        Object[] ua = new File[urls.size()];
        urls.copyInto(ua);
        ExtensionDependency.debug("getExtFiles ua.length " + ua.length);
        return ua;
    }

    private File[] getInstalledExtensions() throws IOException {
        return AccessController.doPrivileged(new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                try {
                    return ExtensionDependency.getExtFiles(ExtensionDependency.getExtDirs());
                }
                catch (IOException e) {
                    ExtensionDependency.debug("Cannot get list of installed extensions");
                    ExtensionDependency.this.debugException(e);
                    return new File[0];
                }
            }
        });
    }

    private Boolean addNewExtensionsToClassLoader(Launcher.ExtClassLoader cl) {
        try {
            File[] installedExts = this.getInstalledExtensions();
            for (int i = 0; i < installedExts.length; ++i) {
                final File instFile = installedExts[i];
                URL instURL = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                    @Override
                    public URL run() {
                        try {
                            return ParseUtil.fileToEncodedURL(instFile);
                        }
                        catch (MalformedURLException e) {
                            ExtensionDependency.this.debugException(e);
                            return null;
                        }
                    }
                });
                if (instURL == null) continue;
                URL[] urls = cl.getURLs();
                boolean found = false;
                for (int j = 0; j < urls.length; ++j) {
                    ExtensionDependency.debug("URL[" + j + "] is " + urls[j] + " looking for " + instURL);
                    if (urls[j].toString().compareToIgnoreCase(instURL.toString()) != 0) continue;
                    found = true;
                    ExtensionDependency.debug("Found !");
                }
                if (found) continue;
                ExtensionDependency.debug("Not Found ! adding to the classloader " + instURL);
                cl.addExtURL(instURL);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Boolean.TRUE;
    }

    private static void debug(String s) {
    }

    private void debugException(Throwable e) {
    }
}

