if {0} {
  /*
    * This file is part of din.
    *
    * din is copyright (c) 2006 - 2018 Jagannathan Sampath <jag@dinisnoise.org>
    * For more information, please visit http://dinisnoise.org
    *
    *
  */
}

proc after-fade {} {}

proc sounder-left {hz {vol 0} {bias 1}} { ;# create sounder at hz with left channel volume
	sounder create $hz $vol 0 $bias ;# bias = 1 for left
}

proc sounder-right {hz {vol 0} {bias 2}} { ;# create sounder at hz with right channel volume
	sounder create $hz 0 $vol $bias ;# bias = 2 for right
}

proc create-binaural-pair {hz {separation 1} {justification l}} {
	if [string equal $justification l] { ;# hz to left 
		sounder-left $hz
		sounder-right [+ $hz $separation]
	} elseif [string equal $justification r] { ;# hz to right
    sounder-left [- $hz $separation]
		sounder-right $hz
	} elseif [string equal $justification c] { ;# hz at center
		set separation2 [/ $separation 2.0]
		sounder-left [expr $hz - $separation2]
		sounder-right [expr $hz + $separation2]
	}
}

proc after-create n {
	proc after-fade {} "set-text-color 0.5 1 0.5; echo Created $n pairs of binaural drones, [/ [sounder n] 2] pairs in total"
}


proc create-binaurals-on-notes {hz {separation 1} {intervals {1 3 5 8}} {resize_separation 1}} {
	set n 0
  set justification [get-justification]
	foreach i $intervals {
		global $i
    set l_resize_separation "$separation [expr $$i*$separation]"
		create-binaural-pair [expr $hz*$$i] [lindex $l_resize_separation $resize_separation] $justification
		incr n
	}
	set-binaurals-volume [get-var sounding_board.master_volume]
	after-create $n
}

proc get-justification {} { ;# return channel justification for each binaural drone pair
  set types {l r c}
  return [lindex $types [get-var sounding_board.justification]]
}

proc create-binaurals-from-pitch {hz {separation 1} {pairs 1} spacing} {
	set-var sounding_board.starting_pitch $hz
	set-var sounding_board.spacing $spacing
  set justification [get-justification]
	for {set i 0} {$i < $pairs} {incr i} {
    create-binaural-pair $hz $separation $justification
		set hz [+ $hz $spacing]
	}
	set-binaurals-volume [get-var sounding_board.master_volume]
	after-create $pairs
}

proc set-binaurals-volume {{max 1}} {
	set n [sounder n]
	if {$n eq 0} return
	set v [expr 2.0 * $max/$n]
	set last [expr $n - 1]
	for {set i 0} {$i < $last} {incr i} {
		sounder edit $i l $v
		incr i
		sounder edit $i r $v
	}
	proc after-fade {} {}
}


proc delete-binaurals {start {num 1}} {
	set end [expr $start+$num]
	for {set i $start} {$i < $end} {incr i} {sounder delete $start}
}

proc list-all-binaurals {} {
	sounder list
}

proc sync-all-binaurals {} {
	set-binaurals-volume 0 ;# fade out first
	proc after-fade {} { ;# sync and fade in
		sounder sync
		set-binaurals-volume [get-var sounding_board.master_volume]
		proc after-fade {} {echo "Synced all binaural drones"}
	}
}

proc delete-all-binaurals {} {
	set-binaurals-volume 0 ;# fade out first
	proc after-fade {} {
		set n [sounder n]
		delete-binaurals 0 $n ;# delete all 
		echo "Deleted [/ $n 2] pairs of binaural drones"
	}
}

if 0 {

  proc rec {} {
    global mon
    set mon 1
    sounder sync
    set-var sounding_board.fadet 30
    set-var recorder.clear
    set-var recorder.start
    set-var recorder.stop_secs 00
    set-var recorder.stop_mins 60
  }

  proc stopped-recording {} {
    set-var recorder.fname 108.wav
    set-var recorder.save
  }

  proc monitor-recording {} {
    set rmins [get-var recorder.mins]
    set rsecs [get-var recorder.secs]
    global mon
    if {$rmins >= 59 && $rsecs >= 28 && $mon} {
      set mon 0
      set-binaurals-volume 0
    }
  }
}

if 0 {
  proc edit-binaurals {what value start {end $start} {step 1}} {
	  for {set i $start} {$i < $end} {incr i $step} {
		  sounder edit $i $what $value
	  }
  }
}
