/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.backtrace;

import java.io.Serializable;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.backtrace.FrameType;
import org.jruby.util.CommonByteLists;

public class RubyStackTraceElement
implements Serializable {
    public static final RubyStackTraceElement[] EMPTY_ARRAY = new RubyStackTraceElement[0];
    private final String className;
    private final String methodName;
    private final String fileName;
    private final int lineNumber;
    private final boolean binding;
    private final FrameType frameType;
    private transient StackTraceElement element;

    public RubyStackTraceElement(StackTraceElement element) {
        this.className = element.getClassName();
        this.methodName = element.getMethodName();
        this.fileName = element.getFileName() == null ? "unknown" : element.getFileName();
        this.lineNumber = element.getLineNumber();
        this.binding = false;
        this.frameType = FrameType.METHOD;
        this.element = element;
    }

    public RubyStackTraceElement(String klass, String method2, String file2, int line, boolean binding2) {
        this(klass, method2, file2, line, binding2, FrameType.METHOD);
    }

    public RubyStackTraceElement(String klass, String method2, String file2, int line, boolean binding2, FrameType frameType) {
        this.className = klass;
        this.methodName = method2;
        this.fileName = file2 == null ? "unknown" : file2;
        this.lineNumber = line;
        this.binding = binding2;
        this.frameType = frameType;
    }

    public final boolean isBinding() {
        return this.binding;
    }

    public final String getClassName() {
        return this.className;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    public final String getMethodName() {
        return this.methodName;
    }

    public final FrameType getFrameType() {
        return this.frameType;
    }

    public final StackTraceElement asStackTraceElement() {
        if (this.element != null) {
            return this.element;
        }
        this.element = new StackTraceElement(this.className, this.methodName, this.fileName, this.lineNumber);
        return this.element;
    }

    @Deprecated
    public StackTraceElement getElement() {
        return this.asStackTraceElement();
    }

    public String toString() {
        return this.asStackTraceElement().toString();
    }

    public static RubyString to_s_mri(ThreadContext context, RubyStackTraceElement element) {
        RubySymbol methodSym = context.runtime.newSymbol(element.getMethodName());
        RubyString line = context.runtime.newString();
        line.setEncoding(methodSym.getEncoding());
        line.cat(element.getFileName().getBytes());
        line.cat(CommonByteLists.COLON);
        line.append(context.runtime.newFixnum(element.getLineNumber()));
        line.cat(CommonByteLists.BACKTRACE_IN);
        line.cat(methodSym.getBytes());
        line.cat(new byte[]{39});
        return line;
    }

    @Deprecated
    public final CharSequence mriStyleString() {
        return new StringBuilder(this.fileName.length() + this.methodName.length() + 12).append(this.fileName).append(':').append(this.lineNumber).append(":in `").append(this.methodName).append('\'');
    }
}

