/*
 * Decompiled with CFR 0.152.
 */
package de.danielnaber.jwordsplitter.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class FastObjectSaver {
    private FastObjectSaver() {
    }

    public static void saveToFile(File file, Serializable serializableObject) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try (ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.writeObject(serializableObject);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object load(String filenameInClassPath) throws IOException {
        InputStream is = FastObjectSaver.class.getResourceAsStream(filenameInClassPath);
        if (is == null) {
            throw new IOException("Cannot find dictionary in class path: " + filenameInClassPath);
        }
        try (ObjectInputStream oos = new ObjectInputStream(is);){
            Object object = oos.readObject();
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not read data from " + filenameInClassPath, e);
        }
    }
}

