/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.bits;

import java.util.BitSet;

public final class BitList {
    private final BitSet data = new BitSet();
    private int numBits = 0;

    public void add(boolean b) {
        this.set(this.numBits, b);
    }

    public boolean get(int i) {
        if (i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.data.get(i);
    }

    public int size() {
        return this.numBits;
    }

    private void set(int index, boolean b) {
        this.data.set(index, b);
        this.numBits = Math.max(this.numBits, index + 1);
    }

    public String toString() {
        StringBuilder s = new StringBuilder("");
        long l = 0L;
        String hex = "";
        for (int i = 0; i < this.numBits; ++i) {
            boolean curr = this.data.get(i);
            if (i % 64 == 0 && i > 0) {
                hex = hex + String.format("%x", l);
                l = 0L;
            }
            l = l << 1 | (long)(curr ? 1 : 0);
            s.append(curr ? "1" : "0");
        }
        return s.toString() + "(" + hex + ")";
    }

    public void addAll(BitList bits) {
        for (int i = 0; i < bits.size(); ++i) {
            this.add(bits.get(i));
        }
    }

    public void addLong(long l) {
        int size = 64;
        this.addHelp(l, 64);
    }

    private void addHelp(long l, int size) {
        for (int b = size - 1; b >= 0; --b) {
            this.add((l & 1L << b) != 0L);
        }
    }

    public void addShort(short l) {
        this.addHelp(l, 16);
    }

    public void clear() {
        this.numBits = 0;
    }
}

