/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.repo;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ivy.osgi.repo.AbstractFSManifestIterable;

public class FSManifestIterable
extends AbstractFSManifestIterable {
    public static final Set NON_BUNDLE_DIRS = new HashSet<String>(Arrays.asList("source", "sources", "javadoc", "javadocs", "doc", "docs"));
    public static final FilenameFilter DEFAULT_DIR_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File file, String string) {
            return !string.equals(".svn") && !NON_BUNDLE_DIRS.contains(string);
        }
    };
    public static final FilenameFilter DEFAULT_BUNLDE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File file, String string) {
            return string.endsWith(".jar");
        }
    };
    private FilenameFilter dirFilter = DEFAULT_DIR_FILTER;
    private FilenameFilter bundleFilter = DEFAULT_BUNLDE_FILTER;

    public FSManifestIterable(File file) {
        super(file);
    }

    public FilenameFilter getDirFilter() {
        return this.dirFilter;
    }

    public void setDirFilter(FilenameFilter filenameFilter) {
        this.dirFilter = filenameFilter;
    }

    public FilenameFilter getBundleFilter() {
        return this.bundleFilter;
    }

    public void setBundleFilter(FilenameFilter filenameFilter) {
        this.bundleFilter = filenameFilter;
    }

    @Override
    protected URI buildBundleURI(Object object) {
        try {
            return new URI(((File)object).toURL().toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Unexpected file to url conversion error", malformedURLException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException("Unexpected url to uri conversion error", uRISyntaxException);
        }
    }

    @Override
    protected InputStream getInputStream(Object object) throws FileNotFoundException {
        return new FileInputStream((File)object);
    }

    @Override
    protected List listBundleFiles(Object object) {
        return Arrays.asList(((File)object).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!file.isFile()) {
                    return false;
                }
                return FSManifestIterable.this.bundleFilter.accept(file.getParentFile(), file.getName());
            }
        }));
    }

    @Override
    protected List listDirs(Object object) {
        return Arrays.asList(((File)object).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!file.isDirectory()) {
                    return false;
                }
                return FSManifestIterable.this.dirFilter == null || FSManifestIterable.this.dirFilter.accept(file.getParentFile(), file.getName());
            }
        }));
    }
}

