/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.matcher;

import java.util.regex.PatternSyntaxException;
import org.apache.ivy.plugins.matcher.AbstractPatternMatcher;
import org.apache.ivy.plugins.matcher.Matcher;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;

public final class GlobPatternMatcher
extends AbstractPatternMatcher {
    public static final GlobPatternMatcher INSTANCE = new GlobPatternMatcher();

    public GlobPatternMatcher() {
        super("glob");
    }

    @Override
    protected Matcher newMatcher(String string) {
        return new GlobMatcher(string);
    }

    private static class GlobMatcher
    implements Matcher {
        private Pattern pattern;
        private String expression;
        private Boolean exact;

        public GlobMatcher(String string) throws PatternSyntaxException {
            this.expression = string;
            try {
                this.pattern = new GlobCompiler().compile(string);
            }
            catch (MalformedPatternException malformedPatternException) {
                throw new PatternSyntaxException(malformedPatternException.getMessage(), string, 0);
            }
        }

        @Override
        public boolean matches(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            return new Perl5Matcher().matches(string, this.pattern);
        }

        @Override
        public boolean isExact() {
            if (this.exact == null) {
                this.exact = this.calculateExact();
            }
            return this.exact;
        }

        private Boolean calculateExact() {
            Boolean bl = Boolean.TRUE;
            char[] cArray = this.expression.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (c != '*' && c != '?' && c != '[' && c != ']') continue;
                bl = Boolean.FALSE;
                break;
            }
            return bl;
        }
    }
}

