/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.ivy.plugins.repository.BasicResource;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.sftp.SFTPResource;
import org.apache.ivy.plugins.repository.ssh.AbstractSshBasedRepository;
import org.apache.ivy.plugins.repository.ssh.SshCache;
import org.apache.ivy.util.Message;

public class SFTPRepository
extends AbstractSshBasedRepository {
    private static final long MILLIS_PER_SECOND = 1000L;

    @Override
    public Resource getResource(String string) {
        return new SFTPResource(this, string);
    }

    public Resource resolveResource(String string) {
        try {
            ChannelSftp channelSftp = this.getSftpChannel(string);
            Vector vector = channelSftp.ls(this.getPath(string));
            if (vector != null) {
                for (Object e : vector) {
                    if (!(e instanceof ChannelSftp.LsEntry)) continue;
                    ChannelSftp.LsEntry lsEntry = (ChannelSftp.LsEntry)e;
                    SftpATTRS sftpATTRS = lsEntry.getAttrs();
                    return new BasicResource(string, true, sftpATTRS.getSize(), (long)sftpATTRS.getMTime() * 1000L, false);
                }
            }
        }
        catch (Exception exception) {
            Message.debug("reolving resource error: " + exception.getMessage());
        }
        return new BasicResource(string, false, 0L, 0L, false);
    }

    public InputStream openStream(SFTPResource sFTPResource) throws IOException {
        ChannelSftp channelSftp = this.getSftpChannel(sFTPResource.getName());
        try {
            String string = this.getPath(sFTPResource.getName());
            return channelSftp.get(string);
        }
        catch (SftpException sftpException) {
            IOException iOException = new IOException("impossible to open stream for " + sFTPResource + " on " + this.getHost() + (sftpException.getMessage() != null ? ": " + sftpException.getMessage() : ""));
            iOException.initCause(sftpException);
            throw iOException;
        }
        catch (URISyntaxException uRISyntaxException) {
            IOException iOException = new IOException("impossible to open stream for " + sFTPResource + " on " + this.getHost() + (uRISyntaxException.getMessage() != null ? ": " + uRISyntaxException.getMessage() : ""));
            iOException.initCause(uRISyntaxException);
            throw iOException;
        }
    }

    @Override
    public void get(String string, File file) throws IOException {
        this.fireTransferInitiated(this.getResource(string), 5);
        ChannelSftp channelSftp = this.getSftpChannel(string);
        try {
            String string2 = this.getPath(string);
            channelSftp.get(string2, file.getAbsolutePath(), (SftpProgressMonitor)new MyProgressMonitor());
        }
        catch (SftpException sftpException) {
            IOException iOException = new IOException("impossible to get " + string + " on " + this.getHost() + (sftpException.getMessage() != null ? ": " + sftpException.getMessage() : ""));
            iOException.initCause(sftpException);
            throw iOException;
        }
        catch (URISyntaxException uRISyntaxException) {
            IOException iOException = new IOException("impossible to get " + string + " on " + this.getHost() + (uRISyntaxException.getMessage() != null ? ": " + uRISyntaxException.getMessage() : ""));
            iOException.initCause(uRISyntaxException);
            throw iOException;
        }
    }

    @Override
    public void put(File file, String string, boolean bl) throws IOException {
        this.fireTransferInitiated(this.getResource(string), 6);
        ChannelSftp channelSftp = this.getSftpChannel(string);
        try {
            String string2 = this.getPath(string);
            if (!bl && this.checkExistence(string2, channelSftp)) {
                throw new IOException("destination file exists and overwrite == false");
            }
            if (string2.indexOf(47) != -1) {
                this.mkdirs(string2.substring(0, string2.lastIndexOf(47)), channelSftp);
            }
            channelSftp.put(file.getAbsolutePath(), string2, (SftpProgressMonitor)new MyProgressMonitor());
        }
        catch (SftpException sftpException) {
            IOException iOException = new IOException(sftpException.getMessage());
            iOException.initCause(sftpException);
            throw iOException;
        }
        catch (URISyntaxException uRISyntaxException) {
            IOException iOException = new IOException(uRISyntaxException.getMessage());
            iOException.initCause(uRISyntaxException);
            throw iOException;
        }
    }

    private void mkdirs(String string, ChannelSftp channelSftp) throws IOException, SftpException {
        try {
            SftpATTRS sftpATTRS = channelSftp.stat(string);
            if (sftpATTRS != null && sftpATTRS.isDir()) {
                return;
            }
        }
        catch (SftpException sftpException) {
            if (string.indexOf(47) != -1) {
                this.mkdirs(string.substring(0, string.lastIndexOf(47)), channelSftp);
            }
            channelSftp.mkdir(string);
        }
    }

    private String getPath(String string) throws URISyntaxException {
        String string2 = null;
        URI uRI = new URI(string);
        string2 = uRI.getPath();
        if (string2 == null) {
            throw new URISyntaxException(string, "Missing path in URI.");
        }
        return string2;
    }

    @Override
    public List list(String string) throws IOException {
        try {
            ChannelSftp channelSftp = this.getSftpChannel(string);
            String string2 = this.getPath(string);
            Vector vector = channelSftp.ls(string2);
            if (vector != null) {
                if (!string2.endsWith("/")) {
                    string2 = string + "/";
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Object e : vector) {
                    ChannelSftp.LsEntry lsEntry;
                    if (!(e instanceof ChannelSftp.LsEntry) || ".".equals((lsEntry = (ChannelSftp.LsEntry)e).getFilename()) || "..".equals(lsEntry.getFilename())) continue;
                    arrayList.add(string2 + lsEntry.getFilename());
                }
                return arrayList;
            }
        }
        catch (SftpException sftpException) {
            IOException iOException = new IOException("Failed to return a listing for '" + string + "'");
            iOException.initCause(sftpException);
            throw iOException;
        }
        catch (URISyntaxException uRISyntaxException) {
            IOException iOException = new IOException("Failed to return a listing for '" + string + "'");
            iOException.initCause(uRISyntaxException);
            throw iOException;
        }
        return null;
    }

    private boolean checkExistence(String string, ChannelSftp channelSftp) throws IOException, SftpException {
        try {
            return channelSftp.stat(string) != null;
        }
        catch (SftpException sftpException) {
            return false;
        }
    }

    private ChannelSftp getSftpChannel(String string) throws IOException {
        Session session = this.getSession(string);
        String string2 = session.getHost();
        ChannelSftp channelSftp = SshCache.getInstance().getChannelSftp(session);
        if (channelSftp == null) {
            try {
                channelSftp = (ChannelSftp)session.openChannel("sftp");
                channelSftp.connect();
                Message.verbose(":: SFTP :: connected to " + string2 + "!");
                SshCache.getInstance().attachChannelSftp(session, channelSftp);
            }
            catch (JSchException jSchException) {
                IOException iOException = new IOException(jSchException.getMessage());
                iOException.initCause(jSchException);
                throw iOException;
            }
        }
        return channelSftp;
    }

    @Override
    protected String getRepositoryScheme() {
        return "sftp";
    }

    private final class MyProgressMonitor
    implements SftpProgressMonitor {
        private long totalLength;

        private MyProgressMonitor() {
        }

        public void init(int n, String string, String string2, long l) {
            this.totalLength = l;
            SFTPRepository.this.fireTransferStarted(l);
        }

        public void end() {
            SFTPRepository.this.fireTransferCompleted(this.totalLength);
        }

        public boolean count(long l) {
            SFTPRepository.this.fireTransferProgress(l);
            return true;
        }
    }
}

