/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.ivy.core.LogOptions;
import org.apache.ivy.util.MessageLogger;

public abstract class AbstractMessageLogger
implements MessageLogger {
    private List problems = new ArrayList();
    private List warns = new ArrayList();
    private List errors = new ArrayList();
    private boolean showProgress = true;

    @Override
    public final void debug(String string) {
        this.log(string, 4);
    }

    @Override
    public final void verbose(String string) {
        this.log(string, 3);
    }

    @Override
    public final void deprecated(String string) {
        this.log("DEPRECATED: " + string, 1);
    }

    @Override
    public final void info(String string) {
        this.log(string, 2);
    }

    @Override
    public final void rawinfo(String string) {
        this.rawlog(string, 2);
    }

    @Override
    public final void warn(String string) {
        this.log("WARN: " + string, 3);
        this.problems.add("WARN:  " + string);
        this.warns.add(string);
    }

    @Override
    public void error(String string) {
        this.log("ERROR: " + string, 3);
        this.problems.add("\tERROR: " + string);
        this.errors.add(string);
    }

    @Override
    public final List getProblems() {
        return this.problems;
    }

    @Override
    public final void sumupProblems() {
        LogOptions.sumupProblems(this);
        this.clearProblems();
    }

    @Override
    public final void clearProblems() {
        this.problems.clear();
        this.warns.clear();
        this.errors.clear();
    }

    @Override
    public final List getErrors() {
        return this.errors;
    }

    @Override
    public final List getWarns() {
        return this.warns;
    }

    @Override
    public final void progress() {
        if (this.showProgress) {
            this.doProgress();
        }
    }

    @Override
    public final void endProgress(String string) {
        if (this.showProgress) {
            this.doEndProgress(string);
        }
    }

    protected abstract void doProgress();

    protected abstract void doEndProgress(String var1);
}

