/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamingWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.resource.Resource;

public abstract class StreamWagon
extends AbstractWagon
implements StreamingWagon {
    public abstract void fillInputData(InputData var1) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException;

    public abstract void fillOutputData(OutputData var1) throws TransferFailedException;

    @Override
    public abstract void closeConnection() throws ConnectionException;

    @Override
    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.getIfNewer(resourceName, destination, 0L);
    }

    protected void checkInputStream(InputStream is2, Resource resource2) throws TransferFailedException {
        if (is2 == null) {
            TransferFailedException e2 = new TransferFailedException(this.getRepository().getUrl() + " - Could not open input stream for resource: '" + resource2 + "'");
            this.fireTransferError(resource2, e2, 5);
            throw e2;
        }
    }

    @Override
    public boolean getIfNewer(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        boolean retValue = false;
        Resource resource2 = new Resource(resourceName);
        this.fireGetInitiated(resource2, destination);
        resource2.setLastModified(timestamp);
        InputStream is2 = this.getInputStream(resource2);
        if (timestamp == 0L || timestamp < resource2.getLastModified()) {
            retValue = true;
            this.checkInputStream(is2, resource2);
            this.getTransfer(resource2, destination, is2);
        } else {
            try {
                if (is2 != null) {
                    is2.close();
                }
            }
            catch (IOException e2) {
                throw new TransferFailedException("Failure transferring " + resourceName, e2);
            }
        }
        return retValue;
    }

    protected InputStream getInputStream(Resource resource2) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        InputData inputData = new InputData();
        inputData.setResource(resource2);
        try {
            this.fillInputData(inputData);
        }
        catch (TransferFailedException e2) {
            this.fireTransferError(resource2, e2, 5);
            this.cleanupGetTransfer(resource2);
            throw e2;
        }
        catch (ResourceDoesNotExistException e3) {
            this.fireTransferError(resource2, e3, 5);
            this.cleanupGetTransfer(resource2);
            throw e3;
        }
        catch (AuthorizationException e4) {
            this.fireTransferError(resource2, e4, 5);
            this.cleanupGetTransfer(resource2);
            throw e4;
        }
        finally {
            if (inputData.getInputStream() == null) {
                this.cleanupGetTransfer(resource2);
            }
        }
        return inputData.getInputStream();
    }

    @Override
    public void put(File source2, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource2 = new Resource(resourceName);
        this.firePutInitiated(resource2, source2);
        resource2.setContentLength(source2.length());
        resource2.setLastModified(source2.lastModified());
        OutputStream os = this.getOutputStream(resource2);
        this.checkOutputStream(resource2, os);
        this.putTransfer(resource2, source2, os, true);
    }

    protected void checkOutputStream(Resource resource2, OutputStream os) throws TransferFailedException {
        if (os == null) {
            TransferFailedException e2 = new TransferFailedException(this.getRepository().getUrl() + " - Could not open output stream for resource: '" + resource2 + "'");
            this.fireTransferError(resource2, e2, 6);
            throw e2;
        }
    }

    protected OutputStream getOutputStream(Resource resource2) throws TransferFailedException {
        OutputData outputData = new OutputData();
        outputData.setResource(resource2);
        try {
            this.fillOutputData(outputData);
        }
        catch (TransferFailedException e2) {
            this.fireTransferError(resource2, e2, 6);
            throw e2;
        }
        finally {
            if (outputData.getOutputStream() == null) {
                this.cleanupPutTransfer(resource2);
            }
        }
        return outputData.getOutputStream();
    }

    @Override
    public boolean getIfNewerToStream(String resourceName, OutputStream stream, long timestamp) throws ResourceDoesNotExistException, TransferFailedException, AuthorizationException {
        boolean retValue = false;
        Resource resource2 = new Resource(resourceName);
        this.fireGetInitiated(resource2, null);
        InputStream is2 = this.getInputStream(resource2);
        if (timestamp == 0L || timestamp < resource2.getLastModified()) {
            retValue = true;
            this.checkInputStream(is2, resource2);
            this.fireGetStarted(resource2, null);
            this.getTransfer(resource2, stream, is2, true, Integer.MAX_VALUE);
            this.fireGetCompleted(resource2, null);
        } else {
            try {
                if (is2 != null) {
                    is2.close();
                }
            }
            catch (IOException e2) {
                throw new TransferFailedException("Failure transferring " + resourceName, e2);
            }
        }
        return retValue;
    }

    @Override
    public void getToStream(String resourceName, OutputStream stream) throws ResourceDoesNotExistException, TransferFailedException, AuthorizationException {
        this.getIfNewerToStream(resourceName, stream, 0L);
    }

    @Override
    public void putFromStream(InputStream stream, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource2 = new Resource(destination);
        this.firePutInitiated(resource2, null);
        this.putFromStream(stream, resource2);
    }

    @Override
    public void putFromStream(InputStream stream, String destination, long contentLength, long lastModified) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource2 = new Resource(destination);
        this.firePutInitiated(resource2, null);
        resource2.setContentLength(contentLength);
        resource2.setLastModified(lastModified);
        this.putFromStream(stream, resource2);
    }

    protected void putFromStream(InputStream stream, Resource resource2) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        OutputStream os = this.getOutputStream(resource2);
        this.checkOutputStream(resource2, os);
        this.firePutStarted(resource2, null);
        this.putTransfer(resource2, stream, os, true);
        this.firePutCompleted(resource2, null);
    }
}

