/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsBibParser;
import com.dickimawbooks.bib2gls.Bib2GlsDualEntry;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsEntryComparator;
import com.dickimawbooks.bib2gls.Bib2GlsEntryDateTimeComparator;
import com.dickimawbooks.bib2gls.Bib2GlsEntryLetterComparator;
import com.dickimawbooks.bib2gls.Bib2GlsEntryLetterNumberComparator;
import com.dickimawbooks.bib2gls.Bib2GlsEntryNumericComparator;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.FlattenedHomograph;
import com.dickimawbooks.bib2gls.FlattenedPreSort;
import com.dickimawbooks.bib2gls.GlsRecord;
import com.dickimawbooks.bib2gls.GlsSeeRecord;
import com.dickimawbooks.bib2gls.GroupTitle;
import com.dickimawbooks.bib2gls.PatternReplace;
import com.dickimawbooks.bib2gls.SortSettings;
import com.dickimawbooks.bib2gls.WidestName;
import com.dickimawbooks.bib2gls.WidestNameHierarchy;
import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.aux.AuxData;
import com.dickimawbooks.texparserlib.aux.AuxParser;
import com.dickimawbooks.texparserlib.bib.BibData;
import com.dickimawbooks.texparserlib.bib.BibEntry;
import com.dickimawbooks.texparserlib.bib.BibUserString;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import com.dickimawbooks.texparserlib.html.L2HStringConverter;
import com.dickimawbooks.texparserlib.latex.CsvList;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class GlsResource {
    private File texFile;
    private Vector<TeXPath> sources;
    private boolean interpretLabelFields = false;
    private boolean stripMissingParents = false;
    private HashMap<String, String> entryTypeAliases = null;
    private HashMap<String, String> fieldAliases = null;
    private HashMap<String, Vector<String>> fieldCopies = null;
    private boolean replicateOverride = false;
    private String[] skipFields = null;
    private String[] bibtexAuthorList = null;
    private String[] dateTimeList = null;
    private String[] dateList = null;
    private String[] timeList = null;
    private String dateTimeListFormat = "default";
    private String dateListFormat = "default";
    private String timeListFormat = "default";
    private String dualDateTimeListFormat = "default";
    private String dualDateListFormat = "default";
    private String dualTimeListFormat = "default";
    private Locale dateTimeListLocale = null;
    private Locale dateListLocale = null;
    private Locale timeListLocale = null;
    private Locale dualDateTimeListLocale = null;
    private Locale dualDateListLocale = null;
    private Locale dualTimeListLocale = null;
    private String[] externalPrefixes = null;
    private String[] checkEndPunc = null;
    private String[] labelifyFields = null;
    private String[] labelifyListFields = null;
    private Vector<PatternReplace> labelifyReplaceMap;
    private String type = null;
    private String category = null;
    private String counter = null;
    private SortSettings sortSettings = new SortSettings("locale");
    private SortSettings dualSortSettings = new SortSettings();
    private SortSettings secondarySortSettings = new SortSettings();
    private String symbolDefaultSortField = "id";
    private String abbrevDefaultSortField = "short";
    private String abbrevDefaultNameField = "short";
    private String dualType = null;
    private String dualCategory = null;
    private String dualCounter = null;
    private String triggerType = null;
    private String pluralSuffix = "\\glspluralsuffix ";
    private String dualPluralSuffix = "\\glspluralsuffix ";
    private String shortPluralSuffix = null;
    private String dualShortPluralSuffix = null;
    private Charset bibCharset = null;
    private boolean flatten = false;
    private boolean interpretPreamble = true;
    private boolean setWidest = false;
    private WidestNameHierarchy widestNameNoType = null;
    private HashMap<String, WidestNameHierarchy> widestNames = null;
    private String secondaryType = null;
    private String secondaryField = null;
    private int minLocationRange = 3;
    private int locGap = 1;
    private String suffixF = null;
    private String suffixFF = null;
    private String preamble = null;
    private BibValueList preambleList = null;
    private boolean savePreamble = true;
    private HashMap<String, Pattern> fieldPatterns = null;
    private boolean notMatch = false;
    private boolean fieldPatternsAnd = true;
    private final byte MATCH_ACTION_FILTER = 0;
    private final byte MATCH_ACTION_ADD = 1;
    private byte matchAction = 0;
    private final byte WRITE_ACTION_DEFINE = 0;
    private final byte WRITE_ACTION_COPY = 1;
    private final byte WRITE_ACTION_DEFINE_OR_COPY = (byte)2;
    private byte writeAction = 0;
    private String copyActionGroupField = null;
    private static final String PATTERN_FIELD_ID = "id";
    private static final String PATTERN_FIELD_ENTRY_TYPE = "entrytype";
    private Vector<Bib2GlsEntry> bibData;
    private Vector<Bib2GlsEntry> dualData;
    private boolean hasDuals = false;
    private boolean hasTertiaries = false;
    private Bib2Gls bib2gls;
    private int seeLocation = 2;
    private int seeAlsoLocation = 2;
    private int aliasLocation = 2;
    private String[] locationPrefix = null;
    private String[] locationSuffix = null;
    private boolean saveLocations = true;
    private boolean saveLocList = true;
    public static final int COMBINE_DUAL_LOCATIONS_OFF = 0;
    public static final int COMBINE_DUAL_LOCATIONS_BOTH = 1;
    public static final int COMBINE_DUAL_LOCATIONS_PRIMARY = 2;
    public static final int COMBINE_DUAL_LOCATIONS_DUAL = 3;
    private int combineDualLocations = 0;
    public static final int FLATTEN_LONELY_FALSE = 0;
    public static final int FLATTEN_LONELY_PRE_SORT = 1;
    public static final int FLATTEN_LONELY_POST_SORT = 2;
    private int flattenLonely = 0;
    public static final int FLATTEN_LONELY_RULE_ONLY_UNRECORDED_PARENTS = 0;
    public static final int FLATTEN_LONELY_RULE_NO_DISCARD = 1;
    public static final int FLATTEN_LONELY_RULE_DISCARD_UNRECORDED = 2;
    private int flattenLonelyRule = 0;
    private boolean saveChildCount = false;
    private boolean defpagesname = false;
    public static final int ALIAS_LOC_OMIT = 0;
    public static final int ALIAS_LOC_TRANS = 1;
    public static final int ALIAS_LOC_KEEP = 2;
    private int aliasLocations = 1;
    private boolean aliases = false;
    private String labelPrefix = null;
    private String dualPrefix = "dual.";
    private String tertiaryType = null;
    private String tertiaryCategory = null;
    private String tertiaryPrefix = "tertiary.";
    private String csLabelPrefix = null;
    private String recordLabelPrefix = null;
    private String dupLabelSuffix = null;
    private String dualField = null;
    private HashMap<String, String> dualEntryMap;
    private HashMap<String, String> dualAbbrevMap;
    private HashMap<String, String> dualSymbolMap;
    private HashMap<String, String> dualAbbrevEntryMap;
    private HashMap<String, String> dualIndexEntryMap;
    private HashMap<String, String> dualIndexSymbolMap;
    private HashMap<String, String> dualIndexAbbrevMap;
    private String dualEntryFirstMap;
    private String dualAbbrevFirstMap;
    private String dualSymbolFirstMap;
    private String dualAbbrevEntryFirstMap;
    private String dualIndexEntryFirstMap;
    private String dualIndexSymbolFirstMap;
    private String dualIndexAbbrevFirstMap;
    private boolean backLinkDualEntry = false;
    private boolean backLinkDualAbbrev = false;
    private boolean backLinkDualSymbol = false;
    private boolean backLinkDualAbbrevEntry = false;
    private boolean backLinkDualIndexEntry = false;
    private boolean backLinkDualIndexSymbol = false;
    private boolean backLinkDualIndexAbbrev = false;
    private String shortCaseChange = null;
    private String dualShortCaseChange = null;
    private String nameCaseChange = null;
    private String descCaseChange = null;
    public static final byte POST_DESC_DOT_NONE = 0;
    public static final byte POST_DESC_DOT_ALL = 1;
    public static final byte POST_DESC_DOT_CHECK = 2;
    private byte postDescDot = 0;
    private boolean stripTrailingNoPost = false;
    private String masterLinkPrefix = null;
    private Vector<TeXPath> masterGlsTeXPath = null;
    private TeXPath masterPdfPath = null;
    private String[] masterSelection = null;
    private String[] counters = null;
    private Random random = null;
    private HashMap<String, GroupTitle> groupTitleMap = null;
    private Vector<GlsRecord> supplementalRecords = null;
    private TeXPath supplementalPdfPath = null;
    private String[] supplementalSelection = null;
    private String supplementalCategory = null;
    private String groupField = null;
    private String saveOriginalId = null;
    public static final int SELECTION_RECORDED_AND_DEPS = 0;
    public static final int SELECTION_RECORDED_AND_DEPS_AND_SEE = 1;
    public static final int SELECTION_RECORDED_NO_DEPS = 2;
    public static final int SELECTION_RECORDED_AND_PARENTS = 3;
    public static final int SELECTION_ALL = 4;
    private int selectionMode = 0;
    private static final String[] SELECTION_OPTIONS = new String[]{"recorded and deps", "recorded and deps and see", "recorded no deps", "recorded and ancestors", "all"};
    public static final byte CONTRIBUTOR_ORDER_SURNAME = 0;
    public static final byte CONTRIBUTOR_ORDER_VON = 1;
    public static final byte CONTRIBUTOR_ORDER_FORENAMES = 2;
    private byte contributorOrder = 1;
    private Vector<String> dependencies;
    private boolean dualPrimaryDependency = true;
    private int limit = 0;
    private boolean copyAliasToSee = false;
    private Bib2GlsBibParser bibParserListener = null;

    public GlsResource(TeXParser teXParser, AuxData auxData, String string, String string2) throws IOException, InterruptedException, Bib2GlsException {
        this.sources = new Vector();
        this.pluralSuffix = string;
        this.dualPluralSuffix = string;
        this.init(teXParser, auxData.getArg(0), auxData.getArg(1));
    }

    private void init(TeXParser teXParser, TeXObject teXObject, TeXObject teXObject2) throws IOException, InterruptedException, Bib2GlsException, IllegalArgumentException {
        this.bib2gls = (Bib2Gls)teXParser.getListener().getTeXApp();
        TeXPath teXPath = new TeXPath(teXParser, teXObject2.toString(teXParser), "glstex", false);
        this.texFile = this.bib2gls.resolveFile(teXPath.getFile());
        this.bib2gls.registerTeXFile(this.texFile);
        this.bib2gls.verboseMessage("message.initialising.resource", this.texFile.getName());
        String string = teXPath.getTeXPath(true);
        this.dependencies = new Vector();
        KeyValList keyValList = KeyValList.getList(teXParser, teXObject);
        String[] stringArray = null;
        String string2 = null;
        String string3 = null;
        String string4 = "define";
        if (this.bib2gls.useGroupField()) {
            this.groupTitleMap = new HashMap();
        }
        block12: for (Object object : keyValList.keySet()) {
            Object object2;
            Object object3;
            Object object4;
            int n;
            int n2;
            if (((String)object).equals("src")) {
                stringArray = this.getStringArray(teXParser, keyValList, (String)object);
                if (stringArray == null) {
                    this.sources.add(this.bib2gls.getBibFilePath(teXParser, string));
                    continue;
                }
                String[] stringArray2 = stringArray;
                n2 = stringArray2.length;
                for (n = 0; n < n2; ++n) {
                    object4 = stringArray2[n];
                    this.sources.add(this.bib2gls.getBibFilePath(teXParser, (String)object4));
                }
                continue;
            }
            if (((String)object).equals("master")) {
                string2 = this.getRequired(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("master-resources")) {
                this.masterSelection = this.getStringArray(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("supplemental-locations")) {
                string3 = this.getRequired(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("supplemental-category")) {
                this.supplementalCategory = this.getRequired(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("supplemental-selection")) {
                this.supplementalSelection = this.getStringArray(teXParser, keyValList, (String)object);
                if (this.supplementalSelection == null || this.supplementalSelection.length == 0) {
                    throw new IllegalArgumentException(this.bib2gls.getMessage("error.missing.value", object));
                }
                if (this.supplementalSelection.length != 1 || !this.supplementalSelection[0].equals("selected")) continue;
                this.supplementalSelection = null;
                continue;
            }
            if (((String)object).equals("entry-type-aliases")) {
                this.entryTypeAliases = this.getHashMap(teXParser, keyValList, (String)object);
                if (this.entryTypeAliases == null) {
                    if (this.bib2gls.getVerboseLevel() <= 0) continue;
                    this.bib2gls.logMessage(this.bib2gls.getMessage("message.clearing.entry.aliases", new Object[0]));
                    continue;
                }
                if (this.bib2gls.getVerboseLevel() > 0) {
                    this.bib2gls.logMessage(this.bib2gls.getMessage("message.setting.entry.aliases", new Object[0]));
                }
                for (String string5 : this.entryTypeAliases.keySet()) {
                    String string6 = this.entryTypeAliases.get(string5);
                    if (string5.matches(".*\\W.*")) {
                        throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.entry.type", string5, object));
                    }
                    if (string6.isEmpty()) {
                        throw new IllegalArgumentException(this.bib2gls.getMessage("error.missing.value", string5));
                    }
                    if (string6.matches(".*\\W.*")) {
                        throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.entry.type", string6, object));
                    }
                    if (this.bib2gls.getVerboseLevel() <= 0) continue;
                    this.bib2gls.logMessage(String.format("@%s=>@%s.", string5, string6));
                }
                continue;
            }
            if (((String)object).equals("field-aliases")) {
                this.fieldAliases = this.getHashMap(teXParser, keyValList, (String)object);
                if (this.fieldAliases == null) continue;
                Set<String> set = this.fieldAliases.keySet();
                for (String string7 : set) {
                    object4 = this.fieldAliases.keySet();
                    object3 = object4.iterator();
                    while (object3.hasNext()) {
                        object2 = (String)object3.next();
                        String string8 = this.fieldAliases.get(object2);
                        if (!string8.equals(string7)) continue;
                        if (string7.equals(object2)) {
                            throw new IllegalArgumentException(this.bib2gls.getMessage("error.field.alias.identity", string7));
                        }
                        throw new IllegalArgumentException(this.bib2gls.getMessage("error.field.alias.trail", string7, this.fieldAliases.get(string7), object2));
                    }
                }
                continue;
            }
            if (((String)object).equals("replicate-fields")) {
                this.fieldCopies = this.getHashMapVector(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("replicate-override")) {
                this.replicateOverride = this.getBoolean(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("primary-dual-dependency")) {
                this.dualPrimaryDependency = this.getBoolean(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("strip-trailing-nopost")) {
                this.stripTrailingNoPost = this.getBoolean(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("copy-alias-to-see")) {
                this.copyAliasToSee = this.getBoolean(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("post-description-dot")) {
                String string9 = this.getChoice(teXParser, keyValList, (String)object, "none", "all", "check");
                if (string9.equals("none")) {
                    this.postDescDot = 0;
                    continue;
                }
                if (string9.equals("all")) {
                    this.postDescDot = 1;
                    continue;
                }
                this.postDescDot = (byte)2;
                continue;
            }
            if (((String)object).equals("name-case-change")) {
                this.nameCaseChange = this.getChoice(teXParser, keyValList, (String)object, "none", "lc", "uc", "lc-cs", "uc-cs", "firstuc", "firstuc-cs");
                continue;
            }
            if (((String)object).equals("description-case-change")) {
                this.descCaseChange = this.getChoice(teXParser, keyValList, (String)object, "none", "lc", "uc", "lc-cs", "uc-cs", "firstuc", "firstuc-cs");
                continue;
            }
            if (((String)object).equals("short-case-change")) {
                this.shortCaseChange = this.getChoice(teXParser, keyValList, (String)object, "none", "lc", "uc", "lc-cs", "uc-cs", "firstuc", "firstuc-cs");
                continue;
            }
            if (((String)object).equals("dual-short-case-change")) {
                this.dualShortCaseChange = this.getChoice(teXParser, keyValList, (String)object, "none", "lc", "uc", "lc-cs", "uc-cs", "firstuc", "firstuc-cs");
                continue;
            }
            if (((String)object).equals("short-plural-suffix")) {
                this.shortPluralSuffix = this.getOptional(teXParser, "", keyValList, (String)object);
                if (!this.shortPluralSuffix.equals("use-default")) continue;
                this.shortPluralSuffix = null;
                continue;
            }
            if (((String)object).equals("dual-short-plural-suffix")) {
                this.dualShortPluralSuffix = this.getOptional(teXParser, "", keyValList, (String)object);
                if (!this.dualShortPluralSuffix.equals("use-default")) continue;
                this.dualShortPluralSuffix = null;
                continue;
            }
            if (((String)object).equals("action")) {
                string4 = this.getChoice(teXParser, keyValList, (String)object, "define", "define or copy", "copy");
                if (string4.equals("define")) {
                    this.writeAction = 0;
                    continue;
                }
                if (string4.equals("define or copy")) {
                    this.writeAction = (byte)2;
                    continue;
                }
                this.writeAction = 1;
                continue;
            }
            if (((String)object).equals("copy-action-group-field")) {
                if (this.bib2gls.useGroupField()) {
                    this.copyActionGroupField = this.getRequired(teXParser, keyValList, (String)object);
                    continue;
                }
                this.bib2gls.warning(this.bib2gls.getMessage("warning.group.option.required", object, "--group"));
                this.copyActionGroupField = null;
                continue;
            }
            if (((String)object).equals("match-action")) {
                String string10 = this.getChoice(teXParser, keyValList, (String)object, "filter", "add");
                if (string10.equals("filter")) {
                    this.matchAction = 0;
                    continue;
                }
                this.matchAction = 1;
                continue;
            }
            if (((String)object).equals("match-op")) {
                String string11 = this.getChoice(teXParser, keyValList, (String)object, "and", "or");
                this.fieldPatternsAnd = string11.equals("and");
                continue;
            }
            if (((String)object).equals("match")) {
                TeXObject[] teXObjectArray = this.getTeXObjectArray(teXParser, keyValList, (String)object);
                this.notMatch = false;
                if (teXObjectArray == null) {
                    this.fieldPatterns = null;
                    continue;
                }
                this.fieldPatterns = new HashMap();
                for (n2 = 0; n2 < teXObjectArray.length; ++n2) {
                    if (!(teXObjectArray[n2] instanceof TeXObjectList)) {
                        throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.value", object, ((TeXObject)keyValList.get(object)).toString(teXParser)));
                    }
                    Vector<TeXObject> vector = this.splitList(teXParser, '=', (TeXObjectList)teXObjectArray[n2]);
                    if (vector == null || vector.size() == 0) continue;
                    object4 = vector.get(0).toString(teXParser);
                    if (vector.size() > 2) {
                        throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.keylist.value", object4, teXObjectArray[n2].toString(teXParser), object));
                    }
                    object3 = vector.size() == 1 ? "" : vector.get(1).toString(teXParser);
                    object2 = this.fieldPatterns.get(object4);
                    object2 = object2 == null ? Pattern.compile((String)object3) : Pattern.compile(String.format("(?:%s)|(?:%s)", ((Pattern)object2).pattern(), object3));
                    try {
                        this.fieldPatterns.put((String)object4, (Pattern)object2);
                        continue;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.keylist.pattern", object4, object3, object), patternSyntaxException);
                    }
                }
                continue;
            }
            if (((String)object).equals("not-match")) {
                TeXObject[] teXObjectArray = this.getTeXObjectArray(teXParser, keyValList, (String)object);
                this.notMatch = true;
                if (teXObjectArray == null) {
                    this.fieldPatterns = null;
                    continue;
                }
                this.fieldPatterns = new HashMap();
                for (n2 = 0; n2 < teXObjectArray.length; ++n2) {
                    if (!(teXObjectArray[n2] instanceof TeXObjectList)) {
                        throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.value", object, ((TeXObject)keyValList.get(object)).toString(teXParser)));
                    }
                    Vector<TeXObject> vector = this.splitList(teXParser, '=', (TeXObjectList)teXObjectArray[n2]);
                    if (vector == null || vector.size() == 0) continue;
                    object4 = vector.get(0).toString(teXParser);
                    if (vector.size() > 2) {
                        throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.keylist.value", object4, teXObjectArray[n2].toString(teXParser), object));
                    }
                    object3 = vector.size() == 1 ? "" : vector.get(1).toString(teXParser);
                    object2 = this.fieldPatterns.get(object4);
                    object2 = object2 == null ? Pattern.compile((String)object3) : Pattern.compile(String.format("(?:%s)|(?:%s)", ((Pattern)object2).pattern(), object3));
                    try {
                        this.fieldPatterns.put((String)object4, (Pattern)object2);
                        continue;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.keylist.pattern", object4, object3, object), patternSyntaxException);
                    }
                }
                continue;
            }
            if (((String)object).equals("limit")) {
                this.limit = this.getRequiredIntGe(teXParser, 0, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("secondary")) {
                TeXObject teXObject3 = this.getRequiredObject(teXParser, keyValList, (String)object);
                if (!(teXObject3 instanceof TeXObjectList)) {
                    throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.value", object, teXObject3.toString(teXParser)));
                }
                Vector<TeXObject> vector = this.splitList(teXParser, ':', (TeXObjectList)teXObject3);
                n = vector.size();
                if (n == 2) {
                    this.secondaryType = vector.get(1).toString(teXParser);
                } else if (n == 3) {
                    this.secondaryField = vector.get(1).toString(teXParser);
                    this.secondaryType = vector.get(2).toString(teXParser);
                } else {
                    throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.value", object, teXObject3.toString(teXParser)));
                }
                object4 = vector.get(0).toString(teXParser);
                try {
                    this.secondarySortSettings.setMethod((String)object4);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.sort.value", object4, object), illegalArgumentException);
                }
            }
            if (((String)object).equals("ext-prefixes")) {
                this.externalPrefixes = this.getStringArray(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("labelify")) {
                this.labelifyFields = this.getFieldArray(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("labelify-list")) {
                this.labelifyListFields = this.getFieldArray(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("labelify-replace")) {
                this.labelifyReplaceMap = this.getSubstitutionList(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("interpret-preamble")) {
                this.interpretPreamble = this.getBoolean(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("interpret-label-fields")) {
                this.interpretLabelFields = this.getBoolean(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("strip-missing-parents")) {
                this.stripMissingParents = this.getBoolean(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("write-preamble")) {
                this.savePreamble = this.getBoolean(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("flatten")) {
                this.flatten = this.getBoolean(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("flatten-lonely")) {
                String string12 = this.getChoice(teXParser, keyValList, (String)object, "false", "presort", "postsort");
                if (string12.equals("false")) {
                    this.flattenLonely = 0;
                    continue;
                }
                if (string12.equals("presort")) {
                    this.flattenLonely = 1;
                    continue;
                }
                if (!string12.equals("postsort")) continue;
                this.flattenLonely = 2;
                continue;
            }
            if (((String)object).equals("flatten-lonely-rule")) {
                String string13 = this.getChoice(teXParser, keyValList, (String)object, "only unrecorded parents", "no discard", "discard unrecorded");
                if (string13.equals("only unrecorded parents")) {
                    this.flattenLonelyRule = 0;
                    continue;
                }
                if (string13.equals("no discard")) {
                    this.flattenLonelyRule = 1;
                    continue;
                }
                if (!string13.equals("discard unrecorded")) continue;
                this.flattenLonelyRule = 2;
                continue;
            }
            if (((String)object).equals("save-locations")) {
                this.saveLocations = this.getBoolean(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("save-loclist")) {
                this.saveLocList = this.getBoolean(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("combine-dual-locations")) {
                String string14 = this.getChoice(teXParser, keyValList, (String)object, "false", "both", "dual", "primary");
                if (string14.equals("false")) {
                    this.combineDualLocations = 0;
                    continue;
                }
                if (string14.equals("both")) {
                    this.combineDualLocations = 1;
                    continue;
                }
                if (string14.equals("dual")) {
                    this.combineDualLocations = 3;
                    continue;
                }
                if (!string14.equals("primary")) continue;
                this.combineDualLocations = 2;
                continue;
            }
            if (((String)object).equals("save-child-count")) {
                this.saveChildCount = this.getBoolean(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("alias-loc")) {
                String string15 = this.getChoice(teXParser, keyValList, (String)object, "omit", "transfer", "keep");
                if (string15.equals("omit")) {
                    this.aliasLocations = 0;
                    continue;
                }
                if (string15.equals("transfer")) {
                    this.aliasLocations = 1;
                    continue;
                }
                this.aliasLocations = 2;
                continue;
            }
            if (((String)object).equals("set-widest")) {
                this.setWidest = this.getBoolean(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("dual-entry-map")) {
                String[] stringArray3 = new String[1];
                this.dualEntryMap = this.getDualMap(teXParser, keyValList, (String)object, stringArray3);
                this.dualEntryFirstMap = stringArray3[0];
                continue;
            }
            if (((String)object).equals("dual-abbrv-map")) {
                String[] stringArray4 = new String[1];
                this.dualAbbrevMap = this.getDualMap(teXParser, keyValList, (String)object, stringArray4);
                this.dualAbbrevFirstMap = stringArray4[0];
                continue;
            }
            if (((String)object).equals("dual-entryabbrv-map")) {
                this.bib2gls.warning(this.bib2gls.getMessage("warning.deprecated.option", object, "dual-abbrventry-map"));
                String[] stringArray5 = new String[1];
                this.dualAbbrevEntryMap = this.getDualMap(teXParser, keyValList, (String)object, stringArray5);
                this.dualAbbrevEntryFirstMap = stringArray5[0];
                continue;
            }
            if (((String)object).equals("dual-abbrventry-map")) {
                String[] stringArray6 = new String[1];
                this.dualAbbrevEntryMap = this.getDualMap(teXParser, keyValList, (String)object, stringArray6);
                this.dualAbbrevEntryFirstMap = stringArray6[0];
                continue;
            }
            if (((String)object).equals("dual-indexentry-map")) {
                String[] stringArray7 = new String[1];
                this.dualIndexEntryMap = this.getDualMap(teXParser, keyValList, (String)object, stringArray7);
                this.dualIndexEntryFirstMap = stringArray7[0];
                continue;
            }
            if (((String)object).equals("dual-indexsymbol-map")) {
                String[] stringArray8 = new String[1];
                this.dualIndexSymbolMap = this.getDualMap(teXParser, keyValList, (String)object, stringArray8);
                this.dualIndexSymbolFirstMap = stringArray8[0];
                continue;
            }
            if (((String)object).equals("dual-indexabbrv-map")) {
                String[] stringArray9 = new String[1];
                this.dualIndexAbbrevMap = this.getDualMap(teXParser, keyValList, (String)object, stringArray9);
                this.dualIndexAbbrevFirstMap = stringArray9[0];
                continue;
            }
            if (((String)object).equals("dual-symbol-map")) {
                String[] stringArray10 = new String[1];
                this.dualSymbolMap = this.getDualMap(teXParser, keyValList, (String)object, stringArray10);
                this.dualSymbolFirstMap = stringArray10[0];
                continue;
            }
            if (((String)object).equals("dual-backlink")) {
                if (this.getBoolean(teXParser, keyValList, (String)object)) {
                    this.backLinkDualEntry = true;
                    this.backLinkDualAbbrev = true;
                    this.backLinkDualSymbol = true;
                    this.backLinkDualAbbrevEntry = true;
                    this.backLinkDualIndexEntry = true;
                    this.backLinkDualIndexSymbol = true;
                    this.backLinkDualIndexAbbrev = true;
                    continue;
                }
                this.backLinkDualEntry = false;
                this.backLinkDualAbbrev = false;
                this.backLinkDualSymbol = false;
                this.backLinkDualAbbrevEntry = false;
                this.backLinkDualIndexEntry = false;
                this.backLinkDualIndexSymbol = false;
                this.backLinkDualIndexAbbrev = false;
                continue;
            }
            if (((String)object).equals("dual-entry-backlink")) {
                this.backLinkDualEntry = this.getBoolean(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("dual-abbrv-backlink")) {
                this.backLinkDualAbbrev = this.getBoolean(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("dual-entryabbrv-backlink")) {
                this.bib2gls.warning(this.bib2gls.getMessage("warning.deprecated.option", object, "dual-abbrventry-backlink"));
                this.backLinkDualAbbrevEntry = this.getBoolean(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("dual-abbrventry-backlink")) {
                this.backLinkDualAbbrevEntry = this.getBoolean(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("dual-indexentry-backlink")) {
                this.backLinkDualIndexEntry = this.getBoolean(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("dual-indexsymbol-backlink")) {
                this.backLinkDualIndexSymbol = this.getBoolean(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("dual-indexabbrv-backlink")) {
                this.backLinkDualIndexAbbrev = this.getBoolean(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("dual-symbol-backlink")) {
                this.backLinkDualSymbol = this.getBoolean(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("type")) {
                this.type = this.getRequired(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("dual-type")) {
                this.dualType = this.getRequired(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("trigger-type")) {
                this.triggerType = this.getRequired(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("dual-field")) {
                this.dualField = this.getOptional(teXParser, "dual", keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("category")) {
                this.category = this.getRequired(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("dual-category")) {
                this.dualCategory = this.getRequired(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("counter")) {
                this.counter = this.getRequired(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("dual-counter")) {
                this.dualCounter = this.getRequired(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("label-prefix")) {
                this.labelPrefix = this.getOptional(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("dual-prefix")) {
                this.dualPrefix = this.getOptional(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("tertiary-prefix")) {
                this.tertiaryPrefix = this.getOptional(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("tertiary-category")) {
                this.tertiaryCategory = this.getOptional(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("tertiary-type")) {
                this.tertiaryType = this.getOptional(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("cs-label-prefix")) {
                this.csLabelPrefix = this.getOptional(teXParser, keyValList, (String)object);
                if (this.csLabelPrefix != null) continue;
                this.csLabelPrefix = "";
                continue;
            }
            if (((String)object).equals("record-label-prefix")) {
                this.recordLabelPrefix = this.getOptional(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("duplicate-label-suffix")) {
                this.dupLabelSuffix = this.getOptional(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("save-original-id")) {
                this.saveOriginalId = this.getOptional(teXParser, keyValList, (String)object);
                if (this.saveOriginalId == null || this.saveOriginalId.isEmpty()) {
                    this.saveOriginalId = "originalid";
                    continue;
                }
                if (!this.saveOriginalId.equals("false")) continue;
                this.saveOriginalId = null;
                continue;
            }
            if (((String)object).equals("sort-suffix")) {
                String string16 = this.getRequired(teXParser, keyValList, (String)object);
                if (string16.equals("none")) {
                    this.sortSettings.setSuffixOption(0);
                } else if (string16.equals("non-unique")) {
                    this.sortSettings.setSuffixOption(1);
                } else if (this.bib2gls.isKnownField(string16)) {
                    this.sortSettings.setSuffixOption(2);
                    this.sortSettings.setSuffixField(string16);
                } else {
                    throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.value", object, string16));
                }
                this.dualSortSettings.setSuffixOption(this.sortSettings.getSuffixOption());
                this.dualSortSettings.setSuffixField(this.sortSettings.getSuffixField());
                this.secondarySortSettings.setSuffixOption(this.sortSettings.getSuffixOption());
                this.secondarySortSettings.setSuffixField(this.sortSettings.getSuffixField());
                continue;
            }
            if (((String)object).equals("dual-sort-suffix")) {
                String string17 = this.getRequired(teXParser, keyValList, (String)object);
                if (string17.equals("none")) {
                    this.dualSortSettings.setSuffixOption(0);
                    continue;
                }
                if (string17.equals("non-unique")) {
                    this.dualSortSettings.setSuffixOption(1);
                    continue;
                }
                if (this.bib2gls.isKnownField(string17)) {
                    this.dualSortSettings.setSuffixOption(2);
                    this.dualSortSettings.setSuffixField(string17);
                    continue;
                }
                throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.value", object, string17));
            }
            if (((String)object).equals("secondary-sort-suffix")) {
                String string18 = this.getRequired(teXParser, keyValList, (String)object);
                if (string18.equals("none")) {
                    this.secondarySortSettings.setSuffixOption(0);
                    continue;
                }
                if (string18.equals("non-unique")) {
                    this.secondarySortSettings.setSuffixOption(1);
                    continue;
                }
                if (this.bib2gls.isKnownField(string18)) {
                    this.secondarySortSettings.setSuffixOption(2);
                    this.secondarySortSettings.setSuffixField(string18);
                    continue;
                }
                throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.value", object, string18));
            }
            if (((String)object).equals("sort-suffix-marker")) {
                this.sortSettings.setSuffixMarker(this.replaceHex(this.getOptional(teXParser, "", keyValList, (String)object)));
                this.dualSortSettings.setSuffixMarker(this.sortSettings.getSuffixMarker());
                this.secondarySortSettings.setSuffixMarker(this.sortSettings.getSuffixMarker());
                continue;
            }
            if (((String)object).equals("dual-sort-suffix-marker")) {
                this.dualSortSettings.setSuffixMarker(this.replaceHex(this.getOptional(teXParser, "", keyValList, (String)object)));
                continue;
            }
            if (((String)object).equals("secondary-sort-suffix-marker")) {
                this.secondarySortSettings.setSuffixMarker(this.replaceHex(this.getOptional(teXParser, "", keyValList, (String)object)));
                continue;
            }
            if (((String)object).equals("group-formation")) {
                String string19 = this.getChoice(teXParser, keyValList, (String)object, "default", "codepoint", "unicode category", "unicode script", "unicode category and script");
                if (string19.equals("codepoint")) {
                    this.sortSettings.setGroupFormation(1);
                    continue;
                }
                if (string19.equals("unicode category")) {
                    this.sortSettings.setGroupFormation(2);
                    continue;
                }
                if (string19.equals("unicode script")) {
                    this.sortSettings.setGroupFormation(3);
                    continue;
                }
                if (string19.equals("unicode category and script")) {
                    this.sortSettings.setGroupFormation(4);
                    continue;
                }
                this.sortSettings.setGroupFormation(0);
                continue;
            }
            if (((String)object).equals("secondary-group-formation")) {
                String string20 = this.getChoice(teXParser, keyValList, (String)object, "default", "codepoint", "unicode category", "unicode script", "unicode category and script");
                if (string20.equals("codepoint")) {
                    this.secondarySortSettings.setGroupFormation(1);
                    continue;
                }
                if (string20.equals("unicode category")) {
                    this.secondarySortSettings.setGroupFormation(2);
                    continue;
                }
                if (string20.equals("unicode script")) {
                    this.secondarySortSettings.setGroupFormation(3);
                    continue;
                }
                if (string20.equals("unicode category and script")) {
                    this.secondarySortSettings.setGroupFormation(4);
                    continue;
                }
                this.secondarySortSettings.setGroupFormation(0);
                continue;
            }
            if (((String)object).equals("dual-group-formation")) {
                String string21 = this.getChoice(teXParser, keyValList, (String)object, "default", "codepoint", "unicode category", "unicode script", "unicode category and script");
                if (string21.equals("codepoint")) {
                    this.dualSortSettings.setGroupFormation(1);
                    continue;
                }
                if (string21.equals("unicode category")) {
                    this.dualSortSettings.setGroupFormation(2);
                    continue;
                }
                if (string21.equals("unicode script")) {
                    this.dualSortSettings.setGroupFormation(3);
                    continue;
                }
                if (string21.equals("unicode category and script")) {
                    this.dualSortSettings.setGroupFormation(4);
                    continue;
                }
                this.dualSortSettings.setGroupFormation(0);
                continue;
            }
            if (((String)object).equals("identical-sort-action")) {
                String string22 = this.getRequired(teXParser, keyValList, (String)object);
                if (string22.equals("none")) {
                    this.sortSettings.setIdenticalSortAction(0);
                } else if (string22.equals(PATTERN_FIELD_ID)) {
                    this.sortSettings.setIdenticalSortAction(1);
                } else if (string22.equals("original id")) {
                    this.sortSettings.setIdenticalSortAction(3);
                } else if (this.bib2gls.isKnownField(string22)) {
                    this.sortSettings.setIdenticalSortAction(2);
                    this.sortSettings.setIdenticalSortField(string22);
                } else {
                    throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.value", object, string22));
                }
                this.dualSortSettings.setIdenticalSortAction(this.sortSettings.getIdenticalSortAction());
                this.dualSortSettings.setIdenticalSortField(this.sortSettings.getIdenticalSortField());
                this.secondarySortSettings.setIdenticalSortAction(this.sortSettings.getIdenticalSortAction());
                this.secondarySortSettings.setIdenticalSortField(this.sortSettings.getIdenticalSortField());
                continue;
            }
            if (((String)object).equals("dual-identical-sort-action")) {
                String string23 = this.getRequired(teXParser, keyValList, (String)object);
                if (string23.equals("none")) {
                    this.dualSortSettings.setIdenticalSortAction(0);
                    continue;
                }
                if (string23.equals(PATTERN_FIELD_ID)) {
                    this.dualSortSettings.setIdenticalSortAction(1);
                    continue;
                }
                if (string23.equals("original id")) {
                    this.dualSortSettings.setIdenticalSortAction(3);
                    continue;
                }
                if (this.bib2gls.isKnownField(string23)) {
                    this.dualSortSettings.setIdenticalSortAction(2);
                    this.dualSortSettings.setIdenticalSortField(string23);
                    continue;
                }
                throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.value", object, string23));
            }
            if (((String)object).equals("secondary-identical-sort-action")) {
                String string24 = this.getRequired(teXParser, keyValList, (String)object);
                if (string24.equals("none")) {
                    this.secondarySortSettings.setIdenticalSortAction(0);
                    continue;
                }
                if (string24.equals(PATTERN_FIELD_ID)) {
                    this.secondarySortSettings.setIdenticalSortAction(1);
                    continue;
                }
                if (string24.equals("original id")) {
                    this.secondarySortSettings.setIdenticalSortAction(3);
                    continue;
                }
                if (this.bib2gls.isKnownField(string24)) {
                    this.secondarySortSettings.setIdenticalSortAction(2);
                    this.secondarySortSettings.setIdenticalSortField(string24);
                    continue;
                }
                throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.value", object, string24));
            }
            if (((String)object).equals("sort")) {
                String string25 = this.getOptional(teXParser, "doc", keyValList, (String)object);
                try {
                    this.sortSettings.setMethod(string25);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.sort.value", string25, object), illegalArgumentException);
                }
            }
            if (((String)object).equals("sort-rule")) {
                this.sortSettings.setCollationRule(this.replaceHexAndSpecial(this.getRequired(teXParser, keyValList, (String)object)));
                continue;
            }
            if (((String)object).equals("dual-sort-rule")) {
                this.dualSortSettings.setCollationRule(this.replaceHexAndSpecial(this.getRequired(teXParser, keyValList, (String)object)));
                continue;
            }
            if (((String)object).equals("secondary-sort-rule")) {
                this.secondarySortSettings.setCollationRule(this.replaceHexAndSpecial(this.getRequired(teXParser, keyValList, (String)object)));
                continue;
            }
            if (((String)object).equals("sort-number-pad")) {
                this.sortSettings.setNumberPad(this.getRequiredInt(teXParser, keyValList, (String)object));
                this.dualSortSettings.setNumberPad(this.sortSettings.getNumberPad());
                this.secondarySortSettings.setNumberPad(this.sortSettings.getNumberPad());
                continue;
            }
            if (((String)object).equals("dual-sort-number-pad")) {
                this.dualSortSettings.setNumberPad(this.getRequiredInt(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("secondary-sort-number-pad")) {
                this.secondarySortSettings.setNumberPad(this.getRequiredInt(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("sort-pad-plus")) {
                this.sortSettings.setPadPlus(this.replaceHex(this.getOptional(teXParser, "", keyValList, (String)object)));
                this.dualSortSettings.setPadPlus(this.sortSettings.getPadPlus());
                this.secondarySortSettings.setPadPlus(this.sortSettings.getPadPlus());
                continue;
            }
            if (((String)object).equals("dual-sort-pad-plus")) {
                this.dualSortSettings.setPadPlus(this.replaceHex(this.getOptional(teXParser, "", keyValList, (String)object)));
                continue;
            }
            if (((String)object).equals("secondary-sort-pad-plus")) {
                this.secondarySortSettings.setPadPlus(this.replaceHex(this.getOptional(teXParser, "", keyValList, (String)object)));
                continue;
            }
            if (((String)object).equals("sort-pad-minus")) {
                this.sortSettings.setPadMinus(this.replaceHex(this.getOptional(teXParser, "", keyValList, (String)object)));
                this.dualSortSettings.setPadMinus(this.sortSettings.getPadMinus());
                this.secondarySortSettings.setPadMinus(this.sortSettings.getPadMinus());
                continue;
            }
            if (((String)object).equals("dual-sort-pad-minus")) {
                this.dualSortSettings.setPadMinus(this.replaceHex(this.getOptional(teXParser, "", keyValList, (String)object)));
                continue;
            }
            if (((String)object).equals("secondary-sort-pad-minus")) {
                this.secondarySortSettings.setPadMinus(this.replaceHex(this.getOptional(teXParser, "", keyValList, (String)object)));
                continue;
            }
            if (((String)object).equals("numeric-locale")) {
                this.sortSettings.setNumberLocale(this.getRequired(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("dual-numeric-locale")) {
                this.dualSortSettings.setNumberLocale(this.getRequired(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("secondary-numeric-locale")) {
                this.secondarySortSettings.setNumberLocale(this.getRequired(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("numeric-sort-pattern")) {
                this.sortSettings.setNumberFormat(this.replaceHexAndSpecial(this.getRequired(teXParser, keyValList, (String)object)));
                continue;
            }
            if (((String)object).equals("dual-numeric-sort-pattern")) {
                this.dualSortSettings.setNumberFormat(this.replaceHexAndSpecial(this.getRequired(teXParser, keyValList, (String)object)));
                continue;
            }
            if (((String)object).equals("secondary-numeric-sort-pattern")) {
                this.secondarySortSettings.setNumberFormat(this.replaceHexAndSpecial(this.getRequired(teXParser, keyValList, (String)object)));
                continue;
            }
            if (((String)object).equals("trim-sort")) {
                this.sortSettings.setTrim(this.getBoolean(teXParser, keyValList, (String)object));
                this.dualSortSettings.setTrim(this.sortSettings.isTrimOn());
                this.secondarySortSettings.setTrim(this.sortSettings.isTrimOn());
                continue;
            }
            if (((String)object).equals("dual-trim-sort")) {
                this.dualSortSettings.setTrim(this.getBoolean(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("secondary-trim-sort")) {
                this.secondarySortSettings.setTrim(this.getBoolean(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("letter-number-rule")) {
                this.sortSettings.setLetterNumberRule(this.getLetterNumberRule(teXParser, keyValList, (String)object));
                this.dualSortSettings.setLetterNumberRule(this.sortSettings.getLetterNumberRule());
                this.secondarySortSettings.setLetterNumberRule(this.sortSettings.getLetterNumberRule());
                continue;
            }
            if (((String)object).equals("dual-letter-number-rule")) {
                this.dualSortSettings.setLetterNumberRule(this.getLetterNumberRule(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("secondary-letter-number-rule")) {
                this.secondarySortSettings.setLetterNumberRule(this.getLetterNumberRule(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("letter-number-punc-rule")) {
                this.sortSettings.setLetterNumberPuncRule(this.getLetterNumberPuncRule(teXParser, keyValList, (String)object));
                this.dualSortSettings.setLetterNumberPuncRule(this.sortSettings.getLetterNumberPuncRule());
                this.secondarySortSettings.setLetterNumberPuncRule(this.sortSettings.getLetterNumberPuncRule());
                continue;
            }
            if (((String)object).equals("dual-letter-number-punc-rule")) {
                this.dualSortSettings.setLetterNumberPuncRule(this.getLetterNumberPuncRule(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("secondary-letter-number-punc-rule")) {
                this.secondarySortSettings.setLetterNumberPuncRule(this.getLetterNumberPuncRule(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("date-sort-format")) {
                this.sortSettings.setDateFormat(this.replaceHexAndSpecial(this.getRequired(teXParser, keyValList, (String)object)));
                continue;
            }
            if (((String)object).equals("dual-date-sort-format")) {
                this.dualSortSettings.setDateFormat(this.replaceHexAndSpecial(this.getRequired(teXParser, keyValList, (String)object)));
                continue;
            }
            if (((String)object).equals("secondary-date-sort-format")) {
                this.secondarySortSettings.setDateFormat(this.replaceHexAndSpecial(this.getRequired(teXParser, keyValList, (String)object)));
                continue;
            }
            if (((String)object).equals("date-sort-locale")) {
                this.sortSettings.setDateLocale(this.getRequired(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("dual-date-sort-locale")) {
                this.dualSortSettings.setDateLocale(this.getRequired(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("secondary-date-sort-locale")) {
                this.secondarySortSettings.setDateLocale(this.getRequired(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("group")) {
                if (this.bib2gls.useGroupField()) {
                    this.groupField = this.getOptional(teXParser, "auto", keyValList, (String)object);
                    if (!this.groupField.equals("auto")) continue;
                    this.groupField = null;
                    continue;
                }
                this.bib2gls.warning(this.bib2gls.getMessage("warning.group.option.required", object, "--group"));
                this.groupField = null;
                continue;
            }
            if (((String)object).equals("shuffle")) {
                long l = this.getOptionalLong(teXParser, 0L, keyValList, (String)object);
                this.random = l == 0L ? new Random() : new Random(l);
                this.sortSettings.setMethod("random");
                this.flatten = true;
                continue;
            }
            if (((String)object).equals("dual-sort")) {
                String string26 = this.getOptional(teXParser, "doc", keyValList, (String)object);
                try {
                    this.dualSortSettings.setMethod(string26);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.sort.value", string26, object), illegalArgumentException);
                }
            }
            if (((String)object).equals("sort-field")) {
                String string27 = this.getRequired(teXParser, keyValList, (String)object);
                if (!string27.equals(PATTERN_FIELD_ID) && !this.bib2gls.isKnownField(string27)) {
                    throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.value", object, string27));
                }
                this.sortSettings.setSortField(string27);
                continue;
            }
            if (((String)object).equals("dual-sort-field")) {
                String string28 = this.getRequired(teXParser, keyValList, (String)object);
                if (!string28.equals(PATTERN_FIELD_ID) && !this.bib2gls.isKnownField(string28)) {
                    throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.value", object, string28));
                }
                this.dualSortSettings.setSortField(string28);
                continue;
            }
            if (((String)object).equals("missing-sort-fallback")) {
                this.sortSettings.setMissingFieldFallback(this.getOptional(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("dual-missing-sort-fallback")) {
                this.dualSortSettings.setMissingFieldFallback(this.getOptional(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("secondary-missing-sort-fallback")) {
                this.secondarySortSettings.setMissingFieldFallback(this.getOptional(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("abbreviation-sort-fallback")) {
                this.abbrevDefaultSortField = this.getRequired(teXParser, keyValList, (String)object);
                if (this.bib2gls.isKnownField(this.abbrevDefaultSortField)) continue;
                throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.value", object, this.abbrevDefaultSortField));
            }
            if (((String)object).equals("symbol-sort-fallback")) {
                this.symbolDefaultSortField = this.getRequired(teXParser, keyValList, (String)object);
                if (this.bib2gls.isKnownField(this.symbolDefaultSortField)) continue;
                throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.value", object, this.symbolDefaultSortField));
            }
            if (((String)object).equals("abbreviation-name-fallback")) {
                this.abbrevDefaultNameField = this.getRequired(teXParser, keyValList, (String)object);
                if (this.bib2gls.isKnownField(this.abbrevDefaultNameField)) continue;
                throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.value", object, this.abbrevDefaultNameField));
            }
            if (((String)object).equals("charset")) {
                this.bibCharset = Charset.forName(this.getRequired(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("min-loc-range")) {
                this.minLocationRange = this.getRequiredIntGe(teXParser, 2, "none", Integer.MAX_VALUE, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("loc-gap")) {
                this.bib2gls.warning(this.bib2gls.getMessage("warning.deprecated", object, "max-loc-diff"));
                this.locGap = this.getRequiredIntGe(teXParser, 1, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("max-loc-diff")) {
                this.locGap = this.getRequiredIntGe(teXParser, 1, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("suffixF")) {
                this.suffixF = this.getOptional(teXParser, "", keyValList, (String)object);
                if (!this.suffixF.equals("none")) continue;
                this.suffixF = null;
                continue;
            }
            if (((String)object).equals("suffixFF")) {
                this.suffixFF = this.getOptional(teXParser, "", keyValList, (String)object);
                if (!this.suffixFF.equals("none")) continue;
                this.suffixFF = null;
                continue;
            }
            if (((String)object).equals("see")) {
                String string29 = this.getChoice(teXParser, keyValList, (String)object, "omit", "before", "after");
                if (string29.equals("omit")) {
                    this.seeLocation = 0;
                    continue;
                }
                if (string29.equals("before")) {
                    this.seeLocation = 1;
                    continue;
                }
                if (!string29.equals("after")) continue;
                this.seeLocation = 2;
                continue;
            }
            if (((String)object).equals("seealso")) {
                String string30 = this.getChoice(teXParser, keyValList, (String)object, "omit", "before", "after");
                if (string30.equals("omit")) {
                    this.seeAlsoLocation = 0;
                    continue;
                }
                if (string30.equals("before")) {
                    this.seeAlsoLocation = 1;
                    continue;
                }
                if (!string30.equals("after")) continue;
                this.seeAlsoLocation = 2;
                continue;
            }
            if (((String)object).equals("alias")) {
                String string31 = this.getChoice(teXParser, keyValList, (String)object, "omit", "before", "after");
                if (string31.equals("omit")) {
                    this.aliasLocation = 0;
                    continue;
                }
                if (string31.equals("before")) {
                    this.aliasLocation = 1;
                    continue;
                }
                if (!string31.equals("after")) continue;
                this.aliasLocation = 2;
                continue;
            }
            if (((String)object).equals("loc-counters")) {
                String[] stringArray11 = this.getStringArray(teXParser, keyValList, (String)object);
                if (stringArray11 == null || stringArray11.length == 0) {
                    throw new IllegalArgumentException(this.bib2gls.getMessage("error.missing.value", object));
                }
                if (stringArray11.length == 1) {
                    if (stringArray11[0].equals("as-use")) {
                        this.counters = null;
                        continue;
                    }
                    this.counters = stringArray11;
                    continue;
                }
                this.counters = stringArray11;
                continue;
            }
            if (((String)object).equals("loc-prefix")) {
                String[] stringArray12 = this.getStringArray(teXParser, "true", keyValList, (String)object);
                this.defpagesname = false;
                if (stringArray12.length == 1) {
                    if (stringArray12[0].equals("false")) {
                        this.locationPrefix = null;
                        continue;
                    }
                    if (stringArray12[0].equals("comma")) {
                        this.locationPrefix = new String[]{", "};
                        continue;
                    }
                    if (stringArray12[0].equals("list")) {
                        this.locationPrefix = new String[]{"\\pagelistname "};
                        continue;
                    }
                    if (stringArray12[0].equals("true")) {
                        this.locationPrefix = new String[]{"\\bibglspagename ", "\\bibglspagesname "};
                        this.defpagesname = true;
                        continue;
                    }
                    this.locationPrefix = stringArray12;
                    continue;
                }
                this.locationPrefix = stringArray12;
                continue;
            }
            if (((String)object).equals("loc-suffix")) {
                String[] stringArray13 = this.getStringArray(teXParser, "\\@.", keyValList, (String)object);
                if (stringArray13.length == 1) {
                    if (stringArray13[0].equals("false")) {
                        this.locationSuffix = null;
                        continue;
                    }
                    this.locationSuffix = stringArray13;
                    continue;
                }
                this.locationSuffix = stringArray13;
                continue;
            }
            if (((String)object).equals("ignore-fields")) {
                this.skipFields = this.getStringArray(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("check-end-punctuation")) {
                this.checkEndPunc = this.getStringArray(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("date-time-fields")) {
                this.dateTimeList = this.getStringArray(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("date-fields")) {
                this.dateList = this.getStringArray(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("time-fields")) {
                this.timeList = this.getStringArray(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("date-time-field-format")) {
                this.dualDateTimeListFormat = this.dateTimeListFormat = this.replaceHexAndSpecial(this.getRequired(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("dual-date-time-field-format")) {
                this.dualDateTimeListFormat = this.replaceHexAndSpecial(this.getRequired(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("date-field-format")) {
                this.dualDateListFormat = this.dateListFormat = this.replaceHexAndSpecial(this.getRequired(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("dual-date-field-format")) {
                this.dualDateListFormat = this.replaceHexAndSpecial(this.getRequired(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("time-field-format")) {
                this.dualTimeListFormat = this.timeListFormat = this.replaceHexAndSpecial(this.getRequired(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("dual-time-field-format")) {
                this.dualTimeListFormat = this.replaceHexAndSpecial(this.getRequired(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("date-time-field-locale")) {
                this.dualDateTimeListLocale = this.dateTimeListLocale = this.getLocale(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("dual-date-time-field-locale")) {
                this.dualDateTimeListLocale = this.getLocale(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("date-field-locale")) {
                this.dualDateListLocale = this.dateListLocale = this.getLocale(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("dual-date-field-locale")) {
                this.dualDateListLocale = this.getLocale(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("time-field-locale")) {
                this.dualTimeListLocale = this.timeListLocale = this.getLocale(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("dual-time-field-locale")) {
                this.dualTimeListLocale = this.getLocale(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("bibtex-contributor-fields")) {
                this.bibtexAuthorList = this.getStringArray(teXParser, keyValList, (String)object);
                continue;
            }
            if (((String)object).equals("contributor-order")) {
                String string32 = this.getChoice(teXParser, keyValList, (String)object, "surname", "von", "forenames");
                if (string32.equals("surname")) {
                    this.contributorOrder = 0;
                    continue;
                }
                if (string32.equals("von")) {
                    this.contributorOrder = 1;
                    continue;
                }
                if (!string32.equals("forenames")) continue;
                this.contributorOrder = (byte)2;
                continue;
            }
            if (((String)object).equals("selection")) {
                String string33 = this.getChoice(teXParser, keyValList, (String)object, SELECTION_OPTIONS);
                this.selectionMode = -1;
                for (n2 = 0; n2 < SELECTION_OPTIONS.length; ++n2) {
                    if (!string33.equals(SELECTION_OPTIONS[n2])) continue;
                    this.selectionMode = n2;
                    continue block12;
                }
                continue;
            }
            if (((String)object).equals("break-at")) {
                this.sortSettings.setBreakPoint(this.getBreakAt(teXParser, keyValList, (String)object));
                this.dualSortSettings.setBreakPoint(this.sortSettings.getBreakPoint());
                this.secondarySortSettings.setBreakPoint(this.sortSettings.getBreakPoint());
                continue;
            }
            if (((String)object).equals("dual-break-at")) {
                this.dualSortSettings.setBreakPoint(this.getBreakAt(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("secondary-break-at")) {
                this.secondarySortSettings.setBreakPoint(this.getBreakAt(teXParser, keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("break-marker")) {
                this.sortSettings.setBreakPointMarker(this.getOptional(teXParser, "", keyValList, (String)object));
                this.dualSortSettings.setBreakPointMarker(this.sortSettings.getBreakPointMarker());
                this.secondarySortSettings.setBreakPointMarker(this.sortSettings.getBreakPointMarker());
                continue;
            }
            if (((String)object).equals("dual-break-marker")) {
                this.dualSortSettings.setBreakPointMarker(this.getOptional(teXParser, "", keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("secondary-break-marker")) {
                this.secondarySortSettings.setBreakPointMarker(this.getOptional(teXParser, "", keyValList, (String)object));
                continue;
            }
            if (((String)object).equals("strength")) {
                String string34 = this.getChoice(teXParser, keyValList, (String)object, "primary", "secondary", "tertiary", "identical");
                if (string34.equals("primary")) {
                    this.sortSettings.setCollatorStrength(0);
                } else if (string34.equals("secondary")) {
                    this.sortSettings.setCollatorStrength(1);
                } else if (string34.equals("tertiary")) {
                    this.sortSettings.setCollatorStrength(2);
                } else if (string34.equals("identical")) {
                    this.sortSettings.setCollatorStrength(3);
                }
                this.dualSortSettings.setCollatorStrength(this.sortSettings.getCollatorStrength());
                this.secondarySortSettings.setCollatorStrength(this.sortSettings.getCollatorStrength());
                continue;
            }
            if (((String)object).equals("dual-strength")) {
                String string35 = this.getChoice(teXParser, keyValList, (String)object, "primary", "secondary", "tertiary", "identical");
                if (string35.equals("primary")) {
                    this.dualSortSettings.setCollatorStrength(0);
                    continue;
                }
                if (string35.equals("secondary")) {
                    this.dualSortSettings.setCollatorStrength(1);
                    continue;
                }
                if (string35.equals("tertiary")) {
                    this.dualSortSettings.setCollatorStrength(2);
                    continue;
                }
                if (!string35.equals("identical")) continue;
                this.dualSortSettings.setCollatorStrength(3);
                continue;
            }
            if (((String)object).equals("secondary-strength")) {
                String string36 = this.getChoice(teXParser, keyValList, (String)object, "primary", "secondary", "tertiary", "identical");
                if (string36.equals("primary")) {
                    this.secondarySortSettings.setCollatorStrength(0);
                    continue;
                }
                if (string36.equals("secondary")) {
                    this.secondarySortSettings.setCollatorStrength(1);
                    continue;
                }
                if (string36.equals("tertiary")) {
                    this.secondarySortSettings.setCollatorStrength(2);
                    continue;
                }
                if (!string36.equals("identical")) continue;
                this.secondarySortSettings.setCollatorStrength(3);
                continue;
            }
            if (((String)object).equals("decomposition")) {
                String string37 = this.getChoice(teXParser, keyValList, (String)object, "none", "canonical", "full");
                if (string37.equals("none")) {
                    this.sortSettings.setCollatorDecomposition(0);
                } else if (string37.equals("canonical")) {
                    this.sortSettings.setCollatorDecomposition(1);
                } else if (string37.equals("full")) {
                    this.sortSettings.setCollatorDecomposition(2);
                }
                this.dualSortSettings.setCollatorDecomposition(this.sortSettings.getCollatorDecomposition());
                this.secondarySortSettings.setCollatorDecomposition(this.sortSettings.getCollatorDecomposition());
                continue;
            }
            if (((String)object).equals("dual-decomposition")) {
                String string38 = this.getChoice(teXParser, keyValList, (String)object, "none", "canonical", "full");
                if (string38.equals("none")) {
                    this.dualSortSettings.setCollatorDecomposition(0);
                    continue;
                }
                if (string38.equals("canonical")) {
                    this.dualSortSettings.setCollatorDecomposition(1);
                    continue;
                }
                if (!string38.equals("full")) continue;
                this.dualSortSettings.setCollatorDecomposition(2);
                continue;
            }
            if (((String)object).equals("secondary-decomposition")) {
                String string39 = this.getChoice(teXParser, keyValList, (String)object, "none", "canonical", "full");
                if (string39.equals("none")) {
                    this.secondarySortSettings.setCollatorDecomposition(0);
                    continue;
                }
                if (string39.equals("canonical")) {
                    this.secondarySortSettings.setCollatorDecomposition(1);
                    continue;
                }
                if (!string39.equals("full")) continue;
                this.secondarySortSettings.setCollatorDecomposition(2);
                continue;
            }
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.syntax.unknown_option", object));
        }
        if (this.csLabelPrefix == null) {
            this.csLabelPrefix = this.labelPrefix;
        }
        if (string3 != null) {
            this.parseSupplemental(teXParser, string3);
        }
        if (string2 != null) {
            this.parseMaster(teXParser, string2);
        }
        String string40 = this.bib2gls.getDocDefaultLocale();
        this.sortSettings.setDocLocale(string40);
        this.dualSortSettings.setDocLocale(string40);
        if (this.sortSettings.isCustom() && !this.sortSettings.hasCustomRule()) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("warning.option.pair.required", "sort=custom", "sort-rules"));
        }
        if (this.sortSettings.isCustomNumeric() && !this.sortSettings.hasCustomNumericRule()) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("warning.option.pair.required", "sort=" + this.sortSettings.getMethod(), "sort-number-pattern"));
        }
        if (this.dualSortSettings.isCustom() && !this.dualSortSettings.hasCustomRule()) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("warning.option.pair.required", "dual-sort=custom", "dual-sort-rules"));
        }
        if (this.dualSortSettings.isCustomNumeric() && !this.dualSortSettings.hasCustomNumericRule()) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("warning.option.pair.required", "dual-sort=" + this.dualSortSettings.getMethod(), "dual-sort-number-pattern"));
        }
        if (this.secondarySortSettings.isCustom() && !this.secondarySortSettings.hasCustomRule()) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("warning.option.pair.required", this.secondaryField == null ? String.format("secondary={%s:%s}", this.secondarySortSettings.getMethod(), this.secondaryType) : String.format("secondary={%s:%s:%s}", this.secondarySortSettings.getMethod(), this.secondarySortSettings.getSortField(), this.secondaryType), "secondary-sort-rules"));
        }
        if (this.secondarySortSettings.isCustomNumeric() && !this.secondarySortSettings.hasCustomNumericRule()) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("warning.option.pair.required", this.secondaryField == null ? String.format("secondary={%s:%s}", this.secondarySortSettings.getMethod(), this.secondaryType) : String.format("secondary={%s:%s:%s}", this.secondarySortSettings.getMethod(), this.secondarySortSettings.getSortField(), this.secondaryType), "secondary-sort-number-pattern"));
        }
        if (this.limit > 0 && string2 != null) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.option.clash", "limit=" + this.limit, "master"));
        }
        if (this.writeAction != 0) {
            if (this.type == null) {
                throw new IllegalArgumentException(this.bib2gls.getMessage("warning.option.pair.required", "action=" + string4, "type"));
            }
            if (this.secondaryType != null) {
                throw new IllegalArgumentException(this.bib2gls.getMessage("error.option.clash", "action=" + string4, "secondary"));
            }
            if (string2 != null) {
                throw new IllegalArgumentException(this.bib2gls.getMessage("error.option.clash", "action=" + string4, "master"));
            }
        }
        if (this.selectionMode == 4 && this.sortSettings.isOrderOfRecords()) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "selection=all", "sort=use"));
            this.sortSettings.setMethod(null);
        } else if (this.matchAction == 1 && this.sortSettings.isOrderOfRecords()) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "match-action=add", "sort=use"));
            this.sortSettings.setMethod(null);
        }
        if (this.labelPrefix == null && this.dualPrefix == null || this.labelPrefix != null && this.dualPrefix != null && this.labelPrefix.equals(this.dualPrefix)) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.option.clash", String.format("label-prefix={%s}", this.labelPrefix == null ? "" : this.labelPrefix), String.format("dual-prefix={%s}", this.dualPrefix == null ? "" : this.dualPrefix)));
        }
        if (this.labelPrefix == null && this.tertiaryPrefix == null || this.labelPrefix != null && this.tertiaryPrefix != null && this.labelPrefix.equals(this.tertiaryPrefix)) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.option.clash", String.format("label-prefix={%s}", this.labelPrefix == null ? "" : this.labelPrefix), String.format("tertiary-prefix={%s}", this.tertiaryPrefix == null ? "" : this.tertiaryPrefix)));
        }
        if (this.dualPrefix == null && this.tertiaryPrefix == null || this.dualPrefix != null && this.tertiaryPrefix != null && this.dualPrefix.equals(this.tertiaryPrefix)) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.option.clash", String.format("dual-prefix={%s}", this.dualPrefix == null ? "" : this.dualPrefix), String.format("tertiary-prefix={%s}", this.tertiaryPrefix == null ? "" : this.tertiaryPrefix)));
        }
        if (this.dualEntryMap == null) {
            this.dualEntryMap = new HashMap();
            this.dualEntryMap.put("name", "description");
            this.dualEntryMap.put("plural", "descriptionplural");
            this.dualEntryMap.put("description", "name");
            this.dualEntryMap.put("descriptionplural", "plural");
            this.dualEntryFirstMap = "name";
        }
        if (this.dualAbbrevMap == null) {
            this.dualAbbrevMap = new HashMap();
            this.dualAbbrevMap.put("short", "dualshort");
            this.dualAbbrevMap.put("shortplural", "dualshortplural");
            this.dualAbbrevMap.put("long", "duallong");
            this.dualAbbrevMap.put("longplural", "duallongplural");
            this.dualAbbrevMap.put("dualshort", "short");
            this.dualAbbrevMap.put("dualshortplural", "shortplural");
            this.dualAbbrevMap.put("duallong", "long");
            this.dualAbbrevMap.put("duallongplural", "longplural");
            this.dualAbbrevFirstMap = "short";
        }
        if (this.dualAbbrevEntryMap == null) {
            this.dualAbbrevEntryMap = new HashMap();
            this.dualAbbrevEntryMap.put("long", "name");
            this.dualAbbrevEntryMap.put("longplural", "plural");
            this.dualAbbrevEntryMap.put("short", "text");
            this.dualAbbrevEntryFirstMap = "long";
        }
        if (this.dualSymbolMap == null) {
            this.dualSymbolMap = new HashMap();
            this.dualSymbolMap.put("name", "symbol");
            this.dualSymbolMap.put("plural", "symbolplural");
            this.dualSymbolMap.put("symbol", "name");
            this.dualSymbolMap.put("symbolplural", "plural");
            this.dualSymbolFirstMap = "name";
        }
        if (this.dualIndexEntryMap == null) {
            this.dualIndexEntryMap = new HashMap();
            this.dualIndexEntryMap.put("name", "name");
            this.dualIndexEntryFirstMap = "name";
        }
        if (this.dualIndexSymbolMap == null) {
            this.dualIndexSymbolMap = new HashMap();
            this.dualIndexSymbolMap.put("symbol", "name");
            this.dualIndexSymbolMap.put("name", "symbol");
            this.dualIndexSymbolMap.put("symbolplural", "plural");
            this.dualIndexSymbolMap.put("plural", "symbolplural");
            this.dualIndexSymbolFirstMap = "symbol";
        }
        if (this.dualIndexAbbrevMap == null) {
            this.dualIndexAbbrevMap = new HashMap();
            this.dualIndexAbbrevMap.put("name", "name");
            this.dualIndexAbbrevFirstMap = "name";
        }
        if (this.dualSortSettings.getMethod() == null) {
            this.dualSortSettings.setMethod("combine");
        } else if ("none".equals(this.dualSortSettings.getMethod())) {
            this.dualSortSettings.setMethod(null);
        }
        if (this.dualSortSettings.getSortField() == null) {
            this.dualSortSettings.setSortField(this.sortSettings.getSortField());
        }
        if (this.bib2gls.getVerboseLevel() > 0) {
            this.bib2gls.logMessage();
            this.bib2gls.verboseMessage("message.selection.mode", SELECTION_OPTIONS[this.selectionMode]);
            if (this.skipFields != null) {
                this.bib2gls.verboseMessage("message.ignore.fields", new Object[0]);
                for (int i = 0; i < this.skipFields.length; ++i) {
                    this.bib2gls.verbose(this.skipFields[i]);
                }
                this.bib2gls.logMessage();
            }
            this.sortSettings.verboseMessages(this.bib2gls);
            this.dualSortSettings.verboseMessages(this.bib2gls, "dual.sort");
            this.bib2gls.verboseMessage("message.label.prefix", this.labelPrefix == null ? "" : this.labelPrefix);
            this.bib2gls.verboseMessage("message.dual.label.prefix", this.dualPrefix == null ? "" : this.dualPrefix);
            this.bib2gls.verboseMessage("message.tertiary.label.prefix", this.tertiaryPrefix == null ? "" : this.tertiaryPrefix);
            this.bib2gls.logMessage();
            this.bib2gls.verboseMessage("message.dual.entry.mappings", new Object[0]);
            for (String string41 : this.dualEntryMap.keySet()) {
                this.bib2gls.verbose(String.format("%s -> %s", string41, this.dualEntryMap.get(string41)));
            }
            this.bib2gls.logMessage();
            this.bib2gls.verboseMessage("message.dual.symbol.mappings", new Object[0]);
            for (String string42 : this.dualSymbolMap.keySet()) {
                this.bib2gls.verbose(String.format("%s -> %s", string42, this.dualSymbolMap.get(string42)));
            }
            this.bib2gls.logMessage();
            this.bib2gls.verboseMessage("message.dual.abbreviation.mappings", new Object[0]);
            for (String string43 : this.dualAbbrevMap.keySet()) {
                this.bib2gls.verbose(String.format("%s -> %s", string43, this.dualAbbrevMap.get(string43)));
            }
            this.bib2gls.logMessage();
            this.bib2gls.verboseMessage("message.dual.abbreviationentry.mappings", new Object[0]);
            for (String string44 : this.dualAbbrevEntryMap.keySet()) {
                this.bib2gls.verbose(String.format("%s -> %s", string44, this.dualAbbrevEntryMap.get(string44)));
            }
            this.bib2gls.logMessage();
            this.bib2gls.verboseMessage("message.dual.indexentry.mappings", new Object[0]);
            for (String string45 : this.dualIndexEntryMap.keySet()) {
                this.bib2gls.verbose(String.format("%s -> %s", string45, this.dualIndexEntryMap.get(string45)));
            }
            this.bib2gls.logMessage();
            this.bib2gls.verboseMessage("message.dual.indexsymbol.mappings", new Object[0]);
            for (String string46 : this.dualIndexSymbolMap.keySet()) {
                this.bib2gls.verbose(String.format("%s -> %s", string46, this.dualIndexSymbolMap.get(string46)));
            }
            this.bib2gls.logMessage();
            this.bib2gls.verboseMessage("message.dual.indexabbrv.mappings", new Object[0]);
            for (String string47 : this.dualIndexAbbrevMap.keySet()) {
                this.bib2gls.verbose(String.format("%s -> %s", string47, this.dualIndexAbbrevMap.get(string47)));
            }
            this.bib2gls.logMessage();
        }
        if (stringArray == null && string2 == null) {
            try {
                this.sources.add(this.bib2gls.getBibFilePath(teXParser, string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Bib2GlsException(this.bib2gls.getMessage("error.missing.src", string + ".bib"), fileNotFoundException);
            }
        }
    }

    private void parseMaster(TeXParser teXParser, String string) throws IOException, Bib2GlsException {
        if (this.sources.size() > 0) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "src"));
            this.sources.clear();
        }
        if (this.supplementalRecords != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "supplemental-locations"));
        }
        if (this.nameCaseChange != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "name-case-change"));
        }
        if (this.descCaseChange != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "description-case-change"));
        }
        if (this.shortCaseChange != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "short-case-change"));
        }
        if (this.dualShortCaseChange != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "dual-short-case-change"));
        }
        if (this.shortPluralSuffix != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "short-plural-suffix"));
        }
        if (this.dualShortPluralSuffix != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "dual-short-plural-suffix"));
        }
        if (this.fieldPatterns != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "match"));
        }
        if (this.secondaryType != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "secondary"));
        }
        if (this.externalPrefixes != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "ext-prefixes"));
        }
        if (this.flatten) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "flatten"));
        }
        if (this.setWidest) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "set-widest"));
        }
        if (this.dualType != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "dual-type"));
        }
        if (this.dualField != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "dual-field"));
        }
        if (this.dualCategory != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "dual-category"));
        }
        if (!"dual.".equals(this.dualPrefix)) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "dual-prefix"));
        }
        if (!"tertiary.".equals(this.tertiaryPrefix)) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "tertiary-prefix"));
        }
        if (this.dualSortSettings.getMethod() != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "dual-sort"));
        }
        if (!this.dualSortSettings.getSortField().equals("sort")) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "dual-sort"));
        }
        if (!"locale".equals(this.sortSettings.getMethod())) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "sort"));
        }
        if (!this.sortSettings.getSortField().equals("sort")) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "sort"));
        }
        if (this.bibCharset != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "charset"));
        }
        if (this.minLocationRange != 3) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "min-loc-range"));
        }
        if (this.locGap != 1) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "loc-gap"));
        }
        if (this.suffixF != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "suffixF"));
        }
        if (this.suffixFF != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "suffixFF"));
        }
        if (this.seeLocation != 2) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "see"));
        }
        if (this.seeAlsoLocation != 2) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "seealso"));
        }
        if (this.aliasLocation != 2) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "alias"));
        }
        if (this.locationPrefix != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "loc-prefix"));
        }
        if (this.locationSuffix != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "loc-suffix"));
        }
        if (this.skipFields != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "ignore-fields"));
        }
        if (this.selectionMode != 0) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "selection"));
        }
        if (this.sortSettings.getCollatorStrength() != 0) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "strength"));
        }
        if (this.sortSettings.getCollatorDecomposition() != 1) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "decomposition"));
        }
        TeXPath teXPath = new TeXPath(teXParser, string + ".aux", false);
        this.bib2gls.checkReadAccess(teXPath);
        File file = teXPath.getFile();
        if (this.category == null) {
            this.category = "master";
        }
        if (this.type == null) {
            this.type = "master";
        }
        AuxParser auxParser = new AuxParser(this.bib2gls){

            @Override
            protected void addPredefined() {
                super.addPredefined();
                this.addAuxCommand("glsxtr@resource", 2);
                this.addAuxCommand("glsxtr@linkprefix", 1);
            }
        };
        this.masterPdfPath = new TeXPath(teXParser, string + ".pdf", false);
        TeXParser teXParser2 = auxParser.parseAuxFile(file);
        Vector<AuxData> vector = auxParser.getAuxData();
        this.masterGlsTeXPath = new Vector();
        for (AuxData auxData : vector) {
            String string2 = auxData.getName();
            if (string2.equals("glsxtr@resource")) {
                String string3 = auxData.getArg(1).toString(teXParser2);
                if (this.masterSelection != null) {
                    boolean bl = false;
                    for (String string4 : this.masterSelection) {
                        if (!string4.equals(string3)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                }
                TeXPath teXPath2 = new TeXPath(teXParser, string3 + ".glstex", false);
                this.bib2gls.checkReadAccess(teXPath2);
                this.masterGlsTeXPath.add(teXPath2);
                continue;
            }
            if (!string2.equals("glsxtr@linkprefix")) continue;
            this.masterLinkPrefix = auxData.getArg(0).toString(teXParser2);
        }
    }

    private void parseSupplemental(TeXParser teXParser, String string) throws IOException {
        TeXPath teXPath = new TeXPath(teXParser, string + ".aux", false);
        this.bib2gls.checkReadAccess(teXPath);
        File file = teXPath.getFile();
        AuxParser auxParser = new AuxParser(this.bib2gls){

            @Override
            protected void addPredefined() {
                super.addPredefined();
                this.addAuxCommand("glsxtr@record", 5);
            }
        };
        this.supplementalPdfPath = new TeXPath(teXParser, string + ".pdf", false);
        TeXParser teXParser2 = auxParser.parseAuxFile(file);
        Vector<AuxData> vector = auxParser.getAuxData();
        this.supplementalRecords = new Vector();
        for (AuxData auxData : vector) {
            if (!auxData.getName().equals("glsxtr@record")) continue;
            this.supplementalRecords.add(new GlsRecord(auxData.getArg(0).toString(teXParser2), auxData.getArg(1).toString(teXParser2), auxData.getArg(2).toString(teXParser2), auxData.getArg(3).toString(teXParser2), auxData.getArg(4).toString(teXParser2)));
        }
        if (this.supplementalCategory == null) {
            this.supplementalCategory = this.category;
        }
    }

    private String replaceHexAndSpecial(String string) {
        return this.replaceHex(this.replaceEscapeSpecialChar(string));
    }

    private String replaceEscapeSpecialChar(String string) {
        Pattern pattern = Pattern.compile("\\\\([#%_\\&\\{\\}])");
        Matcher matcher = pattern.matcher(string);
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (matcher.find()) {
            String string2 = matcher.group(1);
            stringBuilder.append(string.substring(n, matcher.start()));
            stringBuilder.append(string2);
            n = matcher.end();
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    private String replaceHex(String string) {
        Pattern pattern = Pattern.compile("\\\\u\\s?([0-9A-Fa-f]+)");
        Matcher matcher = pattern.matcher(string);
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (matcher.find()) {
            String string2 = matcher.group(1);
            stringBuilder.append(string.substring(n, matcher.start()));
            stringBuilder.appendCodePoint(Integer.parseInt(string2, 16));
            n = matcher.end();
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    private boolean getBoolean(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        String string2 = keyValList.getValue(string).toString(teXParser).trim();
        if (string2.isEmpty() || string2.equals("true")) {
            return true;
        }
        if (string2.equals("false")) {
            return false;
        }
        throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.choice.value", string, string2, "true, false"));
    }

    private TeXObject getRequiredObject(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        TeXObject teXObject = keyValList.getValue(string);
        if (teXObject == null) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.missing.value", string));
        }
        if (teXObject instanceof TeXObjectList && ((TeXObjectList)(teXObject = GlsResource.trimList((TeXObjectList)teXObject))).size() == 0) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.missing.value", string));
        }
        return teXObject;
    }

    private String getRequired(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        String string2;
        TeXObject teXObject = keyValList.getValue(string);
        if (teXObject == null) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.missing.value", string));
        }
        if (teXObject instanceof TeXObjectList) {
            teXObject = GlsResource.trimList((TeXObjectList)teXObject);
        }
        if ((string2 = teXObject.toString(teXParser).trim()).isEmpty()) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.missing.value", string));
        }
        return string2;
    }

    private String getOptional(TeXParser teXParser, String string, KeyValList keyValList, String string2) throws IOException {
        String string3;
        TeXObject teXObject = keyValList.getValue(string2);
        if (teXObject == null) {
            return string;
        }
        if (teXObject instanceof TeXObjectList) {
            teXObject = GlsResource.trimList((TeXObjectList)teXObject);
        }
        if ((string3 = teXObject.toString(teXParser).trim()).isEmpty()) {
            return string;
        }
        return string3;
    }

    private String getOptional(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        return this.getOptional(teXParser, null, keyValList, string);
    }

    private int getRequiredInt(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        String string2 = this.getRequired(teXParser, keyValList, string);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.int.value", string, string2), numberFormatException);
        }
    }

    private int getOptionalInt(TeXParser teXParser, int n, KeyValList keyValList, String string) throws IOException {
        String string2 = this.getOptional(teXParser, keyValList, string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.int.value", string, string2), numberFormatException);
        }
    }

    private int getRequiredInt(TeXParser teXParser, String string, int n, KeyValList keyValList, String string2) throws IOException {
        String string3 = this.getRequired(teXParser, keyValList, string2);
        if (string3.equals(string)) {
            return n;
        }
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.int.value", string2, string3), numberFormatException);
        }
    }

    private int getRequiredIntGe(TeXParser teXParser, int n, KeyValList keyValList, String string) throws IOException {
        int n2 = this.getRequiredInt(teXParser, keyValList, string);
        if (n2 < n) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.minint.value", string, n2, n));
        }
        return n2;
    }

    private int getRequiredIntGe(TeXParser teXParser, int n, String string, int n2, KeyValList keyValList, String string2) throws IOException {
        int n3 = this.getRequiredInt(teXParser, string, n2, keyValList, string2);
        if (n3 < n) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.minint.value", string2, n3, n));
        }
        return n3;
    }

    private int getOptionalIntGe(TeXParser teXParser, int n, int n2, KeyValList keyValList, String string) throws IOException {
        int n3 = this.getOptionalInt(teXParser, n2, keyValList, string);
        if (n3 < n) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.minint.value", string, n3, n));
        }
        return n3;
    }

    private long getRequiredLong(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        String string2 = this.getRequired(teXParser, keyValList, string);
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.int.value", string, string2), numberFormatException);
        }
    }

    private long getOptionalLong(TeXParser teXParser, long l, KeyValList keyValList, String string) throws IOException {
        String string2 = this.getOptional(teXParser, keyValList, string);
        if (string2 == null) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.int.value", string, string2), numberFormatException);
        }
    }

    private String getChoice(TeXParser teXParser, KeyValList keyValList, String string, String ... stringArray) throws IOException {
        return this.getChoice(teXParser, null, keyValList, string, stringArray);
    }

    private String getChoice(TeXParser teXParser, String string, KeyValList keyValList, String string2, String ... stringArray) throws IOException {
        String string3 = this.getOptional(teXParser, keyValList, string2);
        if (string3 == null) {
            if (string == null) {
                throw new IllegalArgumentException(this.bib2gls.getMessage("error.missing.value", string2));
            }
            return string;
        }
        StringBuilder stringBuilder = null;
        for (String string4 : stringArray) {
            if (string3.equals(string4)) {
                return string3;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append('\'');
            stringBuilder.append(string4);
            stringBuilder.append('\'');
        }
        throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.choice.value", string2, string3, stringBuilder));
    }

    private Locale getLocale(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        String string2 = this.getOptional(teXParser, keyValList, string);
        if (string2 == null || "locale".equals(string2)) {
            return null;
        }
        if ("doc".equals(string2)) {
            return Locale.forLanguageTag(this.bib2gls.getDocDefaultLocale());
        }
        return Locale.forLanguageTag(string2);
    }

    private String[] getStringArray(TeXParser teXParser, String string, KeyValList keyValList, String string2) throws IOException {
        String[] stringArray = this.getStringArray(teXParser, keyValList, string2);
        if (stringArray == null) {
            return new String[]{string};
        }
        return stringArray;
    }

    private String[] getStringArray(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        CsvList csvList;
        int n;
        TeXObject teXObject = keyValList.getValue(string);
        if (teXObject instanceof TeXObjectList) {
            teXObject = GlsResource.trimList((TeXObjectList)teXObject);
        }
        if ((n = (csvList = CsvList.getList(teXParser, teXObject)).size()) == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject2 = csvList.getValue(i);
            if (teXObject2 instanceof TeXObjectList) {
                teXObject2 = GlsResource.trimList((TeXObjectList)teXObject2);
            }
            stringArray[i] = teXObject2.toString(teXParser).trim();
        }
        return stringArray;
    }

    private String[] getFieldArray(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        String[] stringArray = this.getStringArray(teXParser, keyValList, string);
        if (stringArray == null) {
            return null;
        }
        for (String string2 : stringArray) {
            if (this.bib2gls.isKnownField(string2)) continue;
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.field", string2, string));
        }
        return stringArray;
    }

    private TeXObject[] getTeXObjectArray(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        CsvList csvList;
        int n;
        TeXObject teXObject = keyValList.getValue(string);
        if (teXObject instanceof TeXObjectList) {
            teXObject = GlsResource.trimList((TeXObjectList)teXObject);
        }
        if ((n = (csvList = CsvList.getList(teXParser, teXObject)).size()) == 0) {
            return null;
        }
        TeXObject[] teXObjectArray = new TeXObject[n];
        for (int i = 0; i < n; ++i) {
            teXObject = csvList.getValue(i);
            if (teXObject instanceof TeXObjectList) {
                teXObject = GlsResource.trimList((TeXObjectList)teXObject);
            }
            teXObjectArray[i] = teXObject;
        }
        return teXObjectArray;
    }

    private CsvList[] getListArray(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        CsvList csvList;
        int n;
        TeXObject teXObject = keyValList.getValue(string);
        if (teXObject instanceof TeXObjectList) {
            teXObject = GlsResource.trimList((TeXObjectList)teXObject);
        }
        if ((n = (csvList = CsvList.getList(teXParser, teXObject)).size()) == 0) {
            return null;
        }
        CsvList[] csvListArray = new CsvList[n];
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject2 = csvList.getValue(i);
            if (teXObject2 instanceof TeXObjectList) {
                teXObject2 = GlsResource.trimList((TeXObjectList)teXObject2);
            }
            csvListArray[i] = CsvList.getList(teXParser, teXObject2);
        }
        return csvListArray;
    }

    private HashMap<String, String> getDualMap(TeXParser teXParser, KeyValList keyValList, String string, String[] stringArray) throws IOException {
        CsvList[] csvListArray = this.getListArray(teXParser, keyValList, string);
        if (csvListArray == null) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.missing.value", string));
        }
        if (csvListArray.length != 2) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.list.size", string, 2));
        }
        int n = csvListArray[0].size();
        if (n != csvListArray[1].size()) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.dual.map", string, ((TeXObject)keyValList.get(string)).toString(teXParser), n, csvListArray[1].size()));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject = csvListArray[0].getValue(i);
            TeXObject teXObject2 = csvListArray[1].getValue(i);
            if (teXObject instanceof TeXObjectList) {
                teXObject = GlsResource.trimList((TeXObjectList)teXObject);
            }
            if (teXObject2 instanceof TeXObjectList) {
                teXObject2 = GlsResource.trimList((TeXObjectList)teXObject2);
            }
            String string2 = teXObject.toString(teXParser);
            String string3 = teXObject2.toString(teXParser);
            if (string2.equals("alias") || string3.equals("alias")) {
                throw new IllegalArgumentException(this.bib2gls.getMessage("error.alias.map.forbidden", new Object[0]));
            }
            hashMap.put(string2, string3);
            if (i >= stringArray.length) continue;
            stringArray[i] = string2;
        }
        return hashMap;
    }

    private KeyValList getKeyValList(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        KeyValList keyValList2;
        TeXObject teXObject = keyValList.getValue(string);
        if (teXObject instanceof TeXObjectList) {
            teXObject = GlsResource.trimList((TeXObjectList)teXObject);
        }
        if ((keyValList2 = KeyValList.getList(teXParser, teXObject)) == null || keyValList2.size() == 0) {
            return null;
        }
        return keyValList2;
    }

    private HashMap<String, String> getHashMap(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        KeyValList keyValList2;
        int n;
        TeXObject teXObject = keyValList.getValue(string);
        if (teXObject instanceof TeXObjectList) {
            teXObject = GlsResource.trimList((TeXObjectList)teXObject);
        }
        if ((n = (keyValList2 = KeyValList.getList(teXParser, teXObject)).size()) == 0) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(n);
        for (String string2 : keyValList2.keySet()) {
            teXObject = (TeXObject)keyValList2.get(string2);
            String string3 = teXObject == null ? "" : teXObject.toString(teXParser).trim();
            string2 = string2.trim();
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    private HashMap<String, Vector<String>> getHashMapVector(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        TeXObject[] teXObjectArray = this.getTeXObjectArray(teXParser, keyValList, string);
        if (teXObjectArray == null) {
            return null;
        }
        HashMap<String, Vector<String>> hashMap = new HashMap<String, Vector<String>>();
        for (int i = 0; i < teXObjectArray.length; ++i) {
            if (!(teXObjectArray[i] instanceof TeXObjectList)) {
                throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.value", string, ((TeXObject)keyValList.get(string)).toString(teXParser)));
            }
            Vector<TeXObject> vector = this.splitList(teXParser, '=', (TeXObjectList)teXObjectArray[i]);
            if (vector == null || vector.size() == 0) continue;
            String string2 = vector.get(0).toString(teXParser);
            if (vector.size() != 2) {
                throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.keylist.value", string2, teXObjectArray[i].toString(teXParser), string));
            }
            CsvList csvList = CsvList.getList(teXParser, vector.get(1));
            int n = csvList.size();
            Vector<String> vector2 = new Vector<String>(n);
            for (int j = 0; j < n; ++j) {
                TeXObject teXObject = csvList.getValue(j);
                if (teXObject instanceof TeXObjectList) {
                    teXObject = GlsResource.trimList((TeXObjectList)teXObject);
                }
                vector2.add(teXObject.toString(teXParser).trim());
            }
            hashMap.put(string2, vector2);
        }
        return hashMap;
    }

    private Vector<PatternReplace> getSubstitutionList(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        TeXObject[] teXObjectArray = this.getTeXObjectArray(teXParser, keyValList, string);
        if (teXObjectArray == null) {
            return null;
        }
        Vector<PatternReplace> vector = new Vector<PatternReplace>();
        for (TeXObject teXObject : teXObjectArray) {
            if (!(teXObject instanceof TeXObjectList) && ((TeXObjectList)teXObject).size() == 2) {
                throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.substitution", teXObject.toString(teXParser), string));
            }
            TeXObject teXObject2 = (TeXObject)((TeXObjectList)teXObject).get(0);
            TeXObject teXObject3 = (TeXObject)((TeXObjectList)teXObject).get(1);
            if (teXObject2 instanceof Group && !(teXObject2 instanceof MathGroup)) {
                teXObject2 = ((Group)teXObject2).toList();
            }
            if (teXObject3 instanceof Group && !(teXObject3 instanceof MathGroup)) {
                teXObject3 = ((Group)teXObject3).toList();
            }
            String string2 = teXObject2.toString(teXParser);
            String string3 = teXObject3.toString(teXParser);
            vector.add(new PatternReplace(string2, string3));
        }
        return vector;
    }

    private int getLetterNumberRule(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        String string2 = this.getChoice(teXParser, keyValList, string, "before letter", "after letter", "between", "first", "last");
        if (string2.equals("before letter")) {
            return 0;
        }
        if (string2.equals("after letter")) {
            return 1;
        }
        if (string2.equals("between")) {
            return 2;
        }
        if (string2.equals("first")) {
            return 3;
        }
        if (string2.equals("last")) {
            return 4;
        }
        throw new IllegalArgumentException("Invalid letter number rule");
    }

    private int getLetterNumberPuncRule(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        String string2 = this.getChoice(teXParser, keyValList, string, "punc-space-first", "punc-space-last", "space-punc-first", "space-punc-last", "space-first-punc-last", "punc-first-space-last", "punc-first-space-zero", "punc-last-space-zero", "punc-first-space-zero-match-next", "punc-last-space-zero-match-next");
        if (string2.equals("punc-space-first")) {
            return 0;
        }
        if (string2.equals("punc-space-last")) {
            return 1;
        }
        if (string2.equals("space-punc-first")) {
            return 2;
        }
        if (string2.equals("space-punc-last")) {
            return 3;
        }
        if (string2.equals("space-first-punc-last")) {
            return 4;
        }
        if (string2.equals("punc-first-space-last")) {
            return 5;
        }
        if (string2.equals("punc-first-space-zero")) {
            return 6;
        }
        if (string2.equals("punc-last-space-zero")) {
            return 7;
        }
        if (string2.equals("punc-first-space-zero-match-next")) {
            return 8;
        }
        if (string2.equals("punc-last-space-zero-match-next")) {
            return 9;
        }
        throw new IllegalArgumentException("Invalid letter number punc rule");
    }

    private int getBreakAt(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        String string2 = this.getChoice(teXParser, keyValList, string, "none", "word", "character", "sentence", "upper-notlower", "upper-upper", "upper-notlower-word", "upper-upper-word");
        if (string2.equals("none")) {
            return 0;
        }
        if (string2.equals("word")) {
            return 1;
        }
        if (string2.equals("character")) {
            return 2;
        }
        if (string2.equals("sentence")) {
            return 3;
        }
        if (string2.equals("upper-notlower")) {
            return 4;
        }
        if (string2.equals("upper-upper")) {
            return 5;
        }
        if (string2.equals("upper-notlower-word")) {
            return 6;
        }
        if (string2.equals("upper-upper-word")) {
            return 7;
        }
        throw new IllegalArgumentException("Invalid break at setting: " + string2);
    }

    public static TeXObjectList trimList(TeXObjectList teXObjectList) {
        while (teXObjectList.size() > 0 && teXObjectList.get(0) instanceof WhiteSpace) {
            teXObjectList.remove(0);
        }
        while (teXObjectList.size() > 0 && teXObjectList.lastElement() instanceof WhiteSpace) {
            teXObjectList.remove(teXObjectList.size() - 1);
        }
        if (teXObjectList.size() == 1 && teXObjectList.get(0) instanceof Group) {
            teXObjectList = ((Group)teXObjectList.get(0)).toList();
        }
        return teXObjectList;
    }

    private Vector<TeXObject> splitList(TeXParser teXParser, char c, TeXObjectList teXObjectList) throws IOException {
        while (teXObjectList.size() == 1 && teXObjectList.firstElement() instanceof TeXObjectList) {
            teXObjectList = (TeXObjectList)teXObjectList.firstElement();
        }
        if (teXObjectList.size() == 0) {
            return null;
        }
        Vector<TeXObject> vector = new Vector<TeXObject>();
        TeXObjectList teXObjectList2 = new TeXObjectList();
        for (TeXObject teXObject : teXObjectList) {
            if (teXObject instanceof CharObject && ((CharObject)teXObject).getCharCode() == c) {
                if ((teXObjectList2 = GlsResource.trimList(teXObjectList2)).size() != 0) {
                    vector.add(teXObjectList2);
                }
                teXObjectList2 = new TeXObjectList();
                continue;
            }
            teXObjectList2.add(teXObject);
        }
        if ((teXObjectList2 = GlsResource.trimList(teXObjectList2)).size() != 0) {
            vector.add(teXObjectList2);
        }
        return vector;
    }

    private void stripUnknownFieldPatterns() {
        if (this.fieldPatterns == null) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        for (String string : this.fieldPatterns.keySet()) {
            if (this.bib2gls.isKnownField(string) || string.equals(PATTERN_FIELD_ID) || string.equals(PATTERN_FIELD_ENTRY_TYPE)) continue;
            this.bib2gls.warning(this.bib2gls.getMessage("warning.unknown.field.pattern", string));
            vector.add(string);
        }
        for (String string : vector) {
            this.fieldPatterns.remove(string);
        }
        if (this.fieldPatterns.size() == 0) {
            this.fieldPatterns = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseBibFiles(TeXParser teXParser) throws IOException {
        this.bib2gls.verboseMessage("message.parsing.resource.bib", this.texFile.getName());
        this.stripUnknownFieldPatterns();
        this.bibParserListener = new Bib2GlsBibParser(this.bib2gls, this, this.bibCharset);
        for (TeXPath teXPath : this.sources) {
            File file = teXPath.getFile();
            String string = file.getName();
            string = string.substring(0, string.length() - 4);
            Charset charset = this.bibCharset;
            if (charset == null) {
                Pattern pattern = Pattern.compile("% Encoding: ([^\\s]+)");
                try (BufferedReader bufferedReader = null;){
                    String string2;
                    bufferedReader = new BufferedReader(new FileReader(file));
                    int n = 0;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        ++n;
                        Matcher matcher = pattern.matcher(string2);
                        if (!matcher.matches()) continue;
                        String string3 = matcher.group(1);
                        try {
                            charset = Charset.forName(string3);
                        }
                        catch (Exception exception) {
                            this.bib2gls.warning(file, n, this.bib2gls.getMessage("warning.ignoring.unknown.encoding", string3), exception);
                            charset = this.bibCharset;
                        }
                        bufferedReader.close();
                        bufferedReader = null;
                        break;
                    }
                }
            }
            this.bibParserListener.setCharSet(charset);
            this.bibParserListener.parse(file);
        }
    }

    public String toString() {
        return this.texFile == null ? super.toString() : this.texFile.getName();
    }

    /*
     * Could not resolve type clashes
     */
    public void processBibList(TeXParser teXParser) throws IOException, Bib2GlsException {
        Bib2GlsEntry bib2GlsEntry;
        Object object;
        this.bib2gls.verboseMessage("message.processing.resource", this.texFile.getName());
        this.processPreamble();
        TeXParser teXParser2 = this.bibParserListener.getParser();
        Vector<BibData> vector = this.bibParserListener.getBibData();
        this.bibData = new Vector();
        this.dualData = new Vector();
        Vector<GlsRecord> vector2 = this.bib2gls.getRecords();
        Vector<GlsSeeRecord> vector3 = this.bib2gls.getSeeRecords();
        Vector<Object> vector4 = null;
        Vector<Object> vector5 = null;
        if (this.selectionMode == 1) {
            vector4 = new Vector<Object>();
        }
        boolean bl = "combine".equals(this.dualSortSettings.getMethod());
        for (int i = 0; i < vector.size(); ++i) {
            String string;
            BibData bibData = vector.get(i);
            if (!(bibData instanceof Bib2GlsEntry)) continue;
            object = (Bib2GlsEntry)bibData;
            ((Bib2GlsEntry)object).parseFields(teXParser2);
            bib2GlsEntry = null;
            String string2 = ((Bib2GlsEntry)object).getId();
            String string3 = null;
            String string4 = null;
            if (object instanceof Bib2GlsDualEntry) {
                bib2GlsEntry = ((Bib2GlsDualEntry)object).createDual();
                ((Bib2GlsEntry)object).setDual(bib2GlsEntry);
                bib2GlsEntry.setDual((Bib2GlsEntry)object);
                string3 = bib2GlsEntry.getId();
                this.hasDuals = true;
                if (((Bib2GlsDualEntry)object).hasTertiary()) {
                    string4 = this.tertiaryPrefix == null ? ((Bib2GlsEntry)object).getOriginalId() : this.tertiaryPrefix + ((Bib2GlsEntry)object).getOriginalId();
                    this.hasTertiaries = true;
                }
                if (bib2GlsEntry.getField("see") != null || bib2GlsEntry.getField("seealso") != null) {
                    bib2GlsEntry.initCrossRefs(teXParser);
                }
            }
            boolean bl2 = ((Bib2GlsEntry)object).hasRecords();
            boolean bl3 = bib2GlsEntry != null && bib2GlsEntry.hasRecords();
            for (Object object2 : vector2) {
                string = this.getRecordLabel((GlsRecord)object2);
                if (string.equals(string2)) {
                    ((Bib2GlsEntry)object).addRecord((GlsRecord)object2);
                    bl2 = true;
                    if (bib2GlsEntry != null && this.combineDualLocations != 0) {
                        bib2GlsEntry.addRecord(((GlsRecord)object2).copy(string3));
                        bl3 = true;
                    }
                }
                if (bib2GlsEntry == null) continue;
                if (string.equals(string3)) {
                    bib2GlsEntry.addRecord((GlsRecord)object2);
                    bl3 = true;
                    if (this.combineDualLocations != 0) {
                        ((Bib2GlsEntry)object).addRecord(((GlsRecord)object2).copy(string2));
                        bl2 = true;
                    }
                }
                if (string4 == null || !((GlsRecord)object2).getLabel().equals(string4)) continue;
                bib2GlsEntry.addRecord(((GlsRecord)object2).copy(string3));
                bl3 = true;
                if (this.combineDualLocations == 0) continue;
                ((Bib2GlsEntry)object).addRecord(((GlsRecord)object2).copy(string2));
                bl2 = true;
            }
            for (Object object2 : vector3) {
                string = this.getRecordLabel((GlsSeeRecord)object2);
                if (string.equals(string2)) {
                    ((Bib2GlsEntry)object).addRecord((GlsSeeRecord)object2);
                    bl2 = true;
                }
                if (bib2GlsEntry == null || !string.equals(string3)) continue;
                bib2GlsEntry.addRecord((GlsSeeRecord)object2);
                bl3 = true;
            }
            this.setType((Bib2GlsEntry)object);
            this.setCategory((Bib2GlsEntry)object);
            this.setCounter((Bib2GlsEntry)object);
            if (this.discard((Bib2GlsEntry)object)) {
                this.bib2gls.verboseMessage("message.discarding.entry", ((Bib2GlsEntry)object).getId());
                continue;
            }
            ((Bib2GlsEntry)object).checkRequiredFields();
            this.bibData.add((Bib2GlsEntry)object);
            if (bib2GlsEntry != null) {
                if (this.discard(bib2GlsEntry)) {
                    this.bib2gls.verboseMessage("message.discarding.entry", string3);
                    continue;
                }
                if (bl) {
                    this.setDualType(bib2GlsEntry);
                    this.setDualCategory(bib2GlsEntry);
                    this.setDualCounter(bib2GlsEntry);
                    this.bibData.add(bib2GlsEntry);
                } else {
                    this.dualData.add(bib2GlsEntry);
                }
                if (this.dualPrimaryDependency) {
                    ((Bib2GlsEntry)object).addDependency(string3);
                    bib2GlsEntry.addDependency(string2);
                }
                if (this.bib2gls.getVerboseLevel() > 0) {
                    this.bib2gls.logMessage(this.bib2gls.getMessage("message.dual.dep", string3, string2));
                }
            }
            if (this.aliasLocations == 1 && ((BibEntry)object).getField("alias") != null) {
                if (vector5 == null) {
                    vector5 = new Vector<Object>();
                }
                vector5.add(object);
            }
            if (this.selectionMode == 1 || this.selectionMode == 0) {
                if (this.bib2gls.getVerboseLevel() > 0) {
                    this.bib2gls.logMessage(this.bib2gls.getMessage("message.checking.crossrefs", string2));
                }
                ((Bib2GlsEntry)object).initCrossRefs(teXParser);
                if (bib2GlsEntry != null) {
                    if (this.bib2gls.getVerboseLevel() > 0) {
                        this.bib2gls.logMessage(this.bib2gls.getMessage("message.checking.crossrefs", string3));
                    }
                    bib2GlsEntry.initCrossRefs(teXParser);
                }
                if (vector4 != null) {
                    if (((Bib2GlsEntry)object).hasCrossRefs() || ((BibEntry)object).getField("alias") != null) {
                        vector4.add(object);
                    }
                    if (bib2GlsEntry != null && (bib2GlsEntry.hasCrossRefs() || bib2GlsEntry.getField("alias") != null)) {
                        vector4.add(bib2GlsEntry);
                    }
                }
                if (bl2 || bl3) {
                    this.bib2gls.registerDependencies((Bib2GlsEntry)object);
                    if (bib2GlsEntry != null) {
                        this.bib2gls.registerDependencies(bib2GlsEntry);
                    }
                }
            }
            if (this.dateTimeList != null) {
                for (Iterator<Object> iterator : this.dateTimeList) {
                    ((Bib2GlsEntry)object).convertFieldToDateTime(teXParser2, (String)((Object)iterator), this.dateTimeListFormat, this.dateTimeListLocale, true, true);
                    if (bib2GlsEntry == null) continue;
                    ((Bib2GlsEntry)object).convertFieldToDateTime(teXParser2, (String)((Object)iterator), this.dualDateTimeListFormat, this.dualDateTimeListLocale, true, true);
                }
            }
            if (this.dateList != null) {
                for (Iterator<Object> iterator : this.dateList) {
                    ((Bib2GlsEntry)object).convertFieldToDateTime(teXParser2, (String)((Object)iterator), this.dateListFormat, this.dateListLocale, true, false);
                    if (bib2GlsEntry == null) continue;
                    ((Bib2GlsEntry)object).convertFieldToDateTime(teXParser2, (String)((Object)iterator), this.dualDateListFormat, this.dualDateListLocale, true, false);
                }
            }
            if (this.timeList == null) continue;
            for (Iterator<Object> iterator : this.timeList) {
                ((Bib2GlsEntry)object).convertFieldToDateTime(teXParser2, (String)((Object)iterator), this.timeListFormat, this.timeListLocale, false, true);
                if (bib2GlsEntry == null) continue;
                ((Bib2GlsEntry)object).convertFieldToDateTime(teXParser2, (String)((Object)iterator), this.dualTimeListFormat, this.dualTimeListLocale, false, true);
            }
        }
        if (vector5 != null) {
            for (BibData bibData : vector5) {
                object = ((Bib2GlsEntry)bibData).getFieldValue("alias");
                bib2GlsEntry = GlsResource.getEntry((String)object, this.bibData);
                if (bib2GlsEntry == null && this.dualData != null) {
                    bib2GlsEntry = GlsResource.getEntry((String)object, this.dualData);
                }
                if (bib2GlsEntry == null) {
                    this.bib2gls.warningMessage("warning.alias.not.found", object, ((Bib2GlsEntry)bibData).getId(), "alias-loc", "transfer");
                    continue;
                }
                if (this.selectionMode == 1) {
                    this.bib2gls.debugMessage("message.added.alias.dep", ((Bib2GlsEntry)bibData).getId(), bib2GlsEntry.getId());
                    bib2GlsEntry.addDependency(((Bib2GlsEntry)bibData).getId());
                }
                bib2GlsEntry.copyRecordsFrom((Bib2GlsEntry)bibData);
            }
        }
        if (vector4 != null) {
            for (BibData bibData : vector4) {
                this.addCrossRefs((Bib2GlsEntry)bibData, ((Bib2GlsEntry)bibData).getCrossRefs());
                this.addCrossRefs((Bib2GlsEntry)bibData, ((Bib2GlsEntry)bibData).getAlsoCrossRefs());
                object = ((Bib2GlsEntry)bibData).getFieldValue("alias");
                if (object == null) continue;
                this.addCrossRefs((Bib2GlsEntry)bibData, new String[]{object});
            }
        }
        this.addSupplementalRecords();
    }

    private void addCrossRefs(Bib2GlsEntry bib2GlsEntry, String ... stringArray) {
        if (stringArray == null) {
            return;
        }
        for (String string : stringArray) {
            Bib2GlsEntry bib2GlsEntry2 = null;
            if (this.dualData.isEmpty()) {
                bib2GlsEntry2 = GlsResource.getEntry(string, this.bibData);
            } else if (bib2GlsEntry instanceof Bib2GlsDualEntry && !((Bib2GlsDualEntry)bib2GlsEntry).isPrimary()) {
                bib2GlsEntry2 = GlsResource.getEntry(string, this.dualData);
                if (bib2GlsEntry2 == null) {
                    bib2GlsEntry2 = GlsResource.getEntry(string, this.bibData);
                }
            } else {
                bib2GlsEntry2 = GlsResource.getEntry(string, this.bibData);
                if (bib2GlsEntry2 == null) {
                    bib2GlsEntry2 = GlsResource.getEntry(string, this.dualData);
                }
            }
            if (bib2GlsEntry2 == null) continue;
            if (this.bib2gls.getVerboseLevel() > 0) {
                this.bib2gls.logMessage(this.bib2gls.getMessage("message.crossref.by", bib2GlsEntry2.getId(), bib2GlsEntry.getId()));
            }
            bib2GlsEntry2.addDependency(bib2GlsEntry.getId());
            bib2GlsEntry2.addCrossRefdBy(bib2GlsEntry);
        }
    }

    private void addSupplementalRecords() {
        if (this.supplementalRecords != null) {
            for (GlsRecord glsRecord : this.supplementalRecords) {
                String string = this.getRecordLabel(glsRecord);
                Bib2GlsEntry bib2GlsEntry = GlsResource.getEntry(string, this.bibData);
                if (bib2GlsEntry == null && this.labelPrefix != null && !string.startsWith(this.labelPrefix)) {
                    bib2GlsEntry = GlsResource.getEntry(this.labelPrefix + string, this.bibData);
                }
                if (bib2GlsEntry == null) {
                    if (this.dualData == null) {
                        bib2GlsEntry = GlsResource.getEntry(this.dualPrefix + string, this.bibData);
                    } else {
                        bib2GlsEntry = GlsResource.getEntry(string, this.dualData);
                        if (bib2GlsEntry == null && !string.startsWith(this.dualPrefix)) {
                            bib2GlsEntry = GlsResource.getEntry(this.dualPrefix + string, this.dualData);
                        }
                    }
                }
                if (bib2GlsEntry == null) continue;
                if (this.supplementalCategory != null) {
                    this.setCategory(bib2GlsEntry, this.supplementalCategory);
                }
                bib2GlsEntry.addSupplementalRecord(glsRecord);
            }
        }
    }

    private void addDependencies(Bib2GlsEntry bib2GlsEntry, Vector<Bib2GlsEntry> vector) {
        Iterator<String> iterator = bib2GlsEntry.getDependencyIterator();
        while (iterator.hasNext()) {
            Bib2GlsEntry bib2GlsEntry2;
            String string = iterator.next();
            if (this.isDependent(string)) continue;
            this.addDependent(string);
            if (this.bib2gls.hasRecord(string) || (bib2GlsEntry2 = GlsResource.getEntry(string, vector)) == null) continue;
            this.addDependencies(bib2GlsEntry2, vector);
        }
    }

    public boolean isDependent(String string) {
        return this.dependencies.contains(string);
    }

    public void addDependent(String string) {
        if (!this.dependencies.contains(string)) {
            this.bib2gls.verboseMessage("message.added.dep", string);
            this.dependencies.add(string);
        }
    }

    public Vector<String> getDependencies() {
        return this.dependencies;
    }

    public int processData() throws IOException, Bib2GlsException {
        if (this.masterGlsTeXPath == null) {
            this.bib2gls.verboseMessage("message.selecting.entries", this.texFile.getName());
            return this.processBibData();
        }
        this.bib2gls.verboseMessage("message.processing.master", this.masterGlsTeXPath);
        this.processMaster();
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMaster() throws IOException, Bib2GlsException {
        this.bib2gls.message(this.bib2gls.getMessage("message.writing", this.texFile.toString()));
        try (PrintWriter printWriter = null;){
            printWriter = new PrintWriter(this.texFile, this.bib2gls.getTeXCharset().name());
            if (this.bib2gls.suppressFieldExpansion()) {
                printWriter.println("\\glsnoexpandfields");
            }
            this.bib2gls.writeCommonCommands(printWriter);
            printWriter.println("\\let\\bibglsorgdefglossaryentry\\@glsxtr@s@longnewglossaryentry");
            printWriter.println("\\let\\bibglsorgdefabbreviation\\glsxtr@newabbreviation");
            printWriter.println();
            printWriter.println("\\renewcommand{\\@glsxtr@s@longnewglossaryentry}[3]{%");
            printWriter.format(" \\bibglsorgdefglossaryentry{%s#1}{#2,type={%s},category={%s}}{#3}%%%n", this.labelPrefix == null ? "" : this.labelPrefix, this.type, this.category);
            printWriter.println("}");
            printWriter.println();
            printWriter.println("\\renewcommand{\\glsxtr@newabbreviation}[4]{%");
            printWriter.format(" \\bibglsorgdefabbreviation{#1,type={%s},category={%s}}{%s#2}{#3}{#4}%%%n", this.type, this.category, this.labelPrefix == null ? "" : this.labelPrefix);
            printWriter.println("}");
            printWriter.println();
            printWriter.format("\\provideignoredglossary*{%s}%n", this.type);
            printWriter.format("\\glssetcategoryattribute{%s}{targeturl}{%s}%n", this.category, this.masterPdfPath);
            printWriter.format("\\glssetcategoryattribute{%s}{targetname}", this.category);
            if (this.labelPrefix == null) {
                printWriter.format("{%s\\glslabel}%n", this.masterLinkPrefix);
            } else {
                printWriter.format("{%s\\csname bibglsstrip%sprefix\\expandafter\\endcsname\\glslabel}%n", this.masterLinkPrefix, this.category);
                printWriter.format("\\csdef{bibglsstrip%sprefix}%s#1{#1}%n", this.category, this.labelPrefix);
            }
            for (TeXPath teXPath : this.masterGlsTeXPath) {
                printWriter.println();
                printWriter.format("\\InputIfFileExists{%s}{}{}%n", teXPath);
                printWriter.println();
            }
            printWriter.println("\\let\\@glsxtr@s@longnewglossaryentry\\bibglsorgdefglossaryentry");
            printWriter.println("\\let\\glsxtr@newabbreviation\\bibglsorgdefabbreviation");
        }
    }

    public void setPreamble(String string, BibValueList bibValueList) {
        this.preamble = this.preamble == null ? string : this.preamble + string;
        if (bibValueList != null && this.interpretPreamble) {
            if (this.preambleList == null) {
                this.preambleList = bibValueList;
            } else {
                this.preambleList.addAll(bibValueList);
            }
        }
    }

    public void processPreamble() throws IOException {
        if (this.preambleList != null) {
            this.bib2gls.processPreamble(this.preambleList);
        }
    }

    private void addHierarchy(Bib2GlsEntry bib2GlsEntry, Vector<Bib2GlsEntry> vector, Vector<Bib2GlsEntry> vector2) {
        String string = bib2GlsEntry.getParent();
        if (string == null) {
            return;
        }
        for (Bib2GlsEntry bib2GlsEntry2 : vector) {
            if (!bib2GlsEntry2.getId().equals(string)) continue;
            return;
        }
        Bib2GlsEntry bib2GlsEntry3 = GlsResource.getEntry(string, vector2);
        if (bib2GlsEntry3 != null) {
            this.bib2gls.verboseMessage("message.added.parent", string);
            this.addHierarchy(bib2GlsEntry3, vector, vector2);
            vector.add(bib2GlsEntry3);
        }
    }

    public String flipLabel(String string) {
        if (this.labelPrefix == null) {
            if (string.startsWith(this.dualPrefix)) {
                return string.substring(this.dualPrefix.length());
            }
            if (this.hasTertiaries && string.startsWith(this.tertiaryPrefix)) {
                return string.substring(this.tertiaryPrefix.length());
            }
            return this.dualPrefix + string;
        }
        if (this.dualPrefix == null) {
            if (string.startsWith(this.labelPrefix)) {
                return string.substring(this.labelPrefix.length());
            }
            if (this.hasTertiaries && string.startsWith(this.tertiaryPrefix)) {
                return string.substring(this.tertiaryPrefix.length());
            }
            return this.labelPrefix + string;
        }
        if (string.startsWith(this.labelPrefix)) {
            String string2 = string.substring(this.labelPrefix.length());
            if (string2.startsWith(this.dualPrefix)) {
                return string2;
            }
            return this.dualPrefix + string2;
        }
        if (string.startsWith(this.dualPrefix)) {
            String string3 = string.substring(this.dualPrefix.length());
            if (string3.startsWith(this.labelPrefix)) {
                return string3;
            }
            return this.labelPrefix + string3;
        }
        if (this.hasTertiaries && this.tertiaryPrefix != null && string.startsWith(this.tertiaryPrefix)) {
            String string4 = string.substring(this.tertiaryPrefix.length());
            if (string4.startsWith(this.dualPrefix) || string4.startsWith(this.labelPrefix)) {
                return string4;
            }
            return this.dualPrefix + string4;
        }
        return null;
    }

    public Bib2GlsEntry getEntry(String string) {
        Bib2GlsEntry bib2GlsEntry = GlsResource.getEntry(string, this.bibData);
        if (bib2GlsEntry != null) {
            return bib2GlsEntry;
        }
        return GlsResource.getEntry(string, this.dualData);
    }

    public static Bib2GlsEntry getEntry(String string, Vector<Bib2GlsEntry> vector) {
        for (Bib2GlsEntry bib2GlsEntry : vector) {
            if (!bib2GlsEntry.getId().equals(string)) continue;
            return bib2GlsEntry;
        }
        return null;
    }

    public Bib2GlsEntry getBib2GlsEntry(String string, Vector<BibData> vector) {
        for (BibData bibData : vector) {
            if (!(bibData instanceof Bib2GlsEntry) || !((Bib2GlsEntry)bibData).getId().equals(string)) continue;
            return (Bib2GlsEntry)bibData;
        }
        return null;
    }

    public String getRecordLabel(GlsRecord glsRecord) {
        String string = glsRecord.getLabel();
        if (this.recordLabelPrefix == null || string.startsWith(this.recordLabelPrefix)) {
            return string;
        }
        return this.recordLabelPrefix + string;
    }

    public String getRecordLabel(GlsSeeRecord glsSeeRecord) {
        if (this.recordLabelPrefix == null) {
            return glsSeeRecord.getLabel();
        }
        return this.recordLabelPrefix + glsSeeRecord.getLabel();
    }

    private void processData(Vector<Bib2GlsEntry> vector, Vector<Bib2GlsEntry> vector2, String string) throws Bib2GlsException {
        Vector<String> vector3 = this.bib2gls.getFields();
        Vector<GlsRecord> vector4 = this.bib2gls.getRecords();
        Vector<GlsSeeRecord> vector5 = this.bib2gls.getSeeRecords();
        if (this.selectionMode == 4) {
            this.bib2gls.debugMessage("message.selecting.all", new Object[0]);
            for (Bib2GlsEntry bib2GlsEntry : vector) {
                vector2.add(bib2GlsEntry);
            }
        } else if (string == null || string.equals("none") || this.matchAction == 1) {
            for (Bib2GlsEntry bib2GlsEntry : vector) {
                boolean bl;
                boolean bl2 = bib2GlsEntry.hasRecords();
                Bib2GlsEntry bib2GlsEntry2 = bib2GlsEntry.getDual();
                boolean bl3 = bib2GlsEntry2 != null && bib2GlsEntry2.hasRecords() && this.dualPrimaryDependency;
                boolean bl4 = bl = bl2 || this.bib2gls.isDependent(bib2GlsEntry.getId());
                if (!bl && (this.matchAction != 1 || this.fieldPatterns == null || this.notMatch(bib2GlsEntry)) && (bib2GlsEntry2 == null || !bl3 && (this.matchAction != 1 || this.fieldPatterns == null || this.notMatch(bib2GlsEntry2)))) continue;
                if (this.bib2gls.getDebugLevel() > 0) {
                    if (bl2) {
                        this.bib2gls.debugMessage("message.selecting.entry.records", bib2GlsEntry);
                    } else if (bl) {
                        this.bib2gls.debugMessage("message.selecting.entry.dep", bib2GlsEntry);
                    } else if (bl3) {
                        this.bib2gls.debugMessage("message.selecting.entry.dualrecords", bib2GlsEntry, bib2GlsEntry2);
                    } else {
                        this.bib2gls.debugMessage("message.selecting.entry", bib2GlsEntry);
                    }
                }
                if (this.selectionMode == 0 || this.selectionMode == 1 || this.selectionMode == 3) {
                    this.addHierarchy(bib2GlsEntry, vector2, vector);
                }
                vector2.add(bib2GlsEntry);
                if (this.selectionMode != 0 && this.selectionMode != 1) continue;
                this.addDependencies(bib2GlsEntry, vector);
            }
        } else {
            String[] stringArray;
            Bib2GlsEntry bib2GlsEntry;
            Object object;
            int n;
            for (n = 0; n < vector4.size(); ++n) {
                GlsRecord object22 = vector4.get(n);
                object = this.getRecordLabel(object22);
                bib2GlsEntry = GlsResource.getEntry((String)object, vector);
                if (bib2GlsEntry == null && this.hasDuals && (stringArray = this.flipLabel((String)object)) != null) {
                    bib2GlsEntry = GlsResource.getEntry((String)stringArray, vector);
                }
                if (bib2GlsEntry == null || vector2.contains(bib2GlsEntry)) continue;
                this.bib2gls.debugMessage("message.selecting.entry.record.match", bib2GlsEntry.getId(), object);
                if (this.selectionMode == 0 || this.selectionMode == 1 || this.selectionMode == 3) {
                    this.addHierarchy(bib2GlsEntry, vector2, vector);
                }
                vector2.add(bib2GlsEntry);
                if (this.selectionMode != 0 && this.selectionMode != 1) continue;
                this.addDependencies(bib2GlsEntry, vector);
            }
            for (n = 0; n < vector5.size(); ++n) {
                GlsSeeRecord glsSeeRecord = vector5.get(n);
                object = this.getRecordLabel(glsSeeRecord);
                bib2GlsEntry = GlsResource.getEntry((String)object, vector);
                if (bib2GlsEntry == null && this.hasDuals && (stringArray = this.flipLabel((String)object)) != null) {
                    bib2GlsEntry = GlsResource.getEntry((String)stringArray, vector);
                }
                if (bib2GlsEntry == null || vector2.contains(bib2GlsEntry)) continue;
                this.bib2gls.debugMessage("message.selecting.entry.seerecord.match", bib2GlsEntry.getId(), object);
                if (this.selectionMode == 0 || this.selectionMode == 1 || this.selectionMode == 3) {
                    this.addHierarchy(bib2GlsEntry, vector2, vector);
                }
                vector2.add(bib2GlsEntry);
                if (this.selectionMode != 0 && this.selectionMode != 1) continue;
                this.addDependencies(bib2GlsEntry, vector);
            }
            if (this.supplementalRecords != null && this.supplementalSelection != null) {
                block4: for (GlsRecord glsRecord : this.supplementalRecords) {
                    object = this.getRecordLabel(glsRecord);
                    bib2GlsEntry = GlsResource.getEntry((String)object, vector);
                    if (bib2GlsEntry == null || vector2.contains(bib2GlsEntry)) continue;
                    if (this.supplementalSelection.length == 1 && this.supplementalSelection[0].equals("all")) {
                        this.bib2gls.debugMessage("message.selecting.entry.suprecord.match", bib2GlsEntry.getId(), object);
                        if (this.selectionMode == 0 || this.selectionMode == 1 || this.selectionMode == 3) {
                            this.addHierarchy(bib2GlsEntry, vector2, vector);
                        }
                        vector2.add(bib2GlsEntry);
                        if (this.selectionMode != 0 && this.selectionMode != 1) continue;
                        this.addDependencies(bib2GlsEntry, vector);
                        continue;
                    }
                    for (String string2 : this.supplementalSelection) {
                        if (!string2.equals(object)) continue;
                        this.bib2gls.debugMessage("message.selecting.entry.suprecord.match", bib2GlsEntry.getId(), object);
                        if (this.selectionMode == 0 || this.selectionMode == 1 || this.selectionMode == 3) {
                            this.addHierarchy(bib2GlsEntry, vector2, vector);
                        }
                        vector2.add(bib2GlsEntry);
                        if (this.selectionMode != 0 && this.selectionMode != 1) continue block4;
                        this.addDependencies(bib2GlsEntry, vector);
                        continue block4;
                    }
                }
            }
            if (this.bib2gls.hasCrossResourceDependencies()) {
                Iterator<String> iterator = this.bib2gls.getDependencyIterator();
                while (iterator.hasNext()) {
                    String string3 = iterator.next();
                    object = GlsResource.getEntry(string3, vector);
                    if (object == null || vector2.contains(object)) continue;
                    this.bib2gls.debugMessage("message.selecting.entry.crossresource.dep", object);
                    if (this.selectionMode == 0 || this.selectionMode == 1 || this.selectionMode == 3) {
                        this.addHierarchy((Bib2GlsEntry)object, vector2, vector);
                    }
                    vector2.add((Bib2GlsEntry)object);
                    if (this.selectionMode != 0 && this.selectionMode != 1) continue;
                    this.addDependencies((Bib2GlsEntry)object, vector);
                }
            }
        }
        this.processDeps(vector, vector2);
    }

    private void processDeps(Vector<Bib2GlsEntry> vector, Vector<Bib2GlsEntry> vector2) throws Bib2GlsException {
        if (this.selectionMode == 0 || this.selectionMode == 1) {
            for (String object : this.dependencies) {
                String string;
                Bib2GlsEntry bib2GlsEntry = GlsResource.getEntry(object, vector);
                if (bib2GlsEntry == null && this.hasDuals && (string = this.flipLabel(object)) != null) {
                    bib2GlsEntry = GlsResource.getEntry(string, vector);
                }
                if (bib2GlsEntry == null || vector2.contains(bib2GlsEntry)) continue;
                this.addHierarchy(bib2GlsEntry, vector2, vector);
                vector2.add(bib2GlsEntry);
            }
        }
        if (this.flattenLonely == 1) {
            L2HStringConverter l2HStringConverter = this.bib2gls.getInterpreterListener();
            if (l2HStringConverter != null) {
                TeXParser teXParser = l2HStringConverter.getParser();
                if (teXParser.getControlSequence("bibglsflattenedchildpresort") == null) {
                    l2HStringConverter.putControlSequence(new FlattenedPreSort());
                }
                if (teXParser.getControlSequence("bibglsflattenedhomograph") == null) {
                    l2HStringConverter.putControlSequence(new FlattenedHomograph());
                }
            }
            this.flattenLonelyChildren(vector2);
        }
    }

    private void sortDataIfRequired(Vector<Bib2GlsEntry> vector, SortSettings sortSettings, String string) throws Bib2GlsException {
        if (sortSettings.requiresSorting() && vector.size() > 0) {
            this.sortData(vector, sortSettings, string, null);
        } else {
            this.bib2gls.verboseMessage("message.no.sort.required", new Object[0]);
        }
    }

    private void sortData(Vector<Bib2GlsEntry> vector, SortSettings sortSettings, String string, String string2) throws Bib2GlsException {
        this.sortData(vector, sortSettings, sortSettings.getSortField(), string, string2);
    }

    private void sortData(Vector<Bib2GlsEntry> vector, SortSettings sortSettings, String string, String string2, String string3) throws Bib2GlsException {
        if (sortSettings.isRandom()) {
            if (this.random == null) {
                this.random = new Random();
            }
            Collections.shuffle(vector, this.random);
        } else if (sortSettings.isLetter()) {
            Bib2GlsEntryLetterComparator bib2GlsEntryLetterComparator = new Bib2GlsEntryLetterComparator(this.bib2gls, vector, sortSettings, string, string2, string3);
            bib2GlsEntryLetterComparator.sortEntries();
        } else if (sortSettings.isLetterNumber()) {
            Bib2GlsEntryLetterNumberComparator bib2GlsEntryLetterNumberComparator = new Bib2GlsEntryLetterNumberComparator(this.bib2gls, vector, sortSettings, string, string2, string3);
            bib2GlsEntryLetterNumberComparator.sortEntries();
        } else if (sortSettings.isNumeric()) {
            Bib2GlsEntryNumericComparator bib2GlsEntryNumericComparator = new Bib2GlsEntryNumericComparator(this.bib2gls, vector, sortSettings, string, string2, string3);
            bib2GlsEntryNumericComparator.sortEntries();
        } else if (sortSettings.isDateOrTimeSort()) {
            Bib2GlsEntryDateTimeComparator bib2GlsEntryDateTimeComparator = new Bib2GlsEntryDateTimeComparator(this.bib2gls, vector, sortSettings, string, string2, string3);
            bib2GlsEntryDateTimeComparator.sortEntries();
        } else {
            try {
                Bib2GlsEntryComparator bib2GlsEntryComparator = new Bib2GlsEntryComparator(this.bib2gls, vector, sortSettings, string, string2, string3);
                bib2GlsEntryComparator.sortEntries();
            }
            catch (ParseException parseException) {
                throw new Bib2GlsException(this.bib2gls.getMessage("error.invalid.sort.rule", parseException.getMessage()), parseException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processBibData() throws IOException, Bib2GlsException {
        if (this.bibData == null) {
            throw new NullPointerException("No data (processBibList must come before processData)");
        }
        if (this.dualField != null) {
            this.bib2gls.addField(this.dualField);
        }
        this.checkFieldMaps(this.dualEntryMap, "dual-entry-map");
        this.checkFieldMaps(this.dualAbbrevMap, "dual-abbrv-map");
        this.checkFieldMaps(this.dualSymbolMap, "dual-symbol-map");
        this.checkFieldMaps(this.dualAbbrevEntryMap, "dual-abbrventry-map");
        this.checkFieldMaps(this.dualIndexEntryMap, "dual-indexentry-map");
        this.checkFieldMaps(this.dualIndexSymbolMap, "dual-indexsymbol-map");
        this.checkFieldMaps(this.dualIndexAbbrevMap, "dual-indexabbrv-map");
        Vector<Bib2GlsEntry> vector = new Vector<Bib2GlsEntry>();
        this.processData(this.bibData, vector, this.sortSettings.getMethod());
        if (this.limit > 0 && vector.size() > this.limit) {
            this.bib2gls.verboseMessage("message.truncated", this.limit);
            vector.setSize(this.limit);
        }
        if (this.bib2gls.getVerboseLevel() > 0) {
            this.bib2gls.logMessage(this.bib2gls.getChoiceMessage("message.selected", 0, "entry", 3, vector.size()));
        }
        Vector<Bib2GlsEntry> vector2 = null;
        int n = vector.size();
        if (this.dualData.size() > 0) {
            vector2 = new Vector<Bib2GlsEntry>();
            if (!this.dualSortSettings.requiresSorting()) {
                for (Bib2GlsEntry bib2GlsEntry : vector) {
                    if (!(bib2GlsEntry instanceof Bib2GlsDualEntry)) continue;
                    Bib2GlsEntry bib2GlsEntry2 = bib2GlsEntry.getDual();
                    this.setDualType(bib2GlsEntry2);
                    this.setDualCategory(bib2GlsEntry2);
                    this.setDualCounter(bib2GlsEntry2);
                    vector2.add(bib2GlsEntry2);
                }
            } else {
                for (Bib2GlsEntry bib2GlsEntry : this.dualData) {
                    this.setDualType(bib2GlsEntry);
                    this.setDualCategory(bib2GlsEntry);
                    this.setDualCounter(bib2GlsEntry);
                    vector2.add(bib2GlsEntry);
                }
            }
            this.processDeps(this.dualData, vector2);
            n += vector2.size();
            if (this.limit > 0 && vector2.size() > this.limit) {
                this.bib2gls.verboseMessage("message.truncated", this.limit);
                vector2.setSize(this.limit);
            }
            if (this.bib2gls.getVerboseLevel() > 0) {
                this.bib2gls.logMessage(this.bib2gls.getChoiceMessage("message.dual.selected", 0, "entry", 3, vector2.size()));
            }
        }
        this.sortDataIfRequired(vector, this.sortSettings, "group");
        if (vector2 != null) {
            this.sortDataIfRequired(vector2, this.dualSortSettings, "group");
        }
        this.bib2gls.message(this.bib2gls.getMessage("message.writing", this.texFile.toString()));
        try (Object object = null;){
            Object object2;
            int n2;
            object = new PrintWriter(this.texFile, this.bib2gls.getTeXCharset().name());
            if (this.bib2gls.suppressFieldExpansion()) {
                ((PrintWriter)object).println("\\glsnoexpandfields");
            }
            this.bib2gls.writeCommonCommands((PrintWriter)object);
            if (this.triggerType != null) {
                ((PrintWriter)object).format("\\provideignoredglossary*{%s}%n", this.triggerType);
            }
            if (this.bibtexAuthorList != null) {
                ((PrintWriter)object).println("\\ifdef\\DTLformatlist");
                ((PrintWriter)object).println("{% datatool v2.28+");
                ((PrintWriter)object).print(" \\providecommand*{\\bibglscontributorlist}[2]");
                ((PrintWriter)object).println("{\\DTLformatlist{#1}}");
                ((PrintWriter)object).println("}");
                ((PrintWriter)object).println("{% datatool v2.27 or earlier");
                ((PrintWriter)object).println(" \\providecommand*{\\bibglscontributorlist}[2]{%");
                ((PrintWriter)object).println("  \\def\\bibgls@sep{}%");
                ((PrintWriter)object).print("  \\@for\\bibgls@item:=#1\\do{");
                ((PrintWriter)object).println("\\bibgls@sep\\bibgls@item\\def\\bibgls@sep{, }}%");
                ((PrintWriter)object).println(" }");
                ((PrintWriter)object).println("}");
                ((PrintWriter)object).println("\\providecommand*{\\bibglscontributor}[4]{%");
                switch (this.contributorOrder) {
                    case 0: {
                        ((PrintWriter)object).print("  #3\\ifstrempty{#4}{}{, #4}");
                        ((PrintWriter)object).print("\\ifstrempty{#1}{}{, #1}");
                        ((PrintWriter)object).println("\\ifstrempty{#2}{}{, #2}%");
                        break;
                    }
                    case 1: {
                        ((PrintWriter)object).print("  \\ifstrempty{#2}{}{#2 }#3");
                        ((PrintWriter)object).print("\\ifstrempty{#4}{}{, #4}");
                        ((PrintWriter)object).println("\\ifstrempty{#1}{}{, #1}%");
                        break;
                    }
                    case 2: {
                        ((PrintWriter)object).print("  #1\\ifstrempty{#2}{}{ #2} #3");
                        ((PrintWriter)object).println("\\ifstrempty{#4}{}{, #4}%");
                    }
                }
                ((PrintWriter)object).println("}");
            }
            if (this.dateTimeList != null) {
                ((PrintWriter)object).print("\\providecommand{\\bibglsdatetime}[9]");
                ((PrintWriter)object).println("{\\bibglsdatetimeremainder}");
                ((PrintWriter)object).format("\\providecommand{\\bibglsdatetimeremainder}[4]{#4}", new Object[0]);
                ((PrintWriter)object).println();
            }
            if (this.dateList != null) {
                ((PrintWriter)object).println("\\providecommand{\\bibglsdate}[7]{#7}");
                ((PrintWriter)object).println();
            }
            if (this.timeList != null) {
                ((PrintWriter)object).println("\\providecommand{\\bibglstime}[7]{#7}");
                ((PrintWriter)object).println();
            }
            if (this.counters != null) {
                ((PrintWriter)object).println("\\providecommand{\\bibglslocationgroup}[3]{#3}");
                ((PrintWriter)object).println("\\providecommand{\\bibglslocationgroupsep}{\\bibglsdelimN}");
                ((PrintWriter)object).println();
            }
            if (this.supplementalRecords != null) {
                ((PrintWriter)object).println("\\providecommand{\\bibglssupplementalsep}{\\bibglsdelimN}");
                ((PrintWriter)object).println("\\providecommand{\\bibglssupplemental}[2]{#2}");
                ((PrintWriter)object).println();
            }
            if (this.dualField != null) {
                ((PrintWriter)object).format("\\glsxtrprovidestoragekey{%s}{}{}%n%n", this.dualField);
            }
            if (this.seeLocation != 0) {
                ((PrintWriter)object).println("\\providecommand{\\bibglsseesep}{, }");
                ((PrintWriter)object).println();
            }
            if (this.seeAlsoLocation != 0) {
                ((PrintWriter)object).println("\\providecommand{\\bibglsseealsosep}{, }");
                ((PrintWriter)object).println();
            }
            if (this.aliasLocation != 0) {
                ((PrintWriter)object).println("\\providecommand{\\bibglsaliassep}{, }");
                ((PrintWriter)object).println();
            }
            boolean bl = false;
            if (this.bib2gls.useGroupField()) {
                boolean bl2;
                ((PrintWriter)object).println("\\ifdef\\glsxtrsetgrouptitle");
                ((PrintWriter)object).println("{");
                ((PrintWriter)object).println("  \\providecommand{\\bibglslettergroup}[4]{#4#3}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglslettergrouptitle}[4]{\\unexpanded{#1}}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglssetlettergrouptitle}[1]{%");
                ((PrintWriter)object).println("    \\glsxtrsetgrouptitle{\\bibglslettergroup#1}{\\bibglslettergrouptitle#1}}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglsunicodegroup}[4]{#4#3}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglsunicodegrouptitle}[4]{\\unexpanded{#1}}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglssetunicodegrouptitle}[1]{%");
                ((PrintWriter)object).println("    \\glsxtrsetgrouptitle{\\bibglsunicodegroup#1}{\\bibglsunicodegrouptitle#1}}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglsothergroup}[3]{glssymbols}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglsothergrouptitle}[3]{\\glssymbolsgroupname}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglssetothergrouptitle}[1]{%");
                ((PrintWriter)object).println("    \\glsxtrsetgrouptitle{\\bibglsothergroup#1}{\\bibglsothergrouptitle#1}}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglsemptygroup}[1]{glssymbols}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglsemptygrouptitle}[1]{\\glssymbolsgroupname}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglssetemptygrouptitle}[1]{%");
                ((PrintWriter)object).println("    \\glsxtrsetgrouptitle{\\bibglsemptygroup#1}{\\bibglsemptygrouptitle#1}}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglsnumbergroup}[3]{glsnumbers}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglsnumbergrouptitle}[3]{\\glsnumbersgroupname}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglssetnumbergrouptitle}[1]{%");
                ((PrintWriter)object).println("    \\glsxtrsetgrouptitle{\\bibglsnumbergroup#1}{\\bibglsnumbergrouptitle#1}}");
                boolean bl3 = this.sortSettings.isDateTimeSort() || this.dualSortSettings.isDateTimeSort() || this.secondarySortSettings.isDateTimeSort();
                boolean bl4 = this.sortSettings.isDateSort() || this.dualSortSettings.isDateSort() || this.secondarySortSettings.isDateSort();
                boolean bl5 = bl2 = this.sortSettings.isTimeSort() || this.dualSortSettings.isTimeSort() || this.secondarySortSettings.isTimeSort();
                if (bl3) {
                    ((PrintWriter)object).println("  \\providecommand{\\bibglsdatetimegroup}[9]{#1#2#3\\@firstofone}");
                    ((PrintWriter)object).println("  \\providecommand{\\bibglsdatetimegrouptitle}[9]{#1-#2-#3\\@gobble}");
                    ((PrintWriter)object).println("  \\providecommand{\\bibglssetdatetimegrouptitle}[1]{%");
                    ((PrintWriter)object).println("    \\glsxtrsetgrouptitle{\\bibglsdatetimegroup#1}{\\bibglsdatetimegrouptitle#1}}");
                }
                if (bl4) {
                    ((PrintWriter)object).println("  \\providecommand{\\bibglsdategroup}[7]{#1#2#4#7}");
                    ((PrintWriter)object).println("  \\providecommand{\\bibglsdategrouptitle}[7]{#1-#2}");
                    ((PrintWriter)object).println("  \\providecommand{\\bibglssetdategrouptitle}[1]{%");
                    ((PrintWriter)object).println("    \\glsxtrsetgrouptitle{\\bibglsdategroup#1}{\\bibglsdategrouptitle#1}}");
                }
                if (bl2) {
                    ((PrintWriter)object).println("  \\providecommand{\\bibglstimegroup}[7]{#1#2#7}");
                    ((PrintWriter)object).println("  \\providecommand{\\bibglstimegrouptitle}[7]{#1}");
                    ((PrintWriter)object).println("  \\providecommand{\\bibglssettimegrouptitle}[1]{%");
                    ((PrintWriter)object).println("    \\glsxtrsetgrouptitle{\\bibglstimegroup#1}{\\bibglstimegrouptitle#1}}");
                }
                ((PrintWriter)object).println("}");
                ((PrintWriter)object).println("{");
                ((PrintWriter)object).println("  \\providecommand{\\bibglslettergroup}[4]{#1}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglsothergroup}[3]{glssymbols}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglsnumbergroup}[3]{glsnumbers}");
                if (bl3) {
                    ((PrintWriter)object).println("  \\providecommand{\\bibglsdatetimegroup}[9]{#1-#2-#3\\@gobble}");
                }
                if (bl4) {
                    ((PrintWriter)object).println("  \\providecommand{\\bibglsdategroup}[7]{#1-#2}");
                }
                if (bl2) {
                    ((PrintWriter)object).println("  \\providecommand{\\bibglstimegroup}[6]{#1-#2}");
                }
                ((PrintWriter)object).println("  \\providecommand{\\bibglssetlettergrouptitle}[1]{}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglssetothergrouptitle}[1]{}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglssetnumbergrouptitle}[1]{}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglssetdatetimegrouptitle}[1]{}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglssetdategrouptitle}[1]{}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglssettimegrouptitle}[1]{}");
                ((PrintWriter)object).println("}");
                ((PrintWriter)object).println();
                bl = this.writeGroupDefs((PrintWriter)object);
                if (!bl) {
                    this.bib2gls.setCreateHyperGroups(false);
                }
                if (bl) {
                    ((PrintWriter)object).println("\\ifdef\\@glsnavhypertarget");
                    ((PrintWriter)object).println("{");
                    ((PrintWriter)object).println("  \\ifdef\\bibglsorgnavhypertarget");
                    ((PrintWriter)object).println("  {}");
                    ((PrintWriter)object).println("  {");
                    ((PrintWriter)object).println("    \\let\\bibglsorgnavhypertarget\\@glsnavhypertarget");
                    ((PrintWriter)object).println("  }");
                    ((PrintWriter)object).println("  \\renewcommand*{\\@glsnavhypertarget}[3]{%");
                    ((PrintWriter)object).println("    \\@glstarget{\\glsnavhyperlinkname{#1}{#2}}{#3}%");
                    ((PrintWriter)object).println("  }");
                    ((PrintWriter)object).println("  \\providecommand{\\bibglshypergroup}{\\@gls@hypergroup}");
                    ((PrintWriter)object).println("}");
                    ((PrintWriter)object).println("{");
                    ((PrintWriter)object).println("  \\providecommand{\\bibglshypergroup}[2]{}");
                    ((PrintWriter)object).println("}");
                } else if (this.bib2gls.hyperrefLoaded()) {
                    ((PrintWriter)object).println("\\ifdef\\bibglsorgnavhypertarget");
                    ((PrintWriter)object).println("{");
                    ((PrintWriter)object).println("  \\let\\@glsnavhypertarget\\bibglsorgnavhypertarget");
                    ((PrintWriter)object).println("}");
                    ((PrintWriter)object).println("{}");
                }
            }
            if (this.locationPrefix != null) {
                ((PrintWriter)object).println("\\providecommand{\\bibglspostlocprefix}{\\ }");
                if (this.defpagesname) {
                    ((PrintWriter)object).format("\\providecommand{\\bibglspagename}{%s}%n", this.bib2gls.getMessage("tag.page", new Object[0]));
                    ((PrintWriter)object).format("\\providecommand{\\bibglspagesname}{%s}%n", this.bib2gls.getMessage("tag.pages", new Object[0]));
                }
                if (this.type == null) {
                    ((PrintWriter)object).println("\\appto\\glossarypreamble{%");
                } else {
                    ((PrintWriter)object).format("\\apptoglossarypreamble[%s]{%%%n", this.type);
                }
                ((PrintWriter)object).println(" \\providecommand{\\bibglslocprefix}[1]{%");
                ((PrintWriter)object).println("  \\ifcase#1");
                for (int i = 0; i < this.locationPrefix.length; ++i) {
                    ((PrintWriter)object).format("  \\%s %s\\bibglspostlocprefix%n", i == this.locationPrefix.length - 1 ? "else" : "or", this.locationPrefix[i]);
                }
                ((PrintWriter)object).println("  \\fi");
                ((PrintWriter)object).println(" }%");
                ((PrintWriter)object).println("}");
            }
            if (this.locationSuffix != null) {
                if (this.type == null) {
                    ((PrintWriter)object).println("\\appto\\glossarypreamble{%");
                } else {
                    ((PrintWriter)object).format("\\apptoglossarypreamble[%s]{%%%n", this.type);
                }
                ((PrintWriter)object).print(" \\providecommand{\\bibglslocsuffix}[1]{");
                if (this.locationSuffix.length == 1) {
                    ((PrintWriter)object).print(this.locationSuffix[0]);
                } else {
                    ((PrintWriter)object).format("\\ifcase#1 %s", this.locationSuffix[0]);
                    for (int i = 1; i < this.locationSuffix.length; ++i) {
                        ((PrintWriter)object).format("\\%s %s", i == this.locationSuffix.length - 1 ? "else" : "or", this.locationSuffix[i]);
                    }
                    ((PrintWriter)object).print("\\fi");
                }
                ((PrintWriter)object).println("}%");
                ((PrintWriter)object).println("}");
            }
            Vector<String> vector3 = new Vector<String>();
            if (this.preamble != null && this.savePreamble) {
                ((PrintWriter)object).println(this.preamble);
                ((PrintWriter)object).println();
            }
            Vector<Bib2GlsEntry> vector4 = null;
            if (this.secondaryType != null) {
                vector4 = new Vector<Bib2GlsEntry>(n);
            }
            Font font = null;
            FontRenderContext fontRenderContext = null;
            if (this.setWidest) {
                font = new Font("Serif", 0, 12);
                fontRenderContext = new FontRenderContext(null, false, false);
            }
            if (this.supplementalPdfPath != null && this.supplementalCategory != null) {
                ((PrintWriter)object).format("\\glssetcategoryattribute{%s}{externallocation}{%s}%n%n", this.supplementalCategory, this.supplementalPdfPath);
            }
            if (this.flattenLonely == 2 || this.saveChildCount && this.flattenLonely != 1) {
                this.flattenLonelyChildren(vector);
            }
            ((PrintWriter)object).println("\\providecommand*{\\bibglsflattenedhomograph}[2]{#1}");
            if (this.flattenLonely == 2) {
                ((PrintWriter)object).format("\\providecommand*{\\%s}[2]{#1, #2}%n", this.flattenLonelyCsName());
                ((PrintWriter)object).println();
            } else if (this.flattenLonely == 1) {
                ((PrintWriter)object).format("\\providecommand*{\\%s}[2]{#1}%n", this.flattenLonelyCsName());
                ((PrintWriter)object).println();
            }
            int n3 = vector.size();
            for (n2 = 0; n2 < n3; ++n2) {
                Bib2GlsEntry object32 = vector.get(n2);
                this.bib2gls.verbose(object32.getId());
                if (this.setWidest) {
                    this.updateWidestName(object32, font, fontRenderContext);
                }
                if (this.saveLocations) {
                    if (object32 instanceof Bib2GlsDualEntry && this.combineDualLocations != 0 && this.combineDualLocations != 1) {
                        boolean bl6 = ((Bib2GlsDualEntry)object32).isPrimary();
                        if (this.combineDualLocations == 2 && bl6 || this.combineDualLocations == 3 && !bl6) {
                            object32.updateLocationList();
                        }
                    } else {
                        object32.updateLocationList();
                    }
                }
                if (this.flattenLonely == 0 && !this.saveChildCount) {
                    this.checkParent(object32, n2, vector);
                }
                if (bl) {
                    this.writeHyperGroupDef(object32, (PrintWriter)object);
                }
                if (!vector3.contains(object2 = object32.getCsName())) {
                    object32.writeCsDefinition((PrintWriter)object);
                    ((PrintWriter)object).println();
                    vector3.add((String)object2);
                }
                this.writeBibEntry((PrintWriter)object, object32);
                if (this.supplementalPdfPath != null && this.supplementalCategory == null && object32.supplementalRecordCount() > 0) {
                    ((PrintWriter)object).format("\\glssetattribute{%s}{externallocation}{%s}%n", object32.getId(), this.supplementalPdfPath);
                }
                ((PrintWriter)object).println();
                if (vector4 == null) continue;
                vector4.add(object32);
            }
            if (vector2 != null) {
                if (this.flattenLonely == 2 || this.saveChildCount && this.flattenLonely != 1) {
                    this.flattenLonelyChildren(vector2);
                }
                n3 = vector2.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    Bib2GlsEntry bib2GlsEntry = vector2.get(n2);
                    this.bib2gls.verbose(bib2GlsEntry.getId());
                    if (this.setWidest) {
                        this.updateWidestName(bib2GlsEntry, this.dualType, font, fontRenderContext);
                        if (bib2GlsEntry instanceof Bib2GlsDualEntry && ((Bib2GlsDualEntry)bib2GlsEntry).hasTertiary() && this.tertiaryType != null) {
                            this.updateWidestName(bib2GlsEntry, this.tertiaryType, font, fontRenderContext);
                        }
                    }
                    if (this.saveLocations && this.combineDualLocations != 2) {
                        bib2GlsEntry.updateLocationList();
                    }
                    if (this.flattenLonely == 0 && !this.saveChildCount) {
                        this.checkParent(bib2GlsEntry, n2, vector2);
                    }
                    if (bl) {
                        this.writeHyperGroupDef(bib2GlsEntry, (PrintWriter)object);
                    }
                    if (!vector3.contains(object2 = bib2GlsEntry.getCsName())) {
                        bib2GlsEntry.writeCsDefinition((PrintWriter)object);
                        ((PrintWriter)object).println();
                        vector3.add((String)object2);
                    }
                    this.writeBibEntry((PrintWriter)object, bib2GlsEntry);
                    if (vector4 == null) continue;
                    vector4.add(bib2GlsEntry);
                }
            }
            if (vector4 != null) {
                ((PrintWriter)object).format("\\provideignoredglossary*{%s}%n", this.secondaryType);
                ((PrintWriter)object).println("\\ifdef\\glsxtrgroupfield{%");
                ((PrintWriter)object).format("  \\apptoglossarypreamble[%s]{", this.secondaryType);
                ((PrintWriter)object).println("\\renewcommand{\\glsxtrgroupfield}{secondarygroup}}%");
                ((PrintWriter)object).println("}{}");
                if (this.secondarySortSettings.isUnsrt()) {
                    for (Bib2GlsEntry bib2GlsEntry : vector4) {
                        this.writeCopyToGlossary((PrintWriter)object, bib2GlsEntry);
                        if (!this.setWidest) continue;
                        this.updateWidestName(bib2GlsEntry, this.secondaryType, font, fontRenderContext);
                    }
                } else if (this.secondarySortSettings.isOrderOfRecords()) {
                    Vector<GlsRecord> vector5 = this.bib2gls.getRecords();
                    for (GlsRecord glsRecord : vector5) {
                        object2 = GlsResource.getEntry(this.getRecordLabel(glsRecord), vector4);
                        if (object2 == null) continue;
                        this.writeCopyToGlossary((PrintWriter)object, (Bib2GlsEntry)object2);
                        if (!this.setWidest) continue;
                        this.updateWidestName((Bib2GlsEntry)object2, this.secondaryType, font, fontRenderContext);
                    }
                } else {
                    if (this.bib2gls.useGroupField()) {
                        this.groupTitleMap = new HashMap();
                    }
                    this.sortData(vector4, this.secondarySortSettings, this.secondaryField == null ? this.secondarySortSettings.getSortField() : this.secondaryField, "secondarygroup", this.secondaryType);
                    if (this.bib2gls.useGroupField()) {
                        this.writeGroupDefs((PrintWriter)object);
                    }
                    for (Bib2GlsEntry bib2GlsEntry : vector4) {
                        this.writeCopyToGlossary((PrintWriter)object, bib2GlsEntry);
                        if (!this.setWidest) continue;
                        this.updateWidestName(bib2GlsEntry, this.secondaryType, font, fontRenderContext);
                    }
                }
            }
            if (this.setWidest) {
                ((PrintWriter)object).println("\\ifdef\\glsupdatewidest");
                ((PrintWriter)object).println("{");
                ((PrintWriter)object).println("  \\providecommand*{\\bibglssetwidest}[2]{%");
                ((PrintWriter)object).println("    \\glsupdatewidest[#1]{#2}%");
                ((PrintWriter)object).println("  }");
                ((PrintWriter)object).println("  \\providecommand*{\\bibglssetwidestfortype}[3]{%");
                ((PrintWriter)object).print("    \\apptoglossarypreamble[#1]");
                ((PrintWriter)object).println("{\\glsupdatewidest[#2]{#3}}%");
                ((PrintWriter)object).println("  }");
                ((PrintWriter)object).println("}");
                ((PrintWriter)object).println("{");
                ((PrintWriter)object).println("  \\providecommand*{\\bibglssetwidest}[2]{%");
                ((PrintWriter)object).println("    \\glssetwidest[#1]{#2}%");
                ((PrintWriter)object).println("  }");
                ((PrintWriter)object).println("  \\providecommand*{\\bibglssetwidestfortype}[3]{%");
                ((PrintWriter)object).print("    \\apptoglossarypreamble[#1]");
                ((PrintWriter)object).println("{\\glssetwidest[#2]{#3}}%");
                ((PrintWriter)object).println("  }");
                ((PrintWriter)object).println("}");
                ((PrintWriter)object).println("\\providecommand*{\\bibglssetwidestfallback}[1]{%");
                ((PrintWriter)object).println("  \\glsFindWidestLevelTwo[#1]%");
                ((PrintWriter)object).println("}");
                ((PrintWriter)object).print("\\providecommand*");
                ((PrintWriter)object).println("{\\bibglssetwidesttoplevelfallback}[1]{%");
                ((PrintWriter)object).println("  \\glsFindWidestTopLevelName[#1]%");
                ((PrintWriter)object).println("}");
                ((PrintWriter)object).print("\\providecommand*");
                ((PrintWriter)object).println("{\\bibglssetwidestfortypefallback}[1]{%");
                ((PrintWriter)object).print("  \\apptoglossarypreamble[#1]");
                ((PrintWriter)object).println("{\\bibglssetwidestfallback{#1}}%");
                ((PrintWriter)object).println("}");
                ((PrintWriter)object).print("\\providecommand*");
                ((PrintWriter)object).println("{\\bibglssetwidesttoplevelfortypefallback}[1]{%");
                ((PrintWriter)object).print("  \\apptoglossarypreamble[#1]");
                ((PrintWriter)object).println("{\\bibglssetwidesttoplevelfallback{#1}}%");
                ((PrintWriter)object).println("}");
            }
            if (this.setWidest) {
                this.writeWidestNames((PrintWriter)object, font, fontRenderContext);
                ((PrintWriter)object).println();
            }
            this.bib2gls.message(this.bib2gls.getChoiceMessage("message.written", 0, "entry", 3, n, this.texFile.toString()));
        }
        return n;
    }

    private void writeBibEntryDef(PrintWriter printWriter, Bib2GlsEntry bib2GlsEntry) throws IOException {
        String string = bib2GlsEntry.getId();
        if (this.bib2gls.isEntrySelected(string)) {
            if (this.dupLabelSuffix == null) {
                this.bib2gls.warningMessage("warning.entry.already.defined", string, this.toString());
            } else {
                int n = 1;
                String string2 = this.dupLabelSuffix + n;
                while (this.bib2gls.isEntrySelected(string + string2)) {
                    string2 = this.dupLabelSuffix + ++n;
                }
                bib2GlsEntry.setSuffix(string2);
                string = bib2GlsEntry.getId();
                this.bib2gls.selectedEntry(string);
            }
        } else {
            this.bib2gls.selectedEntry(string);
        }
        bib2GlsEntry.writeBibEntry(printWriter);
        if (this.saveOriginalId != null && !this.bib2gls.isKnownField(this.saveOriginalId)) {
            printWriter.format("\\GlsXtrSetField{%s}{%s}{%s}%n", string, this.saveOriginalId, bib2GlsEntry.getOriginalId());
        }
        if (this.saveLocList) {
            bib2GlsEntry.writeLocList(printWriter);
        }
        if (this.saveChildCount) {
            printWriter.format("\\GlsXtrSetField{%s}{childcount}{%d}%n", string, bib2GlsEntry.getChildCount());
        }
        if (this.checkEndPunc != null) {
            for (String string3 : this.checkEndPunc) {
                String string4 = string3 + "endpunc";
                String string5 = bib2GlsEntry.getFieldValue(string4);
                if (string5 == null) continue;
                printWriter.format("\\GlsXtrSetField{%s}{%s}{%s}%n", string, string4, string5);
            }
        }
        if (this.bib2gls.isRecordCountSet()) {
            this.bib2gls.writeRecordCount(string, printWriter);
        }
    }

    private void writeBibEntryCopy(PrintWriter printWriter, Bib2GlsEntry bib2GlsEntry) throws IOException {
        String string;
        String string2 = this.getType(bib2GlsEntry);
        if (string2 == null) {
            string2 = this.type;
        }
        printWriter.format("\\glsxtrcopytoglossary{%s}{%s}%n", bib2GlsEntry.getId(), string2);
        if (this.copyActionGroupField != null && (string = bib2GlsEntry.getFieldValue("group")) != null) {
            printWriter.format("\\GlsXtrSetField{%s}{%s}{%s}%n", bib2GlsEntry.getId(), this.copyActionGroupField, string);
        }
        if (bib2GlsEntry instanceof Bib2GlsDualEntry && ((Bib2GlsDualEntry)bib2GlsEntry).hasTertiary()) {
            String string3;
            if (this.tertiaryType != null) {
                string2 = this.tertiaryType;
            }
            string = bib2GlsEntry.getOriginalId();
            if (this.tertiaryPrefix != null) {
                string = this.tertiaryPrefix + string;
            }
            printWriter.format("\\glsxtrcopytoglossary{%s}{%s}%n", string, string2);
            if (this.copyActionGroupField != null && (string3 = bib2GlsEntry.getFieldValue("group")) != null) {
                printWriter.format("\\GlsXtrSetField{%s}{%s}{%s}%n", string, this.copyActionGroupField, string3);
            }
        }
    }

    private void writeBibEntry(PrintWriter printWriter, Bib2GlsEntry bib2GlsEntry) throws IOException {
        switch (this.writeAction) {
            case 0: {
                this.writeBibEntryDef(printWriter, bib2GlsEntry);
                break;
            }
            case 1: {
                this.writeBibEntryCopy(printWriter, bib2GlsEntry);
                break;
            }
            case 2: {
                String string;
                printWriter.format("\\ifglsentryexists{%s}{%n", bib2GlsEntry.getId());
                this.writeBibEntryCopy(printWriter, bib2GlsEntry);
                printWriter.println("}");
                printWriter.println("{");
                this.writeBibEntryDef(printWriter, bib2GlsEntry);
                if (this.copyActionGroupField != null && (string = bib2GlsEntry.getFieldValue("group")) != null) {
                    printWriter.format("\\GlsXtrSetField{%s}{%s}{%s}%n", bib2GlsEntry.getId(), this.copyActionGroupField, string);
                }
                printWriter.println("}");
            }
        }
        printWriter.println();
    }

    private boolean writeGroupDefs(PrintWriter printWriter) throws IOException {
        boolean bl = this.bib2gls.hyperrefLoaded() && this.bib2gls.createHyperGroupsOn();
        for (String string : this.groupTitleMap.keySet()) {
            GroupTitle groupTitle = this.groupTitleMap.get(string);
            if (groupTitle.getType() == null) {
                bl = false;
            }
            printWriter.format("\\%s{%s}%n", groupTitle.getCsSetName(), groupTitle);
        }
        printWriter.println();
        return bl;
    }

    private void writeCopyToGlossary(PrintWriter printWriter, Bib2GlsEntry bib2GlsEntry) throws IOException {
        String string;
        printWriter.format("\\glsxtrcopytoglossary{%s}{%s}%n", bib2GlsEntry.getId(), this.secondaryType);
        String string2 = bib2GlsEntry.getFieldValue("secondarygroup");
        if (string2 != null) {
            printWriter.format("\\GlsXtrSetField{%s}{secondarygroup}{%s}%n", bib2GlsEntry.getId(), string2);
        }
        if ((string = bib2GlsEntry.getFieldValue("sort")) != null) {
            printWriter.format("\\GlsXtrSetField{%s}{secondarysort}{%s}%n", bib2GlsEntry.getId(), string);
        }
        printWriter.println();
    }

    private void writeWidestNames(PrintWriter printWriter, Font font, FontRenderContext fontRenderContext) throws IOException {
        Object object;
        Serializable serializable;
        if (this.widestNameNoType != null) {
            int n = 0;
            boolean bl = false;
            serializable = new StringBuilder();
            Iterator<Integer> iterator = this.widestNameNoType.getKeyIterator();
            while (iterator.hasNext()) {
                Integer n2 = iterator.next();
                if (n2 > n) {
                    n = n2;
                }
                if (((WidestName)(object = (WidestName)this.widestNameNoType.get(n2))).getName().isEmpty()) {
                    this.bib2gls.verboseMessage("warning.unknown.widest", new Object[0]);
                    bl = true;
                    continue;
                }
                ((StringBuilder)serializable).append("\\bibglssetwidest");
                ((StringBuilder)serializable).append(String.format("{%d}{\\glsentryname{%s}}%n", n2, ((WidestName)object).getLabel()));
            }
            if (bl) {
                if (n == 0) {
                    printWriter.println("\\bibglssetwidesttoplevelfallback{\\@glo@types}");
                } else {
                    printWriter.format("\\bibglssetwidestfallback{\\@glo@types}", new Object[0]);
                }
            }
            printWriter.println(serializable);
        }
        if (this.widestNames != null) {
            for (String string : this.widestNames.keySet()) {
                serializable = this.widestNames.get(string);
                int n = 0;
                boolean bl = false;
                object = new StringBuilder();
                Iterator<Integer> iterator = ((WidestNameHierarchy)serializable).getKeyIterator();
                while (iterator.hasNext()) {
                    WidestName widestName;
                    Integer n3 = iterator.next();
                    if (n3 > n) {
                        n = n3;
                    }
                    if ((widestName = (WidestName)((HashMap)serializable).get(n3)).getName().isEmpty()) {
                        this.bib2gls.verboseMessage("warning.unknown.widest.fortype", n3, string);
                        bl = true;
                        continue;
                    }
                    ((StringBuilder)object).append("\\bibglssetwidestfortype");
                    ((StringBuilder)object).append(String.format("{%s}{%d}{\\glsentryname{%s}}%n", string, n3, widestName.getLabel()));
                }
                if (bl) {
                    if (n == 0) {
                        printWriter.format("\\bibglssetwidesttoplevelfortypefallback{%s}%n", string);
                    } else {
                        printWriter.format("\\bibglssetwidestfortypefallback{%s}%n", string);
                    }
                }
                printWriter.println(object);
            }
        }
    }

    private void updateWidestName(Bib2GlsEntry bib2GlsEntry, Font font, FontRenderContext fontRenderContext) {
        this.updateWidestName(bib2GlsEntry, null, font, fontRenderContext);
    }

    private void updateWidestName(Bib2GlsEntry bib2GlsEntry, String string, Font font, FontRenderContext fontRenderContext) {
        Cloneable cloneable;
        string = string == null ? this.getType(bib2GlsEntry) : this.getType(bib2GlsEntry, string, false);
        String string2 = bib2GlsEntry.getFieldValue("name");
        if (string2 == null || string2.isEmpty()) {
            return;
        }
        this.bib2gls.logMessage(this.bib2gls.getMessage("message.calc.text.width", bib2GlsEntry.getId()));
        if (string2.matches("(?s).*[\\\\\\$\\{\\}].*")) {
            string2 = this.bib2gls.interpret(string2, bib2GlsEntry.getField("name"), true);
        }
        double d = 0.0;
        if (!string2.isEmpty()) {
            cloneable = new TextLayout(string2, font, fontRenderContext);
            d = cloneable.getBounds().getWidth();
        }
        this.bib2gls.logMessage(this.bib2gls.getMessage("message.calc.text.width.result", string2, d));
        if (string == null) {
            if (this.widestNameNoType == null) {
                this.widestNameNoType = new WidestNameHierarchy();
            }
            this.widestNameNoType.update(bib2GlsEntry, string2, d);
        } else {
            if (this.widestNames == null) {
                this.widestNames = new HashMap();
            }
            if ((cloneable = this.widestNames.get(string)) == null) {
                cloneable = new WidestNameHierarchy();
                this.widestNames.put(string, (WidestNameHierarchy)cloneable);
            }
            ((WidestNameHierarchy)cloneable).update(bib2GlsEntry, string2, d);
        }
    }

    private void checkParent(Bib2GlsEntry bib2GlsEntry, int n, Vector<Bib2GlsEntry> vector) {
        Bib2GlsEntry bib2GlsEntry2;
        int n2;
        if (this.flatten) {
            bib2GlsEntry.removeFieldValue("parent");
            return;
        }
        String string = bib2GlsEntry.getParent();
        if (string == null || string.isEmpty()) {
            return;
        }
        for (n2 = n - 1; n2 >= 0; --n2) {
            bib2GlsEntry2 = vector.get(n2);
            if (!bib2GlsEntry2.getId().equals(string)) continue;
            if (this.flattenLonely != 0 || this.saveChildCount) {
                bib2GlsEntry2.addChild(bib2GlsEntry);
            }
            return;
        }
        for (n2 = vector.size() - 1; n2 > n - 1; --n2) {
            bib2GlsEntry2 = vector.get(n2);
            if (!bib2GlsEntry2.getId().equals(string)) continue;
            if (this.flattenLonely != 0 || this.saveChildCount) {
                bib2GlsEntry2.addChild(bib2GlsEntry);
            }
            return;
        }
        this.bib2gls.warning(this.bib2gls.getMessage("warning.parent.missing", string, bib2GlsEntry.getId()));
        bib2GlsEntry.removeFieldValue("parent");
    }

    private String flattenLonelyCsName() {
        return this.flattenLonely == 1 ? "bibglsflattenedchildpresort" : "bibglsflattenedchildpostsort";
    }

    private void flattenChild(Bib2GlsEntry bib2GlsEntry, Bib2GlsEntry bib2GlsEntry2, Vector<Bib2GlsEntry> vector) {
        String string;
        String string2;
        L2HStringConverter l2HStringConverter = null;
        BibValueList bibValueList = null;
        BibValueList bibValueList2 = null;
        if (this.flattenLonely == 1) {
            l2HStringConverter = this.bib2gls.getInterpreterListener();
        }
        String string3 = bib2GlsEntry2.getFieldValue("name");
        if (l2HStringConverter != null) {
            bibValueList = bib2GlsEntry2.getField("name");
        }
        if (string3 == null) {
            string3 = bib2GlsEntry2.getFallbackValue("name");
            if (l2HStringConverter != null && bibValueList == null) {
                bibValueList = bib2GlsEntry2.getFallbackContents("name");
            }
        }
        if ((string2 = bib2GlsEntry2.getFieldValue("text")) == null && string3 != null) {
            bib2GlsEntry2.putField("text", string3);
        }
        String string4 = bib2GlsEntry.getFieldValue("name");
        if (l2HStringConverter != null) {
            bibValueList2 = bib2GlsEntry.getField("name");
        }
        if (string4 == null) {
            string4 = bib2GlsEntry.getFallbackValue("name");
            if (l2HStringConverter != null) {
                bibValueList2 = bib2GlsEntry.getFallbackContents("name");
            }
        }
        if (string3 != null) {
            boolean bl = string3.equals(string4);
            String string5 = bl ? "bibglsflattenedhomograph" : this.flattenLonelyCsName();
            TeXObjectList teXObjectList = null;
            Group group = null;
            Group group2 = null;
            if (l2HStringConverter != null) {
                teXObjectList = new TeXObjectList();
                teXObjectList.add(new TeXCsRef(string5));
                group = bibValueList == null ? l2HStringConverter.createGroup(string3) : this.getContents(bibValueList, l2HStringConverter);
                group2 = bibValueList2 == null ? (string4 == null ? l2HStringConverter.createGroup() : l2HStringConverter.createGroup(string4)) : this.getContents(bibValueList2, l2HStringConverter);
                if (this.flattenLonely == 2) {
                    teXObjectList.add(group2);
                    teXObjectList.add(group);
                } else {
                    teXObjectList.add(group);
                    teXObjectList.add(group2);
                }
            }
            if (this.flattenLonely == 2) {
                bib2GlsEntry2.putField("name", String.format("\\%s{%s}{%s}", string5, string4, string3));
            } else {
                bib2GlsEntry2.putField("name", String.format("\\%s{%s}{%s}", string5, string3, string4));
                if (teXObjectList != null) {
                    BibValueList bibValueList3 = new BibValueList();
                    bibValueList3.add(new BibUserString(teXObjectList));
                    bib2GlsEntry2.putField("name", bibValueList3);
                }
            }
        }
        bib2GlsEntry2.moveUpHierarchy(vector);
        if (this.flattenLonely == 2 && (string = bib2GlsEntry.getFieldValue("group")) != null) {
            bib2GlsEntry2.putField("group", string);
        }
    }

    private Group getContents(BibValueList bibValueList, L2HStringConverter l2HStringConverter) {
        TeXObject teXObject = bibValueList.getContents(true);
        if (teXObject instanceof TeXObjectList && !(teXObject instanceof MathGroup) && ((TeXObjectList)teXObject).size() == 1 && ((TeXObjectList)teXObject).firstElement() instanceof Group) {
            TeXObjectList teXObjectList = (TeXObjectList)teXObject;
            Group group = (Group)teXObjectList.firstElement();
            if (!(group instanceof MathGroup)) {
                return group;
            }
            group = l2HStringConverter.createGroup();
            group.add(teXObjectList);
            return group;
        }
        Group group = l2HStringConverter.createGroup();
        group.add(teXObject);
        return group;
    }

    private void flattenLonelyChildren(Vector<Bib2GlsEntry> vector) {
        Object object;
        Bib2GlsEntry bib2GlsEntry;
        Object object22;
        int n;
        Hashtable<Object, Vector<Bib2GlsEntry>> hashtable = new Hashtable<Object, Vector<Bib2GlsEntry>>();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        Vector<Object> vector2 = new Vector<Object>();
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            object22 = vector.get(n);
            this.checkParent((Bib2GlsEntry)object22, n, vector);
        }
        int n4 = vector.size();
        for (n = 0; n < n4; ++n) {
            boolean string;
            object22 = vector.get(n);
            int iterator = ((Bib2GlsEntry)object22).getChildCount();
            if (iterator != 1) continue;
            bib2GlsEntry = ((Bib2GlsEntry)object22).getChild(0);
            boolean bl = string = ((Bib2GlsEntry)object22).recordCount() > 0 || ((Bib2GlsEntry)object22).hasCrossRefs();
            if (this.flattenLonelyRule == 0 && string) continue;
            object = new Integer(bib2GlsEntry.getLevel(vector));
            Vector<Bib2GlsEntry> vector3 = (Vector<Bib2GlsEntry>)hashtable.get(object);
            if (vector3 == null) {
                vector3 = new Vector<Bib2GlsEntry>();
                hashtable.put(object, vector3);
                treeSet.add(object);
            }
            vector3.add(bib2GlsEntry);
            if (this.flattenLonelyRule == 1 || string) continue;
            vector2.add(object22);
        }
        for (Integer n3 : treeSet) {
            object22 = (Vector)hashtable.get(n3);
            Iterator iterator = ((Vector)object22).iterator();
            while (iterator.hasNext()) {
                bib2GlsEntry = (Bib2GlsEntry)iterator.next();
                String string = bib2GlsEntry.getParent();
                object = Bib2GlsEntry.getEntry(string, vector);
                this.flattenChild((Bib2GlsEntry)object, bib2GlsEntry, vector);
            }
        }
        for (Object object22 : vector2) {
            vector.remove(object22);
        }
    }

    public boolean flattenSort() {
        return this.flatten;
    }

    private void setType(Bib2GlsEntry bib2GlsEntry) {
        String string;
        if (this.triggerType != null && bib2GlsEntry.hasTriggerRecord()) {
            bib2GlsEntry.putField("type", this.triggerType);
        } else if (this.type != null && (string = this.getType(bib2GlsEntry, this.type, false)) != null) {
            bib2GlsEntry.putField("type", string);
        }
    }

    private void setCategory(Bib2GlsEntry bib2GlsEntry) {
        this.setCategory(bib2GlsEntry, this.category);
    }

    private void setCategory(Bib2GlsEntry bib2GlsEntry, String string) {
        String string2;
        if (string != null && (string2 = this.getCategory(bib2GlsEntry, string, false)) != null) {
            bib2GlsEntry.putField("category", string2);
        }
    }

    private void setCounter(Bib2GlsEntry bib2GlsEntry) {
        if (this.counter != null) {
            bib2GlsEntry.putField("counter", this.counter);
        }
    }

    private void setDualCounter(Bib2GlsEntry bib2GlsEntry) {
        if (this.dualCounter != null) {
            if (this.dualCounter.equals("same as primary")) {
                String string = bib2GlsEntry.getDual().getFieldValue("counter");
                if (string != null) {
                    bib2GlsEntry.putField("counter", string);
                }
            } else {
                bib2GlsEntry.putField("counter", this.dualCounter);
            }
        }
    }

    private void setDualType(Bib2GlsEntry bib2GlsEntry) {
        String string;
        if (this.triggerType != null && bib2GlsEntry.hasTriggerRecord()) {
            bib2GlsEntry.putField("type", this.triggerType);
        } else if (this.dualType != null && (string = this.getType(bib2GlsEntry, this.dualType, false)) != null) {
            bib2GlsEntry.putField("type", string);
        }
    }

    private void setDualCategory(Bib2GlsEntry bib2GlsEntry) {
        String string;
        if (this.dualCategory != null && (string = this.getCategory(bib2GlsEntry, this.dualCategory, false)) != null) {
            bib2GlsEntry.putField("category", string);
        }
    }

    public boolean hasSkippedFields() {
        return this.skipFields != null && this.skipFields.length != 0;
    }

    public String[] getSkipFields() {
        return this.skipFields;
    }

    public boolean skipField(String string) {
        if (this.skipFields == null) {
            return false;
        }
        for (int i = 0; i < this.skipFields.length; ++i) {
            if (!this.skipFields[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public byte getContributorOrder() {
        return this.contributorOrder;
    }

    public boolean isBibTeXAuthorField(String string) {
        if (this.bibtexAuthorList == null) {
            return false;
        }
        for (String string2 : this.bibtexAuthorList) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public String getLabelPrefix() {
        return this.labelPrefix;
    }

    public String getDualPrefix() {
        return this.dualPrefix;
    }

    public String getTertiaryType() {
        return this.tertiaryType;
    }

    public String getTertiaryPrefix() {
        return this.tertiaryPrefix;
    }

    public String getTertiaryCategory() {
        return this.tertiaryCategory;
    }

    public String getExternalPrefix(int n) {
        if (this.externalPrefixes == null) {
            return null;
        }
        if (n >= 1 && n <= this.externalPrefixes.length) {
            return this.externalPrefixes[n - 1];
        }
        return null;
    }

    public String getCsLabelPrefix() {
        return this.csLabelPrefix;
    }

    public String getDualSortField() {
        return this.dualSortSettings.getSortField();
    }

    public String getPluralSuffix() {
        return this.pluralSuffix;
    }

    public String getShortPluralSuffix() {
        return this.shortPluralSuffix;
    }

    public String getDualPluralSuffix() {
        return this.dualPluralSuffix;
    }

    public String getDualShortPluralSuffix() {
        return this.dualShortPluralSuffix;
    }

    public HashMap<String, String> getDualEntryMap() {
        return this.dualEntryMap;
    }

    public String getFirstDualEntryMap() {
        return this.dualEntryFirstMap;
    }

    public boolean backLinkFirstDualEntryMap() {
        return this.backLinkDualEntry;
    }

    public HashMap<String, String> getDualSymbolMap() {
        return this.dualSymbolMap;
    }

    public String getFirstDualSymbolMap() {
        return this.dualSymbolFirstMap;
    }

    public boolean backLinkFirstDualSymbolMap() {
        return this.backLinkDualSymbol;
    }

    public HashMap<String, String> getDualAbbrevMap() {
        return this.dualAbbrevMap;
    }

    public HashMap<String, String> getDualAbbrevEntryMap() {
        return this.dualAbbrevEntryMap;
    }

    public HashMap<String, String> getDualIndexEntryMap() {
        return this.dualIndexEntryMap;
    }

    public HashMap<String, String> getDualIndexSymbolMap() {
        return this.dualIndexSymbolMap;
    }

    public HashMap<String, String> getDualIndexAbbrevMap() {
        return this.dualIndexAbbrevMap;
    }

    public String getFirstDualAbbrevMap() {
        return this.dualAbbrevFirstMap;
    }

    public String getFirstDualAbbrevEntryMap() {
        return this.dualAbbrevEntryFirstMap;
    }

    public String getFirstDualIndexEntryMap() {
        return this.dualIndexEntryFirstMap;
    }

    public String getFirstDualIndexSymbolMap() {
        return this.dualIndexSymbolFirstMap;
    }

    public String getFirstDualIndexAbbrevMap() {
        return this.dualIndexAbbrevFirstMap;
    }

    public boolean backLinkFirstDualAbbrevMap() {
        return this.backLinkDualAbbrev;
    }

    public boolean backLinkFirstDualAbbrevEntryMap() {
        return this.backLinkDualAbbrevEntry;
    }

    public boolean backLinkFirstDualIndexEntryMap() {
        return this.backLinkDualIndexEntry;
    }

    public boolean backLinkFirstDualIndexSymbolMap() {
        return this.backLinkDualIndexSymbol;
    }

    public boolean backLinkFirstDualIndexAbbrevMap() {
        return this.backLinkDualIndexAbbrev;
    }

    public String getDualField() {
        return this.dualField;
    }

    private void checkFieldMaps(HashMap<String, String> hashMap, String string) throws Bib2GlsException {
        for (String string2 : hashMap.keySet()) {
            if (!this.bib2gls.isKnownField(string2)) {
                throw new Bib2GlsException(this.bib2gls.getMessage("error.invalid.field", string2, string));
            }
            if (this.bib2gls.isKnownField(string2 = hashMap.get(string2))) continue;
            throw new Bib2GlsException(this.bib2gls.getMessage("error.invalid.field", string2, string));
        }
    }

    public boolean discard(Bib2GlsEntry bib2GlsEntry) {
        if (this.fieldPatterns == null || this.matchAction != 0) {
            return false;
        }
        boolean bl = this.notMatch(bib2GlsEntry);
        return this.notMatch ? !bl : bl;
    }

    private boolean notMatch(Bib2GlsEntry bib2GlsEntry) {
        boolean bl = this.fieldPatternsAnd;
        for (String string : this.fieldPatterns.keySet()) {
            String string2 = null;
            string2 = string.equals(PATTERN_FIELD_ID) ? bib2GlsEntry.getId() : (string.equals(PATTERN_FIELD_ENTRY_TYPE) ? bib2GlsEntry.getEntryType() : bib2GlsEntry.getFieldValue(string));
            if (string2 == null) {
                string2 = "";
            }
            Pattern pattern = this.fieldPatterns.get(string);
            Matcher matcher = pattern.matcher(string2);
            boolean bl2 = matcher.matches();
            this.bib2gls.debug(this.bib2gls.getMessage("message.pattern.info", pattern.pattern(), string, string2, bl2));
            if (this.fieldPatternsAnd) {
                if (bl2) continue;
                return true;
            }
            if (!bl2) continue;
            return false;
        }
        return !bl;
    }

    public byte getPostDescDot() {
        return this.postDescDot;
    }

    public boolean isStripTrailingNoPostOn() {
        return this.stripTrailingNoPost;
    }

    public boolean isLabelifyField(String string) {
        if (this.labelifyFields == null) {
            return false;
        }
        for (String string2 : this.labelifyFields) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isLabelifyListField(String string) {
        if (this.labelifyListFields == null) {
            return false;
        }
        for (String string2 : this.labelifyListFields) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public Vector<PatternReplace> getLabelifySubstitutions() {
        return this.labelifyReplaceMap;
    }

    public boolean isCheckEndPuncOn() {
        return this.checkEndPunc != null;
    }

    public boolean isCheckEndPuncOn(String string) {
        if (this.checkEndPunc == null) {
            return false;
        }
        for (String string2 : this.checkEndPunc) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean changeNameCase() {
        return this.nameCaseChange != null;
    }

    public boolean changeDescriptionCase() {
        return this.descCaseChange != null;
    }

    public boolean changeShortCase() {
        return this.shortCaseChange != null;
    }

    public boolean changeDualShortCase() {
        return this.dualShortCaseChange != null;
    }

    public BibValueList applyNameCaseChange(TeXParser teXParser, BibValueList bibValueList) throws IOException {
        return this.applyCaseChange(teXParser, bibValueList, this.nameCaseChange);
    }

    public BibValueList applyDescriptionCaseChange(TeXParser teXParser, BibValueList bibValueList) throws IOException {
        return this.applyCaseChange(teXParser, bibValueList, this.descCaseChange);
    }

    public BibValueList applyShortCaseChange(TeXParser teXParser, BibValueList bibValueList) throws IOException {
        return this.applyCaseChange(teXParser, bibValueList, this.shortCaseChange);
    }

    public BibValueList applyDualShortCaseChange(TeXParser teXParser, BibValueList bibValueList) throws IOException {
        return this.applyCaseChange(teXParser, bibValueList, this.dualShortCaseChange);
    }

    public static void toLowerCase(TeXObjectList teXObjectList) {
        int n = teXObjectList.size();
        for (int i = 0; i < n; ++i) {
            String string;
            TeXObject teXObject = (TeXObject)teXObjectList.get(i);
            if (teXObject instanceof CharObject) {
                int n2 = ((CharObject)teXObject).getCharCode();
                if (!Character.isAlphabetic(n2)) continue;
                n2 = Character.toLowerCase(n2);
                ((CharObject)teXObject).setCharCode(n2);
                continue;
            }
            if (teXObject instanceof TeXObjectList) {
                GlsResource.toLowerCase((TeXObjectList)teXObject);
                continue;
            }
            if (!(teXObject instanceof ControlSequence) || !(string = ((ControlSequence)teXObject).getName()).equals("NoCaseChange") && !string.equals("ensuremath") && !string.equals("si")) continue;
            ++i;
            while (i < n && (teXObject = (TeXObject)teXObjectList.get(i)) instanceof Ignoreable) {
                ++i;
            }
        }
    }

    public static void toUpperCase(TeXObjectList teXObjectList) {
        int n = teXObjectList.size();
        for (int i = 0; i < n; ++i) {
            String string;
            TeXObject teXObject = (TeXObject)teXObjectList.get(i);
            if (teXObject instanceof CharObject) {
                int n2 = ((CharObject)teXObject).getCharCode();
                if (!Character.isAlphabetic(n2)) continue;
                n2 = Character.toUpperCase(n2);
                ((CharObject)teXObject).setCharCode(n2);
                continue;
            }
            if (teXObject instanceof MathGroup) continue;
            if (teXObject instanceof TeXObjectList) {
                GlsResource.toUpperCase((TeXObjectList)teXObject);
                continue;
            }
            if (!(teXObject instanceof ControlSequence) || !(string = ((ControlSequence)teXObject).getName()).equals("NoCaseChange") && !string.equals("ensuremath") && !string.equals("si")) continue;
            ++i;
            while (i < n && (teXObject = (TeXObject)teXObjectList.get(i)) instanceof Ignoreable) {
                ++i;
            }
        }
    }

    public static void toSentenceCase(TeXObjectList teXObjectList) {
        int n = teXObjectList.size();
        for (int i = 0; i < n; ++i) {
            String string;
            TeXObject teXObject = (TeXObject)teXObjectList.get(i);
            if (teXObject instanceof CharObject) {
                int n2 = ((CharObject)teXObject).getCharCode();
                if (!Character.isAlphabetic(n2)) continue;
                n2 = Character.toTitleCase(n2);
                ((CharObject)teXObject).setCharCode(n2);
                return;
            }
            if (teXObject instanceof MathGroup) {
                return;
            }
            if (teXObject instanceof Group) {
                GlsResource.toUpperCase((TeXObjectList)teXObject);
                return;
            }
            if (!(teXObject instanceof ControlSequence) || (string = ((ControlSequence)teXObject).getName()).equals("protect")) continue;
            ++i;
            while (i < n && (teXObject = (TeXObject)teXObjectList.get(i)) instanceof Ignoreable) {
                ++i;
            }
            if (string.equals("NoCaseChange") || string.equals("ensuremath") || string.equals("si")) continue;
            if (teXObject instanceof Group && !(teXObject instanceof MathGroup)) {
                GlsResource.toSentenceCase((TeXObjectList)teXObject);
            }
            return;
        }
    }

    public BibValueList applyCaseChange(TeXParser teXParser, BibValueList bibValueList, String string) throws IOException {
        if (string == null) {
            return bibValueList;
        }
        TeXObjectList teXObjectList = BibValueList.stripDelim(bibValueList.expand(teXParser));
        BibValueList bibValueList2 = new BibValueList();
        if (string.equals("lc-cs")) {
            Group group = teXParser.getListener().createGroup();
            group.addAll(teXObjectList);
            teXObjectList = new TeXObjectList();
            teXObjectList.add(new TeXCsRef("MakeTextLowercase"));
            teXObjectList.add(group);
        } else if (string.equals("uc-cs")) {
            Group group = teXParser.getListener().createGroup();
            group.addAll(teXObjectList);
            teXObjectList = new TeXObjectList();
            teXObjectList.add(new TeXCsRef("MakeTextUppercase"));
            teXObjectList.add(group);
        } else if (string.equals("firstuc-cs")) {
            Group group = teXParser.getListener().createGroup();
            group.addAll(teXObjectList);
            teXObjectList = new TeXObjectList();
            teXObjectList.add(new TeXCsRef("makefirstuc"));
            teXObjectList.add(group);
        } else if (string.equals("lc")) {
            GlsResource.toLowerCase(teXObjectList);
        } else if (string.equals("uc")) {
            GlsResource.toUpperCase(teXObjectList);
        } else if (string.equals("firstuc")) {
            GlsResource.toSentenceCase(teXObjectList);
        } else {
            throw new IllegalArgumentException("Invalid case change option: " + string);
        }
        bibValueList2.add(new BibUserString(teXObjectList));
        return bibValueList2;
    }

    public int aliasLocations() {
        return this.aliasLocations;
    }

    public boolean hasAliases() {
        return this.aliases;
    }

    public void setAliases(boolean bl) {
        this.aliases = bl;
    }

    public String[] getLocationCounters() {
        return this.counters;
    }

    public String getGroupField() {
        return this.groupField;
    }

    public String getType(Bib2GlsEntry bib2GlsEntry) {
        String string = bib2GlsEntry.getFieldValue("type");
        if (string != null) {
            return string;
        }
        string = this.type;
        if (bib2GlsEntry instanceof Bib2GlsDualEntry && !((Bib2GlsDualEntry)bib2GlsEntry).isPrimary()) {
            string = this.dualType;
        }
        return this.getType(bib2GlsEntry, string, false);
    }

    public String getType(Bib2GlsEntry bib2GlsEntry, String string) {
        return this.getType(bib2GlsEntry, string, true);
    }

    public String getType(Bib2GlsEntry bib2GlsEntry, String string, boolean bl) {
        Bib2GlsEntry bib2GlsEntry2;
        String string2 = null;
        if (bl && (string2 = bib2GlsEntry.getFieldValue("type")) != null) {
            return string2;
        }
        string2 = string;
        if (string2 == null) {
            return null;
        }
        if (string2.equals("same as category")) {
            string2 = bib2GlsEntry instanceof Bib2GlsDualEntry && !((Bib2GlsDualEntry)bib2GlsEntry).isPrimary() ? this.dualCategory : this.category;
            if ("same as type".equals(string2)) {
                throw new IllegalArgumentException(this.bib2gls.getMessage("error.cyclic.sameas.type.category", new Object[0]));
            }
            return this.getCategory(bib2GlsEntry, string2);
        }
        if (string2.equals("same as entry")) {
            return bib2GlsEntry.getEntryType();
        }
        if (string2.equals("same as base")) {
            return bib2GlsEntry.getBase();
        }
        if (string2.equals("same as primary") && bib2GlsEntry instanceof Bib2GlsDualEntry && !((Bib2GlsDualEntry)bib2GlsEntry).isPrimary() && (bib2GlsEntry2 = bib2GlsEntry.getDual()) != null) {
            return this.getType(bib2GlsEntry2, string);
        }
        return string2;
    }

    public String getCategory(Bib2GlsEntry bib2GlsEntry) {
        String string = bib2GlsEntry.getFieldValue("category");
        if (string != null) {
            return string;
        }
        string = this.category;
        if (bib2GlsEntry instanceof Bib2GlsDualEntry && !((Bib2GlsDualEntry)bib2GlsEntry).isPrimary()) {
            string = this.dualCategory;
        }
        return this.getCategory(bib2GlsEntry, string, false);
    }

    public String getCategory(Bib2GlsEntry bib2GlsEntry, String string) {
        return this.getCategory(bib2GlsEntry, string, true);
    }

    public String getCategory(Bib2GlsEntry bib2GlsEntry, String string, boolean bl) {
        Bib2GlsEntry bib2GlsEntry2;
        String string2 = null;
        if (bl && (string2 = bib2GlsEntry.getFieldValue("category")) != null) {
            return string2;
        }
        string2 = string;
        if (string2 == null) {
            return null;
        }
        if (string2.equals("same as type")) {
            string2 = bib2GlsEntry instanceof Bib2GlsDualEntry && !((Bib2GlsDualEntry)bib2GlsEntry).isPrimary() ? this.dualType : this.type;
            if ("same as category".equals(string2)) {
                throw new IllegalArgumentException(this.bib2gls.getMessage("error.cyclic.sameas.type.category", new Object[0]));
            }
            return this.getType(bib2GlsEntry, string2);
        }
        if (string2.equals("same as entry")) {
            return bib2GlsEntry.getEntryType();
        }
        if (string2.equals("same as base")) {
            return bib2GlsEntry.getBase();
        }
        if (string2.equals("same as primary") && bib2GlsEntry instanceof Bib2GlsDualEntry && !((Bib2GlsDualEntry)bib2GlsEntry).isPrimary() && (bib2GlsEntry2 = bib2GlsEntry.getDual()) != null) {
            return this.getCategory(bib2GlsEntry2, string);
        }
        return string2;
    }

    private void writeHyperGroupDef(Bib2GlsEntry bib2GlsEntry, PrintWriter printWriter) throws IOException {
        String string = bib2GlsEntry.getGroupId();
        if (string == null) {
            this.bib2gls.debug("writeHyperGroupDef: No group ID for entry " + bib2GlsEntry.getId());
            return;
        }
        GroupTitle groupTitle = this.groupTitleMap.get(string);
        if (groupTitle == null) {
            this.bib2gls.debug("writeHyperGroupDef: No group found for " + string);
            return;
        }
        if (!groupTitle.isDone()) {
            printWriter.format("\\bibglshypergroup{%s}{\\%s%s}%n", groupTitle.getType(), groupTitle.getCsLabelName(), groupTitle);
            groupTitle.mark();
            printWriter.println();
        }
    }

    public void putGroupTitle(GroupTitle groupTitle, Bib2GlsEntry bib2GlsEntry) {
        if (this.groupTitleMap != null) {
            String string = groupTitle.getKey();
            bib2GlsEntry.setGroupId(string);
            this.groupTitleMap.put(string, groupTitle);
        }
    }

    public GroupTitle getGroupTitle(String string, long l) {
        if (this.groupTitleMap != null) {
            return this.groupTitleMap.get(GroupTitle.getKey(string, l));
        }
        return null;
    }

    public String mapEntryType(String string) {
        if (this.entryTypeAliases == null) {
            return string;
        }
        String string2 = this.entryTypeAliases.get(string);
        return string2 == null ? string : string2;
    }

    public String getSaveOriginalIdField() {
        return this.saveOriginalId;
    }

    public boolean hasFieldAliases() {
        return this.fieldAliases != null;
    }

    public Iterator<String> getFieldAliasesIterator() {
        return this.fieldAliases.keySet().iterator();
    }

    public String getFieldAlias(String string) {
        return this.fieldAliases.get(string);
    }

    public boolean isReplicateOverrideOn() {
        return this.replicateOverride;
    }

    public boolean hasFieldCopies() {
        return this.fieldCopies != null;
    }

    public Iterator<String> getFieldCopiesIterator() {
        return this.fieldCopies.keySet().iterator();
    }

    public Vector<String> getFieldCopy(String string) {
        return this.fieldCopies.get(string);
    }

    public boolean isCombineDualLocationsOn() {
        return this.combineDualLocations != 0;
    }

    public int getCombineDualLocations() {
        return this.combineDualLocations;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDualCategory() {
        return this.dualCategory;
    }

    public String getAbbrevDefaultSortField() {
        return this.abbrevDefaultSortField;
    }

    public String getSymbolDefaultSortField() {
        return this.symbolDefaultSortField;
    }

    public String getAbbrevDefaultNameField() {
        return this.abbrevDefaultNameField;
    }

    public boolean useNonBreakSpace() {
        return this.bib2gls.useNonBreakSpace();
    }

    public boolean useInterpreter() {
        return this.bib2gls.useInterpreter();
    }

    public String interpret(String string, BibValueList bibValueList, boolean bl) {
        return this.bib2gls.interpret(string, bibValueList, bl);
    }

    public boolean isInterpretLabelFieldsEnabled() {
        return this.interpretLabelFields && this.bib2gls.useInterpreter();
    }

    public boolean allowsCrossResourceRefs() {
        return this.preamble == null || !this.interpretPreamble;
    }

    public boolean isLabelifyEnabled() {
        if (this.labelifyFields == null || this.labelifyFields.length == 0) {
            return true;
        }
        return this.labelifyListFields == null || this.labelifyListFields.length == 0;
    }

    public boolean isStripMissingParentsEnabled() {
        return this.stripMissingParents;
    }

    public boolean isCopyAliasToSeeEnabled() {
        return this.copyAliasToSee;
    }

    public int getMinLocationRange() {
        return this.minLocationRange;
    }

    public String getSuffixF() {
        return this.suffixF;
    }

    public String getSuffixFF() {
        return this.suffixFF;
    }

    public int getSeeLocation() {
        return this.seeLocation;
    }

    public int getSeeAlsoLocation() {
        return this.seeAlsoLocation;
    }

    public int getAliasLocation() {
        return this.aliasLocation;
    }

    public boolean showLocationPrefix() {
        return this.locationPrefix != null;
    }

    public boolean showLocationSuffix() {
        return this.locationSuffix != null;
    }

    public int getLocationGap() {
        return this.locGap;
    }
}

