/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.swing.HomeTransferableList;
import com.eteks.sweethome3d.swing.LocatedTransferHandler;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.HomeController;
import com.eteks.sweethome3d.viewcontroller.TransferableView;
import java.awt.EventQueue;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;

public class FurnitureTransferHandler
extends LocatedTransferHandler {
    private final Home home;
    private final ContentManager contentManager;
    private final HomeController homeController;
    private List<HomePieceOfFurniture> copiedFurniture;
    private Object copiedCSV;

    public FurnitureTransferHandler(Home home, ContentManager contentManager, HomeController homeController) {
        this.home = home;
        this.contentManager = contentManager;
        this.homeController = homeController;
    }

    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        this.copiedFurniture = Home.getFurnitureSubList(this.home.getSelectedItems());
        final HomeTransferableList homeTransferableList = new HomeTransferableList(this.copiedFurniture);
        if (jComponent instanceof TransferableView) {
            this.copiedCSV = null;
            this.homeController.createTransferData(new TransferableView.TransferObserver(){

                public void dataReady(Object[] objectArray) {
                    for (Object object : objectArray) {
                        if (!(object instanceof String)) continue;
                        FurnitureTransferHandler.this.copiedCSV = object;
                        break;
                    }
                }
            }, TransferableView.DataType.FURNITURE_LIST);
            return new Transferable(){

                public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                    if (DataFlavor.stringFlavor.equals(dataFlavor)) {
                        return FurnitureTransferHandler.this.copiedCSV;
                    }
                    return homeTransferableList.getTransferData(dataFlavor);
                }

                public DataFlavor[] getTransferDataFlavors() {
                    ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>(Arrays.asList(homeTransferableList.getTransferDataFlavors()));
                    arrayList.add(DataFlavor.stringFlavor);
                    return arrayList.toArray(new DataFlavor[arrayList.size()]);
                }

                public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                    return homeTransferableList.isDataFlavorSupported(dataFlavor) || DataFlavor.stringFlavor.equals(dataFlavor);
                }
            };
        }
        return homeTransferableList;
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (n == 2) {
            this.homeController.cut(this.copiedFurniture);
        }
        this.copiedFurniture = null;
        this.copiedCSV = null;
        this.homeController.enablePasteAction();
    }

    public boolean canImportFlavor(DataFlavor[] dataFlavorArray) {
        Level level = this.home.getSelectedLevel();
        List<DataFlavor> list = Arrays.asList(dataFlavorArray);
        return !(level != null && !level.isViewable() || !list.contains(HomeTransferableList.HOME_FLAVOR) && !list.contains(DataFlavor.javaFileListFlavor));
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (this.canImportFlavor(transferable.getTransferDataFlavors())) {
            try {
                List<DataFlavor> list = Arrays.asList(transferable.getTransferDataFlavors());
                if (list.contains(HomeTransferableList.HOME_FLAVOR)) {
                    List list2 = (List)transferable.getTransferData(HomeTransferableList.HOME_FLAVOR);
                    List<HomePieceOfFurniture> list3 = Home.getFurnitureSubList(list2);
                    if (this.isDrop()) {
                        this.homeController.drop(list3, 0.0f, 0.0f);
                    } else {
                        this.homeController.paste(list3);
                    }
                    return true;
                }
                List list4 = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                final List<String> list5 = this.getModelContents(list4, this.contentManager);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        FurnitureTransferHandler.this.homeController.dropFiles(list5, 0.0f, 0.0f);
                    }
                });
                return !list5.isEmpty();
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                throw new RuntimeException("Can't import", unsupportedFlavorException);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Can't access to data", iOException);
            }
        }
        return false;
    }
}

