/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.util;

import com.jogamp.nativewindow.util.PointImmutable;

public class Point
implements Cloneable,
PointImmutable {
    int x;
    int y;

    public Point(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public Point() {
        this(0, 0);
    }

    public Object cloneMutable() {
        return this.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public int compareTo(PointImmutable pointImmutable) {
        int n = this.x * this.y;
        int n2 = pointImmutable.getX() * pointImmutable.getY();
        if (n > n2) {
            return 1;
        }
        if (n < n2) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Point) {
            Point point = (Point)object;
            return this.y == point.y && this.x == point.x;
        }
        return false;
    }

    @Override
    public final int getX() {
        return this.x;
    }

    @Override
    public final int getY() {
        return this.y;
    }

    @Override
    public int hashCode() {
        int n = 31 + this.x;
        n = (n << 5) - n + this.y;
        return n;
    }

    public String toString() {
        return this.x + " / " + this.y;
    }

    public final void set(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public final void setX(int n) {
        this.x = n;
    }

    public final void setY(int n) {
        this.y = n;
    }

    public final Point translate(Point point) {
        this.x += point.x;
        this.y += point.y;
        return this;
    }

    public final Point translate(int n, int n2) {
        this.x += n;
        this.y += n2;
        return this;
    }

    public final Point scale(int n, int n2) {
        this.x *= n;
        this.y *= n2;
        return this;
    }

    public final Point scale(float f, float f2) {
        this.x = (int)((float)this.x * f + 0.5f);
        this.y = (int)((float)this.y * f2 + 0.5f);
        return this;
    }

    public final Point scaleInv(int n, int n2) {
        this.x /= n;
        this.y /= n2;
        return this;
    }

    public final Point scaleInv(float f, float f2) {
        this.x = (int)((float)this.x / f + 0.5f);
        this.y = (int)((float)this.y / f2 + 0.5f);
        return this;
    }
}

