/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.util.HashSet;
import java.util.Set;

public class HtmlParameter
implements Comparable<HtmlParameter> {
    private String name;
    private String value;
    private Type type;
    private Set<String> flags;

    public HtmlParameter(Type type, String name, String value) {
        this.name = name;
        this.value = value;
        this.type = type;
    }

    public HtmlParameter(String cookieLine) {
        String[] array = cookieLine.split(";");
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(cookieLine);
        }
        int eqOffset = array[0].indexOf("=");
        if (eqOffset <= 0) {
            throw new IllegalArgumentException(cookieLine);
        }
        this.type = Type.cookie;
        this.name = array[0].substring(0, eqOffset).trim();
        this.value = array[0].substring(eqOffset + 1).trim();
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                this.addFlag(array[i].trim());
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Set<String> getFlags() {
        if (this.flags == null) {
            this.flags = new HashSet<String>();
        }
        return this.flags;
    }

    public void addFlag(String flag) {
        this.getFlags().add(flag);
    }

    @Override
    public int compareTo(HtmlParameter o) {
        if (o == null) {
            return 1;
        }
        int result = this.type.ordinal() - o.getType().ordinal();
        if (result == 0) {
            result = this.name.compareTo(o.getName());
        }
        if (result == 0) {
            result = this.value.compareTo(o.getValue());
        }
        return result;
    }

    public String toString() {
        return "HtmlParameter type = " + (Object)((Object)this.type) + " name= " + this.name + " value=" + this.value;
    }

    public static enum Flags {
        anticsrf,
        session,
        structural;

    }

    public static enum Type {
        cookie,
        form,
        url,
        header;

    }
}

