/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.tree;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.tree.EnhancedTreeCellRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;

public class MethodNameTreeCellRenderer
extends EnhancedTreeCellRenderer {
    private Icon allThreadsIcon = Icons.getIcon((String)"ProfilerIcons.AllThreads");
    private Icon threadIcon = Icons.getIcon((String)"ProfilerIcons.Thread");

    @Override
    public Component getTreeCellRendererComponentPersistent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        MethodNameTreeCellRenderer methodNameTreeCellRenderer = new MethodNameTreeCellRenderer();
        methodNameTreeCellRenderer.setLeafIcon(this.getLeafIcon(object));
        methodNameTreeCellRenderer.setClosedIcon(this.getClosedIcon(object));
        methodNameTreeCellRenderer.setOpenIcon(this.getOpenIcon(object));
        Color color = UIUtils.getProfilerResultsBackground();
        if ((n & 1) == 0) {
            methodNameTreeCellRenderer.setBackgroundNonSelectionColor(UIUtils.getDarker(color));
        } else {
            methodNameTreeCellRenderer.setBackgroundNonSelectionColor(color);
        }
        return methodNameTreeCellRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
    }

    @Override
    protected Icon getClosedIcon(Object object) {
        if (object instanceof PrestimeCPUCCTNode) {
            PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)object;
            if (prestimeCPUCCTNode.isThreadNode()) {
                if (prestimeCPUCCTNode.getThreadId() == -1) {
                    return this.allThreadsIcon;
                }
                return this.threadIcon;
            }
            if (prestimeCPUCCTNode.isFilteredNode()) {
                return UIManager.getLookAndFeel().getDisabledIcon(this, super.getClosedIcon(object));
            }
        } else if (object instanceof PresoObjAllocCCTNode && ((PresoObjAllocCCTNode)object).isFilteredNode()) {
            return UIManager.getLookAndFeel().getDisabledIcon(this, super.getClosedIcon(object));
        }
        return super.getClosedIcon(object);
    }

    @Override
    protected String getLabel1Text(Object object, String string) {
        if (object instanceof PrestimeCPUCCTNode ? ((PrestimeCPUCCTNode)object).isThreadNode() || ((PrestimeCPUCCTNode)object).isFilteredNode() : object instanceof PresoObjAllocCCTNode && ((PresoObjAllocCCTNode)object).isFilteredNode()) {
            return "";
        }
        int n = string.indexOf(40);
        int n2 = string.lastIndexOf(46);
        if (n2 == -1 && n == -1) {
            return string;
        }
        if (n != -1) {
            string = string.substring(0, n);
            n2 = string.lastIndexOf(46);
        }
        return string.substring(0, n2 + 1);
    }

    @Override
    protected String getLabel2Text(Object object, String string) {
        if (object instanceof PrestimeCPUCCTNode) {
            if (((PrestimeCPUCCTNode)object).isThreadNode()) {
                return string;
            }
            if (((PrestimeCPUCCTNode)object).isFilteredNode()) {
                return "";
            }
        } else if (object instanceof PresoObjAllocCCTNode && ((PresoObjAllocCCTNode)object).isFilteredNode()) {
            return "";
        }
        int n = string.indexOf(40);
        int n2 = string.lastIndexOf(46);
        if (n2 == -1 && n == -1) {
            return "";
        }
        if (n != -1) {
            string = string.substring(0, n);
            n2 = string.lastIndexOf(46);
        }
        return string.substring(n2 + 1);
    }

    @Override
    protected String getLabel3Text(Object object, String string) {
        int n;
        if (object instanceof PrestimeCPUCCTNode) {
            if (((PrestimeCPUCCTNode)object).isThreadNode()) {
                return "";
            }
            if (((PrestimeCPUCCTNode)object).isFilteredNode()) {
                return string;
            }
        } else if (object instanceof PresoObjAllocCCTNode && ((PresoObjAllocCCTNode)object).isFilteredNode()) {
            return string;
        }
        if ((n = string.indexOf(40)) != -1) {
            return " " + string.substring(n);
        }
        return "";
    }

    @Override
    protected Icon getLeafIcon(Object object) {
        if (object instanceof PrestimeCPUCCTNode) {
            PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)object;
            if (prestimeCPUCCTNode.isThreadNode()) {
                if (prestimeCPUCCTNode.getThreadId() == -1) {
                    return this.allThreadsIcon;
                }
                return this.threadIcon;
            }
            if (prestimeCPUCCTNode.isFilteredNode()) {
                return UIManager.getLookAndFeel().getDisabledIcon(this, super.getLeafIcon(object));
            }
        } else if (object instanceof PresoObjAllocCCTNode && ((PresoObjAllocCCTNode)object).isFilteredNode()) {
            return UIManager.getLookAndFeel().getDisabledIcon(this, super.getLeafIcon(object));
        }
        return super.getLeafIcon(object);
    }

    @Override
    protected Icon getOpenIcon(Object object) {
        if (object instanceof PrestimeCPUCCTNode) {
            PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)object;
            if (prestimeCPUCCTNode.isThreadNode()) {
                if (prestimeCPUCCTNode.getThreadId() == -1) {
                    return this.allThreadsIcon;
                }
                return this.threadIcon;
            }
            if (prestimeCPUCCTNode.isFilteredNode()) {
                return UIManager.getLookAndFeel().getDisabledIcon(this, super.getOpenIcon(object));
            }
        } else if (object instanceof PresoObjAllocCCTNode && ((PresoObjAllocCCTNode)object).isFilteredNode()) {
            return UIManager.getLookAndFeel().getDisabledIcon(this, super.getOpenIcon(object));
        }
        return super.getOpenIcon(object);
    }
}

