/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.ValUtil;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public abstract class CrossingWays
extends Test {
    static final String HIGHWAY = "highway";
    static final String RAILWAY = "railway";
    static final String WATERWAY = "waterway";
    static final String LANDUSE = "landuse";
    private final Map<Point2D, List<WaySegment>> cellSegments = new HashMap<Point2D, List<WaySegment>>(1000);
    private final Map<List<Way>, List<WaySegment>> seenWays = new HashMap<List<Way>, List<WaySegment>>(50);
    private final int code;

    public CrossingWays(String title, int code) {
        super(title, I18n.tr("This test checks if two roads, railways, waterways or buildings crosses in the same layer, but are not connected by a node.", new Object[0]));
        this.code = code;
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.cellSegments.clear();
        this.seenWays.clear();
    }

    @Override
    public void endTest() {
        super.endTest();
        this.cellSegments.clear();
        this.seenWays.clear();
    }

    static boolean isCoastline(OsmPrimitive w) {
        return w.hasTag("natural", "water", "coastline") || w.hasTag(LANDUSE, "reservoir");
    }

    static boolean isHighway(OsmPrimitive w) {
        return w.hasTagDifferent(HIGHWAY, "rest_area", "services");
    }

    static boolean isRailway(OsmPrimitive w) {
        return w.hasKey(RAILWAY) && !CrossingWays.isSubwayOrTramOrRazed(w);
    }

    static boolean isSubwayOrTramOrRazed(OsmPrimitive w) {
        return w.hasTag(RAILWAY, "subway", "tram", "razed");
    }

    static boolean isProposedOrAbandoned(OsmPrimitive w) {
        return w.hasTag(HIGHWAY, "proposed") || w.hasTag(RAILWAY, "proposed", "abandoned");
    }

    abstract boolean ignoreWaySegmentCombination(Way var1, Way var2);

    abstract String createMessage(Way var1, Way var2);

    @Override
    public void visit(Way w) {
        if (this instanceof SelfCrossing) {
            this.cellSegments.clear();
            this.seenWays.clear();
        }
        int nodesSize = w.getNodesCount();
        for (int i = 0; i < nodesSize - 1; ++i) {
            WaySegment es1 = new WaySegment(w, i);
            EastNorth en1 = es1.getFirstNode().getEastNorth();
            EastNorth en2 = es1.getSecondNode().getEastNorth();
            if (en1 == null || en2 == null) {
                Logging.warn("Crossing ways test skipped " + es1);
                continue;
            }
            for (List<WaySegment> segments : CrossingWays.getSegments(this.cellSegments, en1, en2)) {
                for (WaySegment es2 : segments) {
                    List<WaySegment> highlight;
                    if (!es1.intersects(es2) || this.ignoreWaySegmentCombination(es1.way, es2.way)) continue;
                    ArrayList<Way> prims = new ArrayList<Way>();
                    prims.add(es1.way);
                    if (es1.way != es2.way) {
                        prims.add(es2.way);
                    }
                    if ((highlight = this.seenWays.get(prims)) == null) {
                        highlight = new ArrayList<WaySegment>();
                        highlight.add(es1);
                        highlight.add(es2);
                        String message = this.createMessage(es1.way, es2.way);
                        this.errors.add(TestError.builder(this, Severity.WARNING, this.code).message(message).primitives(prims).highlightWaySegments(highlight).build());
                        this.seenWays.put(prims, highlight);
                        continue;
                    }
                    highlight.add(es1);
                    highlight.add(es2);
                }
                segments.add(es1);
            }
        }
    }

    public static List<List<WaySegment>> getSegments(Map<Point2D, List<WaySegment>> cellSegments, EastNorth n1, EastNorth n2) {
        ArrayList<List<WaySegment>> cells = new ArrayList<List<WaySegment>>();
        for (Point2D cell : ValUtil.getSegmentCells(n1, n2, OsmValidator.getGridDetail())) {
            cells.add(cellSegments.computeIfAbsent(cell, k -> new ArrayList()));
        }
        return cells;
    }

    public static class SelfCrossing
    extends CrossingWays {
        protected static final int CROSSING_SELF = 604;
        Ways normalTest = new Ways();
        Barrier barrierTest = new Barrier();
        Boundaries boundariesTest = new Boundaries();

        public SelfCrossing() {
            super(I18n.tr("Self crossing", new Object[0]), 604);
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive p) {
            return super.isPrimitiveUsable(p) && !this.normalTest.isPrimitiveUsable(p) && !this.barrierTest.isPrimitiveUsable(p) && !this.boundariesTest.isPrimitiveUsable(p);
        }

        @Override
        boolean ignoreWaySegmentCombination(Way w1, Way w2) {
            return w1 != w2;
        }

        @Override
        String createMessage(Way w1, Way w2) {
            return I18n.tr("Self-crossing ways", new Object[0]);
        }
    }

    public static class Barrier
    extends CrossingWays {
        protected static final int CROSSING_BARRIERS = 603;

        public Barrier() {
            super(I18n.tr("Crossing barriers", new Object[0]), 603);
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive p) {
            return super.isPrimitiveUsable(p) && p.hasKey("barrier");
        }

        @Override
        boolean ignoreWaySegmentCombination(Way w1, Way w2) {
            return !Objects.equals(OsmUtils.getLayer(w1), OsmUtils.getLayer(w2));
        }

        @Override
        String createMessage(Way w1, Way w2) {
            return I18n.tr("Crossing barriers", new Object[0]);
        }
    }

    public static class Boundaries
    extends CrossingWays {
        protected static final int CROSSING_BOUNDARIES = 602;

        public Boundaries() {
            super(I18n.tr("Crossing boundaries", new Object[0]), 602);
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive p) {
            return super.isPrimitiveUsable(p) && p.hasKey("boundary") && (!(p instanceof Relation) || ((Relation)p).isMultipolygon() && !((Relation)p).hasIncompleteMembers());
        }

        @Override
        boolean ignoreWaySegmentCombination(Way w1, Way w2) {
            return !Objects.equals(w1.get("boundary"), w2.get("boundary"));
        }

        @Override
        String createMessage(Way w1, Way w2) {
            return I18n.tr("Crossing boundaries", new Object[0]);
        }

        @Override
        public void visit(Relation r) {
            for (Way w : r.getMemberPrimitives(Way.class)) {
                this.visit(w);
            }
        }
    }

    public static class Ways
    extends CrossingWays {
        protected static final int CROSSING_WAYS = 601;

        public Ways() {
            super(I18n.tr("Crossing ways", new Object[0]), 601);
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive w) {
            return super.isPrimitiveUsable(w) && !Ways.isProposedOrAbandoned(w) && (Ways.isHighway(w) || w.hasKey(CrossingWays.WATERWAY) || Ways.isRailway(w) || Ways.isCoastline(w) || Ways.isBuilding(w) || Ways.isResidentialArea(w));
        }

        @Override
        boolean ignoreWaySegmentCombination(Way w1, Way w2) {
            if (w1 == w2) {
                return false;
            }
            if (!Objects.equals(OsmUtils.getLayer(w1), OsmUtils.getLayer(w2))) {
                return true;
            }
            if (w1.hasKey(CrossingWays.HIGHWAY) && w2.hasKey(CrossingWays.HIGHWAY) && !Objects.equals(w1.get("level"), w2.get("level"))) {
                return true;
            }
            if (w1.hasKey(CrossingWays.HIGHWAY) && Ways.isResidentialArea(w2) || w2.hasKey(CrossingWays.HIGHWAY) && Ways.isResidentialArea(w1)) {
                return true;
            }
            if (Ways.isSubwayOrTramOrRazed(w2)) {
                return true;
            }
            if (Ways.isCoastline(w1) != Ways.isCoastline(w2)) {
                return true;
            }
            if (w1.hasTag(CrossingWays.WATERWAY, "river", "stream", "canal", "drain", "ditch") && w2.hasTag(CrossingWays.WATERWAY, "riverbank") || w2.hasTag(CrossingWays.WATERWAY, "river", "stream", "canal", "drain", "ditch") && w1.hasTag(CrossingWays.WATERWAY, "riverbank")) {
                return true;
            }
            return Ways.isProposedOrAbandoned(w2);
        }

        @Override
        String createMessage(Way w1, Way w2) {
            WayType[] types = new WayType[]{WayType.of(w1), WayType.of(w2)};
            Arrays.sort((Object[])types);
            if (types[0] == types[1]) {
                switch (types[0]) {
                    case BUILDING: {
                        return I18n.tr("Crossing buildings", new Object[0]);
                    }
                    case HIGHWAY: {
                        return I18n.tr("Crossing highways", new Object[0]);
                    }
                    case RESIDENTIAL_AREA: {
                        return I18n.tr("Crossing residential areas", new Object[0]);
                    }
                    case WATERWAY: {
                        return I18n.tr("Crossing waterways", new Object[0]);
                    }
                }
                return I18n.tr("Crossing ways", new Object[0]);
            }
            switch (types[0]) {
                case BUILDING: {
                    switch (types[1]) {
                        case HIGHWAY: {
                            return I18n.tr("Crossing building/highway", new Object[0]);
                        }
                        case RESIDENTIAL_AREA: {
                            return I18n.tr("Crossing building/residential area", new Object[0]);
                        }
                        case WATERWAY: {
                            return I18n.tr("Crossing building/waterway", new Object[0]);
                        }
                    }
                    return I18n.tr("Crossing building/way", new Object[0]);
                }
                case HIGHWAY: {
                    switch (types[1]) {
                        case RESIDENTIAL_AREA: {
                            return I18n.tr("Crossing highway/residential area", new Object[0]);
                        }
                        case WATERWAY: {
                            return I18n.tr("Crossing highway/waterway", new Object[0]);
                        }
                    }
                    return I18n.tr("Crossing highway/way", new Object[0]);
                }
                case RESIDENTIAL_AREA: {
                    switch (types[1]) {
                        case WATERWAY: {
                            return I18n.tr("Crossing residential area/waterway", new Object[0]);
                        }
                    }
                    return I18n.tr("Crossing residential area/way", new Object[0]);
                }
            }
            return I18n.tr("Crossing waterway/way", new Object[0]);
        }
    }

    private static enum WayType {
        BUILDING,
        HIGHWAY,
        RESIDENTIAL_AREA,
        WATERWAY,
        WAY;


        static WayType of(Way w) {
            if (CrossingWays.isBuilding(w)) {
                return BUILDING;
            }
            if (w.hasKey(CrossingWays.HIGHWAY)) {
                return HIGHWAY;
            }
            if (CrossingWays.isResidentialArea(w)) {
                return RESIDENTIAL_AREA;
            }
            if (w.hasKey(CrossingWays.WATERWAY)) {
                return WATERWAY;
            }
            return WAY;
        }
    }
}

