/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeBlacklist;

public class IvyNodeUsage {
    private IvyNode node;
    private Map rootModuleConfs = new HashMap();
    private Map requiredConfs = new HashMap();
    private Map dependers = new HashMap();
    private Map blacklisted = new HashMap();

    public IvyNodeUsage(IvyNode ivyNode) {
        this.node = ivyNode;
    }

    protected Collection getRequiredConfigurations(IvyNode ivyNode, String string) {
        return (Collection)this.requiredConfs.get(new NodeConf(ivyNode, string));
    }

    protected void setRequiredConfs(IvyNode ivyNode, String string, Collection collection) {
        this.requiredConfs.put(new NodeConf(ivyNode, string), new HashSet(collection));
    }

    protected Set getConfigurations(String string) {
        return (Set)this.rootModuleConfs.get(string);
    }

    protected Set addAndGetConfigurations(String string) {
        HashSet hashSet = (HashSet)this.rootModuleConfs.get(string);
        if (hashSet == null) {
            hashSet = new HashSet();
            this.rootModuleConfs.put(string, hashSet);
        }
        return hashSet;
    }

    protected Set getRootModuleConfigurations() {
        return this.rootModuleConfs.keySet();
    }

    public void updateDataFrom(Collection collection, String string) {
        for (IvyNodeUsage ivyNodeUsage : collection) {
            this.updateDataFrom(ivyNodeUsage, string);
        }
    }

    private void updateDataFrom(IvyNodeUsage ivyNodeUsage, String string) {
        this.updateMapOfSet(ivyNodeUsage.requiredConfs, this.requiredConfs);
        this.updateMapOfSetForKey(ivyNodeUsage.rootModuleConfs, this.rootModuleConfs, string);
        this.updateMapOfSetForKey(ivyNodeUsage.dependers, this.dependers, string);
    }

    private void updateMapOfSet(Map map, Map map2) {
        for (Object k : map.keySet()) {
            this.updateMapOfSetForKey(map, map2, k);
        }
    }

    private void updateMapOfSetForKey(Map map, Map map2, Object object) {
        Set set = (Set)map.get(object);
        if (set != null) {
            Set set2 = (Set)map2.get(object);
            if (set2 != null) {
                set2.addAll(set);
            } else {
                map2.put(object, new HashSet(set));
            }
        }
    }

    private void addObjectsForConf(String string, Object object, Map map) {
        HashSet<Object> hashSet = (HashSet<Object>)map.get(string);
        if (hashSet == null) {
            hashSet = new HashSet<Object>();
            map.put(string, hashSet);
        }
        hashSet.add(object);
    }

    public void addUsage(String string, DependencyDescriptor dependencyDescriptor, String string2) {
        this.addObjectsForConf(string, new Depender(dependencyDescriptor, string2), this.dependers);
    }

    protected Set getDependencyArtifactsSet(String string) {
        Collection collection = (Collection)this.dependers.get(string);
        if (collection == null) {
            return null;
        }
        HashSet<DependencyArtifactDescriptor> hashSet = new HashSet<DependencyArtifactDescriptor>();
        for (Depender depender : collection) {
            DependencyArtifactDescriptor[] dependencyArtifactDescriptorArray = depender.dd.getDependencyArtifacts(depender.dependerConf);
            hashSet.addAll(Arrays.asList(dependencyArtifactDescriptorArray));
        }
        return hashSet;
    }

    protected Set getDependencyIncludesSet(String string) {
        Collection collection = (Collection)this.dependers.get(string);
        if (collection == null) {
            return null;
        }
        HashSet<IncludeRule> hashSet = new HashSet<IncludeRule>();
        for (Depender depender : collection) {
            IncludeRule[] includeRuleArray = depender.dd.getIncludeRules(depender.dependerConf);
            if (includeRuleArray == null || includeRuleArray.length == 0) {
                return null;
            }
            hashSet.addAll(Arrays.asList(includeRuleArray));
        }
        return hashSet;
    }

    protected void removeRootModuleConf(String string) {
        this.rootModuleConfs.remove(string);
    }

    protected void blacklist(IvyNodeBlacklist ivyNodeBlacklist) {
        this.blacklisted.put(ivyNodeBlacklist.getRootModuleConf(), ivyNodeBlacklist);
    }

    protected boolean isBlacklisted(String string) {
        return this.blacklisted.containsKey(string);
    }

    protected IvyNodeBlacklist getBlacklistData(String string) {
        return (IvyNodeBlacklist)this.blacklisted.get(string);
    }

    protected IvyNode getNode() {
        return this.node;
    }

    public boolean hasTransitiveDepender(String string) {
        Set set = (Set)this.dependers.get(string);
        if (set == null) {
            return false;
        }
        for (Depender depender : set) {
            if (!depender.dd.isTransitive()) continue;
            return true;
        }
        return false;
    }

    private static final class Depender {
        private DependencyDescriptor dd;
        private String dependerConf;

        public Depender(DependencyDescriptor dependencyDescriptor, String string) {
            this.dd = dependencyDescriptor;
            this.dependerConf = string;
        }

        public String toString() {
            return this.dd + " [" + this.dependerConf + "]";
        }

        public boolean equals(Object object) {
            if (!(object instanceof Depender)) {
                return false;
            }
            Depender depender = (Depender)object;
            return depender.dd == this.dd && depender.dependerConf.equals(this.dependerConf);
        }

        public int hashCode() {
            int n = 33;
            n += this.dd.hashCode() * 13;
            return n += this.dependerConf.hashCode() * 13;
        }
    }

    private static final class NodeConf {
        private IvyNode node;
        private String conf;

        public NodeConf(IvyNode ivyNode, String string) {
            if (ivyNode == null) {
                throw new NullPointerException("node must not null");
            }
            if (string == null) {
                throw new NullPointerException("conf must not null");
            }
            this.node = ivyNode;
            this.conf = string;
        }

        public final String getConf() {
            return this.conf;
        }

        public final IvyNode getNode() {
            return this.node;
        }

        public boolean equals(Object object) {
            if (!(object instanceof NodeConf)) {
                return false;
            }
            return this.getNode().equals(((NodeConf)object).getNode()) && this.getConf().equals(((NodeConf)object).getConf());
        }

        public int hashCode() {
            int n = 33;
            n += this.getNode().hashCode() * 17;
            return n += this.getConf().hashCode() * 17;
        }

        public String toString() {
            return "NodeConf(" + this.conf + ")";
        }
    }
}

