/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.jar;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.ivy.plugins.repository.AbstractRepository;
import org.apache.ivy.plugins.repository.RepositoryCopyProgressListener;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.jar.JarResource;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.FileUtil;

public class JarRepository
extends AbstractRepository {
    private RepositoryCopyProgressListener progress = new RepositoryCopyProgressListener(this);
    private JarFile jarFile;

    public void setJarFile(JarFile jarFile) {
        this.jarFile = jarFile;
    }

    @Override
    public Resource getResource(String string) throws IOException {
        return new JarResource(this.jarFile, string);
    }

    protected RepositoryCopyProgressListener getProgressListener() {
        return this.progress;
    }

    @Override
    public void get(String string, File file) throws IOException {
        this.fireTransferInitiated(this.getResource(string), 5);
        try {
            ZipEntry zipEntry = this.jarFile.getEntry(string);
            if (zipEntry == null) {
                throw new FileNotFoundException();
            }
            this.getProgressListener().setTotalLength(new Long(zipEntry.getSize()));
            FileUtil.copy(this.jarFile.getInputStream(zipEntry), file, (CopyProgressListener)this.getProgressListener());
        }
        catch (IOException iOException) {
            this.fireTransferError(iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.fireTransferError(runtimeException);
            throw runtimeException;
        }
        finally {
            this.getProgressListener().setTotalLength(null);
        }
    }

    @Override
    public List list(String string) throws IOException {
        ZipEntry zipEntry = this.jarFile.getEntry(string);
        if (zipEntry == null || !zipEntry.isDirectory()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<JarEntry> enumeration = this.jarFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry2 = enumeration.nextElement();
            if (!zipEntry2.getName().startsWith(string) || !zipEntry2.getName().equals(zipEntry.getName())) continue;
            arrayList.add(zipEntry2.getName());
        }
        return arrayList;
    }
}

