/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface Policy<K, V> {
    public boolean isRecordingStats();

    @Nonnull
    public Optional<Eviction<K, V>> eviction();

    @Nonnull
    public Optional<Expiration<K, V>> expireAfterAccess();

    @Nonnull
    public Optional<Expiration<K, V>> expireAfterWrite();

    @Nonnull
    default public Optional<VarExpiration<K, V>> expireVariably() {
        return Optional.empty();
    }

    @Nonnull
    public Optional<Expiration<K, V>> refreshAfterWrite();

    public static interface VarExpiration<K, V> {
        @Nonnull
        public OptionalLong getExpiresAfter(@Nonnull K var1, @Nonnull TimeUnit var2);

        public void setExpiresAfter(@Nonnull K var1, @Nonnegative long var2, @Nonnull TimeUnit var4);

        @Nonnull
        public Map<K, V> oldest(@Nonnegative int var1);

        @Nonnull
        public Map<K, V> youngest(@Nonnegative int var1);
    }

    public static interface Expiration<K, V> {
        @Nonnull
        public OptionalLong ageOf(@Nonnull K var1, @Nonnull TimeUnit var2);

        @Nonnegative
        public long getExpiresAfter(@Nonnull TimeUnit var1);

        public void setExpiresAfter(@Nonnegative long var1, @Nonnull TimeUnit var3);

        @Nonnull
        public Map<K, V> oldest(@Nonnegative int var1);

        @Nonnull
        public Map<K, V> youngest(@Nonnegative int var1);
    }

    public static interface Eviction<K, V> {
        public boolean isWeighted();

        @Nonnull
        default public OptionalInt weightOf(@Nonnull K key) {
            return OptionalInt.empty();
        }

        @Nonnull
        public OptionalLong weightedSize();

        @Nonnegative
        public long getMaximum();

        public void setMaximum(@Nonnegative long var1);

        @Nonnull
        public Map<K, V> coldest(@Nonnegative int var1);

        @Nonnull
        public Map<K, V> hottest(@Nonnegative int var1);
    }
}

