/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.ui.components.JRangeSlider;
import org.gephi.utils.NumberUtils;
import org.openide.util.NbBundle;

public class JRangeSliderPanel
extends JPanel {
    public static final String LOWER_BOUND = "lowerbound";
    public static final String UPPER_BOUND = "upperbound";
    private static final int SLIDER_MAXIMUM = 1000;
    private String lowerBound = "N/A";
    private String upperBound = "N/A";
    private Range range;
    private JTextField lowerBoundTextField;
    private JSlider rangeSlider;
    private JTextField upperBoundTextField;

    public JRangeSliderPanel() {
        this.initComponents();
        ((JRangeSlider)this.rangeSlider).setUpperValue(1000);
        this.rangeSlider.setOpaque(false);
        this.lowerBoundTextField.setOpaque(false);
        this.lowerBoundTextField.setCursor(Cursor.getPredefinedCursor(12));
        this.upperBoundTextField.setOpaque(false);
        this.upperBoundTextField.setCursor(Cursor.getPredefinedCursor(12));
        this.lowerBoundTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JRangeSliderPanel.this.lowerBoundTextField.selectAll();
            }
        });
        this.lowerBoundTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!JRangeSliderPanel.this.lowerBoundTextField.getText().equals(JRangeSliderPanel.this.lowerBound)) {
                    JRangeSliderPanel.this.lowerBound = JRangeSliderPanel.this.lowerBoundTextField.getText();
                    if (JRangeSliderPanel.this.range != null) {
                        JRangeSliderPanel.this.range.setLowerBound(JRangeSliderPanel.this.lowerBound);
                        JRangeSliderPanel.this.firePropertyChange(JRangeSliderPanel.LOWER_BOUND, null, JRangeSliderPanel.this.lowerBound);
                    }
                } else {
                    JRangeSliderPanel.this.lowerBound = JRangeSliderPanel.this.lowerBoundTextField.getText();
                }
                JRangeSliderPanel.this.refreshBoundTexts();
                JRangeSliderPanel.this.requestFocusInWindow();
            }
        });
        this.upperBoundTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JRangeSliderPanel.this.upperBoundTextField.selectAll();
            }
        });
        this.upperBoundTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!JRangeSliderPanel.this.upperBoundTextField.getText().equals(JRangeSliderPanel.this.upperBound)) {
                    JRangeSliderPanel.this.upperBound = JRangeSliderPanel.this.upperBoundTextField.getText();
                    if (JRangeSliderPanel.this.range != null) {
                        JRangeSliderPanel.this.range.setUpperBound(JRangeSliderPanel.this.upperBound);
                        JRangeSliderPanel.this.firePropertyChange(JRangeSliderPanel.UPPER_BOUND, null, JRangeSliderPanel.this.upperBound);
                    }
                } else {
                    JRangeSliderPanel.this.upperBound = JRangeSliderPanel.this.upperBoundTextField.getText();
                }
                JRangeSliderPanel.this.refreshBoundTexts();
                JRangeSliderPanel.this.requestFocusInWindow();
            }
        });
        this.rangeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JRangeSlider source = (JRangeSlider)e.getSource();
                if (!source.getValueIsAdjusting() && JRangeSliderPanel.this.range != null) {
                    JRangeSliderPanel.this.range.refreshBounds();
                    JRangeSliderPanel.this.refreshBoundTexts();
                }
            }
        });
    }

    private void refreshBoundTexts() {
        if (this.range != null) {
            this.lowerBound = this.range.lowerBound.toString();
            this.upperBound = this.range.upperBound.toString();
            this.lowerBoundTextField.setText(this.lowerBound);
            this.upperBoundTextField.setText(this.upperBound);
        }
    }

    public JRangeSlider getSlider() {
        return (JRangeSlider)this.rangeSlider;
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        if (!range.min.equals(range.max)) {
            this.range = range;
            this.rangeSlider.setEnabled(true);
            range.refreshSlider();
            this.refreshBoundTexts();
        } else {
            this.lowerBound = range.lowerBound.toString();
            this.upperBound = range.upperBound.toString();
            this.lowerBoundTextField.setText(this.lowerBound);
            this.upperBoundTextField.setText(this.upperBound);
            this.rangeSlider.setEnabled(false);
        }
    }

    private void initComponents() {
        this.rangeSlider = new JRangeSlider();
        this.lowerBoundTextField = new JTextField();
        this.upperBoundTextField = new JTextField();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.rangeSlider.setMaximum(1000);
        this.rangeSlider.setValue(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.rangeSlider, gridBagConstraints);
        this.lowerBoundTextField.setText(NbBundle.getMessage(JRangeSliderPanel.class, (String)"JRangeSliderPanel.lowerBoundTextField.text"));
        this.lowerBoundTextField.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.lowerBoundTextField, gridBagConstraints);
        this.upperBoundTextField.setHorizontalAlignment(4);
        this.upperBoundTextField.setText(NbBundle.getMessage(JRangeSliderPanel.class, (String)"JRangeSliderPanel.upperBoundTextField.text"));
        this.upperBoundTextField.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.upperBoundTextField, gridBagConstraints);
    }

    public static class Range<T extends Number> {
        private final JRangeSliderPanel slider;
        private final Class<T> type;
        private T min;
        private T max;
        private T lowerBound;
        private T upperBound;
        private int sliderLowValue = -1;
        private int sliderUpValue = -1;

        public Range(JRangeSliderPanel slider, T min, T max, T lowerBound, T upperBound, Class<T> type) {
            this.slider = slider;
            this.min = min;
            this.max = max;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.type = type;
        }

        public Range(JRangeSliderPanel slider, T min, T max, Class<T> type) {
            this(slider, min, max, min, max, type);
        }

        public T getLowerBound() {
            return this.lowerBound;
        }

        public T getUpperBound() {
            return this.upperBound;
        }

        private void setLowerBound(String bound) {
            try {
                Number v = NumberUtils.parseNumber((String)bound, this.type);
                this.lowerBound = ((Comparable)((Object)v)).compareTo(this.min) < 0 ? this.min : (((Comparable)((Object)v)).compareTo(this.upperBound) > 0 ? this.upperBound : v);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.refreshSlider();
        }

        private void setUpperBound(String bound) {
            try {
                Number v = NumberUtils.parseNumber((String)bound, this.type);
                this.upperBound = ((Comparable)((Object)v)).compareTo(this.max) > 0 ? this.max : (((Comparable)((Object)v)).compareTo(this.lowerBound) < 0 ? this.lowerBound : v);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.refreshSlider();
        }

        private void refreshSlider() {
            BigDecimal lowerBoundBigDecimal = new BigDecimal(this.lowerBound.toString());
            BigDecimal upperBoundBigDecimal = new BigDecimal(this.upperBound.toString());
            BigDecimal minBigDecimal = new BigDecimal(this.min.toString());
            BigDecimal maxBigDecimal = new BigDecimal(this.max.toString());
            double normalizedLow = lowerBoundBigDecimal.subtract(minBigDecimal).divide(maxBigDecimal.subtract(minBigDecimal), RoundingMode.HALF_UP).doubleValue();
            double normalizedUp = upperBoundBigDecimal.subtract(minBigDecimal).divide(maxBigDecimal.subtract(minBigDecimal), RoundingMode.HALF_UP).doubleValue();
            this.sliderLowValue = (int)(normalizedLow * 1000.0);
            this.sliderUpValue = (int)(normalizedUp * 1000.0);
            this.slider.getSlider().setValues(this.sliderLowValue, this.sliderUpValue);
        }

        private void refreshBounds() {
            boolean lowerChanged = this.slider.getSlider().getValue() != this.sliderLowValue;
            boolean upperChanged = this.slider.getSlider().getUpperValue() != this.sliderUpValue;
            this.sliderLowValue = this.slider.getSlider().getValue();
            this.sliderUpValue = this.slider.getSlider().getUpperValue();
            double normalizedLow = (double)this.slider.getSlider().getValue() / 1000.0;
            double normalizedUp = (double)this.slider.getSlider().getUpperValue() / 1000.0;
            if (lowerChanged || upperChanged) {
                BigDecimal minBigDecimal = new BigDecimal(this.min.toString());
                BigDecimal maxBigDecimal = new BigDecimal(this.max.toString());
                if (lowerChanged) {
                    BigDecimal newLowerBound = BigDecimal.valueOf(normalizedLow).multiply(maxBigDecimal.subtract(minBigDecimal)).add(minBigDecimal);
                    this.lowerBound = this.type.equals(Double.class) || this.type.equals(Float.class) || this.type.equals(BigDecimal.class) ? (Number)NumberUtils.parseNumber((String)newLowerBound.toString(), this.type) : (Number)NumberUtils.parseNumber((String)newLowerBound.setScale(0, RoundingMode.HALF_UP).toBigInteger().toString(), this.type);
                    this.slider.firePropertyChange(JRangeSliderPanel.LOWER_BOUND, null, this.lowerBound);
                }
                if (upperChanged) {
                    BigDecimal newUpperBound = BigDecimal.valueOf(normalizedUp).multiply(maxBigDecimal.subtract(minBigDecimal)).add(minBigDecimal);
                    this.upperBound = this.type.equals(Double.class) || this.type.equals(Float.class) || this.type.equals(BigDecimal.class) ? (Number)NumberUtils.parseNumber((String)newUpperBound.toString(), this.type) : (Number)NumberUtils.parseNumber((String)newUpperBound.setScale(0, RoundingMode.HALF_UP).toBigInteger().toString(), this.type);
                    this.slider.firePropertyChange(JRangeSliderPanel.UPPER_BOUND, null, this.upperBound);
                }
            }
        }

        public static Range build(JRangeSliderPanel slider, Number min, Number max) {
            return Range.build(slider, min, max, min, max);
        }

        public static Range build(JRangeSliderPanel slider, Number min, Number max, Number lowerBound, Number upperBound) {
            if (min instanceof Double) {
                return new Range<Double>(slider, (Double)min, (Double)max, (Double)lowerBound, (Double)upperBound, Double.class);
            }
            if (min instanceof Float) {
                return new Range<Float>(slider, (Float)min, (Float)max, (Float)lowerBound, (Float)upperBound, Float.class);
            }
            if (min instanceof Long) {
                return new Range<Long>(slider, (Long)min, (Long)max, (Long)lowerBound, (Long)upperBound, Long.class);
            }
            if (min instanceof Integer) {
                return new Range<Integer>(slider, (Integer)min, (Integer)max, (Integer)lowerBound, (Integer)upperBound, Integer.class);
            }
            if (min instanceof Short) {
                return new Range<Short>(slider, (Short)min, (Short)max, (Short)lowerBound, (Short)upperBound, Short.class);
            }
            if (min instanceof Byte) {
                return new Range<Byte>(slider, (Byte)min, (Byte)max, (Byte)lowerBound, (Byte)upperBound, Byte.class);
            }
            if (min instanceof BigDecimal) {
                return new Range<BigDecimal>(slider, (BigDecimal)min, (BigDecimal)max, (BigDecimal)lowerBound, (BigDecimal)upperBound, BigDecimal.class);
            }
            if (min instanceof BigInteger) {
                return new Range<BigInteger>(slider, (BigInteger)min, (BigInteger)max, (BigInteger)lowerBound, (BigInteger)upperBound, BigInteger.class);
            }
            throw new UnsupportedOperationException("Unsupported number type " + min.getClass().getName());
        }
    }
}

