/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.AbstractMapRenderer;
import org.openstreetmap.josm.data.osm.visitor.paint.ArrowPaintHelper;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.draw.MapPath2D;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Utils;

public class WireframeMapRenderer
extends AbstractMapRenderer
implements OsmPrimitiveVisitor {
    protected Color dfltWayColor;
    protected Color relationColor;
    protected Color untaggedWayColor;
    protected Color taggedColor;
    protected Color connectionColor;
    protected Color taggedConnectionColor;
    protected boolean showDirectionArrow;
    protected boolean showOnewayArrow;
    protected boolean showHeadArrowOnly;
    protected boolean showOrderNumber;
    protected boolean showOrderNumberOnSelectedWay;
    protected boolean fillSelectedNode;
    protected boolean fillUnselectedNode;
    protected boolean fillTaggedNode;
    protected boolean fillConnectionNode;
    protected int selectedNodeSize;
    protected int unselectedNodeSize;
    protected int connectionNodeSize;
    protected int taggedNodeSize;
    protected Color currentColor;
    protected MapPath2D currentPath = new MapPath2D();
    private DataSet ds;
    private static final ArrowPaintHelper ARROW_PAINT_HELPER = new ArrowPaintHelper(Utils.toRadians(20.0), 10.0);
    private final Stroke relatedWayStroke = new BasicStroke(4.0f, 2, 2);
    private MapViewState.MapViewRectangle viewClip;

    public WireframeMapRenderer(Graphics2D g, NavigatableComponent nc, boolean isInactiveMode) {
        super(g, nc, isInactiveMode);
    }

    @Override
    public void getColors() {
        super.getColors();
        this.dfltWayColor = PaintColors.DEFAULT_WAY.get();
        this.relationColor = PaintColors.RELATION.get();
        this.untaggedWayColor = PaintColors.UNTAGGED_WAY.get();
        this.highlightColor = PaintColors.HIGHLIGHT_WIREFRAME.get();
        this.taggedColor = PaintColors.TAGGED.get();
        this.connectionColor = PaintColors.CONNECTION.get();
        this.taggedConnectionColor = !this.taggedColor.equals(this.nodeColor) ? this.taggedColor : this.connectionColor;
    }

    @Override
    protected void getSettings(boolean virtual) {
        super.getSettings(virtual);
        MapPaintSettings settings = MapPaintSettings.INSTANCE;
        this.showDirectionArrow = settings.isShowDirectionArrow();
        this.showOnewayArrow = settings.isShowOnewayArrow();
        this.showHeadArrowOnly = settings.isShowHeadArrowOnly();
        this.showOrderNumber = settings.isShowOrderNumber();
        this.showOrderNumberOnSelectedWay = settings.isShowOrderNumberOnSelectedWay();
        this.selectedNodeSize = settings.getSelectedNodeSize();
        this.unselectedNodeSize = settings.getUnselectedNodeSize();
        this.connectionNodeSize = settings.getConnectionNodeSize();
        this.taggedNodeSize = settings.getTaggedNodeSize();
        this.fillSelectedNode = settings.isFillSelectedNode();
        this.fillUnselectedNode = settings.isFillUnselectedNode();
        this.fillConnectionNode = settings.isFillConnectionNode();
        this.fillTaggedNode = settings.isFillTaggedNode();
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, Config.getPref().getBoolean("mappaint.wireframe.use-antialiasing", false) ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    @Override
    public void render(DataSet data, boolean virtual, Bounds bounds) {
        BBox bbox = bounds.toBBox();
        this.ds = data;
        Rectangle clip = this.g.getClipBounds();
        clip.grow(50, 50);
        this.viewClip = this.mapState.getViewArea(clip);
        this.getSettings(virtual);
        for (Relation rel : data.searchRelations(bbox)) {
            if (!rel.isDrawable() || this.ds.isSelected(rel) || rel.isDisabledAndHidden()) continue;
            rel.accept(this);
        }
        ArrayList<Way> highlightedWays = new ArrayList<Way>();
        ArrayList<Way> untaggedWays = new ArrayList<Way>();
        for (Way way : data.searchWays(bbox)) {
            if (!way.isDrawable() || this.ds.isSelected(way) || way.isDisabledAndHidden()) continue;
            if (way.isHighlighted()) {
                highlightedWays.add(way);
                continue;
            }
            if (!way.isTagged()) {
                untaggedWays.add(way);
                continue;
            }
            way.accept(this);
        }
        this.displaySegments();
        ArrayList<Way> specialWays = new ArrayList<Way>(untaggedWays);
        specialWays.addAll(highlightedWays);
        for (Way way : specialWays) {
            way.accept(this);
        }
        specialWays.clear();
        this.displaySegments();
        for (OsmPrimitive osmPrimitive : data.getSelected()) {
            if (!osmPrimitive.isDrawable()) continue;
            osmPrimitive.accept(this);
        }
        this.displaySegments();
        for (OsmPrimitive osmPrimitive : data.searchNodes(bbox)) {
            if (!osmPrimitive.isDrawable() || this.ds.isSelected(osmPrimitive) || osmPrimitive.isDisabledAndHidden()) continue;
            osmPrimitive.accept(this);
        }
        this.drawVirtualNodes(data, bbox);
        for (WaySegment waySegment : data.getHighlightedWaySegments()) {
            this.drawSegment(this.mapState.getPointFor(waySegment.getFirstNode()), this.mapState.getPointFor(waySegment.getSecondNode()), this.highlightColor, false);
        }
        this.displaySegments();
    }

    private static int max(int a, int b, int c, int d) {
        return Math.max(Math.max(a, b), Math.max(c, d));
    }

    @Override
    public void visit(Node n) {
        if (n.isIncomplete()) {
            return;
        }
        if (n.isHighlighted()) {
            this.drawNode(n, this.highlightColor, this.selectedNodeSize, this.fillSelectedNode);
        } else {
            Color color = this.isInactiveMode || n.isDisabled() ? this.inactiveColor : (n.isSelected() ? this.selectedColor : (n.isMemberOfSelected() ? this.relationSelectedColor : (n.isConnectionNode() ? (WireframeMapRenderer.isNodeTagged(n) ? this.taggedConnectionColor : this.connectionColor) : (WireframeMapRenderer.isNodeTagged(n) ? this.taggedColor : this.nodeColor))));
            int size = WireframeMapRenderer.max(this.ds.isSelected(n) ? this.selectedNodeSize : 0, WireframeMapRenderer.isNodeTagged(n) ? this.taggedNodeSize : 0, n.isConnectionNode() ? this.connectionNodeSize : 0, this.unselectedNodeSize);
            boolean fill = this.ds.isSelected(n) && this.fillSelectedNode || WireframeMapRenderer.isNodeTagged(n) && this.fillTaggedNode || n.isConnectionNode() && this.fillConnectionNode || this.fillUnselectedNode;
            this.drawNode(n, color, size, fill);
        }
    }

    private static boolean isNodeTagged(Node n) {
        return n.isTagged() || n.isAnnotated();
    }

    @Override
    public void visit(Way w) {
        boolean showOnlyHeadArrowOnly;
        if (w.isIncomplete() || w.getNodesCount() < 2) {
            return;
        }
        boolean showThisDirectionArrow = this.ds.isSelected(w) || this.showDirectionArrow;
        boolean bl = showOnlyHeadArrowOnly = showThisDirectionArrow && this.showHeadArrowOnly && !this.ds.isSelected(w);
        Color wayColor = this.isInactiveMode || w.isDisabled() ? this.inactiveColor : (w.isHighlighted() ? this.highlightColor : (w.isSelected() ? this.selectedColor : (w.isMemberOfSelected() ? this.relationSelectedColor : (!w.isTagged() ? this.untaggedWayColor : this.dfltWayColor))));
        Iterator<Node> it = w.getNodes().iterator();
        if (it.hasNext()) {
            MapViewState.MapViewPoint lastP = this.mapState.getPointFor(it.next());
            int lastPOutside = lastP.getOutsideRectangleFlags(this.viewClip);
            int orderNumber = 1;
            while (it.hasNext()) {
                MapViewState.MapViewPoint p = this.mapState.getPointFor(it.next());
                int pOutside = p.getOutsideRectangleFlags(this.viewClip);
                if ((pOutside & lastPOutside) == 0) {
                    this.drawSegment(lastP, p, wayColor, showOnlyHeadArrowOnly ? !it.hasNext() : showThisDirectionArrow);
                    if ((this.showOrderNumber || this.showOrderNumberOnSelectedWay && w.isSelected()) && !this.isInactiveMode) {
                        this.drawOrderNumber(lastP, p, orderNumber, this.g.getColor());
                    }
                }
                lastP = p;
                lastPOutside = pOutside;
                ++orderNumber;
            }
        }
    }

    @Override
    public void visit(Relation r) {
        if (r.isIncomplete()) {
            return;
        }
        Color col = this.isInactiveMode || r.isDisabled() ? this.inactiveColor : (r.isSelected() ? this.selectedColor : (r.isMultipolygon() && r.isMemberOfSelected() ? this.relationSelectedColor : this.relationColor));
        this.g.setColor(col);
        for (RelationMember m : r.getMembers()) {
            if (m.getMember().isIncomplete() || !m.getMember().isDrawable()) continue;
            if (m.isNode()) {
                MapViewState.MapViewPoint p = this.mapState.getPointFor(m.getNode());
                if (!p.isInView()) continue;
                this.g.draw(new Ellipse2D.Double(p.getInViewX() - 4.0, p.getInViewY() - 4.0, 9.0, 9.0));
                continue;
            }
            if (!m.isWay()) continue;
            GeneralPath path = new GeneralPath();
            boolean first = true;
            for (Node n : m.getWay().getNodes()) {
                if (!n.isDrawable()) continue;
                MapViewState.MapViewPoint p = this.mapState.getPointFor(n);
                if (first) {
                    path.moveTo(p.getInViewX(), p.getInViewY());
                    first = false;
                    continue;
                }
                path.lineTo(p.getInViewX(), p.getInViewY());
            }
            this.g.draw(this.relatedWayStroke.createStrokedShape(path));
        }
    }

    @Override
    public void drawNode(INode n, Color color, int size, boolean fill) {
        if (size > 1) {
            MapViewState.MapViewPoint p = this.mapState.getPointFor(n);
            if (!p.isInView()) {
                return;
            }
            int radius = size / 2;
            Rectangle2D.Double shape = new Rectangle2D.Double(p.getInViewX() - (double)radius, p.getInViewY() - (double)radius, size, size);
            this.g.setColor(color);
            if (fill) {
                this.g.fill(shape);
            }
            this.g.draw(shape);
        }
    }

    protected void drawSegment(MapPath2D path, MapViewState.MapViewPoint mv1, MapViewState.MapViewPoint mv2, boolean showDirection) {
        path.moveTo(mv1);
        path.lineTo(mv2);
        if (showDirection) {
            ARROW_PAINT_HELPER.paintArrowAt(path, mv2, mv1);
        }
    }

    protected void drawSegment(MapViewState.MapViewPoint p1, MapViewState.MapViewPoint p2, Color col, boolean showDirection) {
        if (!col.equals(this.currentColor)) {
            this.displaySegments(col);
        }
        this.drawSegment(this.currentPath, p1, p2, showDirection);
    }

    protected void displaySegments() {
        this.displaySegments(null);
    }

    protected void displaySegments(Color newColor) {
        if (this.currentPath != null) {
            this.g.setColor(this.currentColor);
            this.g.draw(this.currentPath);
            this.currentPath = new MapPath2D();
            this.currentColor = newColor;
        }
    }
}

