/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.spi.preferences.ListListSetting;
import org.openstreetmap.josm.spi.preferences.ListSetting;
import org.openstreetmap.josm.spi.preferences.MapListSetting;
import org.openstreetmap.josm.spi.preferences.Setting;
import org.openstreetmap.josm.spi.preferences.SettingVisitor;
import org.openstreetmap.josm.spi.preferences.StringSetting;

public class PreferencesWriter
extends XmlWriter
implements SettingVisitor {
    private final boolean noPassword;
    private final boolean defaults;
    private String key;

    public PreferencesWriter(PrintWriter out, boolean noPassword, boolean defaults) {
        super(out);
        this.noPassword = noPassword;
        this.defaults = defaults;
    }

    public void write(Collection<Map.Entry<String, Setting<?>>> settings) {
        this.write(settings.stream());
    }

    public void write(Stream<Map.Entry<String, Setting<?>>> settings) {
        this.out.write(String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>%n", new Object[0]));
        String rootElement = this.defaults ? "preferences-defaults" : "preferences";
        this.out.write(String.format("<%s xmlns='%s/preferences-1.0'", rootElement, Main.getXMLBase()));
        if (this.defaults) {
            this.out.write(" xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'");
        }
        this.out.write(String.format(" version='%d'>%n", Version.getInstance().getVersion()));
        settings.forEachOrdered(e -> {
            this.setKey((String)e.getKey());
            ((Setting)e.getValue()).visit(this);
        });
        this.out.write(String.format("</%s>%n", rootElement));
    }

    private void setKey(String key) {
        this.key = key;
    }

    private void addTime(Setting<?> setting) {
        if (this.defaults) {
            this.out.write("' time='" + Optional.ofNullable(setting.getTime()).orElseThrow(IllegalStateException::new));
        }
    }

    private void addDefaults() {
        this.out.write(String.format("' xsi:nil='true'/>%n", new Object[0]));
    }

    @Override
    public void visit(StringSetting setting) {
        if (this.noPassword && "osm-server.password".equals(this.key)) {
            return;
        }
        this.out.write("  <tag key='" + XmlWriter.encode(this.key));
        this.addTime(setting);
        if (setting.getValue() != null) {
            this.out.write(String.format("' value='%s'/>%n", XmlWriter.encode((String)setting.getValue())));
        } else if (this.defaults) {
            this.addDefaults();
        } else {
            throw new IllegalArgumentException(setting.toString());
        }
    }

    @Override
    public void visit(ListSetting setting) {
        this.out.write("  <list key='" + XmlWriter.encode(this.key));
        this.addTime(setting);
        if (setting.getValue() != null) {
            this.out.write(String.format("'>%n", new Object[0]));
            for (String s : (List)setting.getValue()) {
                this.out.write(String.format("    <entry value='%s'/>%n", XmlWriter.encode(s)));
            }
            this.out.write(String.format("  </list>%n", new Object[0]));
        } else if (this.defaults) {
            this.addDefaults();
        } else {
            throw new IllegalArgumentException(setting.toString());
        }
    }

    @Override
    public void visit(ListListSetting setting) {
        this.out.write("  <lists key='" + XmlWriter.encode(this.key));
        this.addTime(setting);
        if (setting.getValue() != null) {
            this.out.write(String.format("'>%n", new Object[0]));
            for (List list : (List)setting.getValue()) {
                this.out.write(String.format("    <list>%n", new Object[0]));
                for (String s : list) {
                    this.out.write(String.format("      <entry value='%s'/>%n", PreferencesWriter.encode(s)));
                }
                this.out.write(String.format("    </list>%n", new Object[0]));
            }
            this.out.write(String.format("  </lists>%n", new Object[0]));
        } else if (this.defaults) {
            this.addDefaults();
        } else {
            throw new IllegalArgumentException(setting.toString());
        }
    }

    @Override
    public void visit(MapListSetting setting) {
        this.out.write("  <maps key='" + PreferencesWriter.encode(this.key));
        this.addTime(setting);
        if (setting.getValue() != null) {
            this.out.write(String.format("'>%n", new Object[0]));
            for (Map struct : (List)setting.getValue()) {
                this.out.write(String.format("    <map>%n", new Object[0]));
                for (Map.Entry e : struct.entrySet()) {
                    this.out.write(String.format("      <tag key='%s' value='%s'/>%n", PreferencesWriter.encode((String)e.getKey()), PreferencesWriter.encode((String)e.getValue())));
                }
                this.out.write(String.format("    </map>%n", new Object[0]));
            }
            this.out.write(String.format("  </maps>%n", new Object[0]));
        } else if (this.defaults) {
            this.addDefaults();
        } else {
            throw new IllegalArgumentException(setting.toString());
        }
    }
}

