/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.sources.ValidatorPrefHelper;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.Addresses;
import org.openstreetmap.josm.data.validation.tests.ApiCapabilitiesTest;
import org.openstreetmap.josm.data.validation.tests.BarriersEntrances;
import org.openstreetmap.josm.data.validation.tests.Coastlines;
import org.openstreetmap.josm.data.validation.tests.ConditionalKeys;
import org.openstreetmap.josm.data.validation.tests.CrossingWays;
import org.openstreetmap.josm.data.validation.tests.DuplicateNode;
import org.openstreetmap.josm.data.validation.tests.DuplicateRelation;
import org.openstreetmap.josm.data.validation.tests.DuplicateWay;
import org.openstreetmap.josm.data.validation.tests.DuplicatedWayNodes;
import org.openstreetmap.josm.data.validation.tests.Highways;
import org.openstreetmap.josm.data.validation.tests.InternetTags;
import org.openstreetmap.josm.data.validation.tests.Lanes;
import org.openstreetmap.josm.data.validation.tests.LongSegment;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker;
import org.openstreetmap.josm.data.validation.tests.MultipolygonTest;
import org.openstreetmap.josm.data.validation.tests.NameMismatch;
import org.openstreetmap.josm.data.validation.tests.OpeningHourTest;
import org.openstreetmap.josm.data.validation.tests.OverlappingWays;
import org.openstreetmap.josm.data.validation.tests.PowerLines;
import org.openstreetmap.josm.data.validation.tests.PublicTransportRouteTest;
import org.openstreetmap.josm.data.validation.tests.RelationChecker;
import org.openstreetmap.josm.data.validation.tests.RightAngleBuildingTest;
import org.openstreetmap.josm.data.validation.tests.SelfIntersectingWay;
import org.openstreetmap.josm.data.validation.tests.SimilarNamedWays;
import org.openstreetmap.josm.data.validation.tests.TagChecker;
import org.openstreetmap.josm.data.validation.tests.TurnrestrictionTest;
import org.openstreetmap.josm.data.validation.tests.UnclosedWays;
import org.openstreetmap.josm.data.validation.tests.UnconnectedWays;
import org.openstreetmap.josm.data.validation.tests.UntaggedNode;
import org.openstreetmap.josm.data.validation.tests.UntaggedWay;
import org.openstreetmap.josm.data.validation.tests.WayConnectedToArea;
import org.openstreetmap.josm.data.validation.tests.WronglyOrderedWays;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.ValidatorLayer;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class OsmValidator {
    private static volatile ValidatorLayer errorLayer;
    private static double griddetail;
    private static final Collection<String> ignoredErrors;
    private static final Collection<Class<? extends Test>> allTests;
    private static final Map<String, Test> allTestsMap;
    private static final Class<Test>[] CORE_TEST_CLASSES;
    private static boolean testsInitialized;

    private OsmValidator() {
    }

    public static void addTest(Class<? extends Test> testClass) {
        allTests.add(testClass);
        try {
            allTestsMap.put(testClass.getName(), testClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            Logging.error(e);
        }
    }

    public static void initialize() {
        OsmValidator.checkValidatorDir();
        OsmValidator.initializeGridDetail();
        OsmValidator.loadIgnoredErrors();
    }

    public static String getValidatorDir() {
        File dir = new File(Config.getDirs().getUserDataDirectory(true), "validator");
        try {
            return dir.getAbsolutePath();
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_ERROR, null, e);
            return dir.getPath();
        }
    }

    private static void checkValidatorDir() {
        File pathDir = new File(OsmValidator.getValidatorDir());
        try {
            if (!pathDir.exists()) {
                Utils.mkDirs(pathDir);
            }
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to check validator directory", e);
        }
    }

    private static void loadIgnoredErrors() {
        ignoredErrors.clear();
        if (ValidatorPrefHelper.PREF_USE_IGNORE.get().booleanValue()) {
            Path path = Paths.get(OsmValidator.getValidatorDir(), new String[0]).resolve("ignorederrors");
            try {
                if (path.toFile().exists()) {
                    try {
                        ignoredErrors.addAll(Files.readAllLines(path, StandardCharsets.UTF_8));
                    }
                    catch (FileNotFoundException e) {
                        Logging.debug(Logging.getErrorMessage(e));
                    }
                    catch (IOException e) {
                        Logging.error(e);
                    }
                }
            }
            catch (SecurityException e) {
                Logging.log(Logging.LEVEL_ERROR, "Unable to load ignored errors", e);
            }
        }
    }

    public static void addIgnoredError(String s) {
        ignoredErrors.add(s);
    }

    public static boolean hasIgnoredError(String s) {
        return ignoredErrors.contains(s);
    }

    public static void saveIgnoredErrors() {
        try (PrintWriter out = new PrintWriter(new File(OsmValidator.getValidatorDir(), "ignorederrors"), StandardCharsets.UTF_8.name());){
            for (String e : ignoredErrors) {
                out.println(e);
            }
        }
        catch (IOException e) {
            Logging.error(e);
        }
    }

    public static synchronized void initializeErrorLayer() {
        if (!ValidatorPrefHelper.PREF_LAYER.get().booleanValue()) {
            return;
        }
        if (errorLayer == null) {
            errorLayer = new ValidatorLayer();
            MainApplication.getLayerManager().addLayer(errorLayer);
        }
    }

    public static synchronized void resetErrorLayer() {
        errorLayer = null;
    }

    public static SortedMap<String, Test> getAllTestsMap() {
        OsmValidator.applyPrefs(allTestsMap, false);
        OsmValidator.applyPrefs(allTestsMap, true);
        return new TreeMap<String, Test>(allTestsMap);
    }

    public static <T extends Test> T getTest(Class<T> testClass) {
        if (testClass == null) {
            return null;
        }
        return (T)allTestsMap.get(testClass.getName());
    }

    private static void applyPrefs(Map<String, Test> tests, boolean beforeUpload) {
        for (String testName : Config.getPref().getList(beforeUpload ? "validator.skipBeforeUpload" : "validator.skip")) {
            Test test = tests.get(testName);
            if (test == null) continue;
            if (beforeUpload) {
                test.testBeforeUpload = false;
                continue;
            }
            test.enabled = false;
        }
    }

    public static Collection<Test> getTests() {
        return OsmValidator.getAllTestsMap().values();
    }

    public static Collection<Test> getEnabledTests(boolean beforeUpload) {
        Collection<Test> enabledTests = OsmValidator.getTests();
        for (Test t : new ArrayList<Test>(enabledTests)) {
            if (beforeUpload ? t.testBeforeUpload : t.enabled) continue;
            enabledTests.remove(t);
        }
        return enabledTests;
    }

    public static Collection<Class<? extends Test>> getAllAvailableTestClasses() {
        return Collections.unmodifiableCollection(allTests);
    }

    public static void initializeGridDetail() {
        String code = Main.getProjection().toCode();
        griddetail = Arrays.asList(ProjectionPreference.wgs84.allCodes()).contains(code) ? 10000.0 : (Arrays.asList(ProjectionPreference.mercator.allCodes()).contains(code) ? 0.01 : (Arrays.asList(ProjectionPreference.lambert.allCodes()).contains(code) ? 0.1 : 1.0));
    }

    public static double getGridDetail() {
        return griddetail;
    }

    public static synchronized void initializeTests() {
        if (!testsInitialized) {
            Logging.debug("Initializing validator tests");
            long startTime = System.currentTimeMillis();
            OsmValidator.initializeTests(OsmValidator.getTests());
            testsInitialized = true;
            if (Logging.isDebugEnabled()) {
                long elapsedTime = System.currentTimeMillis() - startTime;
                Logging.debug("Initializing validator tests completed in {0}", Utils.getDurationString(elapsedTime));
            }
        }
    }

    public static void initializeTests(Collection<? extends Test> allTests) {
        for (Test test : allTests) {
            try {
                if (!test.enabled) continue;
                test.initialize();
            }
            catch (Exception e) {
                String message = I18n.tr("Error initializing test {0}:\n {1}", test.getClass().getSimpleName(), e);
                Logging.error(message);
                if (GraphicsEnvironment.isHeadless()) continue;
                GuiHelper.runInEDT(() -> JOptionPane.showMessageDialog(Main.parent, message, I18n.tr("Error", new Object[0]), 0));
            }
        }
    }

    public static Map<Severity, Map<String, Map<String, List<TestError>>>> getErrorsBySeverityMessageDescription(Collection<TestError> errors, Predicate<? super TestError> filterToUse) {
        return errors.stream().filter(filterToUse).collect(Collectors.groupingBy(TestError::getSeverity, () -> new EnumMap(Severity.class), Collectors.groupingBy(TestError::getMessage, () -> new TreeMap(AlphanumComparator.getInstance()), Collectors.groupingBy(e -> e.getDescription() == null ? "" : e.getDescription(), () -> new TreeMap(AlphanumComparator.getInstance()), Collectors.toList()))));
    }

    static {
        ignoredErrors = new TreeSet<String>();
        allTests = new ArrayList<Class<? extends Test>>();
        allTestsMap = new HashMap<String, Test>();
        for (Class<Test> testClass : CORE_TEST_CLASSES = new Class[]{DuplicateNode.class, OverlappingWays.class, UntaggedNode.class, UntaggedWay.class, SelfIntersectingWay.class, DuplicatedWayNodes.class, CrossingWays.Ways.class, CrossingWays.Boundaries.class, CrossingWays.Barrier.class, CrossingWays.SelfCrossing.class, SimilarNamedWays.class, Coastlines.class, WronglyOrderedWays.class, UnclosedWays.class, TagChecker.class, UnconnectedWays.UnconnectedHighways.class, UnconnectedWays.UnconnectedRailways.class, UnconnectedWays.UnconnectedWaterways.class, UnconnectedWays.UnconnectedNaturalOrLanduse.class, UnconnectedWays.UnconnectedPower.class, DuplicateWay.class, NameMismatch.class, MultipolygonTest.class, RelationChecker.class, TurnrestrictionTest.class, DuplicateRelation.class, WayConnectedToArea.class, PowerLines.class, Addresses.class, Highways.class, BarriersEntrances.class, OpeningHourTest.class, MapCSSTagChecker.class, Lanes.class, ConditionalKeys.class, InternetTags.class, ApiCapabilitiesTest.class, LongSegment.class, PublicTransportRouteTest.class, RightAngleBuildingTest.class}) {
            OsmValidator.addTest(testClass);
        }
    }
}

