/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Component;
import java.io.IOException;
import javax.swing.JLabel;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.WMTSTileSource;
import org.openstreetmap.josm.gui.preferences.imagery.AddImageryPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class AddWMTSLayerPanel
extends AddImageryPanel {
    public AddWMTSLayerPanel() {
        this.add((Component)new JLabel(I18n.tr("{0} Make sure OSM has the permission to use this service", "1.")), GBC.eol());
        this.add((Component)new JLabel(I18n.tr("{0} Enter GetCapabilities URL", "2.")), GBC.eol());
        this.add((Component)this.rawUrl, GBC.eop().fill());
        this.rawUrl.setLineWrap(true);
        this.rawUrl.setAlignmentY(0.0f);
        this.add((Component)new JLabel(I18n.tr("{0} Enter name for this layer", "3.")), GBC.eol());
        this.add((Component)this.name, GBC.eol().fill(2));
        this.registerValidableComponent(this.rawUrl);
    }

    @Override
    protected ImageryInfo getImageryInfo() {
        ImageryInfo ret = new ImageryInfo(this.getImageryName(), "wmts:" + AddWMTSLayerPanel.sanitize(this.getImageryRawUrl(), ImageryInfo.ImageryType.WMTS));
        ret.setImageryType(ImageryInfo.ImageryType.WMTS);
        try {
            new WMTSTileSource(ret);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return ret;
    }

    @Override
    protected boolean isImageryValid() {
        return !this.getImageryName().isEmpty() && !this.getImageryRawUrl().isEmpty();
    }
}

