/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.imagery;

import java.awt.HeadlessException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WMSImagery {
    private List<LayerDetails> layers;
    private URL serviceUrl;
    private List<String> formats;
    private String version = "1.1.1";

    public List<LayerDetails> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public URL getServiceUrl() {
        return this.serviceUrl;
    }

    public String getVersion() {
        return this.version;
    }

    public List<String> getFormats() {
        return Collections.unmodifiableList(this.formats);
    }

    public String getPreferredFormats() {
        if (this.formats.contains("image/jpeg")) {
            return "image/jpeg";
        }
        if (this.formats.contains("image/png")) {
            return "image/png";
        }
        if (this.formats.isEmpty()) {
            return null;
        }
        return this.formats.get(0);
    }

    String buildRootUrl() {
        if (this.serviceUrl == null) {
            return null;
        }
        StringBuilder a = new StringBuilder(this.serviceUrl.getProtocol());
        a.append("://").append(this.serviceUrl.getHost());
        if (this.serviceUrl.getPort() != -1) {
            a.append(':').append(this.serviceUrl.getPort());
        }
        a.append(this.serviceUrl.getPath()).append('?');
        if (this.serviceUrl.getQuery() != null) {
            a.append(this.serviceUrl.getQuery());
            if (!this.serviceUrl.getQuery().isEmpty() && !this.serviceUrl.getQuery().endsWith("&")) {
                a.append('&');
            }
        }
        return a.toString();
    }

    public String buildGetMapUrl(Collection<LayerDetails> selectedLayers) {
        return this.buildGetMapUrl(selectedLayers, "image/jpeg");
    }

    public String buildGetMapUrl(Collection<LayerDetails> selectedLayers, String format) {
        return this.buildRootUrl() + "FORMAT=" + format + (WMSImagery.imageFormatHasTransparency(format) ? "&TRANSPARENT=TRUE" : "") + "&VERSION=" + this.version + "&SERVICE=WMS&REQUEST=GetMap&LAYERS=" + selectedLayers.stream().map(x -> x.ident).collect(Collectors.joining(",")) + "&STYLES=&" + ("1.3.0".equals(this.version) ? "CRS" : "SRS") + "={proj}&WIDTH={width}&HEIGHT={height}&BBOX={bbox}";
    }

    public void attemptGetCapabilities(String serviceUrlStr) throws IOException, WMSGetCapabilitiesException {
        URL getCapabilitiesUrl = null;
        try {
            if (!Pattern.compile(".*GetCapabilities.*", 2).matcher(serviceUrlStr).matches()) {
                getCapabilitiesUrl = new URL(serviceUrlStr);
                String getCapabilitiesQuery = "VERSION=1.1.1&SERVICE=WMS&REQUEST=GetCapabilities";
                getCapabilitiesUrl = getCapabilitiesUrl.getQuery() == null ? new URL(serviceUrlStr + '?' + "VERSION=1.1.1&SERVICE=WMS&REQUEST=GetCapabilities") : (!getCapabilitiesUrl.getQuery().isEmpty() && !getCapabilitiesUrl.getQuery().endsWith("&") ? new URL(serviceUrlStr + '&' + "VERSION=1.1.1&SERVICE=WMS&REQUEST=GetCapabilities") : new URL(serviceUrlStr + "VERSION=1.1.1&SERVICE=WMS&REQUEST=GetCapabilities"));
            } else {
                getCapabilitiesUrl = new URL(serviceUrlStr);
            }
            this.serviceUrl = new URL(serviceUrlStr.replace("REQUEST=GetCapabilities", "").replace("&&", "&"));
        }
        catch (HeadlessException e) {
            Logging.warn(e);
            return;
        }
        this.doAttemptGetCapabilities(serviceUrlStr, getCapabilitiesUrl);
    }

    private void doAttemptGetCapabilities(String serviceUrlStr, URL getCapabilitiesUrl) throws IOException, WMSGetCapabilitiesException {
        String url = getCapabilitiesUrl.toExternalForm();
        HttpClient.Response response = HttpClient.create(getCapabilitiesUrl).connect();
        if (response.getResponseCode() >= 400) {
            boolean contentAbout130;
            String errorMessage = response.getResponseMessage();
            String errorContent = response.fetchContent();
            Matcher tomcat = HttpClient.getTomcatErrorMatcher(errorContent);
            boolean messageAbout130 = errorMessage != null && errorMessage.contains("1.3.0");
            boolean bl = contentAbout130 = errorContent != null && tomcat != null && tomcat.matches() && tomcat.group(1).contains("1.3.0");
            if (url.contains("VERSION=1.1.1") && (messageAbout130 || contentAbout130)) {
                this.doAttemptGetCapabilities130(serviceUrlStr, url);
                return;
            }
            throw new WMSGetCapabilitiesException(errorMessage, errorContent);
        }
        try {
            this.parseCapabilities(serviceUrlStr, response.getContent());
        }
        catch (WMSGetCapabilitiesException e) {
            if (e.getCause() == null && url.contains("VERSION=1.1.1")) {
                this.doAttemptGetCapabilities130(serviceUrlStr, url);
            }
            throw e;
        }
    }

    private void doAttemptGetCapabilities130(String serviceUrlStr, String url) throws IOException, WMSGetCapabilitiesException {
        this.doAttemptGetCapabilities(serviceUrlStr, new URL(url.replace("VERSION=1.1.1", "VERSION=1.3.0")));
        if (this.serviceUrl.toExternalForm().contains("VERSION=1.1.1")) {
            this.serviceUrl = new URL(this.serviceUrl.toExternalForm().replace("VERSION=1.1.1", "VERSION=1.3.0"));
        }
        this.version = "1.3.0";
    }

    void parseCapabilities(String serviceUrlStr, InputStream contentStream) throws IOException, WMSGetCapabilitiesException {
        String incomingData = null;
        try {
            URL newURL;
            String baseURL;
            DocumentBuilder builder = Utils.newSafeDOMBuilder();
            builder.setEntityResolver((publicId, systemId) -> {
                Logging.info("Ignoring DTD " + publicId + ", " + systemId);
                return new InputSource(new StringReader(""));
            });
            Document document = builder.parse(contentStream);
            Element root = document.getDocumentElement();
            try {
                StringWriter writer = new StringWriter();
                TransformerFactory.newInstance().newTransformer().transform(new DOMSource(document), new StreamResult(writer));
                incomingData = writer.getBuffer().toString();
                Logging.debug("Server response to Capabilities request:");
                Logging.debug(incomingData);
            }
            catch (TransformerException | TransformerFactoryConfigurationError e) {
                Logging.warn(e);
            }
            if ("ServiceException".equals(root.getTagName())) {
                throw new WMSGetCapabilitiesException(root.getTextContent(), incomingData);
            }
            Element child = WMSImagery.getChild(root, "Capability");
            child = WMSImagery.getChild(child, "Request");
            child = WMSImagery.getChild(child, "GetMap");
            this.formats = WMSImagery.getChildrenStream(child, "Format").map(Node::getTextContent).filter(WMSImagery::isImageFormatSupportedWarn).collect(Collectors.toList());
            child = WMSImagery.getChild(child, "DCPType");
            child = WMSImagery.getChild(child, "HTTP");
            child = WMSImagery.getChild(child, "Get");
            if ((child = WMSImagery.getChild(child, "OnlineResource")) != null && !(baseURL = child.getAttributeNS("http://www.w3.org/1999/xlink", "href")).equals(serviceUrlStr) && (newURL = new URL(baseURL)).getAuthority() != null) {
                Logging.info("GetCapabilities specifies a different service URL: " + baseURL);
                this.serviceUrl = newURL;
            }
            Element capabilityElem = WMSImagery.getChild(root, "Capability");
            List<Element> children = WMSImagery.getChildren(capabilityElem, "Layer");
            this.layers = this.parseLayers(children, new HashSet<String>());
        }
        catch (MalformedURLException | ParserConfigurationException | SAXException e) {
            throw new WMSGetCapabilitiesException(e, incomingData);
        }
    }

    private static boolean isImageFormatSupportedWarn(String format) {
        boolean isFormatSupported = WMSImagery.isImageFormatSupported(format);
        if (!isFormatSupported) {
            Logging.info("Skipping unsupported image format {0}", format);
        }
        return isFormatSupported;
    }

    static boolean isImageFormatSupported(String format) {
        return ImageIO.getImageReadersByMIMEType(format).hasNext() || WMSImagery.isImageFormatSupported(format, "tiff", "geotiff") || WMSImagery.isImageFormatSupported(format, "png") || WMSImagery.isImageFormatSupported(format, "svg") || WMSImagery.isImageFormatSupported(format, "bmp");
    }

    static boolean isImageFormatSupported(String format, String ... mimeFormats) {
        for (String mime : mimeFormats) {
            if (!format.startsWith("image/" + mime)) continue;
            return ImageIO.getImageReadersBySuffix(mimeFormats[0]).hasNext();
        }
        return false;
    }

    static boolean imageFormatHasTransparency(String format) {
        return format != null && (format.startsWith("image/png") || format.startsWith("image/gif") || format.startsWith("image/svg") || format.startsWith("image/tiff"));
    }

    public ImageryInfo toImageryInfo(String name, Collection<LayerDetails> selectedLayers) {
        ImageryInfo i = new ImageryInfo(name, this.buildGetMapUrl(selectedLayers));
        if (selectedLayers != null) {
            HashSet<String> proj = new HashSet<String>();
            for (LayerDetails l : selectedLayers) {
                proj.addAll(l.getProjections());
            }
            i.setServerProjections(proj);
        }
        return i;
    }

    private List<LayerDetails> parseLayers(List<Element> children, Set<String> parentCrs) {
        ArrayList<LayerDetails> details = new ArrayList<LayerDetails>(children.size());
        for (Element element : children) {
            details.add(this.parseLayer(element, parentCrs));
        }
        return details;
    }

    private LayerDetails parseLayer(Element element, Set<String> parentCrs) {
        double left;
        String name = WMSImagery.getChildContent(element, "Title", null, null);
        String ident = WMSImagery.getChildContent(element, "Name", null, null);
        String abstr = WMSImagery.getChildContent(element, "Abstract", null, null);
        HashSet<String> crsList = new HashSet<String>();
        crsList.addAll(parentCrs);
        WMSImagery.getChildrenStream(element).filter(child -> "CRS".equals(child.getNodeName()) || "SRS".equals(child.getNodeName())).map(WMSImagery::getContent).filter(crs -> !crs.isEmpty()).map(crs -> crs.trim().toUpperCase(Locale.ENGLISH)).forEach(crsList::add);
        boolean josmSupportsThisLayer = false;
        for (String crs2 : crsList) {
            josmSupportsThisLayer |= WMSImagery.isProjSupported(crs2);
        }
        Bounds bounds = null;
        Element bboxElem = WMSImagery.getChild(element, "EX_GeographicBoundingBox");
        if (bboxElem != null) {
            left = Double.parseDouble(WMSImagery.getChildContent(bboxElem, "westBoundLongitude", null, null));
            double top = Double.parseDouble(WMSImagery.getChildContent(bboxElem, "northBoundLatitude", null, null));
            double right = Double.parseDouble(WMSImagery.getChildContent(bboxElem, "eastBoundLongitude", null, null));
            double bot = Double.parseDouble(WMSImagery.getChildContent(bboxElem, "southBoundLatitude", null, null));
            bounds = new Bounds(bot, left, top, right);
        } else {
            bboxElem = WMSImagery.getChild(element, "LatLonBoundingBox");
            if (bboxElem != null) {
                left = WMSImagery.getDecimalDegree(bboxElem, "minx");
                double top = WMSImagery.getDecimalDegree(bboxElem, "maxy");
                double right = WMSImagery.getDecimalDegree(bboxElem, "maxx");
                double bot = WMSImagery.getDecimalDegree(bboxElem, "miny");
                bounds = new Bounds(bot, left, top, right);
            }
        }
        List<Element> layerChildren = WMSImagery.getChildren(element, "Layer");
        List<LayerDetails> childLayers = this.parseLayers(layerChildren, crsList);
        return new LayerDetails(name, ident, abstr, crsList, josmSupportsThisLayer, bounds, childLayers);
    }

    private static double getDecimalDegree(Element elem, String attr) {
        return Double.parseDouble(elem.getAttribute(attr).replace(',', '.'));
    }

    private static boolean isProjSupported(String crs) {
        return Projections.getProjectionByCode(crs) != null;
    }

    private static String getChildContent(Element parent, String name, String missing, String empty) {
        Element child = WMSImagery.getChild(parent, name);
        if (child == null) {
            return missing;
        }
        String content = WMSImagery.getContent(child);
        return !content.isEmpty() ? content : empty;
    }

    private static String getContent(Element element) {
        NodeList nl = element.getChildNodes();
        StringBuilder content = new StringBuilder();
        block4: for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    content.append(WMSImagery.getContent((Element)node));
                    continue block4;
                }
                case 3: 
                case 4: {
                    content.append(node.getNodeValue());
                    continue block4;
                }
            }
        }
        return content.toString().trim();
    }

    private static Stream<Element> getChildrenStream(Element parent) {
        if (parent == null) {
            return Stream.empty();
        }
        Iterable it = () -> new ChildIterator(parent);
        return StreamSupport.stream(it.spliterator(), false);
    }

    private static Stream<Element> getChildrenStream(Element parent, String name) {
        return WMSImagery.getChildrenStream(parent).filter(child -> name.equals(child.getNodeName()));
    }

    private static List<Element> getChildren(Element parent, String name) {
        return WMSImagery.getChildrenStream(parent, name).collect(Collectors.toList());
    }

    private static Element getChild(Element parent, String name) {
        return WMSImagery.getChildrenStream(parent, name).findFirst().orElse(null);
    }

    public static class LayerDetails {
        public final String name;
        public final String ident;
        public final String abstr;
        public final List<LayerDetails> children;
        public final Bounds bounds;
        public final Set<String> crsList;
        public final boolean supported;

        public LayerDetails(String name, String ident, String abstr, Set<String> crsList, boolean supportedLayer, Bounds bounds, List<LayerDetails> childLayers) {
            this.name = name;
            this.ident = ident;
            this.abstr = abstr;
            this.supported = supportedLayer;
            this.children = childLayers;
            this.bounds = bounds;
            this.crsList = crsList;
        }

        public boolean isSupported() {
            return this.supported;
        }

        public Set<String> getProjections() {
            return this.crsList;
        }

        public String toString() {
            String baseName = this.name == null || this.name.isEmpty() ? this.ident : this.name;
            return this.abstr == null || this.abstr.equalsIgnoreCase(baseName) ? baseName : baseName + " (" + this.abstr + ')';
        }
    }

    public static class WMSGetCapabilitiesException
    extends Exception {
        private final String incomingData;

        public WMSGetCapabilitiesException(Throwable cause, String incomingData) {
            super(cause);
            this.incomingData = incomingData;
        }

        public WMSGetCapabilitiesException(String message, String incomingData) {
            super(message);
            this.incomingData = incomingData;
        }

        public String getIncomingData() {
            return this.incomingData;
        }
    }

    private static final class ChildIterator
    implements Iterator<Element> {
        private Element child;

        ChildIterator(Element parent) {
            this.child = ChildIterator.advanceToElement(parent.getFirstChild());
        }

        private static Element advanceToElement(Node firstChild) {
            Node node;
            for (node = firstChild; node != null && !(node instanceof Element); node = node.getNextSibling()) {
            }
            return (Element)node;
        }

        @Override
        public boolean hasNext() {
            return this.child != null;
        }

        @Override
        public Element next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No next sibling.");
            }
            Element next = this.child;
            this.child = ChildIterator.advanceToElement(this.child.getNextSibling());
            return next;
        }
    }
}

