/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.template_engine;

import org.openstreetmap.josm.tools.template_engine.StaticText;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;
import org.openstreetmap.josm.tools.template_engine.TemplateEntry;

public final class CompoundTemplateEntry
implements TemplateEntry {
    private final TemplateEntry[] entries;

    public static TemplateEntry fromArray(TemplateEntry ... entries) {
        if (entries.length == 0) {
            return new StaticText("");
        }
        if (entries.length == 1) {
            return entries[0];
        }
        return new CompoundTemplateEntry(entries);
    }

    private CompoundTemplateEntry(TemplateEntry ... entries) {
        this.entries = entries;
    }

    @Override
    public void appendText(StringBuilder result, TemplateEngineDataProvider dataProvider) {
        for (TemplateEntry te : this.entries) {
            te.appendText(result, dataProvider);
        }
    }

    @Override
    public boolean isValid(TemplateEngineDataProvider dataProvider) {
        for (TemplateEntry te : this.entries) {
            if (te.isValid(dataProvider)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (TemplateEntry te : this.entries) {
            result.append(te);
        }
        return result.toString();
    }
}

