/*
 * Decompiled with CFR 0.152.
 */
package org.linkgrammar;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import org.linkgrammar.JSONReader;
import org.linkgrammar.LGConfig;
import org.linkgrammar.Link;
import org.linkgrammar.Linkage;
import org.linkgrammar.ParseResult;

public class LGRemoteClient {
    private LGConfig config = new LGConfig();
    private String parserVersion;
    private String hostname = "localhost";
    private int port = 9000;
    private int parseRetryCount = 2;
    private int connectRetryCount = Integer.MAX_VALUE;
    private long connectRetryWait = 1000L;

    private ParseResult jsonToParseResult(String json) {
        JSONReader reader = new JSONReader();
        Map top = (Map)reader.read(json);
        ParseResult result = new ParseResult();
        result.setParserVersion((String)top.get("version"));
        result.setNumSkippedWords(((Number)top.get("numSkippedWords")).intValue());
        for (Map x : (List)top.get("linkages")) {
            Linkage linkage = new Linkage();
            linkage.setDisjunctCost(((Number)x.get("disjunctCost")).doubleValue());
            linkage.setLinkCost(((Number)x.get("linkageCost")).doubleValue());
            linkage.setNumViolations(((Number)x.get("numViolations")).intValue());
            linkage.setWords(((List)x.get("words")).toArray(new String[0]));
            linkage.setDisjuncts(((List)x.get("disjuncts")).toArray(new String[0]));
            linkage.setLinkedWordCount(linkage.getWords().length);
            for (Map y : (List)x.get("links")) {
                Link link = new Link();
                link.setLabel((String)y.get("label"));
                link.setLeftLabel((String)y.get("leftLabel"));
                link.setRightLabel((String)y.get("rightLabel"));
                link.setLeft(((Number)y.get("left")).intValue());
                link.setRight(((Number)y.get("right")).intValue());
                linkage.getLinks().add(link);
            }
            if (this.config.isStoreConstituentString()) {
                linkage.setConstituentString((String)x.get("constituentString"));
            }
            result.getLinkages().add(linkage);
        }
        return result;
    }

    private String makeLGRequest(String text) {
        if (this.config != null) {
            return "storeConstituentString:" + this.config.isStoreConstituentString() + "\u0000" + "maxCost:" + this.config.getMaxCost() + "\u0000" + "maxLinkages:" + this.config.getMaxLinkages() + "\u0000" + "maxParseSeconds:" + this.config.getMaxParseSeconds() + "\u0000" + "text:" + text + "\u0000";
        }
        return "text:" + text + "\u0000";
    }

    private String readResponse(BufferedReader in, int size) throws IOException {
        char[] buf = new char[size];
        for (int count = 0; count < size; count += in.read(buf, count, size - count)) {
        }
        return new String(buf, 0, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String callParser(String request) throws InterruptedException, IOException {
        if (this.hostname == null || this.hostname.length() == 0 || this.port <= 1024) {
            throw new RuntimeException("No hostname for remote parser or invalid port number < 1024");
        }
        Socket socket = null;
        for (int i = 0; i < this.connectRetryCount && socket == null; ++i) {
            try {
                socket = new Socket(this.hostname, this.port);
            }
            catch (UnknownHostException ex) {
                throw new RuntimeException("Host '" + this.hostname + "' not found.");
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (socket != null) continue;
            Thread.sleep(this.connectRetryWait);
        }
        if (socket == null) {
            throw new RuntimeException("Failed to connect to " + this.hostname + ":" + this.port);
        }
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            out = new PrintWriter(socket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            out.print(request);
            out.print('\n');
            out.flush();
            String size = in.readLine();
            if (size == null) {
                throw new RuntimeException("Parser returned no response.");
            }
            String string = this.readResponse(in, Integer.parseInt(size));
            return string;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Throwable throwable) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
            try {
                socket.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public String getVersion() {
        if (this.parserVersion == null) {
            try {
                String json = this.callParser("get:version\u0000");
                JSONReader reader = new JSONReader();
                Map top = (Map)reader.read(json);
                this.parserVersion = (String)top.get("version");
            }
            catch (IOException ex) {
                this.parserVersion = "unavailable";
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Thread interrupted.", ex);
            }
        }
        return this.parserVersion;
    }

    public ParseResult parse(String sentence) throws InterruptedException {
        String parserResponse = null;
        for (int i = 0; i < this.parseRetryCount && parserResponse == null; ++i) {
            try {
                parserResponse = this.callParser(this.makeLGRequest(sentence));
                continue;
            }
            catch (IOException ex) {
                if (i != 0) continue;
                System.err.println("Link grammar called failed on '" + sentence + "'" + ", will retry " + Integer.toString(this.parseRetryCount - 1) + " more time.");
                ex.printStackTrace();
            }
        }
        if (parserResponse == null) {
            return null;
        }
        ParseResult parseResult = this.jsonToParseResult(parserResponse);
        parseResult.setText(sentence);
        return parseResult;
    }

    public LGConfig getConfig() {
        return this.config;
    }

    public void setConfig(LGConfig config) {
        this.config = config;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getParseRetryCount() {
        return this.parseRetryCount;
    }

    public void setParseRetryCount(int parseRetryCount) {
        this.parseRetryCount = parseRetryCount;
    }

    public int getConnectRetryCount() {
        return this.connectRetryCount;
    }

    public void setConnectRetryCount(int connectRetryCount) {
        this.connectRetryCount = connectRetryCount;
    }

    public long getConnectRetryWait() {
        return this.connectRetryWait;
    }

    public void setConnectRetryWait(long connectRetryWait) {
        this.connectRetryWait = connectRetryWait;
    }
}

