/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.common.AppendProcessor;
import org.elasticsearch.ingest.common.ConvertProcessor;
import org.elasticsearch.ingest.common.DateIndexNameProcessor;
import org.elasticsearch.ingest.common.DateProcessor;
import org.elasticsearch.ingest.common.DotExpanderProcessor;
import org.elasticsearch.ingest.common.FailProcessor;
import org.elasticsearch.ingest.common.ForEachProcessor;
import org.elasticsearch.ingest.common.GrokProcessor;
import org.elasticsearch.ingest.common.GrokProcessorGetAction;
import org.elasticsearch.ingest.common.GsubProcessor;
import org.elasticsearch.ingest.common.JoinProcessor;
import org.elasticsearch.ingest.common.JsonProcessor;
import org.elasticsearch.ingest.common.KeyValueProcessor;
import org.elasticsearch.ingest.common.LowercaseProcessor;
import org.elasticsearch.ingest.common.RemoveProcessor;
import org.elasticsearch.ingest.common.RenameProcessor;
import org.elasticsearch.ingest.common.ScriptProcessor;
import org.elasticsearch.ingest.common.SetProcessor;
import org.elasticsearch.ingest.common.SortProcessor;
import org.elasticsearch.ingest.common.SplitProcessor;
import org.elasticsearch.ingest.common.TrimProcessor;
import org.elasticsearch.ingest.common.URLDecodeProcessor;
import org.elasticsearch.ingest.common.UppercaseProcessor;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;

public class IngestCommonPlugin
extends Plugin
implements ActionPlugin,
IngestPlugin {
    private static final String[] PATTERN_NAMES = new String[]{"aws", "bacula", "bro", "exim", "firewalls", "grok-patterns", "haproxy", "java", "junos", "linux-syslog", "mcollective-patterns", "mongodb", "nagios", "postgresql", "rails", "redis", "ruby"};
    static final Map<String, String> GROK_PATTERNS;

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        HashMap<String, Object> processors = new HashMap<String, Object>();
        processors.put("date", new DateProcessor.Factory(parameters.scriptService));
        processors.put("set", new SetProcessor.Factory(parameters.scriptService));
        processors.put("append", new AppendProcessor.Factory(parameters.scriptService));
        processors.put("rename", new RenameProcessor.Factory());
        processors.put("remove", new RemoveProcessor.Factory(parameters.scriptService));
        processors.put("split", new SplitProcessor.Factory());
        processors.put("join", new JoinProcessor.Factory());
        processors.put("uppercase", new UppercaseProcessor.Factory());
        processors.put("lowercase", new LowercaseProcessor.Factory());
        processors.put("trim", new TrimProcessor.Factory());
        processors.put("convert", new ConvertProcessor.Factory());
        processors.put("gsub", new GsubProcessor.Factory());
        processors.put("fail", new FailProcessor.Factory(parameters.scriptService));
        processors.put("foreach", new ForEachProcessor.Factory());
        processors.put("date_index_name", new DateIndexNameProcessor.Factory());
        processors.put("sort", new SortProcessor.Factory());
        processors.put("grok", new GrokProcessor.Factory(GROK_PATTERNS));
        processors.put("script", new ScriptProcessor.Factory(parameters.scriptService));
        processors.put("dot_expander", new DotExpanderProcessor.Factory());
        processors.put("json", new JsonProcessor.Factory());
        processors.put("kv", new KeyValueProcessor.Factory());
        processors.put("urldecode", new URLDecodeProcessor.Factory());
        return Collections.unmodifiableMap(processors);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((GenericAction)GrokProcessorGetAction.INSTANCE, GrokProcessorGetAction.TransportAction.class, new Class[0]));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Arrays.asList(new RestHandler[]{new GrokProcessorGetAction.RestAction(settings, restController)});
    }

    public static Map<String, String> loadBuiltinPatterns() throws IOException {
        HashMap<String, String> builtinPatterns = new HashMap<String, String>();
        for (String pattern : PATTERN_NAMES) {
            try (InputStream is = IngestCommonPlugin.class.getResourceAsStream("/patterns/" + pattern);){
                IngestCommonPlugin.loadPatterns(builtinPatterns, is);
            }
        }
        return Collections.unmodifiableMap(builtinPatterns);
    }

    private static void loadPatterns(Map<String, String> patternBank, InputStream inputStream) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        while ((line = br.readLine()) != null) {
            String[] parts;
            String trimmedLine = line.replaceAll("^\\s+", "");
            if (trimmedLine.startsWith("#") || trimmedLine.length() == 0 || (parts = trimmedLine.split("\\s+", 2)).length != 2) continue;
            patternBank.put(parts[0], parts[1]);
        }
    }

    static {
        try {
            GROK_PATTERNS = IngestCommonPlugin.loadBuiltinPatterns();
        }
        catch (IOException e) {
            throw new UncheckedIOException("unable to load built-in grok patterns", e);
        }
    }
}

